/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package dsgaproteinfoldingkg;
import java.io.*;
import java.util.Date;

/**
 *
 * @author mbrown15
 */
public class DSGAProteinFoldingKG {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        populationSize = Integer.parseInt(args[0]);
        numGenerations = Integer.parseInt(args[1]);
        mutationRate = Double.parseDouble(args[2]);
        currentRadius = Double.parseDouble(args[3]);  // set to initial radius
        radiusDelta = Double.parseDouble(args[4]);
        reevaluationLoopCount = Integer.parseInt(args[5]);
        convergencelimit = Integer.parseInt(args[6]);
        String protein = args[7];
                //new String("HPHPPHHPHPPHPHHPPHPH");
        String fileLocation = args[8];
                //new String("//Users//mbrown15//Documents//genetic-algorithm-files//");
        int loggingLevel = Integer.parseInt(args[9]);
        
      dsga dsga; 
      
      // convert to H and P
      
     // protein = getAminoAcidsHP(protein);
      
        dsga = new dsga();
        dsga.initialization(populationSize, protein);
        for (int x = 0; x < numGenerations; x++)
        {
            if (loggingLevel > 0)
            {
                System.out.println(" ");
                System.out.println("Generation " + x);
            }
            if (loggingLevel > 1)
                dsga.print(protein);
            dsga.seedSelection(currentRadius, protein);
            dsga.selectionCrossover(populationSize, protein);
            dsga.mutation(mutationRate);
            dsga.seedConservation(currentRadius, protein);
            if (((x + 1) % reevaluationLoopCount == 0))
            {
                System.out.println("Reevaluation");
                dsga.reevaluation(convergencelimit, protein);
                currentRadius = radiusDelta + currentRadius;
                if (loggingLevel > 1)
                   dsga.print(protein);
            }
            dsga.retireCurrentGeneration();
        }

        dsga.sortTabuList(protein);
        if (loggingLevel > 0)
           dsga.print(protein);
        
        Writer writer = null;

        try {
            
           java.text.DateFormat df = new java.text.SimpleDateFormat("YYYY-MM-dd-HH-mm-ss");
           Date d = new Date();

           writer = new BufferedWriter(new OutputStreamWriter(
               new FileOutputStream(fileLocation + df.format(d) + "-KeepingGoing.txt"), "utf-8"));
           writer.write("DSGA Protein Folding Problem Results" + "\n");
           
           writer.write("populationSize = " + populationSize + "\n");
           writer.write("numGenerations = " + numGenerations + "\n");
           writer.write("mutationRate = " + mutationRate + "\n");
           writer.write("currentRadius = " + currentRadius + "\n");  
           writer.write("radiusDelta = " + radiusDelta + "\n");
           writer.write("reevaluationLoopCount = " + reevaluationLoopCount + "\n");
           writer.write("convergencelimit = " + convergencelimit + "\n");
           writer.write("protein = " + protein + "\n");
        
           dsga.computeBestIndividual(writer, protein);
        } 
        catch (IOException ex) { System.out.println("Errror " + ex.getMessage());
        } 
        finally {
          try {writer.close();} catch (Exception ex) {}
        }
    }
    
    private static String getAminoAcidsHP(String protein){
        String sHydroPhilic = "CDEHKNQRSTY";
        String tempStr = new String();
        
        for (int x = 0; x < protein.length(); x++)
        {
            tempStr = tempStr + "H";
        }
        tempStr = tempStr.replace("C", "P");
        tempStr = tempStr.replace("D", "P");
        tempStr = tempStr.replace("E", "P");
        tempStr = tempStr.replace("H", "P");
        tempStr = tempStr.replace("K", "P");
        tempStr = tempStr.replace("N", "P");
        tempStr = tempStr.replace("Q", "P");
        tempStr = tempStr.replace("R", "P");
        tempStr = tempStr.replace("S", "P");
        tempStr = tempStr.replace("T", "P");
        tempStr = tempStr.replace("Y", "P");
        return tempStr;
 
    }
    
    private static int numGenerations;
    private static int populationSize;
    private static double mutationRate;
    private static int reevaluationLoopCount;
    private static int numOfBits;
    private static int convergencelimit;
    private static double currentRadius;
    private static double radiusDelta;
}
