/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package gaproteinfoldingdd;
import java.io.BufferedWriter;
import java.io.Writer;
import java.util.*;
/**
 *
 * @author mbrown15
 */
public class dsga {
    private List<individual> currentGeneration;
    private List<individual> nextGeneration;

    
    private Random randNum;
    
    public void initialization(int populationSize, String protein)
    {
        currentGeneration = new ArrayList<>();
        nextGeneration = new ArrayList<>();
        randNum = new Random();
        
        java.text.DateFormat df = new java.text.SimpleDateFormat("ssHHMMmm");
        Date d = new Date();
        randNum.setSeed(Long.parseLong(df.format(d)));
        
        individual tempIndividual; 
        for (int x = 1; x <= populationSize; x++)
        {
            tempIndividual = new individual(computeRandomString(protein));
            currentGeneration.add(tempIndividual);
        }
    }
    
    private String computeRandomString(String protein)
    {
        String tempStr = new String();
        int randInt;
        
       // create a random individual
       for (int y = 1; y < protein.length(); y++)
       {
           randInt = randNum.nextInt(4);
           if (randInt == 0)
               tempStr = tempStr + "0";
           else if (randInt == 1)
               tempStr = tempStr + "1";
           else if (randInt == 2)
               tempStr = tempStr + "2";
           else
               tempStr = tempStr + "3";
       }
       return tempStr;
    }
    
    
    public void selectionCrossover(int populationSize, String protein)
    {
        double sumFittness = 0.0;
//System.out.println("Being selection / crossover");
//printCurrentGeneration();

        // compute sum of fitness;
        Iterator<individual> iterator = currentGeneration.iterator();
	individual tempIndividual;
        
        while (iterator.hasNext()) 
        {
            tempIndividual = iterator.next();
            sumFittness = sumFittness + tempIndividual.setFitness(protein) + 1;
        }
 System.out.println("Fitness sum " + sumFittness);
//        System.out.println("Shared fittness sum  " + sumFittness);
        
        for (int z = 0; z < (populationSize / 2); z++)
        {
            // locate two individuals
            individual individual1 = getIndividualSelect(sumFittness, protein);
            individual individual2 = getIndividualSelect(sumFittness, protein);

            // locate crossover point
            int crossOverPoint = randNum.nextInt(individual1.genes.length());
//System.out.println("Selection         Individual1 " + individual1.genes + "  Individual2 " + individual2.genes + 
  //      " crossover point " + crossOverPoint);


            // create two new individuals
            individual newIndividual1 = new individual(individual1.genes.subSequence(0, crossOverPoint) +
                individual2.genes.substring(crossOverPoint, individual2.genes.length()));
        
            individual newIndividual2 = new individual(individual2.genes.subSequence(0, crossOverPoint) +
                individual1.genes.substring(crossOverPoint, individual2.genes.length()));
        
 //System.out.println("Selection Results Individual1 " + newIndividual1.genes + "  Individual2 " + newIndividual2.genes);
            // add two new individuals to next generation
            nextGeneration.add(newIndividual1);
            nextGeneration.add(newIndividual2);
        }
    }
    
    public void mutation(double mutationeRate)
    {
        Iterator<individual> iterator = nextGeneration.iterator();
	individual tempIndividual;
        
        while (iterator.hasNext()) 
        {
            tempIndividual = iterator.next();
            for (int y = 0; y < tempIndividual.genes.length(); y++)
            {
                if (randNum.nextDouble() < mutationeRate)
                {
//                    System.out.println("Mutate " + tempIndividual.genes + " position " + y);
                    if (tempIndividual.genes.charAt(y) == '0')
                        tempIndividual.genes = tempIndividual.genes.substring(0, y) + '1' +
                                tempIndividual.genes.substring(y + 1, tempIndividual.genes.length());
                    else 
                        tempIndividual.genes = tempIndividual.genes.substring(0, y) + '0' +
                                tempIndividual.genes.substring(y + 1, tempIndividual.genes.length());
//                    System.out.println("  New mutated individual  " + tempIndividual.genes);
                }
            }
        }        
    }
    
    
    public void retireCurrentGeneration()
    {
        currentGeneration = nextGeneration;
        nextGeneration = new ArrayList<>();
    }
    
    
    
    private int individualCount(String genes)
    {
        int count = 0;
        for (int y = 0; y < currentGeneration.size(); y++)
        {
            individual tempIndividual = currentGeneration.get(y);
            if (tempIndividual.genes.equals(genes))
                    count = count + 1;
        }
        return count;
    }
    
    private individual getIndividualSelect(double sumFittness, String protein)
    {
        double randomNum = randNum.nextDouble() * sumFittness;
      
        Iterator<individual> iterator = currentGeneration.iterator();
	individual tempIndividual = new individual("000000000000000000000000000"); // temp value
        
        while ((iterator.hasNext()) && (randomNum > 0.0)) 
        {
            tempIndividual = iterator.next();
            randomNum = randomNum - tempIndividual.setFitness(protein) - 1.0;
	}
        return tempIndividual;
    }

    
    public void print(String protein)
    {     
        System.out.println("");
        System.out.println("CURRENT GENERATION");
        for (int x = 0; x < currentGeneration.size(); x++)
        {
            individual i = currentGeneration.get(x);
            i.setFitness(protein);
            i.print(protein);
        }
        System.out.println("");   
    }
    
    public void commputeNaturalFitness(List<individual> list, String protein)
    {
        for (int x = 0; x < list.size(); x++)
        {
            individual i = list.get(x);
            i.setFitness(protein);
        }
    }
    
    public void computeBestIndividual(Writer w, String protein)
    {
        System.out.println("Best individual(s)");
        
        for (int a = 0; a < currentGeneration.size(); a++)
        {
            individual i1 = currentGeneration.get(a);
            i1.setFitness(protein);
        }
       
        Collections.sort(currentGeneration, new individualSorterNaturalFitness(protein));
        
        Iterator<individual> iterator = currentGeneration.iterator();
	individual tempIndividual;
        
        tempIndividual = iterator.next(); // get first individual
        double bestValue = tempIndividual.naturalFitness; // record natural fitness
        System.out.println("Individual =  " + tempIndividual.genes + " "  + (tempIndividual.naturalFitness));
        try {
           w.write("Individual =  " + tempIndividual.genes + " "  + (tempIndividual.naturalFitness) + "\n");     
        } catch (Exception e)
        {System.out.println("Error " + e.getMessage());}
        
        tempIndividual = iterator.next();
        while ((tempIndividual.naturalFitness == bestValue) && (iterator.hasNext()))
        {
            System.out.println("Individual =  " + tempIndividual.genes+ " "  + (tempIndividual.setFitness(protein)));
            try {
               w.write("Individual =  " + tempIndividual.genes + " "  + (tempIndividual.setFitness(protein)) + "\n");     
            } catch (Exception e)
            {System.out.println("Error " + e.getMessage());}
            if (iterator.hasNext()) 
                tempIndividual = iterator.next();
        }
        
        try
        {
            w.write("");            
        
            for (int y = 0; y < currentGeneration.size(); y++)
            {
                tempIndividual = currentGeneration.get(y);
                w.write(tempIndividual.genes + "," + (tempIndividual.setFitness(protein)) +"\n");
            }    
        }
        catch (Exception e)
        {System.out.println("Error " + e.getMessage());}
    }
}
