/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package gaproteinfoldingdd;
import java.io.*;
import java.util.Date;

/**
 *
 * @author mbrown15
 */
public class GAProteinFolding {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        populationSize = Integer.parseInt(args[0]);
        numGenerations = Integer.parseInt(args[1]);
        mutationRate = Double.parseDouble(args[2]);
        String protein = args[3];
                //new String("HPHPPHHPHPPHPHHPPHPH");
        String fileLocation = args[4];
                //new String("//Users//mbrown15//Documents//genetic-algorithm-files//");
        int loggingLevel = Integer.parseInt(args[5]);
        
      dsga dsga; 
      
      // convert to H and P
      
     // protein = getAminoAcidsHP(protein);
      
        dsga = new dsga();
        dsga.initialization(populationSize, protein);
        for (int x = 0; x < numGenerations; x++)
        {
            if (loggingLevel > 0)
            {
                System.out.println(" ");
                System.out.println("Generation " + x);
            }
            if (loggingLevel > 1)
                dsga.print(protein);
           
            dsga.selectionCrossover(populationSize, protein);
            dsga.mutation(mutationRate);
            
            dsga.retireCurrentGeneration();
        }

 
        
        Writer writer = null;

        try {
            
           java.text.DateFormat df = new java.text.SimpleDateFormat("YYYY-MM-dd-HH-mm-ss");
           Date d = new Date();

           writer = new BufferedWriter(new OutputStreamWriter(
               new FileOutputStream(fileLocation + "GA-" + df.format(d) + ".txt"), "utf-8"));
           writer.write("GA Protein Folding Problem Results" + "\n");
           
           writer.write("populationSize = " + populationSize + "\n");
           writer.write("numGenerations = " + numGenerations + "\n");
           writer.write("mutationRate = " + mutationRate + "\n");

           writer.write("protein = " + protein + "\n");
           
           dsga.computeBestIndividual(writer, protein);
           dsga.print(protein);
        } 
        catch (IOException ex) { System.out.println("Errror " + ex.getMessage());
        } 
        finally {
          try {writer.close();} catch (Exception ex) {}
        }
    }
    
    private static String getAminoAcidsHP(String protein){
        String sHydroPhilic = "CDEHKNQRSTY";
        String tempStr = new String();
        
        for (int x = 0; x < protein.length(); x++)
        {
            tempStr = tempStr + "H";
        }
        tempStr = tempStr.replace("C", "P");
        tempStr = tempStr.replace("D", "P");
        tempStr = tempStr.replace("E", "P");
        tempStr = tempStr.replace("H", "P");
        tempStr = tempStr.replace("K", "P");
        tempStr = tempStr.replace("N", "P");
        tempStr = tempStr.replace("Q", "P");
        tempStr = tempStr.replace("R", "P");
        tempStr = tempStr.replace("S", "P");
        tempStr = tempStr.replace("T", "P");
        tempStr = tempStr.replace("Y", "P");
        return tempStr;
 
    }
    
    private static int numGenerations;
    private static int populationSize;
    private static double mutationRate;
    private static int numOfBits;
   }
