/*
 * Protein Folding Genetic Algorithm Application
 * FoldingClass - contains the properties and methods used to fold the protein, 
 * compute the free energy of the individuals that folded, and computes the 
 * shared fitness.  The methods are called from the Fitness class
 * FC is encapsulated
 */

package gaproteinfoldingdd;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Sadao - BIFS - Primary Developer fold protein and free energy
 * @author Natalie - BIFS - Developer for free energy  
 * @author Tommy - SWEN670 - Developer for shared fitness - Integration Developer
 * Project D Team
 * March 24, 2014
 */
public class Folding {
    int[][] position;
    int[][] zeroPosition;
    
    /**
     * foldProtein() takes and array of individual class and the protein string.
     * This method attempts to fold the protein.  The direction it folds is recorded 
     * in an array that is later used to compute the free energy.
     * @param iC
     * @param iProtein
     * @return 
     */
    public int[][] foldProtein(String genes, int iProtein) {
        /**
         * Using data retrieved from the individual create a 2D array
         * that would be able to store abstract xy-coordinates
         * The first dimension, n, will be set to the length of the protein
         * The second dimension will be set to two for the x and y coordinates
         */
        position = new int[iProtein][2];
        zeroPosition = new int[iProtein][2];

        /**
         * Set the header of the protein to (0,0) as it will represent an origin
         */
        position[0][0] = iProtein;
        position[0][1] = iProtein;

        /**
         * Create variables to store the current xy-coordinate of the current 
         * amino acid within the protein.  Since the protein will start at an 
         * origin of (0,0) these variables should each be set to zero
         */
        int positionx = iProtein;
        int positiony = iProtein;

        int iGene = 0;

        /**
         * Loop through the remainder of the protein in order to generate 
         * the remaining positions
         */
        for (int i = 0; i < (iProtein - 1); i++) {
            iGene = Integer.valueOf(String.valueOf(genes.charAt(i)));
            /**
             * Define a variable for direction storage (i.e. gene)
             * Should be an integer from 0-3, each representing one of 
             * four directions. Using the directions given within the 
             * individual's chromosome to map out coordinates
             */

            
            if (iGene == 0) 
            {
                if (this.isLocationEmpty(position, positionx, positiony+1))  // try up
                   positiony += 1;
                else  // position is taken
                {
                    if (this.isLocationEmpty(position, positionx+1, positiony))  // try right
                        positionx += 1;
                    else if (this.isLocationEmpty(position, positionx, positiony-1)) // try down
                        positiony -= 1;
                    else if (this.isLocationEmpty(position, positionx-1, positiony)) // try left
                        positionx -= 1;
                }
            } 
            else if (iGene == 1) 
            {
                if (this.isLocationEmpty(position, positionx+1, positiony))  // try right
                   positionx += 1;
                else // position is taken
                {
                    if (this.isLocationEmpty(position, positionx, positiony-1))  // try down
                        positiony -= 1;
                    else if (this.isLocationEmpty(position, positionx-1, positiony)) // try left
                        positionx -= 1;
                    else if (this.isLocationEmpty(position, positionx, positiony+1)) // try up
                        positiony += 1;
                }
            } 
            else if (iGene == 2) 
            {
                if (this.isLocationEmpty(position, positionx, positiony-1)) // try down
                   positiony -= 1;
                else // position is taken
                {
                    if (this.isLocationEmpty(position, positionx-1, positiony))  // try left
                        positionx -= 1;
                    else if (this.isLocationEmpty(position, positionx, positiony+1)) // try up
                        positiony += 1;
                    else if (this.isLocationEmpty(position, positionx+1, positiony)) // try right
                        positionx += 1;
                }
            } 
            else 
            { //Current gene would be equal to 3
                if (this.isLocationEmpty(position, positionx-1, positiony))  // try left
                   positionx -= 1;
                else // position is taken
                {
                    if (this.isLocationEmpty(position, positionx, positiony+1))  // try up
                        positiony += 1;
                    else if (this.isLocationEmpty(position, positionx+1, positiony)) // try right
                        positionx += 1;
                    else if (this.isLocationEmpty(position, positionx, positiony-1)) // try down
                        positiony -= 1;
                }
            } //end if...else

            /**
             * This isLocationEmpty method is called to ensure the protein has not folded on itself.
             * If the location is empty it assigned to the position array.  If not an
             * empty array - zeroPosition is assigned to the position, processing is stopped
             * and the empty array is returned.  A natural fitness of ZERO is given.
             */
            if (this.isLocationEmpty(position, positionx, positiony)){
                position[i][0] = positionx;
                position[i][1] = positiony;
            } else {
                position=zeroPosition;
                break;
            } //end if else
        } //end for 
        //printPosition(position);
        return position;
    }
    
    /**
     * computeFreeEnergy() method takes the position array and protein string of
     * H and Ps to compute the free energy.  Traditionally this would be done using a 
     * -1 but for the purpose of this application and GA it will be incremented by +1
     * @param position
     * @param protein
     * @return 
     */
    public int computeFreeEnergy(int[][] position, String protein){
        /**
        * Set int variable for Free Energy to ZERO
        */
       int iFE=0;
        /**
         * Finally calculate the total free energy of the individual Now that 
         * each amino acid is positioned simply loop through each amino acid 
         * and if the amino acid is H then find all adjacent, non-neighbor 
         * amino acids which are also H and subtract from the total free energy 
         * Since we want a lowest minimum we would subtract instead of add
         */
        for (int i = 0; i < protein.length(); i++) {
            if (String.valueOf(protein.charAt(i)).equals("H")) {
                /**
                 * Identify which amino acids are located near current 
                 * amino acid Be sure to check that the second amino acid 
                 * being compared to is not a neighbor to the current 
                 * amino acid in the sequence
                 */
                for (int j = 0; j < protein.length(); j++) {
                    /**
                     * An "if" statement could be used in order to identify 
                     * which amino acids are located in a plus or minus one x direction 
                     * or a plus one or minus one y direction from the current amino acid (i.e. protein[i])
                     */
                    if (String.valueOf(protein.charAt(j)).equals("H")) {
                        if (((position[j][0] == position[i][0] && 
                            (position[j][1] == ((position[i][1]) + 1) || 
                             position[j][1] == ((position[i][1]) - 1))) || 
                            (position[j][1] == position[i][1] && 
                            (position[j][0] == ((position[i][0]) + 1) || 
                             position[j][0] == ((position[i][0]) - 1))))
                                && (j != (i - 1) && j != (i + 1))) {

                            iFE += 1;
                        } //end if
                    } //end if
                } //end for
            } //end if
        } //end for  
        /**
         * Due to iteration through the protein Array twice; once for the X and
         * once for the Y, the free energy is added twice.  To remedy that the 
         * total calculated Free Energy is divided by 2 before being returned.
         */
        return iFE/2;
    }

    /**
     * isLocationEmpty() method checks that the location being requested is empty 
     * of taken. It returns false if the location taken and true if it is empty.
     * 
     * @param foldLocation
     * @param iPosX
     * @param iPosY
     * @return 
     */
    private boolean isLocationEmpty(int[][] foldLocation, int iPosX, int iPosY){
        boolean bTF = true;
        int idx=0;
        for(int t=0;t<foldLocation.length;t++){
            //MyClass.statusMessage("Position location: "+foldLocation[t][0]+":"+foldLocation[t][1]);
            if(foldLocation[t][0]==iPosX && foldLocation[t][1]==iPosY){
                //MyClass.statusMessage("Match found : "+foldLocation[t][0]+" "+foldLocation[t][1]);
                bTF = false;
                idx++;
                break;
            }
        }
        return bTF;
    }
    /**
     * calculateDistance() calculates the Chromosomal Difference to compute 
     * Shared Fitness.
     * @param sTC
     * @param sIC
     * @return 
     */
    public int calculateDistance(String sTC, String sIC) {
        int iDistance = 0;
        for (int i = 0; i < sIC.length(); i++) {
            if (String.valueOf(sIC.charAt(i)).equals(String.valueOf(sTC.charAt(i)))) {
            } else {
                iDistance++;
            }
        }
        return iDistance;
    }     
    
}
