---
title: 'RefManageR: Import and Manage BibTeX and BibLaTeX References in R'
tags:
  - R
  - reference management
  - BibLaTeX
  - document generation
authors:
 - name: Mathew W. McLean
   orcid: 0000-0002-7891-9645
   affiliation: 1
affiliations:
 - name: University of Technology Sydney
   index: 1
date: 25 May 2017
bibliography: paper.bib
---

# Summary

RefManageR provides tools for importing and working with bibliographic
references.  It greatly enhances the bibentry class in R by providing
a class BibEntry which stores BibTeX and BibLaTeX references, supports
UTF-8 encoding, and can be easily searched by any field, by date
ranges, and by various formats for name lists (author by last names,
translator by full names, etc.) using R's person class
[@hornik2012]. Entries can be updated, combined, sorted, printed in a
number of styles, and exported. BibTeX [@bibtex] and BibLaTeX
[@biblatex] .bib files can be read into R and converted to BibEntry
objects.  Interfaces to NCBI's Entrez, CrossRef, and Zotero are
provided for importing references and references can be created from
locally stored PDFs using Poppler.  Includes functions for citing and
generating a bibliography with hyperlinks for documents prepared with
RMarkdown or RHTML.  A vignette is available to further demonstrate
all functionality [@refmanager].
 
BibEntry objects can be created directly in R or a .bib file can be
read into R to create the object.  Tools are
provided for importing references from Crossref, Zotero, Google
Scholar, and PDFs and for looking up PubMed ID's and DOIs.

BibEntry objects may be searched and indexed by field values, name
lists, keys, dates, date ranges, etc.  They can be printed in a number
of formats (e.g. text, html) and most of the base bibliography styles
available with BibLaTeX (e.g. alphabetic, numeric, authortitle, and
authoryear).  All sorting methods for bibliographies available in the
BibLaTeX LaTeX package have been implemented.  A function is provided
to convert a BibEntry object to a character vector containing lines of
a BibTeX or BibLaTeX file, converting fields, entry types and
expanding crossreferences to coerce BibLaTeX entries to BibTeX if
requested.  The results can also be written to a file.

Citations can be gerenated in a number of styles using one of the
available functions for citations.  A list of references can be
printed based on the works the user has cited thus far in their
document.  The citations and bibliography can be printed including
hyperlinks using either the R Markdown or R HTML formats.  A function
is provided to open electronic copies of references in a PDF viewer or
web browser.  A simple function is provided for setting default
formatting options throughout the session.

# References
