from __future__ import absolute_import, division, print_function
import os

from pymor.analyticalproblems.elliptic import EllipticProblem
from pymor.domaindescriptions.basic import RectDomain
from pymor.domaindescriptions.boundarytypes import BoundaryType
from pymor.functions.basic import FunctionBase, ConstantFunction
from pymor.operators.constructions import VectorFunctional, LincombOperator, VectorOperator
from pymor.operators.interfaces import OperatorInterface
from pymor.parameters.functionals import ExpressionParameterFunctional
from pymor.parameters.spaces import CubicParameterSpace
from pymor.functions.bitmap import BitmapFunction

import numpy as np

def h_problem(closed_connections=(3, 4)):
    for i in closed_connections:
        assert i in (1, 2, 3, 4, 5, 6)

    filepath = os.path.dirname(os.path.realpath(__file__))
    rhsfunction = BitmapFunction(os.path.join(filepath,"rhs.png"), range=(-128, 127))
    rhsfunction = rhsfunction
    import pdb
    #pdb.set_trace()
    backgroundfunction = ConstantFunction(1., dim_domain=2)
    coefficientfunction = BitmapFunction(os.path.join(filepath,'h_allopen.png'), range=(1., 0.))
    for i in closed_connections:
        coefficientfunction = coefficientfunction + BitmapFunction(os.path.join(filepath,'h_close'+str(i)+'.png'), range=(1., 0))

    p = EllipticProblem(domain=RectDomain([[0, 0], [1, 1]]),
                        diffusion_functions=(backgroundfunction,
                                             coefficientfunction),
                        diffusion_functionals=(1.,
                                               1e5),
                        rhs=rhsfunction,
                        name="H")
    return p

def poisson_problem():
    backgroundfunction = ConstantFunction(1., dim_domain=2)


    p = EllipticProblem(domain=RectDomain([[0, 0], [1, 1]]),
                        diffusion_functions=(backgroundfunction,),
                        diffusion_functionals=(1.,),
                        rhs=ConstantFunction(1., dim_domain=2),
                        name="poisson")

    return p
