import numpy as np

import simdb

for experiment in ["H", "poisson"]:
    ex = simdb.SimulationDatabase().select_last(
        "local_global_error_fixed_basis_size",
        problem=experiment)
    
    lb = ex.d.local_bestapproximations
    ln = ex.d.local_norms[0,:]
    
    # relative approximations:
    lb = lb/ln
    # maximum over all spaces:
    lbmax = np.max(lb, axis=2)
    # do statistics
    lbmaxp = np.percentile(lbmax, [0,25,50,75,100], axis=0)
    
    #now gfem errors
    gfem_er = ex.d.gfem_errors / ex.d.norm_u
    # do statistics
    gfem_er = np.percentile(gfem_er, [0,25,50,75,100], axis=0)
    
    alldata = np.vstack((range(ex.p.max_basis_size), lbmaxp, gfem_er))
    
    open("local_global_errors_{}.dat".format(experiment), "w").writelines(
        [" ".join(map(str,v)) + "\n" for v in alldata.T]
)

