import simdb
import numpy as np
import matplotlib.pyplot as plt


for problem in reversed(["h", "poisson"]):
    ex = simdb.SimulationDatabase().select_last("local_approximations", problem=problem)
    plt.xscale("log")
    plt.yscale("log")
    plt.gca().invert_xaxis()

    plt.plot(ex.d.tolerances, ex.d.tolerances, "o-", label="x")
    for p in reversed([0,25,50,75,100]):
        plt.plot(ex.d.tolerances, np.percentile(ex.d.quotients, p, axis=0), label="{} percentile".format(p))

    plt.legend()
    plt.show()

    alldata = np.vstack((ex.d.tolerances,np.percentile(ex.d.quotients, [0,25,50,75,100], axis=0)))

    open("local_approximations_{}.dat".format(problem), "w").writelines([" ".join(map(str,v)) + "\n" for v in alldata.T])
