import simdb
import numpy as np
import matplotlib.pyplot as plt


for problem in ["h", "poisson"]:
    ex = simdb.SimulationDatabase().select_last("global_approximations", problem=problem)
    plt.xscale("log")
    plt.yscale("log")
    plt.gca().invert_xaxis()
    rel_errors = ex.d.errors / ex.d.global_energy_norm[0]

    for e in rel_errors:
        plt.plot(ex.d.tolerances, e)

    plt.plot(ex.d.tolerances, ex.d.tolerances, label="x")
    plt.plot(ex.d.tolerances, ex.d.tolerances * 1e-2, label="xe-2")
    plt.plot(ex.d.tolerances, ex.d.tolerances * 1e-4, label="xe-4")
    
    plt.show()

    alldata = np.vstack((ex.d.tolerances,np.percentile(rel_errors, [0,25,50,75,100], axis=0)))

    open("global_approximations_{}.dat".format(problem), "w").writelines([" ".join(map(str,v)) + "\n" for v in alldata.T])
