from problems import *
from localize_problem import localize_problem
from basis_generation import get_random_bases
from lrb_operator_projection import LRBOperatorProjection
from pymor.discretizations.basic import StationaryDiscretization
from pymor.operators.numpy import NumpyMatrixOperator
from pymor.operators.constructions import induced_norm
from pymor.vectorarrays.numpy import NumpyVectorArray
from algorithms import orthogonal_part

import simdb.run as sdb
from calculate_cq import calculate_cq

from operator_svd import *

def run_experiment(p):
    coarse_grid_resolution = 10
    resolution = 200
    gq, lq = localize_problem(p, coarse_grid_resolution, resolution)

    sdb.new_dataset("svddecay",
                    problem=p.name,
                    coarse_grid_resolution=coarse_grid_resolution,
                    resolution=resolution
                    )

    for ypos, xpos in np.ndindex((coarse_grid_resolution-1,coarse_grid_resolution-1)):
        ldict = lq[xpos, ypos]
        transop = ldict["transfer_operator"]
        transopmat = transop.apply(NumpyVectorArray(np.identity(transop.source.dim)))
        transop_assembled = NumpyMatrixOperator(transopmat.data.T)
        ts = operator_svd5(transop_assembled, ldict["source_l2_product"], ldict["range_energy_0_product"])
        ts = np.array(list(reversed(sorted(ts))))
        print("{} {}".format(xpos,ypos))
        sdb.append_values(svd=np.array(ts)[:200])

run_experiment(h_problem())
run_experiment(poisson_problem())
