import numpy as np
import scipy
import scipy.sparse
import scipy.sparse.linalg

def calculate_lambda_min(gq, lq):
    coarse_grid_resolution = gq["coarse_grid_resolution"]

    for ypos, xpos in np.ndindex((coarse_grid_resolution-1,coarse_grid_resolution-1)):
        ldict = lq[xpos, ypos]
        if not "lambda_min" in ldict.keys():
            ldict["lambda_min"] = scipy.sparse.linalg.eigsh(ldict["source_l2_product"]._matrix, return_eigenvectors=False, k=1, which="SM")[0]
