import numpy as np
import scipy

from problems import poisson_problem, h_problem
from localize_problem import localize_problem

from pymor.vectorarrays.numpy import NumpyVectorArray
from pymor.operators.numpy import NumpyMatrixOperator
from pymor.operators.constructions import induced_norm

def calculate_csi(gq, lq):
    l = gq["localizer"]

    show_images = False
    if show_images:
        images = gq["d"].solution_space.empty()

    coarse_grid_resolution = gq["coarse_grid_resolution"]
    for ypos, xpos in np.ndindex((coarse_grid_resolution-1,coarse_grid_resolution-1)):
        ldict = lq[xpos, ypos]

        if ldict["omega_star_has_dirichlet"]:
            mat1 = ldict["omega_star_energy_0_product"]
        else:
            mat1 = ldict["omega_star_fixed_energy_product"]

        mat1 = mat1._matrix

        mat2 = ldict["source_l2_product"]
        
        omega_star_space = ldict["omega_star_space"]
        omega_star_size = len(l.join_spaces(omega_star_space))

        source_space = ldict["source_space"]

        foo1 = NumpyVectorArray(np.identity(omega_star_size))
        foo2 = l.to_space(foo1, omega_star_space, source_space)
        foo3 = mat2.apply(foo2)
        foo4 = l.to_space(foo3, source_space, omega_star_space)
        mat2 = scipy.sparse.csr_matrix(foo4.data)

        eigval = scipy.sparse.linalg.eigsh(mat2, M=mat1, return_eigenvectors=True, k=1)
        maxval = np.sqrt(eigval[0][0])

        ldict["c_si"] = maxval
        if show_images:
            images.append(l.globalize_vector_array(NumpyVectorArray(eigval[1].T), omega_star_space))
        print("C_si on x/y {}/{} is {}".format(xpos, ypos, maxval))
        
    if show_images:
        gq["d"].visualize(images, rescale_colorbars=True)

if __name__ == "__main__":
    coarse_grid_resolution = 10
    gq, lq = localize_problem(h_problem(), coarse_grid_resolution, 200)
    calculate_csi(gq, lq)


