import numpy as np
import scipy

from problems import poisson_problem, h_problem
from localize_problem import localize_problem

from pymor.vectorarrays.numpy import NumpyVectorArray
from pymor.operators.numpy import NumpyMatrixOperator
from pymor.operators.constructions import induced_norm

def calculate_cq(gq, lq):
    l = gq["localizer"]

    show_images = False
    if show_images:
        images = gq["d"].solution_space.empty()

    coarse_grid_resolution = gq["coarse_grid_resolution"]
    for ypos, xpos in np.ndindex((coarse_grid_resolution-1,coarse_grid_resolution-1)):
        ldict = lq[xpos, ypos]

        if ldict["omega_has_dirichlet"]:
            mat1 = ldict["range_energy_0_product"]
        else:
            mat1 = ldict["range_fixed_energy_0_product"]

        mat1 = mat1._matrix

        mat2 = ldict["k_l2_product"]._matrix
        
        omega_space = ldict["range_space"]
        omega_size = len(l.join_spaces(omega_space))

        eigval = scipy.sparse.linalg.eigsh(mat2, M=mat1, return_eigenvectors=True, k=1)
        maxval = np.sqrt(eigval[0][0])
        if not ldict["omega_has_dirichlet"]:
            eigvec = NumpyVectorArray(eigval[1].T)
            constant_function = NumpyVectorArray(np.ones(eigvec.space.dim))
            constant_function_normed = constant_function * (1./induced_norm(ldict["k_l2_product"])(constant_function)[0])
            meanval = ldict["k_l2_product"].apply2(eigvec, constant_function_normed)
            # if this assert fires, the eigenvalue problem is not properly set up
            # consider increasing the constant in range_fixed_energy_0_problem.
            assert((meanval/induced_norm(ldict["k_l2_product"])(eigvec)[0]) < 1e-5 )

        ldict["c_q"] = maxval
        if show_images:
            images.append(l.globalize_vector_array(NumpyVectorArray(eigval[1].T), omega_space))
        print("C_Q on x/y {}/{} is {}".format(xpos, ypos, maxval))
        
    if show_images:
        gq["d"].visualize(images, rescale_colorbars=True)

if __name__ == "__main__":
    coarse_grid_resolution = 10
    gq, lq = localize_problem(h_problem(), coarse_grid_resolution, 200)
    calculate_cq(gq, lq)


