import numpy as np
import pickle
import matplotlib.pyplot as plt

result = pickle.load(file("experiment_helmholtz_algo_convergence_result.pickle","r"))

plt.yscale("log")
plt.xlim([0,10])


operatornorms = result["operatornorms"]
limits = [0, 25, 50, 75, 99, 100]
print("averaging over {}".format(operatornorms.shape))
percentiles = np.array(np.percentile(operatornorms, limits, axis=0))
means = np.mean(operatornorms, axis=0)
for l,p in zip(limits,percentiles):
    plt.plot(p, "o-", label=str(l))


alldata = np.vstack((percentiles.T,))
open("helmholtz_percentiles.dat", "w").writelines(
    [" ".join(map(str, v)) + "\n" for v in alldata]
    )

open("helmholtz_means.dat", "w").writelines(
    ["{}\n".format(m) for m in means])
