import numpy as np
import pickle
import matplotlib.pyplot as plt
import scipy
import scipy.special
from algorithms import testlimit

def basis_sizes(testvecnorms, tolerance, num_testvecs):
    assert num_testvecs <= testvecnorms.shape[2]
    maxtestvecnorms = np.max(testvecnorms[:,:,:num_testvecs], axis=2)
    result = np.sum(maxtestvecnorms > tolerance, axis=1)
    if np.any(result == testvecnorms.shape[1]):
        raise
    return result

result = pickle.load(file("experiment_helmholtz_algo_convergence_result.pickle","r"))

num_testvecs = 10
plt.yscale("log")
plt.xscale("log")


projectionerrors = result["operatornorms"]
testvecnorms = result["testvecnorms"]
all_errors = []
tolerances = np.logspace(4, -11, 50)
for tolerance in tolerances:
    limit = testlimit(
        failure_tolerance=1e-15,
        dim_S=result["dim_source"],
        dim_R=result["dim_range"],
        num_testvecs=num_testvecs,
        target_error=tolerance,
        lambda_min=result["lambdamin"]
        )

    try:
        bs = basis_sizes(testvecnorms, limit, num_testvecs=num_testvecs)
        errors = projectionerrors[range(len(projectionerrors)),bs]
    except:
        errors = np.array([np.float("nan") for _ in range(len(projectionerrors))])

    all_errors.append(errors)

all_errors = np.array(all_errors).T

limits = [0, 25, 50, 75, 100]
percentiles = np.percentile(all_errors, limits, axis=0)
for l, p in zip(limits, percentiles):
    plt.plot(tolerances, p, "o-", label=str(l))

plt.plot(tolerances, tolerances, label="1")
plt.plot(tolerances, tolerances * 1e-2, label="1e-2")
plt.plot(tolerances, tolerances * 1e-4, label="1e-4")
plt.gca().invert_xaxis()

plt.legend()
plt.show()

alldata = np.vstack((tolerances, percentiles))

open("helmholtz_adaptive_convergence.dat", "w").writelines(
    [" ".join(map(str, v)) + "\n" for v in alldata.T]
    )
