"""
This experiment compares the decay of the 
singular values of the transfer operator with the
projection error obtained by the non adaptive algorithm
"""

import numpy as np
import pickle

import matplotlib.pyplot as plt

plt.xlim([0,20])
plt.ylim([1e-16,1])
plt.yscale("log")


svddecay = pickle.load(file("svddecay.pickle", "r"))
plt.plot(svddecay["svals"], "o-", label="svd decay")

singular_values = svddecay["svals"]
scondition = svddecay["source_condition"]
scondition = scondition[1]/scondition[0]
scondition = scondition.real
rcondition = svddecay["range_condition"]
rcondition = rcondition[1]/rcondition[0]
rcondition = rcondition.real

print("condition in {}".format(scondition))

result = []
for n in range(2,20):
    expectation = np.sqrt(scondition * rcondition) * (
        (1 + np.sqrt(n-2.)) * singular_values[n-1 -1] +
        np.e * np.sqrt(n) / 2. * np.sum(singular_values[n-2:]**2)**0.5
        )
    result.append( (n, expectation) )

open("helmholtz_expectation.dat", "w").writelines(
    [" ".join(map(str,v)) + "\n" for v in result]
    )
# how to plot a-priori result?

plt.legend()
plt.show()

