import numpy as np
import scipy.sparse

elementmatrix = np.array(
[
[ 2./3., -1./6., -1./6., -1./3.],
[-1./6.,  2./3., -1./3., -1./6.],
[-1./6., -1./3.,  2./3., -1./6.],
[-1./3., -1./6., -1./6.,  2./3.]
]
)

def elementmatrix_l2_1d(h):
    return h*np.array([[1./3., 1./6.], [1./6., 1./3.]])

def assembly_l2_1d(n, h):
    """assembly of l2 inner product in 1d"""
    ndofs = n+1
    mtx = scipy.sparse.dok_matrix((ndofs,ndofs), dtype=np.float64)
    elementmatrix1d = elementmatrix_l2_1d(h)
    for elem in range(n):
        globaldofs = (elem, elem+1)
        for ldof1 in range(2):
            for ldof2 in range(2):
                mtx[globaldofs[ldof1],globaldofs[ldof2]] += elementmatrix1d[ldof1,ldof2]

    return mtx.tocsc()

def assembly(nx, ny):
    """
    nx elements times ny elements, 
    (nx+1) times (ny+1) unknowns
    """
    ndofs = (nx+1) * (ny+1)
    mtx = scipy.sparse.dok_matrix((ndofs,ndofs), dtype=np.float64)
    for xelem in range(nx):
        for yelem in range(ny):
            globaldofs = (
                xelem + 0 + (yelem + 0) * (nx+1),
                xelem + 1 + (yelem + 0) * (nx+1),
                xelem + 0 + (yelem + 1) * (nx+1),
                xelem + 1 + (yelem + 1) * (nx+1)
                )
            for ldof1 in range(4):
                for ldof2 in range(4):
                    mtx[globaldofs[ldof1],globaldofs[ldof2]] += elementmatrix[ldof1,ldof2]

    return mtx.tocsc()


