import numpy as np
import pickle
import matplotlib.pyplot as plt
import scipy
import scipy.special
from algorithms import testlimit

result = pickle.load(file("experiment_twosquares_algo_convergence_result.pickle","r"))

refine = 8
num_testvecs = 10
epsfail = 1e-10

plt.yscale("log")


projectionerrors = result[refine]["operatornorms"]
testvecnorms = result[refine]["testvecnorms"]
maxdim = min(result[refine]["dim_source"], result[refine]["dim_range"])
alldata = []
norm_est_eff = []
sizes = np.arange(2,100)
limits = np.linspace(0,100,101)
limits = [0,50,100]

for num_testvecs in sizes:
    cest = (np.sqrt(2 * np.abs(result[refine]["lambdamin"])) * scipy.special.erfinv(epsfail**(1./num_testvecs)) )**(-1)
    ceff = np.sqrt( scipy.special.gammainccinv(maxdim/2., epsfail/num_testvecs) * result[refine]["lambdamax"] / result[refine]["lambdamin"] ) * scipy.special.erfinv(epsfail**(1./num_testvecs))**(-1)
    quotients = []
    maxtestvecnorms = np.max(testvecnorms[:,:,:num_testvecs], axis=2)
    for vecnorm, opnorm in zip(maxtestvecnorms.flatten(), projectionerrors.flatten()):
        if vecnorm > 1e-10 and opnorm > 1e-10:
            quotients.append(vecnorm / opnorm)
    quotients = np.array(quotients)
    alldata.append(np.hstack((np.percentile(quotients.flatten(), limits), np.array(cest, ceff))))

cestinv = np.sqrt(2 * np.abs(result[refine]["lambdamin"])) * scipy.special.erfinv(epsfail**(1./sizes))
plt.plot(sizes, cestinv, label="lower")
alldata = np.array(alldata)
plt.plot(sizes,alldata[:,:-1])

ceff_cestinv = (2. * np.abs(result[refine]["lambdamax"]) * scipy.special.gammainccinv(maxdim/2, epsfail/sizes) ) ** 0.5
plt.plot(sizes, ceff_cestinv, label="upper")

plt.legend()
plt.show()

plotdata = np.vstack((sizes, cestinv, alldata.T, ceff_cestinv)).T

open("twosquares_testvecnorms.dat", "w").writelines(
    [" ".join(map(str, v)) + "\n" for v in plotdata]
    )
