"""
This experiment compares the decay of the 
singular values of the transfer operator with the
projection error obtained by the non adaptive algorithm
"""

import numpy as np
import pickle

import matplotlib.pyplot as plt

plt.xlim([0,10])
plt.ylim([1e-16,1])
plt.yscale("log")

refine = 8

#result = pickle.load(file("experiment_twosquares_algo_convergence_result.pickle","r"))

#merrors = np.mean(result[refine]["operatornorms"], axis=0)
#plt.plot(merrors,"o-", label="mean error random algo h={}".format(1./(refine*20)))

svddecay = pickle.load(file("svddecay.pickle", "r"))
plt.plot(svddecay["sval"][refine], "o-", label="svd decay")

singular_values = svddecay["sval"][refine]
scondition = svddecay["source_condition"][refine]
scondition = scondition[1]/scondition[0]
scondition = scondition.real
rcondition = svddecay["range_condition"][refine]
rcondition = rcondition[1]/rcondition[0]
rcondition = rcondition.real

print("condition in {}".format(scondition))

result = []
for n in range(2,13):
    expectation = np.sqrt(scondition * rcondition) * (
        (1 + np.sqrt(n-2.)) * singular_values[n-1 -1] +
        np.e * np.sqrt(n) / 2. * np.sum(singular_values[n-2:]**2)**0.5
        )
    result.append( (n, expectation) )

open("twosquares_expectation.dat", "w").writelines(
    [" ".join(map(str,v)) + "\n" for v in result]
    )
# how to plot a-priori result?

plt.legend()
plt.show()

