import numpy as np
import pickle
import matplotlib.pyplot as plt

result = pickle.load(file("experiment_h_algo_convergence_result.pickle","r"))
svddecay = pickle.load(file("experiment_h_svddecay.pickle", "r"))

num_testvecs = 10

outfile = open("twosquares_h_table.dat", "w")
outfile.write("1/h, basis size, expectation, meanopnorm, meantestvecnorm\n")
for basis_size in [2,4,6,8,10,12]:
    for refine in [1,2,4,8,16]:
        singular_values = svddecay["sval"][refine]
        scondition = svddecay["source_condition"][refine]
        scondition = scondition[1]/scondition[0]
        scondition = scondition.real
        rcondition = svddecay["range_condition"][refine]
        rcondition = rcondition[1]/rcondition[0]
        rcondition = rcondition.real

        expectation = np.sqrt(scondition * rcondition) * (
            (1 + np.sqrt(basis_size-2.)) * singular_values[basis_size-1 -1] +
            np.e * np.sqrt(basis_size) / 2. * np.sum(singular_values[basis_size-2:]**2)**0.5
            )

        mean_opnorm = np.median(result[refine]["operatornorms"][:,basis_size])

        mean_maxtestvecnorm = np.median(
            np.max(result[refine]["testvecnorms"][:,basis_size,:num_testvecs], axis=1)
            /
            result[refine]["operatornorms"][:,basis_size]
            )

        outfile.write("{}, {}, {}, {}, {}\n".format(
                20*refine,
                basis_size,
                expectation / mean_opnorm,
                mean_opnorm,
                mean_maxtestvecnorm
                ))



outfile = open("experiment_h_deviation.dat", "w")
outfile.write("1/h 2 4 6 8 10 12\n")
for refine in [1,2,4,8,16]:
    outfile.write("{} {} {} {} {} {} {}\n".format(
            20*refine,
            np.median(result[refine]["operatornorms"][:,2]),
            np.median(result[refine]["operatornorms"][:,4]),
            np.median(result[refine]["operatornorms"][:,6]),
            np.median(result[refine]["operatornorms"][:,8]),
            np.median(result[refine]["operatornorms"][:,10]),
            np.median(result[refine]["operatornorms"][:,12])
            ))


outfile = open("experiment_h_testvecs.dat", "w")
outfile.write("1/h 2 4 6 8 10 12\n")
for refine in [1,2,4,8,16]:
    outfile.write("{} {} {} {} {} {} {}\n".format(
            20*refine,
            np.median(np.max(result[refine]["testvecnorms"][:,2,:num_testvecs], axis=1)
                      /
                      result[refine]["operatornorms"][:,2]
                      ),
            np.median(np.max(result[refine]["testvecnorms"][:,4,:num_testvecs], axis=1)
                      /
                      result[refine]["operatornorms"][:,4]
                      ),
            np.median(np.max(result[refine]["testvecnorms"][:,6,:num_testvecs], axis=1)
                      /
                      result[refine]["operatornorms"][:,6]
                      ),
            np.median(np.max(result[refine]["testvecnorms"][:,8,:num_testvecs], axis=1)
                      /
                      result[refine]["operatornorms"][:,8]
                      ),
            np.median(np.max(result[refine]["testvecnorms"][:,10,:num_testvecs], axis=1)
                      /
                      result[refine]["operatornorms"][:,10]
                      ),
            np.median(np.max(result[refine]["testvecnorms"][:,12,:num_testvecs], axis=1)
                      /
                      result[refine]["operatornorms"][:,12]
                      )
            ))
