"""
This experiment compares the decay of the 
singular values of the transfer operator with the
values predicted by analysis
"""

import numpy as np
import scipy.sparse
import pickle
from transferoperator import transferoperator_interfaces
from algorithms import operator_svd
import matplotlib.pyplot as plt
from algorithms import gram_schmidt

refine = 8
nx = 40*refine
ny = 20*refine
(top, source_inner, range_inner) = transferoperator_interfaces(nx, ny)
_, _, omodes = operator_svd(top, source_inner, range_inner)
omodes = np.array(omodes).real[:,:5]

scipy.random.seed(42)
modes = top.dot(scipy.random.normal(size=(top.shape[1], 5)))
gram_schmidt(modes, range_inner, 0)
gram_schmidt(omodes, range_inner, 0)

for i in range(modes.shape[1]):
    plt.plot(np.arange(ny+1) /float(ny), modes[:,i], label=str(i))

plt.legend()
plt.show()

for i in range(min(omodes.shape[1],5)):
    plt.plot(np.arange(ny+1) /float(ny), omodes[:,i], label=str(i))

plt.legend()
plt.show()

open("modes.dat", "w").writelines([" ".join(map(str,modes[i,:])) + "\n" for i in range(modes.shape[0])])
open("omodes.dat", "w").writelines([" ".join(map(str,omodes[i,:])) + "\n" for i in range(omodes.shape[0])])
