"""
This experiment compares the decay of the 
singular values of the transfer operator with the
values predicted by analysis
"""

import numpy as np
import scipy.sparse
import pickle
from transferoperator import transferoperator_interfaces
from algorithms import operator_svd
import matplotlib.pyplot as plt

plt.xlim([0,19])
plt.ylim([1e-20,1])
plt.yscale("log")

result = {}
result["source_condition"] = {}
result["range_condition"] = {}
result["sval"] = {}
result["lambdamin"] = {}
result["lambdamax"] = {}
for refine in [1,2,4,8,16]:
    nx = 20*refine
    ny = 20*refine
    (top, source_inner, range_inner) = transferoperator_interfaces(nx, ny)
    s,_,_ = operator_svd(top, source_inner, range_inner)
    plt.plot(s,"o-", label="h={}".format(1./ny))
    result["sval"][refine] = s
    leigenvalues = scipy.sparse.linalg.eigs(source_inner, return_eigenvectors=False, which="LM")
    seigenvalues = scipy.sparse.linalg.eigs(source_inner, return_eigenvectors=False, which="SM")
    print leigenvalues, seigenvalues
    result["source_condition"][refine] = (np.min(seigenvalues), np.max(leigenvalues))
    result["range_condition"][refine] = (np.min(scipy.sparse.linalg.eigs(range_inner, return_eigenvectors=False, which="SM")), 
                                         np.max(scipy.sparse.linalg.eigs(range_inner, return_eigenvectors=False, which="LM")))
    result["lambdamin"][refine] = np.min(seigenvalues)
    result["lambdamax"][refine] = np.max(leigenvalues)
    print("eigenvalues are {}".format(result["source_condition"][refine]))

pickle.dump(result, open("experiment_h_svddecay.pickle","w"))

analytical = 0.5*np.cosh(np.array(range(14)) * np.pi * 0.5)**(-2)
plt.plot(np.sqrt(analytical), "--", label="analytical")
plt.legend()
#plt.show()

for refine in [1,2,4,8,16]:
    open("experiment_h_svddecay_{}.dat".format(refine), "w").writelines(
        ["{} {}\n".format(i,e) for i,e in enumerate(result["sval"][refine])]
        )
