"""
This file runs the randomized range generation code and
writes the results to a pickle file
"""

import sys
import numpy as np
import scipy
from transferoperator import transferoperator_interfaces
from algorithms import range_generation
import pickle

samples = 10000
num_testvecs = 100

result = {}
for refine in [1,2,4,8,16]:
    result[refine] = {}
    nx = 20*refine
    ny = 20*refine
    operatornorms = []
    testvecnorms = []
    (top, source_inner, range_inner) = transferoperator_interfaces(nx, ny)
    for i in range(samples):
        if i%10 == 0:
          sys.stdout.write(".")
          sys.stdout.flush()
        opnorms, tvnorms = range_generation(top, range_inner, source_inner, num_testvecs=num_testvecs)
        operatornorms.append(opnorms)
        testvecnorms.append(tvnorms)

    sys.stdout.write("\n")
    result[refine]["operatornorms"] = np.array(operatornorms)
    result[refine]["testvecnorms"] = np.array(testvecnorms)
    # testvecnorms has three dimensions:
    # 1. sample, 2. basis size 3. testvecnum
    result[refine]["lambdamin"] = np.min(scipy.sparse.linalg.eigs(source_inner, return_eigenvectors=False, which="SM"))
    result[refine]["dim_source"] = source_inner.shape[0]
    result[refine]["dim_range"] = range_inner.shape[0]
    

pickle.dump(result, open("experiment_h_algo_convergence_result.pickle","w"))


