% Generated by roxygen2 (4.0.1): do not edit by hand
\name{read.output}
\alias{read.output}
\title{Read model output}
\usage{
read.output(runid, outdir, start.year = NA, end.year = NA,
  variables = "GPP")
}
\arguments{
\item{runid}{the id distiguishing the model run.}

\item{outdir}{the directory that the model's output was sent to}

\item{start.year}{first year of output to read (should be greater than )}

\item{end.year}{last year of output to read}

\item{variables}{variables to be read from model output}
}
\value{
vector of output variable
}
\description{
Reads the output of a single model run
}
\details{
Generic function to convert model output from model-specific format to
a common PEcAn format. This function uses MsTMIP variables except that units of
 (kg m-2 d-1)  are converted to kg ha-1 y-1. Currently this function converts
Carbon fluxes: GPP, NPP, NEE, TotalResp, AutoResp, HeteroResp,
DOC_flux, Fire_flux, and Stem (Stem is specific to the BioCro model)
and Water fluxes: Evaporation (Evap), Transpiration(TVeg),
surface runoff (Qs), subsurface runoff (Qsb), and rainfall (Rainf).
For more details, see the
\href{http://nacp.ornl.gov/MsTMIP_variables.shtml}{MsTMIP variables}
documentation
}
\author{
Michael Dietze, David LeBauer
}

