% Generated by roxygen2 (4.0.1): do not edit by hand
\name{r2bugs.distributions}
\alias{r2bugs.distributions}
\title{convert R parameterizations to BUGS paramaterizations}
\usage{
r2bugs.distributions(priors, direction = "r2bugs")
}
\arguments{
\item{priors}{data.frame with columns distn = distribution name, parama, paramb using R default parameterizations}
}
\value{
priors dataframe using JAGS default parameterizations
}
\description{
convert R parameterizations to BUGS paramaterizations
}
\details{
R and BUGS have different parameterizations for some distributions. This function transforms the distributions from R defaults to BUGS defaults. BUGS is an implementation of the BUGS language, and these transformations are expected to work for bugs.
}
\examples{
priors <- data.frame(distn = c('weibull', 'lnorm', 'norm', 'gamma'),
                     parama = c(1, 1, 1, 1),
                     paramb = c(2, 2, 2, 2))
r2bugs.distributions(priors)
}
\author{
David LeBauer, Ben Bolker
}

