\name{spline.truncate}
\alias{spline.truncate}
\title{Truncate spline}
\usage{
  spline.truncate(x, min.quantile = pnorm(-3))
}
\arguments{
  \item{x}{vector}

  \item{min.quantile}{threshold quantile for testing lower
  bound on variable}
}
\value{
  either x or a vector with values < 0 converted to zero
}
\description{
  Truncate spline at zero if..
}
\details{
  Truncate spline at zero if P[x<0] < pnorm(-3) pnorm(-3)
  chosen as default value for min quantile because this is
  the default low end of range for the sensitivity
  analysis. This parameter could be determined based on
  minimum value in settings$sensitivity.analysis$quantiles
}
\examples{
set.seed(0)
x <- c(rgamma(998,1,1), rnorm(10))
min(x) # -0.5238
min(PEcAn.uncertainty::spline.truncate(x))
}
\author{
  David LeBauer
}

