\name{plot.variance.decomposition}
\alias{plot.variance.decomposition}
\title{Variance Decomposition Plots}
\usage{
  plot.variance.decomposition(plot.inputs,
    fontsize = list(title = 18, axis = 14))
}
\arguments{
  \item{...}{Output from any number of sensitivity
  analyses. Output must be of the form given by
  sensitivity.results$variance.decomposition.output in
  model output}

  \item{all.plot.inputs}{Optional argument allowing output
  from sensitivity analyses to be specified in a list}

  \item{exclude}{vector of strings specifying parameters to
  omit from the variance decomposition graph}

  \item{convert.var}{function transforming variances to the
  value displayed in the graph}

  \item{var.label}{label to displayed over variance column}

  \item{order.plot.input}{Output from a sensitivity
  analysis that is to be used to order parameters.
  Parameters are ordered by variance. Defaults to the first
  sensitivity analysis output given}

  \item{ticks.plot.input}{Output from a sensitivity
  analysis that is to be used.  Defaults to the first
  sensitivity analysis output given}

  \item{col}{Color of each sensitivity analysis. Equivalent
  to col parameter of the plot function.}

  \item{pch}{Shape of each sensitivity analysis. Equivalent
  to pch parameter of the plot function.}

  \item{main}{Plot title. Useful for multi-pft variance
  decompositions.}

  \item{fontsize}{list specifying the font size of the
  titles and axes of the graph}
}
\description{
  Plot results of variance decomposition
}
\details{
  Plots variance decomposition tryptich
}
\examples{
x <- list(trait.labels = c("a", "b", "c"),
          coef.vars = c(a=1,b=0.5, c=0.1),
          elasticities = c(a=1,b=2,c=0.5),
          variances    = c(a = 20, b=30, c = 10))
do.call(grid.arrange, c(plot.variance.decomposition(x), ncol = 4))
}
\author{
  David LeBauer, Carl Davidson
}

