\name{prior.fn}
\alias{prior.fn}
\title{prior.fn}
\usage{
  prior.fn(parms, x, alpha, distn, central.tendency = NULL,
    trait = NULL)
}
\arguments{
  \item{parms}{target for optimization}

  \item{x}{vector with c(lcl, ucl, ct) lcl / ucl =
  confidence limits, ct = entral tendency}

  \item{alpha}{quantile at which lcl/ucl are estimated
  (e.g. for a 95% CI, alpha = 0.5)}

  \item{distn}{named distribution, one of 'lnorm', 'gamma',
  'weibull', 'beta'; support for other distributions not
  currently implemented}

  \item{central.tendency}{one of 'mode', 'median', and
  'mean'}

  \item{trait}{name of trait, can be used for exceptions
  (currently used for trait == 'q')}
}
\value{
  parms
}
\description{
  Prior fitting function for optimization
}
\details{
  This function is used within \code{\link{DEoptim}} to
  parameterize a distribution to the central tendency and
  confidence interval of a parameter. This function is not
  very robust; currently it needs to be tweaked when
  distributions require starting values (e.g. beta, f)
}
\examples{
DEoptim(fn = prior.fn,
                lower = c(0, 0),
                upper = c(1000, 1000),
                x=c(2, 6, 3.3),
                alpha = 0.05,
                distn = 'lnorm')$optim$bestmem
}
\author{
  David LeBauer
}

