\name{approx.posterior}
\alias{approx.posterior}
\title{Approximate posterior}
\usage{
  approx.posterior(trait.mcmc, priors, trait.data = NULL,
    outdir = NULL)
}
\arguments{
  \item{trait.mcmc}{meta analysis outputs}

  \item{priors}{dataframe of priors used in meta analysis}

  \item{trait.data}{data used in meta-analysis (used for
  plotting)}

  \item{outdir}{directory in which to plot results}
}
\value{
  posteriors data frame, similar to priors, but with closed
  form pdfs fit to meta-analysis results
}
\description{
  Approximate the posterior MCMC with a closed form pdf
}
\details{
  returns priors where posterior MCMC are missing
}
\examples{
\dontrun{data("trait.mcmc", package = "PEcAn.utils")
data("prior.distns", package = "PEcAn.utils")
approx.posterior(trait.mcmc, priors = prior.distns)}
}
\author{
  David LeBauer, Carl Davidson, Mike Dietze
}

