\name{subset.layer}
\alias{subset.layer}
\title{Function to subset and clip a GIS vector or raster layer by a bounding box
or clip/subset layer (e.g. shapefile/KML)}
\usage{
  subset.layer(file, coords = NULL, sub.layer = NULL,
    clip = FALSE, out.dir = NULL, out.name = NULL)
}
\arguments{
  \item{file}{input file to be subset}

  \item{coords}{vector with xmin,ymin,xmax,ymax defing the
  bounding box for subset}

  \item{sub.layer}{Vector layer defining the subset region}

  \item{clip}{clip geometries to bounding box/subset layer?
  TRUE/FALSE}

  \item{out.dir}{output directory for subset layer.
  Defaults to location of input file.  Can also set to
  "pwd"}

  \item{out.name}{filename for subset layer.  Defaults to
  original filename with the suffix *.sub}
}
\description{
  Function to subset and clip a GIS vector or raster layer
  by a bounding box or clip/subset layer (e.g.
  shapefile/KML)
}
\examples{
\dontrun{
# Test dataset
file <- Sys.glob(file.path(R.home(), "library", "PEcAn.data.land","data","*.shp"))
out.dir <- path.expand("~/temp")
# with clipping enabled
subset.layer(file=file,coords=c(-95,42,-84,47),clip=TRUE,out.dir=out.dir)
# without clipping enables
subset.layer(file=file,coords=c(-95,42,-84,47),out.dir=out.dir)
system(paste("rm -r",out.dir,sep=""))
}
}
\author{
  Shawn P. Serbin
}

