% Generated by roxygen2 (4.0.1): do not edit by hand
\name{solarMJ2ppfd}
\alias{solarMJ2ppfd}
\title{MJ to PPFD}
\usage{
solarMJ2ppfd(solarMJ)
}
\arguments{
\item{solarMJ}{MJ per day}
}
\value{
PPFD umol /m2 / s
}
\description{
Solar Radiation to PPFD
}
\details{
There is no easy straight way to convert MJ/m2 to mu mol photons / m2 / s (PAR)
The above conversion is based on the following reasoning
0.12 is about how much of the total radiation is expected to ocurr during the hour of maximum insolation (it is a guesstimate)
2.07 is a coefficient which converts from MJ to mol photons (it is approximate and it is taken from ...
Campbell and Norman (1998). Introduction to Environmental Biophysics. pg 151 'the energy content of solar radiation in the PAR waveband is 2.35 x 10^5 J/mol'
See also the chapter radiation basics (10)
Here the input is the total solar radiation so to obtain in the PAR spectrum need to multiply by 0.486
This last value 0.486 is based on the approximation that PAR is 0.45-0.50 of the total radiation
This means that 1e6 / (2.35e6) * 0.486 = 2.07
1e6 converts from mol to mu mol
1/3600 divides the values in hours to seconds
}
\author{
Fernando Miguez

David LeBauer
}

