\name{read.allom.data}
\alias{read.allom.data}
\title{read.allom.data}
\usage{
  read.allom.data(pft.data, component, field, parm,
    nsim = 10000)
}
\arguments{
  \item{pft.data}{PFT dataframe \itemize{
  \item{acronym}{USDA species acronyms, used with FIELD
  data (vector)} \item{spcd}{USFS species codes, use with
  TALLY data (vector)} }}

  \item{component}{allometry ID, Jenkins table 5}

  \item{field}{raw field data}

  \item{parm}{allometry equation file, Jenkins table 3}

  \item{nsim}{number of Monte Carlo draws in numerical
  transforms}
}
\value{
  \item{field}{PFT-filtered field Data}
  \item{parm}{Component- and PFT-filtered Allometric
  Equations}
}
\description{
  Extracts PFT- and component-specific data and allometeric
  equations from the specified files.
}
\details{
  This code also estimates the standard error from
  R-squared, which is required to simulate pseudodata from
  the allometric eqns.
}

