! DART software - Copyright 2004 - 2011 UCAR. This open source software is
! provided by UCAR, "as is", without charge, subject to all terms of use at
! http://www.image.ucar.edu/DAReS/DART/DART_download

!----------------------------------------------------------------------
! WARNING!!  The file obs_kind_mod.f90 is AUTOGENERATED by the
! 'preprocess' program.  Any changes made to this file will be
! overwritten when it is regenerated.  To make permanent changes
! in the code, edit DEFAULT_obs_kind_mod.F90, or edit the
! observation specific obs_def_xxx_mod.f90 files.
!----------------------------------------------------------------------

module obs_kind_mod

! <next few lines under version control, do not edit>
! $URL: https://proxy.subversion.ucar.edu/DAReS/DART/releases/Kodiak/obs_kind/DEFAULT_obs_kind_mod.F90 $
! $Id: DEFAULT_obs_kind_mod.F90 5809 2012-07-20 23:00:49Z thoar $
! $Revision: 5809 $
! $Date: 2012-07-20 19:00:49 -0400 (Fri, 20 Jul 2012) $

use    utilities_mod, only : register_module, error_handler,  &
                             E_ERR, E_MSG, E_WARN,               &
                             logfileunit, find_namelist_in_file, &
                             check_namelist_read, do_output, ascii_file_format

implicit none
private

public :: get_obs_kind_name, assimilate_this_obs_kind, &
          evaluate_this_obs_kind, get_obs_kind_var_type, get_obs_kind_index, &
          write_obs_kind, read_obs_kind, get_kind_from_menu, map_def_index
! Added by TRW for restart file functionality
public :: get_raw_obs_kind_name, get_raw_obs_kind_index
! Added by nsc to try to limit the number of global vars exported from
! this program.  i do not like this terminology, but since we are still
! using kind where we mean type, raw kind is as good a solution as anything.
! when i get permission to change public interfaces (next significant public
! release of the code), all kinds will become types, and raw_kind will become
! plain kind.  or i'll dump type/kind altogether and go to specific/generic
! or some other pair without this long history.
public :: get_num_obs_kinds, get_num_raw_obs_kinds

public :: do_obs_form_pair, add_wind_names

!----------------------------------------------------------------------------
! Note: this list is currently maintained by hand; new kinds must be added
! to the DEFAULT_obs_kind_mod.F90 file and then the preprocess program must
! be rerun to generate a obs_kind_mod.f90 file for use by the rest of the
! DART system.  Future versions of the preprocess program will be able to
! generate this table automatically.

! F90 currently has a maximum length of 32 characters for the NAME of
! any Fortran PARAMETER. 

integer, parameter, public :: paramname_length = 32

! Definition and public access to the observation types/kinds
! Unique index values associated with each observation type and 
! kind strings are defined here. 

integer, parameter, public :: &
    KIND_RAW_STATE_VARIABLE          = 0, &
    KIND_U_WIND_COMPONENT            = 1, &
    KIND_V_WIND_COMPONENT            = 2, &
    KIND_SURFACE_PRESSURE            = 3, &
    KIND_TEMPERATURE                 = 4, &
    KIND_SPECIFIC_HUMIDITY           = 5, &
    KIND_PRESSURE                    = 6, &
    KIND_VERTICAL_VELOCITY           = 7, &
    KIND_RAINWATER_MIXING_RATIO      = 8, &
    KIND_DEWPOINT                    = 9, &
    KIND_DENSITY                     = 10, &
    KIND_VELOCITY                    = 11, &
    KIND_RADAR_REFLECTIVITY          = 12, &
    KIND_1D_INTEGRAL                 = 13, &
    KIND_GRAUPEL_MIXING_RATIO        = 14, &
    KIND_SNOW_MIXING_RATIO           = 15, &
    KIND_GPSRO                       = 16, &
    KIND_CLOUD_LIQUID_WATER          = 17, &
    KIND_CLOUD_ICE                   = 18, &
    KIND_CONDENSATIONAL_HEATING      = 19, &
    KIND_VAPOR_MIXING_RATIO          = 20, &
    KIND_ICE_NUMBER_CONCENTRATION    = 21, &
    KIND_GEOPOTENTIAL_HEIGHT         = 22, &
    KIND_POTENTIAL_TEMPERATURE       = 23, &
    KIND_SOIL_MOISTURE               = 24, &
    KIND_SURFACE_ELEVATION           = 25
                       
! kinds for Gravity Wave Drag (CAM - kevin)
integer, parameter, public :: &
    KIND_GRAV_WAVE_DRAG_EFFIC        = 26, &
    KIND_GRAV_WAVE_STRESS_FRACTION   = 27
                       
! kinds for simple advection model
integer, parameter, public :: &
    KIND_TRACER_SOURCE               = 28, &
    KIND_TRACER_CONCENTRATION        = 29, &
    KIND_MEAN_SOURCE                 = 30, &
    KIND_SOURCE_PHASE                = 31
 
! kind for power-weighted precipitation fall speed
! and a few other kinds that were missing from the
! collection of fractions and mixing ratio definitions.
! (CONCENTRATION -> CONCENTR because the max len of
! these strings is still 32 chars.)

! WARNING: the current models use 
! KIND_CLOUD_LIQUID_WATER and KIND_CLOUD_ICE
! for mixing ratios.  because current models are
! using them, we can't make them consistent with
! the rest of the names - but in the next release
! we will be changing over to using mixing-ratio
! in the names and removing the old ones.
integer, parameter, public :: &
    KIND_POWER_WEIGHTED_FALL_SPEED   = 32, &
    KIND_CLOUDWATER_MIXING_RATIO     = 33, &
    KIND_ICE_MIXING_RATIO            = 34, &
    KIND_DROPLET_NUMBER_CONCENTR     = 35, & 
    KIND_SNOW_NUMBER_CONCENTR        = 36, &
    KIND_RAIN_NUMBER_CONCENTR        = 37, &
    KIND_GRAUPEL_NUMBER_CONCENTR     = 38, &
    KIND_CLOUD_FRACTION              = 39, &
    KIND_ICE_FRACTION                = 40, &
    KIND_RELATIVE_HUMIDITY           = 41

! kinds for TIEgcm 
integer, parameter, public :: &
    KIND_ELECTRON_DENSITY            = 42
   
! kinds for generic parameters that aren't going to be
! directly observed but are going to be adjusted by the
! assimilation.
integer, parameter, public :: &
    KIND_1D_PARAMETER                = 43, &
    KIND_2D_PARAMETER                = 44, &
    KIND_3D_PARAMETER                = 45

! kinds for CHAMP upper atmosphere computations
integer, parameter, public :: &
    KIND_ATOMIC_OXYGEN_MIXING_RATIO  = 46, &
    KIND_MOLEC_OXYGEN_MIXING_RATIO   = 47

! kinds for tendencies
integer, parameter, public :: &
    KIND_ALTIMETER_TENDENCY          = 48

! kinds for the MITgcm, POP ocean model
integer, parameter, public :: &
    KIND_SALINITY                    = 50, &
    KIND_U_CURRENT_COMPONENT         = 51, &
    KIND_V_CURRENT_COMPONENT         = 52, &
    KIND_SEA_SURFACE_HEIGHT          = 53, &
    KIND_DRY_LAND                    = 54, &
    KIND_SEA_SURFACE_PRESSURE        = 55, &
    KIND_W_CURRENT_COMPONENT         = 56
 
! proposed new kinds for COSMIC GPS/RO obs
! (currently unused)
integer, parameter, public :: &
    KIND_OCCULTATION_REFRACTIVITY    = 57, &
    KIND_OCCULTATION_EXCESSPHASE     = 58

! kinds for satellite radiances (jason o.)
integer, parameter, public :: &
    KIND_INFRARED_RADIANCE           = 60, &
    KIND_INFRARED_BRIGHT_TEMP        = 61, &
    KIND_LANDMASK                    = 62
                                     
! kind for accumulated value - total water in a column
integer, parameter, public :: &
    KIND_TOTAL_PRECIPITABLE_WATER    = 63

! kind for phenological variables
integer, parameter, public :: &
    KIND_LEAF_AREA_INDEX	     = 64, &
    KIND_GREEN_LEAF_FACTOR	     = 65, &
    KIND_PRESCRIBED_EXPONENT	     = 66, &
    KIND_FILLER			     = 67  

! kinds for planetary remote sensing (wglawson, c.lee)
integer, parameter, public :: &
    KIND_SKIN_TEMPERATURE            = 70, &
    KIND_NADIR_RADIANCE              = 71, &
    KIND_TRACER_1_MIXING_RATIO       = 72, &  ! for active dust aerosols
    KIND_TRACER_2_MIXING_RATIO       = 73, &  ! for active dust aerosols
    ! Is KIND_TRACER_MIXING_RATIO necessary with KIND_TRACER_CONCENTRATION
    !   (= 29) available from the simple advection model?
    KIND_SOIL_TEMPERATURE            = 74, &  ! missing from WRF model_mod (?)
    KIND_SOIL_LIQUID_WATER           = 75     ! missing from WRF model_mod (?)

! kinds for NCOMMAS  (Lou W., Ted M.)
integer, parameter, public :: &
    KIND_VERTICAL_VORTICITY          = 76

! more kinds for planetary remote sensing (c.lee)
integer, parameter, public :: &
    KIND_SURFACE_ALBEDO              = 77, &
    KIND_SURFACE_EMISSIVITY          = 78, &
    KIND_DUST_OPACITY_7MB            = 79, &
    KIND_THC                         = 80

! kinds for vortex tracking (WRF - yongsheng)
integer, parameter, public :: &
    KIND_VORTEX_LON                  = 81, &
    KIND_VORTEX_LAT                  = 82, &
    KIND_VORTEX_PMIN                 = 83, &
    KIND_VORTEX_WMAX                 = 84, &
 
! kinds for COAMPS (Tim Whitcomb)
    KIND_EXNER_FUNCTION              = 85, &
    KIND_TURBULENT_KINETIC_ENERGY    = 86, &
    KIND_VERTLEVEL                   = 87

 
!! PRIVATE ONLY TO THIS MODULE. see comment below near the max_obs_specific
!! declaration.
integer, parameter :: max_obs_generic = 87

!----------------------------------------------------------------------------
! This list is autogenerated by the 'preprocess' program.  To add new 
! observation types (e.g. AIRS_U_WIND_COMPONENT), edit the obs_def_x_mod.f90
! files and also add (or remove) them from the 'input_files' variable of 
! the &preprocess_nml namelist in the model-specific work/input.nml file.

! Unique index values associated with each observation type string are
! are defined here. The total number of obs_types is also set in public
! parameter max_obs_kinds.

! DART PREPROCESS INTEGER DECLARATION INSERTED HERE


!----------------------------------------------------------------------------

! version controlled file description for error handling, do not edit
character(len=128), parameter :: &
   source   = "$URL: https://proxy.subversion.ucar.edu/DAReS/DART/releases/Kodiak/obs_kind/DEFAULT_obs_kind_mod.F90 $", &
   revision = "$Revision: 5809 $", &
   revdate  = "$Date: 2012-07-20 19:00:49 -0400 (Fri, 20 Jul 2012) $"

logical, save :: module_initialized = .false.

!! max_obs_kinds is really max_obs_types, and is generated by preprocess.

!! PRIVATE ONLY TO THIS MODULE.  max_obs_kinds is really max_obs_types,
!! but since the original variable name is public it can't change without
!! being non-backwards compatible.  for now, punt on both type and kind
!! and start trying to use specific and generic (ok, which do map to type
!! and kind, respectively).  using intermediate names might make the transition
!! less painful.  right now, many(most) of the subroutine names or args 
!! which are public are using 'kind' where it needs to be 'type'.
integer, parameter :: max_obs_specific = max_obs_kinds

character(len=129) :: msg_string

integer :: num_kind_assimilate, num_kind_evaluate

! Map from values of kind in obs_def to the fixed values in the list above.
! Initially, these are undefined and have values -1.
! For the first index 1, the value is the index in the input obs_sequence file.
! The first index 2 is the value of the corresponding index in this kind module.
integer :: map(2, max_obs_specific) = -1

! An observation kind type links together all the information required.
! An integer index that is also associated with the parameter above,
! A character string that has the same string as the parameter above,
! an integer that indicates what kind of variable type this is (for
! instance a radiosonde u wind component is a u wind component, but so
! is a 10 meter u wind component), and two logicals that indicate
! whether observations of this kind are to be assimilated, evaluated,
! or neither. Name lengths are limited to 32 characters by compiler
! restrictions on the length of parameter identifiers.
type obs_type_type
   integer              :: index
   character(len = paramname_length) :: name
   integer              :: var_type
   logical              :: assimilate
   logical              :: evaluate
end type obs_type_type

! An obs_type_type is defined by the preprocessor to store the association
! between obs_types, associated integer identifiers, the underlying kind,
! and whether observations of this type should be assimilate or evaluated.
type(obs_type_type) :: obs_type_info(max_obs_specific)

type obs_kind_type
   integer              :: index
   character(len = paramname_length) :: name
end type obs_kind_type

! An obs_kind_name_type is defined by the preprocess program to store 
! the association between obs_kind index numbers and string names.
! raw is index 0, so this needs to match.  revisit the direct indexing
! since we have an index in the table -- redundant info?
type(obs_kind_type) :: obs_kind_names(0:max_obs_generic)

! Namelist array to turn on any requested observation types
character(len = 129) :: assimilate_these_obs_types(max_obs_specific) = 'null'
character(len = 129) :: evaluate_these_obs_types(max_obs_specific) = 'null'

namelist /obs_kind_nml/ assimilate_these_obs_types, evaluate_these_obs_types

contains

!----------------------------------------------------------------------------

  subroutine initialize_module

integer :: iunit, io, i, j
character(len = 169) :: err_string

call register_module(source, revision, revdate)
module_initialized = .true.

! Read the namelist entry
call find_namelist_in_file("input.nml", "obs_kind_nml", iunit)
read(iunit, nml = obs_kind_nml, iostat = io)
call check_namelist_read(iunit, io, "obs_kind_nml")


!----------------------------------------------------------------------------

! This list is autogenerated by the 'preprocess' program.  To add types
! or kinds, edit the obs_def_xxx_mod.f90 files, and then add/remove them
! from the 'input_files' variable of the &preprocess_nml namelist
! in the model-specific work/input.nml file.

! Table which associates the string type name with the index type value
! and the kind.  Default for all obs is to not assimilate or evaluate.

! DART PREPROCESS OBS_KIND_INFO INSERTED HERE

!----------------------------------------------------------------------------

! this *should* be autogenerated; the next version of preprocess has code
! to do that.  but for now, hard code this table.  ugly.

do i = 0, max_obs_generic
   obs_kind_names(i) = obs_kind_type(i, 'UNKNOWN')
enddo

obs_kind_names( 0) = obs_kind_type(KIND_RAW_STATE_VARIABLE, 'KIND_RAW_STATE_VARIABLE')
obs_kind_names( 1) = obs_kind_type(KIND_U_WIND_COMPONENT, 'KIND_U_WIND_COMPONENT')
obs_kind_names( 2) = obs_kind_type(KIND_V_WIND_COMPONENT, 'KIND_V_WIND_COMPONENT')
obs_kind_names( 3) = obs_kind_type(KIND_SURFACE_PRESSURE, 'KIND_SURFACE_PRESSURE')
obs_kind_names( 4) = obs_kind_type(KIND_TEMPERATURE, 'KIND_TEMPERATURE')
obs_kind_names( 5) = obs_kind_type(KIND_SPECIFIC_HUMIDITY, 'KIND_SPECIFIC_HUMIDITY')
obs_kind_names( 6) = obs_kind_type(KIND_PRESSURE, 'KIND_PRESSURE')
obs_kind_names( 7) = obs_kind_type(KIND_VERTICAL_VELOCITY, 'KIND_VERTICAL_VELOCITY')
obs_kind_names( 8) = obs_kind_type(KIND_RAINWATER_MIXING_RATIO, 'KIND_RAINWATER_MIXING_RATIO')
obs_kind_names( 9) = obs_kind_type(KIND_DEWPOINT, 'KIND_DEWPOINT')
obs_kind_names(10) = obs_kind_type(KIND_DENSITY, 'KIND_DENSITY')
obs_kind_names(11) = obs_kind_type(KIND_VELOCITY, 'KIND_VELOCITY')
obs_kind_names(12) = obs_kind_type(KIND_RADAR_REFLECTIVITY, 'KIND_RADAR_REFLECTIVITY')
obs_kind_names(13) = obs_kind_type(KIND_1D_INTEGRAL, 'KIND_1D_INTEGRAL')
obs_kind_names(14) = obs_kind_type(KIND_GRAUPEL_MIXING_RATIO, 'KIND_GRAUPEL_MIXING_RATIO')
obs_kind_names(15) = obs_kind_type(KIND_SNOW_MIXING_RATIO, 'KIND_SNOW_MIXING_RATIO')
obs_kind_names(16) = obs_kind_type(KIND_GPSRO, 'KIND_GPSRO')
obs_kind_names(17) = obs_kind_type(KIND_CLOUD_LIQUID_WATER, 'KIND_CLOUD_LIQUID_WATER')
obs_kind_names(18) = obs_kind_type(KIND_CLOUD_ICE, 'KIND_CLOUD_ICE')
obs_kind_names(19) = obs_kind_type(KIND_CONDENSATIONAL_HEATING, 'KIND_CONDENSATIONAL_HEATING')
obs_kind_names(20) = obs_kind_type(KIND_VAPOR_MIXING_RATIO, 'KIND_VAPOR_MIXING_RATIO')
obs_kind_names(21) = obs_kind_type(KIND_ICE_NUMBER_CONCENTRATION, 'KIND_ICE_NUMBER_CONCENTRATION')
obs_kind_names(22) = obs_kind_type(KIND_GEOPOTENTIAL_HEIGHT, 'KIND_GEOPOTENTIAL_HEIGHT')
obs_kind_names(23) = obs_kind_type(KIND_POTENTIAL_TEMPERATURE, 'KIND_POTENTIAL_TEMPERATURE')
obs_kind_names(24) = obs_kind_type(KIND_SOIL_MOISTURE, 'KIND_SOIL_MOISTURE')
obs_kind_names(25) = obs_kind_type(KIND_SURFACE_ELEVATION, 'KIND_SURFACE_ELEVATION')
obs_kind_names(26) = obs_kind_type(KIND_GRAV_WAVE_DRAG_EFFIC, 'KIND_GRAV_WAVE_DRAG_EFFIC')
obs_kind_names(27) = obs_kind_type(KIND_GRAV_WAVE_STRESS_FRACTION, 'KIND_GRAV_WAVE_STRESS_FRACTION')
obs_kind_names(28) = obs_kind_type(KIND_TRACER_SOURCE, 'KIND_TRACER_SOURCE')
obs_kind_names(29) = obs_kind_type(KIND_TRACER_CONCENTRATION, 'KIND_TRACER_CONCENTRATION')
obs_kind_names(30) = obs_kind_type(KIND_MEAN_SOURCE, 'KIND_MEAN_SOURCE')
obs_kind_names(31) = obs_kind_type(KIND_SOURCE_PHASE, 'KIND_SOURCE_PHASE')
obs_kind_names(32) = obs_kind_type(KIND_POWER_WEIGHTED_FALL_SPEED, 'KIND_POWER_WEIGHTED_FALL_SPEED')
obs_kind_names(33) = obs_kind_type(KIND_CLOUDWATER_MIXING_RATIO, 'KIND_CLOUDWATER_MIXING_RATIO')
obs_kind_names(34) = obs_kind_type(KIND_ICE_MIXING_RATIO, 'KIND_ICE_MIXING_RATIO')
obs_kind_names(35) = obs_kind_type(KIND_DROPLET_NUMBER_CONCENTR, 'KIND_DROPLET_NUMBER_CONCENTR')
obs_kind_names(36) = obs_kind_type(KIND_SNOW_NUMBER_CONCENTR, 'KIND_SNOW_NUMBER_CONCENTR')
obs_kind_names(37) = obs_kind_type(KIND_RAIN_NUMBER_CONCENTR, 'KIND_RAIN_NUMBER_CONCENTR')
obs_kind_names(38) = obs_kind_type(KIND_GRAUPEL_NUMBER_CONCENTR, 'KIND_GRAUPEL_NUMBER_CONCENTR')
obs_kind_names(39) = obs_kind_type(KIND_CLOUD_FRACTION, 'KIND_CLOUD_FRACTION')
obs_kind_names(40) = obs_kind_type(KIND_ICE_FRACTION, 'KIND_ICE_FRACTION')
obs_kind_names(41) = obs_kind_type(KIND_RELATIVE_HUMIDITY, 'KIND_RELATIVE_HUMIDITY')
obs_kind_names(42) = obs_kind_type(KIND_ELECTRON_DENSITY, 'KIND_ELECTRON_DENSITY')
obs_kind_names(43) = obs_kind_type(KIND_1D_PARAMETER, 'KIND_1D_PARAMETER')
obs_kind_names(44) = obs_kind_type(KIND_2D_PARAMETER, 'KIND_2D_PARAMETER')
obs_kind_names(45) = obs_kind_type(KIND_3D_PARAMETER, 'KIND_3D_PARAMETER')
obs_kind_names(46) = obs_kind_type(KIND_ATOMIC_OXYGEN_MIXING_RATIO, 'KIND_ATOMIC_OXYGEN_MIXING_RATIO')
obs_kind_names(47) = obs_kind_type(KIND_MOLEC_OXYGEN_MIXING_RATIO, 'KIND_MOLEC_OXYGEN_MIXING_RATIO')
obs_kind_names(48) = obs_kind_type(KIND_ALTIMETER_TENDENCY, 'KIND_ALTIMETER_TENDENCY')

obs_kind_names(50) = obs_kind_type(KIND_SALINITY, 'KIND_SALINITY')
obs_kind_names(51) = obs_kind_type(KIND_U_CURRENT_COMPONENT, 'KIND_U_CURRENT_COMPONENT')
obs_kind_names(52) = obs_kind_type(KIND_V_CURRENT_COMPONENT, 'KIND_V_CURRENT_COMPONENT')
obs_kind_names(53) = obs_kind_type(KIND_SEA_SURFACE_HEIGHT, 'KIND_SEA_SURFACE_HEIGHT')
obs_kind_names(54) = obs_kind_type(KIND_DRY_LAND, 'KIND_DRY_LAND')
obs_kind_names(55) = obs_kind_type(KIND_SEA_SURFACE_PRESSURE, 'KIND_SEA_SURFACE_PRESSURE')
obs_kind_names(56) = obs_kind_type(KIND_W_CURRENT_COMPONENT, 'KIND_W_CURRENT_COMPONENT')
obs_kind_names(57) = obs_kind_type(KIND_OCCULTATION_REFRACTIVITY, 'KIND_OCCULTATION_REFRACTIVITY')
obs_kind_names(58) = obs_kind_type(KIND_OCCULTATION_EXCESSPHASE, 'KIND_OCCULTATION_EXCESSPHASE')
obs_kind_names(60) = obs_kind_type(KIND_INFRARED_RADIANCE, 'KIND_INFRARED_RADIANCE')
obs_kind_names(61) = obs_kind_type(KIND_INFRARED_BRIGHT_TEMP, 'KIND_INFRARED_BRIGHT_TEMP')
obs_kind_names(62) = obs_kind_type(KIND_LANDMASK, 'KIND_LANDMASK')
obs_kind_names(63) = obs_kind_type(KIND_TOTAL_PRECIPITABLE_WATER, 'KIND_TOTAL_PRECIPITABLE_WATER')

obs_kind_names(70) = obs_kind_type(KIND_SKIN_TEMPERATURE, 'KIND_SKIN_TEMPERATURE')
obs_kind_names(71) = obs_kind_type(KIND_NADIR_RADIANCE, 'KIND_NADIR_RADIANCE')
obs_kind_names(72) = obs_kind_type(KIND_TRACER_1_MIXING_RATIO, 'KIND_TRACER_1_MIXING_RATIO')
obs_kind_names(73) = obs_kind_type(KIND_TRACER_2_MIXING_RATIO, 'KIND_TRACER_2_MIXING_RATIO')
obs_kind_names(74) = obs_kind_type(KIND_SOIL_TEMPERATURE, 'KIND_SOIL_TEMPERATURE')
obs_kind_names(75) = obs_kind_type(KIND_SOIL_LIQUID_WATER, 'KIND_SOIL_LIQUID_WATER')
obs_kind_names(76) = obs_kind_type(KIND_VERTICAL_VORTICITY, 'KIND_VERTICAL_VORTICITY')
obs_kind_names(77) = obs_kind_type(KIND_SURFACE_ALBEDO, 'KIND_SURFACE_ALBEDO')
obs_kind_names(78) = obs_kind_type(KIND_SURFACE_EMISSIVITY, 'KIND_SURFACE_EMISSIVITY')
obs_kind_names(79) = obs_kind_type(KIND_DUST_OPACITY_7MB, 'KIND_DUST_OPACITY_7MB')
obs_kind_names(80) = obs_kind_type(KIND_THC, 'KIND_THC')
obs_kind_names(81) = obs_kind_type(KIND_VORTEX_LON, 'KIND_VORTEX_LON')
obs_kind_names(82) = obs_kind_type(KIND_VORTEX_LAT, 'KIND_VORTEX_LAT')
obs_kind_names(83) = obs_kind_type(KIND_VORTEX_PMIN, 'KIND_VORTEX_PMIN')
obs_kind_names(84) = obs_kind_type(KIND_VORTEX_WMAX, 'KIND_VORTEX_WMAX')
obs_kind_names(85) = obs_kind_type(KIND_EXNER_FUNCTION, 'KIND_EXNER_FUNCTION')
obs_kind_names(86) = obs_kind_type(KIND_TURBULENT_KINETIC_ENERGY, 'KIND_TURBULENT_KINETIC_ENERGY')
obs_kind_names(87) = obs_kind_type(KIND_VERTLEVEL, 'KIND_VERTLEVEL')


! count here, then output below 

num_kind_assimilate = 0
do i = 1, max_obs_specific
   if(assimilate_these_obs_types(i) == 'null') exit
   num_kind_assimilate = i
end do

num_kind_evaluate = 0
do i = 1, max_obs_specific
   if(evaluate_these_obs_types(i) == 'null') exit
   num_kind_evaluate = i
end do

if (do_output()) then
   write(*, *) '------------------------------------------------------'
   write(*, *)

   write(logfileunit, *) 'Assimilate_these_obs_types'
   write(*, *)
   write(*, *) '-------------- ASSIMILATE_THESE_OBS_TYPES --------------'

   do i = 1, num_kind_assimilate
      write(logfileunit, *) trim(assimilate_these_obs_types(i))
      write(     *     , *) trim(assimilate_these_obs_types(i))
   end do

   write(logfileunit, *) 'Evaluate_these_obs_types'
   write(*, *) '-------------- EVALUATE_THESE_OBS_TYPES --------------'

   do i = 1, num_kind_evaluate
      write(logfileunit, *) trim(evaluate_these_obs_types(i))
      write(     *     , *) trim(evaluate_these_obs_types(i))
   end do
   write(*, *) '------------------------------------------------------'
   write(*, *)
endif


! Figure out which kinds are being used, look for errors
! Start by loading up kinds to assimilate
if (num_kind_assimilate > 0) then
   do i = 1, num_kind_assimilate
      ! Search for the matching string
      do j = 1, max_obs_specific
         if(assimilate_these_obs_types(i) == obs_type_info(j)%name) then
            obs_type_info(j)%assimilate = .true.
            goto 44
         endif
      end do
      ! Falling off the end is an error
      write(err_string, *) '"',trim(assimilate_these_obs_types(i)), &
         '" from obs_kind_nml is not a legal observation kind to assimilate'
      call error_handler(E_ERR, 'initialize_module', err_string, source, revision, revdate)
      44 continue
   end do
endif

! Now look for kinds to evaluate
if (num_kind_evaluate > 0) then
   do i = 1, num_kind_evaluate
      ! Search for the matching string
      do j = 1, max_obs_specific
         if(evaluate_these_obs_types(i) == obs_type_info(j)%name) then
            obs_type_info(j)%evaluate = .true.
            goto 55
         endif
      end do
      ! Falling off the end is an error
      write(err_string, *) '"',trim(evaluate_these_obs_types(i)), &
         '" from obs_kind_nml is not a legal observation kind to evaluate'
      call error_handler(E_ERR, 'initialize_module', err_string, source, revision, revdate)
      55 continue
   end do
endif

! Make it an error to ask to assimilate AND evaluate the same obs kind
do i = 1, max_obs_specific
   if(obs_type_info(i)%evaluate .and. obs_type_info(i)%assimilate) then
      write(err_string, *) 'Illegal to evaluate and assimilate same kind ', &
         trim(obs_type_info(i)%name)
      call error_handler(E_ERR, 'initialize_module', err_string, source, revision, revdate)
   endif
end do

end subroutine initialize_module

!---------------------------------------------------------------------------

function map_def_index(obs_def_index)

! Argument is the index from the obs_def; needs to be mapped to the appropriate
! Integer storage index
integer, intent(in) :: obs_def_index
integer             :: map_def_index

character(len = 169) :: err_string
integer :: i

if ( .not. module_initialized ) call initialize_module

! Need to search through the first map column to find this obs_def_index value
! Then return the index into table in this module from corresponding row in 
! second column.
do i = 1, max_obs_specific
   if(map(1, i) == obs_def_index) then
      map_def_index = map(2, i)
      return
   endif
end do

! Error, didn't find this obs_def_index in the map
write(err_string, *) 'Could not find obs_def_index ', obs_def_index, &
   ' in obs_kind map'
call error_handler(E_ERR, 'map_def_index', err_string, &
   source, revision, revdate)

end function map_def_index

!----------------------------------------------------------------------------

function get_obs_kind_name(obs_kind_ind)

! Returns observation type name

integer, intent(in) :: obs_kind_ind
character(len = paramname_length) :: get_obs_kind_name

if ( .not. module_initialized ) call initialize_module

if (obs_kind_ind < 1 .or. obs_kind_ind > max_obs_specific) then
   write(msg_string,'(''index out of range 1 <= '',i6,'' <= '',i6)') &
                                       obs_kind_ind, max_obs_specific
   call error_handler(E_ERR, 'get_obs_kind_name', msg_string, &
                      source, revision, revdate)
endif

get_obs_kind_name = obs_type_info(obs_kind_ind)%name

end function get_obs_kind_name

!----------------------------------------------------------------------------
! Added by TRW to handle matching RAW variable types to their strings
! as well as the derived types - this will make the restart file
! handling more readable.

function get_raw_obs_kind_name(obs_kind_ind)
  
! Returns observation kind name

integer, intent(in) :: obs_kind_ind
character(len=paramname_length) :: get_raw_obs_kind_name

if (.not. module_initialized) call initialize_module

if (obs_kind_ind < 1 .or. obs_kind_ind > max_obs_generic) then
   write(msg_string, *) 'index out of range 1<=val<=', max_obs_generic
   call error_handler(E_ERR, 'get_raw_obs_kind_name', msg_string, &
                      source, revision, revdate)
endif

get_raw_obs_kind_name = obs_kind_names(obs_kind_ind)%name

end function get_raw_obs_kind_name
!----------------------------------------------------------------------------

function get_obs_kind_index(obs_kind_name)

! Returns the integer index corresponding to an observation type string name
! Returns a -1 if this string is not in list

character(len = *), intent(in)  :: obs_kind_name
integer                         :: get_obs_kind_index

integer :: i
character(len=len(obs_kind_name)) :: string1

if ( .not. module_initialized ) call initialize_module

string1 = adjustl(obs_kind_name)

do i = 1, max_obs_specific
   if(trim(string1) == trim(obs_type_info(i)%name) ) then
      get_obs_kind_index = i
      return
   endif
end do

get_obs_kind_index = -1

end function get_obs_kind_index

!----------------------------------------------------------------------------
! Added by TRW to handle matching RAW variable types to their strings
! as well as the derived types - this will make the restart file
! handling more readable.

function get_raw_obs_kind_index(obs_kind_name)

! Returns the integer index corresponding to an observation kind string name
! Returns a -1 if this string is not in list

character(len=*), intent(in)  :: obs_kind_name
integer                       :: get_raw_obs_kind_index

integer :: i
character(len=len(obs_kind_name)) :: string1
  
if (.not. module_initialized) call initialize_module

string1 = adjustl(obs_kind_name)

do i = 1, max_obs_generic
   if(trim(string1) == trim(obs_kind_names(i)%name)) then
      get_raw_obs_kind_index = i
      return
   end if
end do

get_raw_obs_kind_index = -1

end function get_raw_obs_kind_index

!----------------------------------------------------------------------------

function get_num_obs_kinds()

! Accessor function to return observation *type* count

integer :: get_num_obs_kinds

if ( .not. module_initialized ) call initialize_module

get_num_obs_kinds = max_obs_specific

end function get_num_obs_kinds

!----------------------------------------------------------------------------

function get_num_raw_obs_kinds()
  
! Accessor function to return observation *kind* count

integer :: get_num_raw_obs_kinds

if (.not. module_initialized) call initialize_module

get_num_raw_obs_kinds = max_obs_generic

end function get_num_raw_obs_kinds

!----------------------------------------------------------------------------

function assimilate_this_obs_kind(obs_kind_ind)

! Returns true if this obs_kind is being assimilated

logical             :: assimilate_this_obs_kind
integer, intent(in) :: obs_kind_ind

if ( .not. module_initialized ) call initialize_module

assimilate_this_obs_kind = obs_type_info(obs_kind_ind)%assimilate

end function assimilate_this_obs_kind

!----------------------------------------------------------------------------

function evaluate_this_obs_kind(obs_kind_ind)

! Returns true if this obs_kind is being assimilated

logical             :: evaluate_this_obs_kind
integer, intent(in) :: obs_kind_ind

if ( .not. module_initialized ) call initialize_module

evaluate_this_obs_kind = obs_type_info(obs_kind_ind)%evaluate

end function evaluate_this_obs_kind

!----------------------------------------------------------------------------

function get_obs_kind_var_type(obs_kind_ind)

! Returns underlying variable type of this observation

integer, intent(in) :: obs_kind_ind
integer             :: get_obs_kind_var_type

if ( .not. module_initialized ) call initialize_module

get_obs_kind_var_type = obs_type_info(obs_kind_ind)%var_type

end function get_obs_kind_var_type

!----------------------------------------------------------------------------

subroutine write_obs_kind(ifile, fform, use_list)

! Writes out the observation kind strings and corresponding integer
! indices as a header for an obs_sequence file.

integer, intent(in)                    :: ifile
character(len=*), intent(in), optional :: fform
integer,          intent(in), optional :: use_list(:)

integer :: i, ntypes
logical :: is_ascii, restrict

if ( .not. module_initialized ) call initialize_module

is_ascii = ascii_file_format(fform)

! Write the 20 character identifier to indicate the start of a kind table.
! To maintain complete backwards compatibility with the original read 
! code this string must start in column 1.  
! you cannot use: write(ifile, *) 'string'  because the output string
! will start in col 2.  the string either has to be part of the format
! argument to write(), or you have to use a separate format statement.
if (is_ascii) then
   write(ifile,  "('obs_kind_definitions')")   ! see note above!
else
   write(ifile)    'obs_kind_definitions'
endif

! If this routine is called with a list of which types are actually
! being used, restrict the table of contents to only those.
! Otherwise, write all known types.
if (present(use_list)) then
   ! make sure the list is the right length
   if (size(use_list) /= max_obs_specific) then
      call error_handler(E_ERR, 'write_obs_kind', &
         'use_list(:) must be the same length as number of types', &
         source, revision, revdate)
   endif

   ntypes = count(use_list(:) > 0)
   restrict = .true.
else
   ntypes = max_obs_specific
   restrict = .false.
endif

if (is_ascii) then
   write(ifile, *) ntypes
else
   write(ifile)    ntypes
endif

do i = 1, max_obs_specific
   if (restrict) then
       if (use_list(i) == 0) cycle
   endif

   if (is_ascii) then
      write(ifile, *) obs_type_info(i)%index, obs_type_info(i)%name
   else
      write(ifile)    obs_type_info(i)%index, obs_type_info(i)%name
   endif
end do

end subroutine write_obs_kind

!----------------------------------------------------------------------------


subroutine read_obs_kind(ifile, pre_I_format, fform)

! Reads the observation kind strings and corresponding integer
! indices as a header for an obs_sequence file. If this isn't
! present, need to revert to default mapping for backwards
! compatibility.

integer,                    intent(in) :: ifile
logical,                    intent(in) :: pre_I_format
character(len=*), intent(in), optional :: fform

character(len=20)  :: header
character(len=paramname_length) :: o_name
integer            :: i, num_def_kinds, o_index, list_index
logical            :: is_ascii

if ( .not. module_initialized ) call initialize_module

! If this is old format, there's no obs_kind header to read
! Still need to initialize input kind map to use the order in
! the obs_kind file. It's users responsibility to make sure
! that this order is consistent with what the obs_sequence
! file thinks.
if(pre_I_format) then
   do i = 1, max_obs_specific
      map(1, i) = i; map(2, i) = i
   end do
   return
endif

is_ascii = ascii_file_format(fform)

! Read the 20 character identifier which identifies the start 
! of the obstype number/name table for this sequence file.
if (is_ascii) then
   read(ifile, *) header
else
   read(ifile)    header
endif

if(header /= 'obs_kind_definitions') then
   call error_handler(E_ERR, 'read_obs_kind', &
      'Did not find obs_kind_definitions string', &
      source, revision, revdate)
endif

! Loop through the list to read the integer indices and strings
! For all the defined observation types
! Set up the map from kinds in the obs_sequence file to those
! in the data structure in this module.
if (is_ascii) then
   read(ifile, *) num_def_kinds
else
   read(ifile)    num_def_kinds
endif

do i = 1, num_def_kinds
   if (is_ascii) then
      read(ifile, *) o_index, o_name
   else
      read(ifile)    o_index, o_name
   endif

   ! What is the integer associated with this o_name in this module?
   list_index = get_obs_kind_index(o_name)
   ! Check for error
   if(list_index == -1) then
      write(msg_string, *) 'Did not find observation kind ', o_name, &
         ' in obs_kind_mod list'
      call error_handler(E_ERR, 'read_obs_kind', msg_string, &
         source, revision, revdate)
   endif
   map(1, i) = o_index
   map(2, i) = list_index
end do

end subroutine read_obs_kind

!----------------------------------------------------------------------------

function get_kind_from_menu()

integer :: get_kind_from_menu

integer :: i, ierr
character(len=paramname_length) :: in

if ( .not. module_initialized ) call initialize_module

! Should only do kinds that have been selected by preprocessor, so those
! are ones that are being evaluated or assimilated.
21 continue
write(*, *) '     ', 'Input -1 * state variable index for identity observations'
write(*, *) '     ', 'OR input the name of the observation kind from table below:'
write(*, *) '     ', 'OR input the integer index, BUT see documentation...'
do i = 1, max_obs_specific
   if(assimilate_this_obs_kind(i) .or. evaluate_this_obs_kind(i)) &
      write(*, *) '     ',  obs_type_info(i)%index, trim(obs_type_info(i)%name)
end do

! Read the input as a string, convert to integers as appropriate 
read(*, '(A)') in

! If string is a positive or negative number, convert it to integer
read(in, *, IOSTAT = ierr) get_kind_from_menu
if(ierr /= 0) then
   get_kind_from_menu = get_obs_kind_index(in)
   ! If string isn't found, need to reprompt
   if(get_kind_from_menu == -1) then
      write(*, *) trim(in) // ' is not a supported kind: Please try again.'
      goto 21
   endif
else
   ! Make sure that number entered isn't 0 or too larg
   if(get_kind_from_menu == 0 .or. get_kind_from_menu > max_obs_specific) then
      write(*, *) get_kind_from_menu, 'is not a legal entry: Please try again.'
      goto 21
   endif
endif

! Make sure 

end function get_kind_from_menu

!----------------------------------------------------------------------------

function add_wind_names(my_names)
!----------------------------------------------------------------------
! Define/Append the 'horizontal wind' obs_kinds to supplant the list 
! of names for scalar observations in obs_kind_names()
! i.e. if there is a RADIOSONDE_U_WIND_COMPONENT and
!                  a RADIOSONDE_V_WIND_COMPONENT, there must be 
!  
!                  a RADIOSONDE_HORIZONTAL_WIND
! Replace calls to 'get_obs_kind_name' with variable 'my_obs_kind_names'
!----------------------------------------------------------------------

character(len=*), pointer :: my_names(:) ! INTENT OUT, btw
integer :: add_wind_names

integer :: ivar, nwinds
character(len=paramname_length) :: str1, str2, str3
character(len=paramname_length), dimension(2*max_obs_kinds) :: names

! Initially, the array of obs_kind_names is exactly 'max_num_obs' in length.
! This block finds the U,V wind pairs and creates the 'horizontal_wind'
! equivalents. Depending on the number of unique wind pairs - we can allocate
! space, copy the existing names into that array, and append the new unique ones.
! easy ...

integer :: indx1, indx2
integer :: indx1N,indx2N,indxN

logical :: DEBUG = .false.

nwinds = 0

! Copy all the known obs kinds to a local list that is SURELY too BIG
! as we find wind pairs, we insert the new name at the end of the known 
! names.

do ivar = 1,max_obs_kinds
   names(ivar) = get_obs_kind_name(ivar)
enddo

! Search through the obs_kind_name list for matching U,V components.
! The U component always comes before the V component, so we exploit that.
! Once we have counted the pairs - we know how far to expand the obs_kind list.

do ivar = 2,max_obs_kinds

   str1   = names(ivar-1)
   indx1  = index(str1,'_U_WIND_COMPONENT') - 1
   indx1N = len_trim(str1)

   str2   = names(ivar)
   indx2  = index(str2,'_V_WIND_COMPONENT') - 1
   indx2N = len_trim(str2)

   if ( DEBUG ) write(*,*)'Checking ',ivar, indx1, indx2, trim(str2)

   if ((indx1 > 0) .and. (indx2 > 0)) then ! we know we have u,v wind components

      indxN = index(str1(1:indx1),str2(1:indx2))

      if ( DEBUG )  write(*,*)' have u,v components at ',ivar,indxN

      if (indxN > 0) then ! we know they are matching kinds
         nwinds = nwinds + 1
         str3   = str1(1:indx2)//'_HORIZONTAL_WIND'
         names(max_obs_kinds + nwinds) = str3

         if ( DEBUG ) write(*,*)'Seems like ',str1(1:indx1N),' matches ',str2(1:indx2N)
         if ( DEBUG ) write(*,*)'results in ',str3
      endif
   endif

enddo

! Turns out there is also a [U,V]_10_METER_WIND
! Need to find and count them, too.

do ivar = 2,max_obs_kinds

   str1   = get_obs_kind_name(ivar-1)
   indx1  = index(str1,'_U_10_METER_WIND') - 1
   indx1N = len_trim(str1)

   str2   = get_obs_kind_name(ivar)
   indx2  = index(str2,'_V_10_METER_WIND') - 1
   indx2N = len_trim(str2)

   if ((indx1 > 0) .and. (indx2 > 0)) then ! we know we have u,v wind components
      indxN = index(str1(1:indx1),str2(1:indx2))
      if (indxN > 0) then ! we know they are matching kinds
         nwinds = nwinds + 1
         str3   = str1(1:indx2)//'_10_M_HORZ_WIND'
         names(max_obs_kinds + nwinds) = str3
      endif
   endif
enddo

if ( DEBUG ) write(*,*)'There are ',nwinds,' pairs of winds.'

! Now that we know how many wind pairs there are, we return the
! exact number and new array of observation kind names  

add_wind_names = max_obs_kinds + nwinds

allocate(my_names(add_wind_names))

do ivar = 1,add_wind_names
   my_names(ivar) = names(ivar)
enddo

end function add_wind_names

!----------------------------------------------------------------------------

function do_obs_form_pair(obs1type, obs2type, obskey, all_obs_typenames, flavor )

! This routine ensures that the U,V components of wind
! are from the same observation platform, and returns
! the 'type'. Keep in mind that DART only uses scalars, so there is
! no explicit type for a bivariate observation. The fourth
! argument to this function is the list of all the normal 'types' plus
! all the types that can be combined to form a wind pair. e.g.
! all_obs_typenames = 'RADIOSONDE_U_WIND_COMPONENT',
!                     'RADIOSONDE_U_WIND_COMPONENT',
!                     'RADIOSONDE_HORIZONTAL_WIND', ...
!
! obstype1           The (specific) 'type' of a candidate observation
! obstype2           The (specific) 'type' of a candidate observation
! obskey             The observation number (from the obs sequence file - 
!                    used for error messages only)
! all_obs_typenames  The 'extended' list of observation types - declared
!                    by grok_observation_names()
! flavor             The (specific) 'type' of wind ... i.e. the index
!                    into all_obs_typenames(:)

integer,                        intent(in)  :: obs1type, obs2type, obskey
character(len=*), dimension(:), intent(in)  :: all_obs_typenames
integer,                        intent(out) :: flavor
logical :: do_obs_form_pair

character(len=len(all_obs_typenames)) :: str1, str2, str3

integer :: obs1kind, obs2kind, num_obs_kinds
integer :: indx1, indx2, ivar

logical :: DEBUG = .false.

do_obs_form_pair = .FALSE. ! Assume no match ... till proven otherwise
flavor           = -1 ! bad flavor

obs1kind = get_obs_kind_var_type(obs1type)
obs2kind = get_obs_kind_var_type(obs2type)

! flavor 1 has to be either U or V, flavor 2 has to be the complement
if ( .not.((obs2kind == KIND_U_WIND_COMPONENT .and. &
            obs1kind == KIND_V_WIND_COMPONENT) .or. &
           (obs1kind == KIND_U_WIND_COMPONENT .and. &
            obs2kind == KIND_V_WIND_COMPONENT)) ) then
   write(msg_string,*) 'around OBS ', obskey, &
           'flavors not complementary ...',obs1type, obs2type
   call error_handler(E_WARN,'do_obs_form_pair',msg_string,source,revision,revdate)
   flavor = -obs1type
   return
endif

! By now they must be compatible wind components but need not be taken
! be the same observation platform.  Protect against matching
! 'QKSWND_U_WIND_COMPONENT' and a 'PROFILER_V_WIND_COMPONENT'

str1  = get_obs_kind_name(obs1type)
str2  = get_obs_kind_name(obs2type)

if (len_trim(str1) /= len_trim(str2)) then
   write(     *     ,*)'wind component 1 ',trim(str1)
   write(     *     ,*)'wind component 2 ',trim(str2)
   write(msg_string,*) 'around OBS ', obskey, ' adjacent U,V lengths not matching'
   call error_handler(E_WARN,'do_obs_form_pair',msg_string,source,revision,revdate)
   flavor = -obs2type
   return
endif

! Focus on getting the platform name 
! There are only two viable wind component strings (see obs_def_mod.f90):
! '_?_WIND_COMPONENT' and '_?_10_METER_WIND'

indx1 = index(str1,'_WIND_COMPONENT') - 3
indx2 = index(str1, '_10_METER_WIND') - 3

if ( DEBUG ) write(*,*)'str1, index is ',trim(str1),indx1
if ( DEBUG ) write(*,*)'str2, index is ',trim(str1),indx2

if ( (indx1 < 1) .and. (indx2 < 1) ) then
   write(msg_string,*) 'around OBS ', obskey,' '//trim(str1)//' not a known wind name ...'
   call error_handler(E_ERR,'do_obs_form_pair',msg_string,source,revision,revdate)
   flavor = -obs2type
   return
endif

if (indx1 > 0) then ! must be _?_WIND_COMPONENT
   str3 = str1(1:indx1)//'_HORIZONTAL_WIND'
else                ! must be _?_10_METER_WIND
   str3 = str1(1:indx2)//'_10_M_HORZ_WIND'
   indx1 = indx2
endif

! So now we have the platform name for one of the observations
! and that (1:indx1) defines the platform name in a matching scenario.
! str1(1:indx1) and str2(1:indx1) should be the wind name - 
! 'RADIOSONDE_' or 'SHIP_' or 'AIREP_' or ...

if ( str1(1:indx1) /= str2(1:indx1) ) then
   write(msg_string,*) 'around OBS ', obskey, trim(str1),trim(str2), 'observation types not compatible.'
   call error_handler(E_WARN,'do_obs_form_pair',msg_string,source,revision,revdate)
endif

! Find the derived type in our augmented list.
! DEBUG ... remove need for num_obs_kinds

num_obs_kinds = size(all_obs_typenames)

if ( DEBUG ) write(*,*)'I think there are ',num_obs_kinds,' different types.'

MyKind : do ivar = 1,num_obs_kinds
   indx1 = index(str3, all_obs_typenames(ivar))
   if (indx1 > 0) then
      flavor = ivar
      do_obs_form_pair = .TRUE.
      exit MyKind
   endif
enddo MyKind

! If we have checked all the types and not found a match ... 

if (.not. do_obs_form_pair ) then
   write(     *     ,*) trim(str1),' ',trim(str2)
   write( msg_string,*) 'around OBS ', obskey, 'observation types not known.'
   call error_handler(E_ERR,'do_obs_form_pair',msg_string,source,revision,revdate)
endif

end function do_obs_form_pair


end module obs_kind_mod
