# Dump File
#
# Database is ported from MS Access
#--------------------------------------------------------
# Program Version 3.0.148

#
# Table structure for table 'BOUNDARY'
#

DROP TABLE IF EXISTS `BOUNDARY`;

CREATE TABLE `BOUNDARY` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `INVYR` INTEGER, 
  `STATECD` INTEGER, 
  `UNITCD` INTEGER, 
  `COUNTYCD` INTEGER, 
  `PLOT` INTEGER, 
  `SUBP` INTEGER, 
  `SUBPTYP` INTEGER, 
  `BNDCHG` INTEGER DEFAULT 0, 
  `CONTRAST` INTEGER, 
  `AZMLEFT` INTEGER, 
  `AZMCORN` INTEGER, 
  `DISTCORN` INTEGER DEFAULT 0, 
  `AZMRIGHT` INTEGER, 
  `CYCLE` INTEGER, 
  `SUBCYCLE` INTEGER, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(50), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(50)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'BOUNDARY'
#

# 0 records

#
# Table structure for table 'COND'
#

DROP TABLE IF EXISTS `COND`;

CREATE TABLE `COND` (
  `CN` VARCHAR(34) NOT NULL, 
  `PLT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `UNITCD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `CONDID` INTEGER DEFAULT 0, 
  `COND_STATUS_CD` INTEGER DEFAULT 0, 
  `COND_NONSAMPLE_REASN_CD` INTEGER DEFAULT 0, 
  `RESERVCD` INTEGER DEFAULT 0, 
  `OWNCD` INTEGER DEFAULT 0, 
  `OWNGRPCD` INTEGER DEFAULT 0, 
  `FORINDCD` INTEGER DEFAULT 0, 
  `ADFORCD` INTEGER DEFAULT 0, 
  `FORTYPCD` INTEGER DEFAULT 0, 
  `FLDTYPCD` INTEGER DEFAULT 0, 
  `MAPDEN` INTEGER DEFAULT 0, 
  `STDAGE` INTEGER DEFAULT 0, 
  `STDSZCD` INTEGER DEFAULT 0, 
  `FLDSZCD` INTEGER DEFAULT 0, 
  `SITECLCD` INTEGER DEFAULT 0, 
  `SICOND` INTEGER DEFAULT 0, 
  `SIBASE` INTEGER DEFAULT 0, 
  `SISP` INTEGER DEFAULT 0, 
  `STDORGCD` INTEGER DEFAULT 0, 
  `STDORGSP` INTEGER, 
  `PROP_BASIS` VARCHAR(12), 
  `CONDPROP_UNADJ` FLOAT NULL DEFAULT 0, 
  `MICRPROP_UNADJ` FLOAT NULL DEFAULT 0, 
  `SUBPPROP_UNADJ` FLOAT NULL DEFAULT 0, 
  `MACRPROP_UNADJ` FLOAT NULL DEFAULT 0, 
  `SLOPE` INTEGER DEFAULT 0, 
  `ASPECT` INTEGER DEFAULT 0, 
  `PHYSCLCD` INTEGER DEFAULT 0, 
  `GSSTKCD` INTEGER DEFAULT 0, 
  `ALSTKCD` INTEGER DEFAULT 0, 
  `DSTRBCD1` INTEGER DEFAULT 0, 
  `DSTRBYR1` INTEGER DEFAULT 0, 
  `DSTRBCD2` INTEGER DEFAULT 0, 
  `DSTRBYR2` INTEGER DEFAULT 0, 
  `DSTRBCD3` INTEGER DEFAULT 0, 
  `DSTRBYR3` INTEGER DEFAULT 0, 
  `TRTCD1` INTEGER DEFAULT 0, 
  `TRTYR1` INTEGER DEFAULT 0, 
  `TRTCD2` INTEGER DEFAULT 0, 
  `TRTYR2` INTEGER DEFAULT 0, 
  `TRTCD3` INTEGER DEFAULT 0, 
  `TRTYR3` INTEGER DEFAULT 0, 
  `PRESNFCD` INTEGER DEFAULT 0, 
  `BALIVE` DOUBLE NULL DEFAULT 0, 
  `FLDAGE` INTEGER DEFAULT 0, 
  `ALSTK` FLOAT NULL DEFAULT 0, 
  `GSSTK` FLOAT NULL DEFAULT 0, 
  `FORTYPCDCALC` INTEGER DEFAULT 0, 
  `HABTYPCD1` VARCHAR(10), 
  `HABTYPCD1_PUB_CD` VARCHAR(10), 
  `HABTYPCD1_DESCR_PUB_CD` VARCHAR(10), 
  `HABTYPCD2` VARCHAR(10), 
  `HABTYPCD2_PUB_CD` VARCHAR(10), 
  `HABTYPCD2_DESCR_PUB_CD` VARCHAR(10), 
  `MIXEDCONFCD` VARCHAR(1), 
  `VOL_LOC_GRP` VARCHAR(200), 
  `SITECLCDEST` INTEGER DEFAULT 0, 
  `SITETREE_TREE` INTEGER DEFAULT 0, 
  `SITECL_METHOD` INTEGER DEFAULT 0, 
  `CARBON_DOWN_DEAD` DOUBLE NULL DEFAULT 0, 
  `CARBON_LITTER` DOUBLE NULL DEFAULT 0, 
  `CARBON_SOIL_ORG` DOUBLE NULL DEFAULT 0, 
  `CARBON_STANDING_DEAD` DOUBLE NULL DEFAULT 0, 
  `CARBON_UNDERSTORY_AG` DOUBLE NULL DEFAULT 0, 
  `CARBON_UNDERSTORY_BG` DOUBLE NULL DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6), 
  `CYCLE` INTEGER DEFAULT 0, 
  `SUBCYCLE` INTEGER DEFAULT 0, 
  `SOIL_ROOTING_DEPTH_PNW` VARCHAR(1), 
  `GROUND_LAND_CLASS_PNW` VARCHAR(3), 
  `PLANT_STOCKABILITY_FACTOR_PNW` DOUBLE NULL, 
  `STND_COND_CD_PNWRS` INTEGER DEFAULT 0, 
  `STND_STRUC_CD_PNWRS` INTEGER DEFAULT 0, 
  `STUMP_CD_PNWRS` VARCHAR(1), 
  `FIRE_SRS` INTEGER DEFAULT 0, 
  `GRAZING_SRS` INTEGER DEFAULT 0, 
  `HARVEST_TYPE1_SRS` INTEGER DEFAULT 0, 
  `HARVEST_TYPE2_SRS` INTEGER DEFAULT 0, 
  `HARVEST_TYPE3_SRS` INTEGER DEFAULT 0, 
  `LAND_USE_SRS` INTEGER DEFAULT 0, 
  `OPERABILITY_SRS` INTEGER DEFAULT 0, 
  `STAND_STRUCTURE_SRS` INTEGER DEFAULT 0, 
  `NF_COND_STATUS_CD` INTEGER, 
  `NF_COND_NONSAMPLE_REASN_CD` INTEGER, 
  `CANOPY_CVR_SAMPLE_METHOD_CD` INTEGER, 
  `LIVE_CANOPY_CVR_PCT` INTEGER, 
  `LIVE_MISSING_CANOPY_CVR_PCT` INTEGER, 
  `NBR_LIVE_STEMS` INTEGER, 
  INDEX (`PLT_CN`), 
  PRIMARY KEY (`CN`)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'COND'
#

# 0 records

#
# Table structure for table 'COUNTY'
#

DROP TABLE IF EXISTS `COUNTY`;

CREATE TABLE `COUNTY` (
  `STATECD` INTEGER DEFAULT 0, 
  `UNITCD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `COUNTYNM` VARCHAR(50), 
  `CN` VARCHAR(34), 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'COUNTY'
#

# 0 records

#
# Table structure for table 'DWM_COARSE_WOODY_DEBRIS'
#

DROP TABLE IF EXISTS `DWM_COARSE_WOODY_DEBRIS`;

CREATE TABLE `DWM_COARSE_WOODY_DEBRIS` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `SUBP` INTEGER DEFAULT 0, 
  `TRANSECT` INTEGER DEFAULT 0, 
  `CWDID` DOUBLE NULL, 
  `MEASYEAR` INTEGER DEFAULT 0, 
  `SLOPDIST` DOUBLE NULL, 
  `SPCD` INTEGER DEFAULT 0, 
  `DECAYCD` INTEGER DEFAULT 0, 
  `TRANSDIA` INTEGER DEFAULT 0, 
  `SMALLDIA` INTEGER DEFAULT 0, 
  `LARGEDIA` INTEGER DEFAULT 0, 
  `LENGTH` INTEGER DEFAULT 0, 
  `HOLLOWCD` VARCHAR(1), 
  `CWDHSTCD` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'DWM_COARSE_WOODY_DEBRIS'
#

# 0 records

#
# Table structure for table 'DWM_DUFF_LITTER_FUEL'
#

DROP TABLE IF EXISTS `DWM_DUFF_LITTER_FUEL`;

CREATE TABLE `DWM_DUFF_LITTER_FUEL` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `TRANSECT` INTEGER DEFAULT 0, 
  `SUBP` INTEGER DEFAULT 0, 
  `SMPLOCCD` INTEGER DEFAULT 0, 
  `MEASYEAR` INTEGER DEFAULT 0, 
  `SMPLDCD` INTEGER DEFAULT 0, 
  `DUFFDEP` DOUBLE NULL, 
  `LITTDEP` DOUBLE NULL, 
  `FUELDEP` DOUBLE NULL, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'DWM_DUFF_LITTER_FUEL'
#

# 0 records

#
# Table structure for table 'DWM_FINE_WOODY_DEBRIS'
#

DROP TABLE IF EXISTS `DWM_FINE_WOODY_DEBRIS`;

CREATE TABLE `DWM_FINE_WOODY_DEBRIS` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `TRANSECT` INTEGER DEFAULT 0, 
  `SUBP` INTEGER DEFAULT 0, 
  `CONDID` INTEGER DEFAULT 0, 
  `MEASYEAR` INTEGER DEFAULT 0, 
  `SMALLCT` INTEGER DEFAULT 0, 
  `MEDIUMCT` INTEGER DEFAULT 0, 
  `LARGECT` INTEGER DEFAULT 0, 
  `RSNCTCD` INTEGER DEFAULT 0, 
  `PILESCD` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'DWM_FINE_WOODY_DEBRIS'
#

# 0 records

#
# Table structure for table 'DWM_MICROPLOT_FUEL'
#

DROP TABLE IF EXISTS `DWM_MICROPLOT_FUEL`;

CREATE TABLE `DWM_MICROPLOT_FUEL` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `SUBP` INTEGER DEFAULT 0, 
  `MEASYEAR` INTEGER DEFAULT 0, 
  `LVSHRBCD` INTEGER DEFAULT 0, 
  `DSHRBCD` INTEGER DEFAULT 0, 
  `LVHRBCD` INTEGER DEFAULT 0, 
  `DHRBCD` INTEGER DEFAULT 0, 
  `LITTERCD` DOUBLE NULL, 
  `LVSHRBHT` DOUBLE NULL, 
  `DSHRBHT` DOUBLE NULL, 
  `LVHRBHT` DOUBLE NULL, 
  `DHRBHT` DOUBLE NULL, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'DWM_MICROPLOT_FUEL'
#

# 0 records

#
# Table structure for table 'DWM_RESIDUAL_PILE'
#

DROP TABLE IF EXISTS `DWM_RESIDUAL_PILE`;

CREATE TABLE `DWM_RESIDUAL_PILE` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `SUBP` INTEGER DEFAULT 0, 
  `PILE` DOUBLE NULL, 
  `MEASYEAR` INTEGER DEFAULT 0, 
  `CONDID` INTEGER DEFAULT 0, 
  `SHAPECD` INTEGER DEFAULT 0, 
  `AZIMUTH` INTEGER DEFAULT 0, 
  `DENSITY` INTEGER DEFAULT 0, 
  `HEIGHT1` INTEGER DEFAULT 0, 
  `WIDTH1` INTEGER DEFAULT 0, 
  `LENGTH1` INTEGER DEFAULT 0, 
  `HEIGHT2` INTEGER DEFAULT 0, 
  `WIDTH2` INTEGER DEFAULT 0, 
  `LENGTH2` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'DWM_RESIDUAL_PILE'
#

# 0 records

#
# Table structure for table 'DWM_TRANSECT_SEGMENT'
#

DROP TABLE IF EXISTS `DWM_TRANSECT_SEGMENT`;

CREATE TABLE `DWM_TRANSECT_SEGMENT` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `SUBP` INTEGER DEFAULT 0, 
  `TRANSECT` INTEGER DEFAULT 0, 
  `SEGMNT` INTEGER DEFAULT 0, 
  `MEASYEAR` INTEGER DEFAULT 0, 
  `CONDID` INTEGER DEFAULT 0, 
  `BEGNDIST` DOUBLE NULL, 
  `ENDDIST` DOUBLE NULL, 
  `SLOPE` INTEGER, 
  `HORIZDIST` DOUBLE NULL, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'DWM_TRANSECT_SEGMENT'
#

# 0 records

#
# Table structure for table 'DWM_VISIT'
#

DROP TABLE IF EXISTS `DWM_VISIT`;

CREATE TABLE `DWM_VISIT` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `MEASDAY` INTEGER DEFAULT 0, 
  `MEASMON` INTEGER DEFAULT 0, 
  `MEASYEAR` INTEGER DEFAULT 0, 
  `QASTATCD` INTEGER DEFAULT 0, 
  `CRWTYPCD` INTEGER DEFAULT 0, 
  `SMPKNDCD` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'DWM_VISIT'
#

# 0 records

#
# Table structure for table 'EVALIDATOR_CHANGES'
#

DROP TABLE IF EXISTS `EVALIDATOR_CHANGES`;

CREATE TABLE `EVALIDATOR_CHANGES` (
  `ID` INTEGER NOT NULL AUTO_INCREMENT, 
  `CHANGE_DATE` DATETIME, 
  `CHANGE` LONGTEXT, 
  PRIMARY KEY (`ID`)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'EVALIDATOR_CHANGES'
#

INSERT INTO `EVALIDATOR_CHANGES` (`ID`, `CHANGE_DATE`, `CHANGE`) VALUES (1, '2011-04-11 00:00:00', 'Added EVALIDATOR_CHANGES table to database to record changes to EVALIDator program.');
INSERT INTO `EVALIDATOR_CHANGES` (`ID`, `CHANGE_DATE`, `CHANGE`) VALUES (2, '2011-04-15 00:00:00', 'Added CN field to POP_EVAL_TYP table and modified POP_EVAL_TYP import specification to reflect this change.');
INSERT INTO `EVALIDATOR_CHANGES` (`ID`, `CHANGE_DATE`, `CHANGE`) VALUES (3, '2011-04-15 00:00:00', NULL);
# 3 records

#
# Table structure for table 'LICHEN_LAB'
#

DROP TABLE IF EXISTS `LICHEN_LAB`;

CREATE TABLE `LICHEN_LAB` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `LICH_SPPCD` INTEGER DEFAULT 0, 
  `MEASYEAR` INTEGER DEFAULT 0, 
  `ABUNDANCE_CLASS` INTEGER DEFAULT 0, 
  `ORIGIN_FLAG` INTEGER DEFAULT 0, 
  `SPP_COMMENTS` LONGTEXT, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'LICHEN_LAB'
#

# 0 records

#
# Table structure for table 'LICHEN_PLOT_SUMMARY'
#

DROP TABLE IF EXISTS `LICHEN_PLOT_SUMMARY`;

CREATE TABLE `LICHEN_PLOT_SUMMARY` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `MEASYEAR` INTEGER DEFAULT 0, 
  `SUMMATION` DOUBLE NULL DEFAULT 0, 
  `RICHNESS` INTEGER DEFAULT 0, 
  `EVENNESS` FLOAT NULL DEFAULT 0, 
  `DIVERSITY` FLOAT NULL DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'LICHEN_PLOT_SUMMARY'
#

# 0 records

#
# Table structure for table 'LICHEN_SPECIES_SUMMARY'
#

DROP TABLE IF EXISTS `LICHEN_SPECIES_SUMMARY`;

CREATE TABLE `LICHEN_SPECIES_SUMMARY` (
  `CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `LICHEN_REGION` INTEGER DEFAULT 0, 
  `LICH_SPPCD` INTEGER DEFAULT 0, 
  `MEASYEAR` INTEGER DEFAULT 0, 
  `LICHEN_REGION_DESCR` VARCHAR(80), 
  `SPP_ACRONYM` VARCHAR(6), 
  `GENUS` VARCHAR(40), 
  `SUM_ABUNDANCE` FLOAT NULL DEFAULT 0, 
  `FREQUENCY_PCT` INTEGER DEFAULT 0, 
  `SPECIES` VARCHAR(50), 
  `PLOTS_IN_REGION` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'LICHEN_SPECIES_SUMMARY'
#

# 0 records

#
# Table structure for table 'LICHEN_VISIT'
#

DROP TABLE IF EXISTS `LICHEN_VISIT`;

CREATE TABLE `LICHEN_VISIT` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `MEASDAY` INTEGER DEFAULT 0, 
  `MEASMON` INTEGER DEFAULT 0, 
  `MEASYEAR` INTEGER DEFAULT 0, 
  `LICHEN_STATCD` INTEGER DEFAULT 0, 
  `LIPROJCD` INTEGER DEFAULT 0, 
  `SMPLSTRT` INTEGER DEFAULT 0, 
  `SMPLSTP` INTEGER DEFAULT 0, 
  `SMPLTIME` INTEGER DEFAULT 0, 
  `SFTWDPCT` INTEGER DEFAULT 0, 
  `HRDWDPCT` INTEGER DEFAULT 0, 
  `SHRUBPCT` INTEGER DEFAULT 0, 
  `GAPPCT` INTEGER DEFAULT 0, 
  `GAPRCNT` INTEGER DEFAULT 0, 
  `TALLSHRB` INTEGER DEFAULT 0, 
  `FTRCD1` DOUBLE NULL, 
  `FTRCD2` DOUBLE NULL, 
  `FTRCD3` DOUBLE NULL, 
  `FTRCD4` DOUBLE NULL, 
  `ISSUECD1` DOUBLE NULL, 
  `ISSUECD2` DOUBLE NULL, 
  `ISSUECD3` DOUBLE NULL, 
  `ISSUECD4` DOUBLE NULL, 
  `SZCLSCD1` INTEGER DEFAULT 0, 
  `SZCLSCD2` INTEGER DEFAULT 0, 
  `SZCLSCD3` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'LICHEN_VISIT'
#

# 0 records

#
# Table structure for table 'OZONE_BIOSITE_SUMMARY'
#

DROP TABLE IF EXISTS `OZONE_BIOSITE_SUMMARY`;

CREATE TABLE `OZONE_BIOSITE_SUMMARY` (
  `CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `O3PLOT` DOUBLE NULL, 
  `FIELD_ID` INTEGER DEFAULT 0, 
  `LOCATION_CNT` DOUBLE NULL, 
  `GROUND_LOC_CD` INTEGER DEFAULT 0, 
  `MEASYEAR` INTEGER DEFAULT 0, 
  `PLANT_INJ_CNT` DOUBLE NULL, 
  `PLANT_EVAL_CNT` DOUBLE NULL, 
  `PLANT_RATIO` DOUBLE NULL, 
  `SPECIES_EVAL_CNT` DOUBLE NULL, 
  `BIOSITE_INDEX` DOUBLE NULL, 
  `BIOSITE_INDEX_MULTIPLIER` DOUBLE NULL, 
  `SVRTY_CLASS_ZERO` DOUBLE NULL, 
  `SVRTY_CLASS_ONE` DOUBLE NULL, 
  `SVRTY_CLASS_TWO` DOUBLE NULL, 
  `SVRTY_CLASS_THREE` DOUBLE NULL, 
  `SVRTY_CLASS_FOUR` DOUBLE NULL, 
  `SVRTY_CLASS_FIVE` DOUBLE NULL, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'OZONE_BIOSITE_SUMMARY'
#

# 0 records

#
# Table structure for table 'OZONE_PLOT'
#

DROP TABLE IF EXISTS `OZONE_PLOT`;

CREATE TABLE `OZONE_PLOT` (
  `CN` VARCHAR(34), 
  `SRV_CN` VARCHAR(34), 
  `CTY_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `UNITCD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `O3PLOT` DOUBLE NULL, 
  `FIELD_ID` INTEGER DEFAULT 0, 
  `SPLIT_PLOTID` INTEGER DEFAULT 0, 
  `MEASYEAR` INTEGER DEFAULT 0, 
  `MEASMON` INTEGER DEFAULT 0, 
  `MEASDAY` INTEGER DEFAULT 0, 
  `LAT` DOUBLE NULL DEFAULT 0, 
  `LON` DOUBLE NULL DEFAULT 0, 
  `ELEVATION` DOUBLE NULL, 
  `MANUAL` FLOAT NULL DEFAULT 0, 
  `QA_STATUS` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6), 
  `CYCLE` INTEGER DEFAULT 0, 
  `SUBCYCLE` INTEGER DEFAULT 0
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'OZONE_PLOT'
#

# 0 records

#
# Table structure for table 'OZONE_PLOT_SUMMARY'
#

DROP TABLE IF EXISTS `OZONE_PLOT_SUMMARY`;

CREATE TABLE `OZONE_PLOT_SUMMARY` (
  `CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `O3PLOT` DOUBLE NULL, 
  `FIELD_ID` INTEGER DEFAULT 0, 
  `SPLIT_PLOTID` INTEGER DEFAULT 0, 
  `MEASYEAR` INTEGER DEFAULT 0, 
  `SPECIES_EVAL_CNT` DOUBLE NULL, 
  `BIOSITE_INDEX` DOUBLE NULL, 
  `ELEV` INTEGER DEFAULT 0, 
  `PLTSIZE` DOUBLE NULL, 
  `ASPECT` INTEGER DEFAULT 0, 
  `TERRPOS` DOUBLE NULL, 
  `SOILDPTH` DOUBLE NULL, 
  `SOILDRN` DOUBLE NULL, 
  `PLOTWET` DOUBLE NULL, 
  `PLTDSTRB` DOUBLE NULL, 
  `BIOSITE_INDEX_MULTIPLIER` DOUBLE NULL, 
  `LAT` DOUBLE NULL DEFAULT 0, 
  `LON` DOUBLE NULL DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'OZONE_PLOT_SUMMARY'
#

# 0 records

#
# Table structure for table 'OZONE_SPECIES_SUMMARY'
#

DROP TABLE IF EXISTS `OZONE_SPECIES_SUMMARY`;

CREATE TABLE `OZONE_SPECIES_SUMMARY` (
  `CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `O3PLOT` DOUBLE NULL, 
  `FIELD_ID` INTEGER DEFAULT 0, 
  `SPLIT_PLOTID` INTEGER DEFAULT 0, 
  `GROUND_LOC_CD` INTEGER DEFAULT 0, 
  `MEASYEAR` INTEGER DEFAULT 0, 
  `BIOSPCD` DOUBLE NULL, 
  `AMNT_MAX` DOUBLE NULL, 
  `AMNT_MIN` DOUBLE NULL, 
  `AMNT_MEAN` DOUBLE NULL, 
  `SVRTY_MAX` DOUBLE NULL, 
  `SVRTY_MIN` DOUBLE NULL, 
  `SVRTY_MEAN` DOUBLE NULL, 
  `PLANT_INJ_CNT` DOUBLE NULL, 
  `PLANT_EVAL_CNT` DOUBLE NULL, 
  `PLANT_RATIO` DOUBLE NULL, 
  `BIOSPCD_SUM` DOUBLE NULL, 
  `BIOSPCD_INDEX` DOUBLE NULL, 
  `ELEV` INTEGER DEFAULT 0, 
  `PLTSIZE` DOUBLE NULL, 
  `ASPECT` INTEGER DEFAULT 0, 
  `TERRPOS` DOUBLE NULL, 
  `SOILDPTH` DOUBLE NULL, 
  `SOILDRN` DOUBLE NULL, 
  `PLOTWET` DOUBLE NULL, 
  `PLTDSTRB` DOUBLE NULL, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'OZONE_SPECIES_SUMMARY'
#

# 0 records

#
# Table structure for table 'OZONE_VALIDATION'
#

DROP TABLE IF EXISTS `OZONE_VALIDATION`;

CREATE TABLE `OZONE_VALIDATION` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `O3PLOT` DOUBLE NULL, 
  `FIELD_ID` INTEGER DEFAULT 0, 
  `SPLIT_PLOTID` INTEGER DEFAULT 0, 
  `BIOSPCD` DOUBLE NULL, 
  `QASTATCD` INTEGER DEFAULT 0, 
  `CRWTYPCD` INTEGER DEFAULT 0, 
  `LEAFVCHR` DOUBLE NULL, 
  `INJVALID` DOUBLE NULL, 
  `O3_STATCD` DOUBLE NULL, 
  `MEASYEAR` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'OZONE_VALIDATION'
#

# 0 records

#
# Table structure for table 'OZONE_VISIT'
#

DROP TABLE IF EXISTS `OZONE_VISIT`;

CREATE TABLE `OZONE_VISIT` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `O3PLOT` DOUBLE NULL, 
  `FIELD_ID` INTEGER DEFAULT 0, 
  `SPLIT_PLOTID` INTEGER DEFAULT 0, 
  `SMPKNDCD` INTEGER DEFAULT 0, 
  `MEASDAY` INTEGER DEFAULT 0, 
  `MEASMON` INTEGER DEFAULT 0, 
  `MEASYEAR` INTEGER DEFAULT 0, 
  `PLTSIZE` DOUBLE NULL, 
  `ASPECT` INTEGER DEFAULT 0, 
  `TERRPOS` DOUBLE NULL, 
  `SOILDPTH` DOUBLE NULL, 
  `SOILDRN` DOUBLE NULL, 
  `PLTDSTRB` DOUBLE NULL, 
  `CRWTYPCD` INTEGER DEFAULT 0, 
  `PLOTWET` DOUBLE NULL, 
  `INJCHECK` INTEGER DEFAULT 0, 
  `GRIDDEN` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'OZONE_VISIT'
#

# 0 records

#
# Table structure for table 'PLOT'
#

DROP TABLE IF EXISTS `PLOT`;

CREATE TABLE `PLOT` (
  `CN` VARCHAR(34) NOT NULL, 
  `SRV_CN` VARCHAR(34), 
  `CTY_CN` VARCHAR(34), 
  `PREV_PLT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `UNITCD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `PLOT_STATUS_CD` INTEGER DEFAULT 0, 
  `PLOT_NONSAMPLE_REASN_CD` INTEGER DEFAULT 0, 
  `MEASYEAR` INTEGER DEFAULT 0, 
  `MEASMON` INTEGER DEFAULT 0, 
  `MEASDAY` INTEGER DEFAULT 0, 
  `REMPER` FLOAT NULL DEFAULT 0, 
  `KINDCD` INTEGER DEFAULT 0, 
  `DESIGNCD` INTEGER DEFAULT 0, 
  `RDDISTCD` INTEGER DEFAULT 0, 
  `WATERCD` INTEGER DEFAULT 0, 
  `LAT` DOUBLE NULL DEFAULT 0, 
  `LON` DOUBLE NULL DEFAULT 0, 
  `ELEV` INTEGER DEFAULT 0, 
  `GROW_TYP_CD` INTEGER DEFAULT 0, 
  `MORT_TYP_CD` INTEGER DEFAULT 0, 
  `P2PANEL` INTEGER DEFAULT 0, 
  `P3PANEL` INTEGER DEFAULT 0, 
  `ECOSUBCD` VARCHAR(7), 
  `CONGCD` INTEGER DEFAULT 0, 
  `MANUAL` FLOAT NULL DEFAULT 0, 
  `SUBPANEL` INTEGER DEFAULT 0, 
  `KINDCD_NC` INTEGER DEFAULT 0, 
  `QA_STATUS` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6), 
  `MICROPLOT_LOC` VARCHAR(12), 
  `DECLINATION` FLOAT NULL DEFAULT 0, 
  `EMAP_HEX` INTEGER DEFAULT 0, 
  `SAMP_METHOD_CD` INTEGER DEFAULT 0, 
  `SUBP_EXAMINE_CD` INTEGER DEFAULT 0, 
  `MACRO_BREAKPOINT_DIA` INTEGER DEFAULT 0, 
  `INTENSITY` VARCHAR(2), 
  `CYCLE` INTEGER DEFAULT 0, 
  `SUBCYCLE` INTEGER DEFAULT 0, 
  `ECO_UNIT_PNW` VARCHAR(10), 
  `TOPO_POSITION_PNW` VARCHAR(2), 
  `NF_SAMPLING_STATUS_CD` INTEGER, 
  `NF_PLOT_STATUS_CD` INTEGER, 
  `NF_PLOT_NONSAMPLE_REASN_CD` INTEGER, 
  `P2VEG_SAMPLING_STATUS_CD` INTEGER, 
  `P2VEG_SAMPLING_LEVEL_DETAIL_CD` INTEGER, 
  `INVASIVE_SAMPLING_STATUS_CD` INTEGER, 
  `INVASIVE_SPECIMEN_RULE_CD` INTEGER, 
  UNIQUE (`STATECD`, `INVYR`, `UNITCD`, `COUNTYCD`, `PLOT`), 
  PRIMARY KEY (`CN`)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'PLOT'
#

# 0 records

#
# Table structure for table 'PLOTGEOM'
#

DROP TABLE IF EXISTS `PLOTGEOM`;

CREATE TABLE `PLOTGEOM` (
  `CN` VARCHAR(34), 
  `STATECD` INTEGER, 
  `INVYR` INTEGER, 
  `UNITCD` INTEGER, 
  `COUNTYCD` INTEGER, 
  `PLOT` INTEGER, 
  `LAT` DOUBLE NULL, 
  `LON` DOUBLE NULL, 
  `CONGCD` INTEGER, 
  `ECOSUBCD` VARCHAR(7), 
  `HUC` INTEGER, 
  `EMAPHEX` INTEGER, 
  `FIPSCOUNTY` INTEGER, 
  `ROADLESSCD` VARCHAR(4), 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` INTEGER DEFAULT 0, 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` INTEGER DEFAULT 0, 
  `ADFORCD` INTEGER
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'PLOTGEOM'
#

# 0 records

#
# Table structure for table 'PLOTSNAP'
#

DROP TABLE IF EXISTS `PLOTSNAP`;

CREATE TABLE `PLOTSNAP` (
  `CN` VARCHAR(34), 
  `SRV_CN` VARCHAR(34), 
  `CTY_CN` VARCHAR(34), 
  `PREV_PLT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `UNITCD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `PLOT_STATUS_CD` INTEGER DEFAULT 0, 
  `PLOT_NONSAMPLE_REASN_CD` INTEGER DEFAULT 0, 
  `MEASYEAR` INTEGER DEFAULT 0, 
  `MEASMON` INTEGER DEFAULT 0, 
  `MEASDAY` INTEGER DEFAULT 0, 
  `REMPER` FLOAT NULL DEFAULT 0, 
  `KINDCD` INTEGER DEFAULT 0, 
  `DESIGNCD` INTEGER DEFAULT 0, 
  `RDDISTCD` INTEGER DEFAULT 0, 
  `WATERCD` INTEGER DEFAULT 0, 
  `LAT` DOUBLE NULL DEFAULT 0, 
  `LON` DOUBLE NULL DEFAULT 0, 
  `ELEV` INTEGER DEFAULT 0, 
  `GROW_TYP_CD` INTEGER DEFAULT 0, 
  `MORT_TYP_CD` INTEGER DEFAULT 0, 
  `P2PANEL` INTEGER DEFAULT 0, 
  `P3PANEL` INTEGER DEFAULT 0, 
  `ECOSUBCD` VARCHAR(7), 
  `CONGCD` INTEGER DEFAULT 0, 
  `MANUAL` FLOAT NULL DEFAULT 0, 
  `SUBPANEL` INTEGER DEFAULT 0, 
  `KINDCD_NC` INTEGER DEFAULT 0, 
  `QA_STATUS` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6), 
  `MICROPLOT_LOC` VARCHAR(12), 
  `DECLINATION` FLOAT NULL DEFAULT 0, 
  `EMAP_HEX` INTEGER DEFAULT 0, 
  `SAMP_METHOD_CD` INTEGER DEFAULT 0, 
  `SUBP_EXAMINE_CD` INTEGER DEFAULT 0, 
  `MACRO_BREAKPOINT_DIA` INTEGER DEFAULT 0, 
  `INTENSITY` VARCHAR(2), 
  `CYCLE` INTEGER DEFAULT 0, 
  `SUBCYCLE` INTEGER DEFAULT 0, 
  `ECO_UNIT_PNW` VARCHAR(10), 
  `TOPO_POSITION_PNW` VARCHAR(2), 
  `EVAL_GRP_CN` VARCHAR(34), 
  `EVAL_GRP` INTEGER DEFAULT 0, 
  `EXPALL` DOUBLE NULL, 
  `EXPCURR` DOUBLE NULL, 
  `EXPVOL` DOUBLE NULL, 
  `EXPGROW` DOUBLE NULL, 
  `EXPMORT` DOUBLE NULL, 
  `EXPREMV` DOUBLE NULL, 
  `ADJ_EXPALL` DOUBLE NULL DEFAULT 0, 
  `ADJ_EXPCURR` DOUBLE NULL, 
  `ADJ_EXPVOL_MACR` DOUBLE NULL, 
  `ADJ_EXPVOL_SUBP` DOUBLE NULL, 
  `ADJ_EXPVOL_MICR` DOUBLE NULL, 
  `ADJ_EXPGROW_MACR` DOUBLE NULL, 
  `ADJ_EXPGROW_SUBP` DOUBLE NULL, 
  `ADJ_EXPGROW_MICR` DOUBLE NULL, 
  `ADJ_EXPMORT_MACR` DOUBLE NULL, 
  `ADJ_EXPMORT_SUBP` DOUBLE NULL, 
  `ADJ_EXPMORT_MICR` DOUBLE NULL, 
  `ADJ_EXPREMV_MACR` DOUBLE NULL, 
  `ADJ_EXPREMV_SUBP` DOUBLE NULL, 
  `ADJ_EXPREMV_MICR` DOUBLE NULL, 
  INDEX (`EVAL_GRP`, `CN`)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'PLOTSNAP'
#

# 0 records

#
# Table structure for table 'POP_ESTN_UNIT'
#

DROP TABLE IF EXISTS `POP_ESTN_UNIT`;

CREATE TABLE `POP_ESTN_UNIT` (
  `CN` VARCHAR(34) NOT NULL, 
  `EVAL_CN` VARCHAR(34), 
  `RSCD` INTEGER DEFAULT 0, 
  `EVALID` INTEGER DEFAULT 0, 
  `ESTN_UNIT` INTEGER DEFAULT 0, 
  `ESTN_UNIT_DESCR` VARCHAR(255), 
  `STATECD` INTEGER DEFAULT 0, 
  `AREALAND_EU` DOUBLE NULL DEFAULT 0, 
  `AREATOT_EU` DOUBLE NULL DEFAULT 0, 
  `AREA_USED` DOUBLE NULL DEFAULT 0, 
  `AREA_SOURCE` VARCHAR(50), 
  `P1PNTCNT_EU` DOUBLE NULL DEFAULT 0, 
  `P1SOURCE` VARCHAR(30), 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6), 
  PRIMARY KEY (`CN`)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'POP_ESTN_UNIT'
#

# 0 records

#
# Table structure for table 'POP_EVAL'
#

DROP TABLE IF EXISTS `POP_EVAL`;

CREATE TABLE `POP_EVAL` (
  `CN` VARCHAR(34) NOT NULL, 
  `RSCD` INTEGER DEFAULT 0, 
  `EVALID` INTEGER DEFAULT 0, 
  `EVAL_DESCR` VARCHAR(255), 
  `STATECD` INTEGER DEFAULT 0, 
  `LOCATION_NM` VARCHAR(255), 
  `REPORT_YEAR_NM` VARCHAR(255), 
  `NOTES` LONGTEXT, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6), 
  `START_INVYR` INTEGER DEFAULT 0, 
  `END_INVYR` INTEGER DEFAULT 0, 
  PRIMARY KEY (`CN`)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'POP_EVAL'
#

# 0 records

#
# Table structure for table 'POP_EVAL_ATTRIBUTE'
#

DROP TABLE IF EXISTS `POP_EVAL_ATTRIBUTE`;

CREATE TABLE `POP_EVAL_ATTRIBUTE` (
  `CN` VARCHAR(34), 
  `EVAL_CN` VARCHAR(34), 
  `ATTRIBUTE_NBR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'POP_EVAL_ATTRIBUTE'
#

# 0 records

#
# Table structure for table 'POP_EVAL_GRP'
#

DROP TABLE IF EXISTS `POP_EVAL_GRP`;

CREATE TABLE `POP_EVAL_GRP` (
  `CN` VARCHAR(34) NOT NULL, 
  `EVAL_CN_FOR_EXPALL` VARCHAR(34), 
  `EVAL_CN_FOR_EXPCURR` VARCHAR(34), 
  `EVAL_CN_FOR_EXPVOL` VARCHAR(34), 
  `EVAL_CN_FOR_EXPGROW` VARCHAR(34), 
  `EVAL_CN_FOR_EXPMORT` VARCHAR(34), 
  `EVAL_CN_FOR_EXPREMV` VARCHAR(34), 
  `RSCD` INTEGER DEFAULT 0, 
  `EVAL_GRP` INTEGER DEFAULT 0, 
  `EVAL_GRP_DESCR` VARCHAR(255), 
  `STATECD` INTEGER DEFAULT 0, 
  `LAND_ONLY` VARCHAR(1), 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6), 
  `NOTES` LONGTEXT, 
  PRIMARY KEY (`CN`)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'POP_EVAL_GRP'
#

# 0 records

#
# Table structure for table 'POP_EVAL_TYP'
#

DROP TABLE IF EXISTS `POP_EVAL_TYP`;

CREATE TABLE `POP_EVAL_TYP` (
  `CN` VARCHAR(34) NOT NULL, 
  `EVAL_GRP_CN` VARCHAR(34), 
  `EVAL_CN` VARCHAR(34), 
  `EVAL_TYP` VARCHAR(15), 
  `STATECD` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6), 
  PRIMARY KEY (`CN`)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'POP_EVAL_TYP'
#

# 0 records

#
# Table structure for table 'POP_PLOT_STRATUM_ASSGN'
#

DROP TABLE IF EXISTS `POP_PLOT_STRATUM_ASSGN`;

CREATE TABLE `POP_PLOT_STRATUM_ASSGN` (
  `CN` VARCHAR(34) NOT NULL, 
  `STRATUM_CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `STATECD` INTEGER DEFAULT 0, 
  `INVYR` INTEGER DEFAULT 0, 
  `UNITCD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `RSCD` INTEGER DEFAULT 0, 
  `EVALID` INTEGER DEFAULT 0, 
  `ESTN_UNIT` INTEGER DEFAULT 0, 
  `STRATUMCD` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6), 
  PRIMARY KEY (`CN`)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'POP_PLOT_STRATUM_ASSGN'
#

# 0 records

#
# Table structure for table 'POP_STRATUM'
#

DROP TABLE IF EXISTS `POP_STRATUM`;

CREATE TABLE `POP_STRATUM` (
  `CN` VARCHAR(34) NOT NULL, 
  `ESTN_UNIT_CN` VARCHAR(34), 
  `RSCD` INTEGER DEFAULT 0, 
  `EVALID` INTEGER DEFAULT 0, 
  `ESTN_UNIT` INTEGER DEFAULT 0, 
  `STRATUMCD` INTEGER DEFAULT 0, 
  `STRATUM_DESCR` VARCHAR(255), 
  `STATECD` INTEGER DEFAULT 0, 
  `P1POINTCNT` DOUBLE NULL DEFAULT 0, 
  `P2POINTCNT` DOUBLE NULL DEFAULT 0, 
  `EXPNS` DOUBLE NULL DEFAULT 0, 
  `ADJ_FACTOR_MACR` FLOAT NULL DEFAULT 0, 
  `ADJ_FACTOR_SUBP` FLOAT NULL DEFAULT 0, 
  `ADJ_FACTOR_MICR` FLOAT NULL DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6), 
  PRIMARY KEY (`CN`)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'POP_STRATUM'
#

# 0 records

#
# Table structure for table 'ref_attribute_access'
#

DROP TABLE IF EXISTS `ref_attribute_access`;

CREATE TABLE `ref_attribute_access` (
  `ATTRIBUTE_NBR` INTEGER DEFAULT 0, 
  `ATTRIBUTE_DESCR` VARCHAR(255), 
  `VBA_SUMFROMWHERE` LONGTEXT, 
  `PEA_SURROGATE` INTEGER DEFAULT 0, 
  `CONDTREESEED` VARCHAR(50)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'ref_attribute_access'
#

INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (80, 'Harvest removals (and resulting non-utilized mortality) of all live on forestland (cuft per year)', ' SUM(TREE.FREMVCFAL*TREE.TPAREMV_UNADJ*\r\n            IIF(ISNULL(TREE.DIA),PPP.ADJ_FACTOR_SUBP,\r\n                              IIF(TREE.DIA<5,\r\n                                     PPP.ADJ_FACTOR_MICR,\r\n                                     IIF(TREE.DIA<NZ(PLOT.MACRO_BREAKPOINT_DIA,9999),PPP.ADJ_FACTOR_SUBP,PPP.ADJ_FACTOR_MACR)))) \r\n   AS \"ESTIMATED_VALUE\" \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n TREE.TPAREMV_UNADJ IS NOT NULL AND TREE.FREMVCFAL IS NOT NULL and \r\n (NZ(tree.statuscd,0)=3 or (NZ(tree.statuscd,0)=2 and NZ(tree.agentcd,0)=80)) and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (98, 'IPCC forest carbon pool 2: live belowground (oven-dry metric tonnes)', '  SUM(0.90718474*COND.CONDPROP_UNADJ *\r\n           ( NZ(COND.CARBON_UNDERSTORY_BG, 0) ) *\r\n           IIF(COND.PROP_BASIS=\"MACR\",PPP.ADJ_FACTOR_MACR,PPP.ADJ_FACTOR_SUBP) +\r\n           nz(tree_bg(cond.plt_cn,cond.condid,ppp.adj_factor_micr, \r\n           ppp.adj_factor_subp, ppp.adj_factor_macr,plot.MACRO_BREAKPOINT_DIA),0)) AS \"ESTIMATED_VALUE\"\r\n  FROM COND\r\n INNER JOIN((POP_PLOT_STRATUM_ASSGN\r\n INNER JOIN POP_STRATUM PPP\r\n    ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN)\r\n INNER JOIN PLOT\r\n    ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN\r\n WHERE ((COND.COND_STATUS_CD) = 1)\r\n   AND (COND.CONDPROP_UNADJ IS NOT NULL) AND', 6, 'COND');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (99, 'IPCC forest carbon pool 3: dead wood (oven-dry metric tonnes)', ' SUM(0.90718474*COND.CONDPROP_UNADJ *\r\n           (NZ(COND.CARBON_STANDING_DEAD,0)+NZ(COND.CARBON_DOWN_DEAD,0)) *\r\n           iif(COND.PROP_BASIS=\"MACR\",PPP.ADJ_FACTOR_MACR,PPP.ADJ_FACTOR_SUBP)) AS ESTIMATED_VALUE\r\n  FROM COND\r\n INNER JOIN((POP_PLOT_STRATUM_ASSGN\r\n INNER JOIN POP_STRATUM PPP\r\n    ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN)\r\n INNER JOIN PLOT\r\n    ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN\r\n WHERE ((COND.COND_STATUS_CD) = 1)\r\n   AND (COND.CONDPROP_UNADJ IS NOT NULL) AND', 6, 'COND');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (100, 'IPCC forest carbon pool 4: litter IPCC (oven-dry metric tonnes)', ' SUM(0.90718474*COND.CONDPROP_UNADJ *\r\n           NZ(COND.CARBON_LITTER,0) *\r\n           iif(COND.PROP_BASIS=\"MACR\",PPP.ADJ_FACTOR_MACR,PPP.ADJ_FACTOR_SUBP) ) AS ESTIMATED_VALUE\r\n  FROM COND\r\n INNER JOIN((POP_PLOT_STRATUM_ASSGN\r\n INNER JOIN POP_STRATUM PPP\r\n    ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN)\r\n INNER JOIN PLOT\r\n    ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN\r\n WHERE ((COND.COND_STATUS_CD) = 1)\r\n   AND (COND.CONDPROP_UNADJ IS NOT NULL) AND', 6, 'COND');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (101, 'IPCC forest carbon pool 5: soil organic (oven-dry metric tonnes)', ' SUM(0.90718474*COND.CONDPROP_UNADJ *\r\n           NZ(COND.CARBON_SOIL_ORG,0) *\r\n           iif(COND.PROP_BASIS=\"MACR\",PPP.ADJ_FACTOR_MACR,PPP.ADJ_FACTOR_SUBP)) AS ESTIMATED_VALUE\r\n  FROM COND\r\n INNER JOIN((POP_PLOT_STRATUM_ASSGN\r\n INNER JOIN POP_STRATUM PPP\r\n    ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN)\r\n INNER JOIN PLOT\r\n    ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN\r\n WHERE ((COND.COND_STATUS_CD) = 1)\r\n   AND (COND.CONDPROP_UNADJ IS NOT NULL) AND', 6, 'COND');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (81, 'Harvest removals (and resulting non-utilized mortality) of growing stock on forestland (cuft per year)', '  SUM(TREE.FREMVCFGS*TREE.TPAREMV_UNADJ*\r\n            IIF(ISNULL(TREE.DIA),PPP.ADJ_FACTOR_SUBP,\r\n                              IIF(TREE.DIA<5,\r\n                                     PPP.ADJ_FACTOR_MICR,\r\n                                     IIF(TREE.DIA<NZ(PLOT.MACRO_BREAKPOINT_DIA,9999),PPP.ADJ_FACTOR_SUBP,PPP.ADJ_FACTOR_MACR)))) \r\n   AS \"ESTIMATED_VALUE\"\r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n TREE.TPAREMV_UNADJ IS NOT NULL AND TREE.FREMVCFAL IS NOT NULL and \r\n (NZ(tree.statuscd,0)=3 or (NZ(tree.statuscd,0)=2 and NZ(tree.agentcd,0)=80)) and', 40, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (82, 'Harvest removals (and resulting non-utilized mortality) of sawtimber on forestland (bdft per year)', ' SUM(TREE.FREMVBFSL*TREE.TPAREMV_UNADJ*\n            IIF(ISNULL(TREE.DIA),PPP.ADJ_FACTOR_SUBP,\r\n                              IIF(TREE.DIA<5,\r\n                                     PPP.ADJ_FACTOR_MICR,\r\n                                     IIF(TREE.DIA<NZ(PLOT.MACRO_BREAKPOINT_DIA,9999),PPP.ADJ_FACTOR_SUBP,PPP.ADJ_FACTOR_MACR)))) \r\n   AS \"ESTIMATED_VALUE\"\n FROM \n TREE INNER JOIN ( \n COND INNER JOIN (( \n POP_PLOT_STRATUM_ASSGN \n INNER JOIN \n POP_STRATUM PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \n INNER JOIN \n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \n WHERE TREE.CONDID=COND.CONDID AND \n TREE.TPAREMV_UNADJ IS NOT NULL AND TREE.FREMVBFSL IS NOT NULL and \n (NZ(tree.statuscd,0)=3 or (NZ(tree.statuscd,0)=2 and NZ(tree.agentcd,0)=80)) and', 41, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (83, 'Harvest removals (and resulting non-utilized mortality) of all live on timberland (cuft per year)', ' SUM(TREE.REMVCFAL*TREE.TPAREMV_UNADJ* \n            IIF(ISNULL(TREE.DIA),PPP.ADJ_FACTOR_SUBP,\r\n                              IIF(TREE.DIA<5,\r\n                                     PPP.ADJ_FACTOR_MICR,\r\n                                     IIF(TREE.DIA<NZ(PLOT.MACRO_BREAKPOINT_DIA,9999),PPP.ADJ_FACTOR_SUBP,PPP.ADJ_FACTOR_MACR)))) \r\n   AS \"ESTIMATED_VALUE\"\n FROM \n TREE INNER JOIN ( \n COND INNER JOIN (( \n POP_PLOT_STRATUM_ASSGN \n INNER JOIN \n POP_STRATUM PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \n INNER JOIN \n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \n WHERE TREE.CONDID=COND.CONDID AND \n TREE.TPAREMV_UNADJ IS NOT NULL AND TREE.REMVCFAL IS NOT NULL and \n (NZ(tree.statuscd,0)=3 or (NZ(tree.statuscd,0)=2 and NZ(tree.agentcd,0)=80)) and', 42, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (84, 'Harvest removals (and resulting non-utilized mortality) of growing-stock on timberland (cuft per year)', ' SUM(TREE.REMVCFGS*TREE.TPAREMV_UNADJ*\n            IIF(ISNULL(TREE.DIA),PPP.ADJ_FACTOR_SUBP,\r\n                              IIF(TREE.DIA<5,\r\n                                     PPP.ADJ_FACTOR_MICR,\r\n                                     IIF(TREE.DIA<NZ(PLOT.MACRO_BREAKPOINT_DIA,9999),PPP.ADJ_FACTOR_SUBP,PPP.ADJ_FACTOR_MACR)))) \r\n   AS \"ESTIMATED_VALUE\" \n FROM \n TREE INNER JOIN ( \n COND INNER JOIN (( \n POP_PLOT_STRATUM_ASSGN \n INNER JOIN \n POP_STRATUM PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \n INNER JOIN \n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \n WHERE TREE.CONDID=COND.CONDID AND \n TREE.TPAREMV_UNADJ IS NOT NULL AND TREE.REMVCFGS IS NOT NULL and \n (NZ(tree.statuscd,0)=3 or (NZ(tree.statuscd,0)=2 and NZ(tree.agentcd,0)=80)) and', 43, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (85, 'Harvest removals (and resulting non-utilized mortality) of sawtimber on timberland (bdft per year)', ' SUM(TREE.REMVBFSL*TREE.TPAREMV_UNADJ*\n            IIF(ISNULL(TREE.DIA),PPP.ADJ_FACTOR_SUBP,\r\n                              IIF(TREE.DIA<5,\r\n                                     PPP.ADJ_FACTOR_MICR,\r\n                                     IIF(TREE.DIA<NZ(PLOT.MACRO_BREAKPOINT_DIA,9999),PPP.ADJ_FACTOR_SUBP,PPP.ADJ_FACTOR_MACR)))) \r\n   AS \"ESTIMATED_VALUE\" \n FROM \n TREE INNER JOIN ( \n COND INNER JOIN (( \n POP_PLOT_STRATUM_ASSGN \n INNER JOIN \n POP_STRATUM PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \n INNER JOIN \n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \n WHERE TREE.CONDID=COND.CONDID AND \n TREE.TPAREMV_UNADJ IS NOT NULL AND TREE.REMVBFSL IS NOT NULL and \n (NZ(tree.statuscd,0)=3 or (NZ(tree.statuscd,0)=2 and NZ(tree.agentcd,0)=80)) and', 44, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (86, 'Other removals (due to land-use reclassification)of all live on forestland (cuft per year)', ' SUM(TREE.FREMVCFAL*TREE.TPAREMV_UNADJ*\r\n            IIF(ISNULL(TREE.DIA),PPP.ADJ_FACTOR_SUBP,\r\n                              IIF(TREE.DIA<5,\r\n                                     PPP.ADJ_FACTOR_MICR,\r\n                                     IIF(TREE.DIA<NZ(PLOT.MACRO_BREAKPOINT_DIA,9999),PPP.ADJ_FACTOR_SUBP,PPP.ADJ_FACTOR_MACR)))) \r\n   AS \"ESTIMATED_VALUE\"\r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n TREE.TPAREMV_UNADJ IS NOT NULL AND TREE.FREMVCFAL IS NOT NULL and \r\n not(NZ(tree.statuscd,0)=3) and not(NZ(tree.statuscd,0)=2 and NZ(tree.agentcd,0)=80) and', 39, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (87, 'Other removals (due to land-use reclassification) of growing stock on forestland (cuft per year)', ' SUM(TREE.FREMVCFGS*TREE.TPAREMV_UNADJ*\n            IIF(ISNULL(TREE.DIA),PPP.ADJ_FACTOR_SUBP,\r\n                              IIF(TREE.DIA<5,\r\n                                     PPP.ADJ_FACTOR_MICR,\r\n                                     IIF(TREE.DIA<NZ(PLOT.MACRO_BREAKPOINT_DIA,9999),PPP.ADJ_FACTOR_SUBP,PPP.ADJ_FACTOR_MACR)))) \r\n   AS \"ESTIMATED_VALUE\" \n FROM \n TREE INNER JOIN ( \n COND INNER JOIN (( \n POP_PLOT_STRATUM_ASSGN \n INNER JOIN \n POP_STRATUM PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \n INNER JOIN \n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \n WHERE TREE.CONDID=COND.CONDID AND \n TREE.TPAREMV_UNADJ IS NOT NULL AND TREE.FREMVCFGS IS NOT NULL and \n not(NZ(tree.statuscd,0)=3) and not(NZ(tree.statuscd,0)=2 and NZ(tree.agentcd,0)=80) and', 40, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (88, 'Other removals (due to land-use reclassification) of sawtimber on forestland (bdft per year)', ' SUM(TREE.FREMVBFSL*TREE.TPAREMV_UNADJ*\r\n            IIF(ISNULL(TREE.DIA),PPP.ADJ_FACTOR_SUBP,\r\n                              IIF(TREE.DIA<5,\r\n                                     PPP.ADJ_FACTOR_MICR,\r\n                                     IIF(TREE.DIA<NZ(PLOT.MACRO_BREAKPOINT_DIA,9999),PPP.ADJ_FACTOR_SUBP,PPP.ADJ_FACTOR_MACR)))) \r\n   AS \"ESTIMATED_VALUE\" \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n TREE.TPAREMV_UNADJ IS NOT NULL AND TREE.FREMVBFSL IS NOT NULL and \r\n not(NZ(tree.statuscd,0)=3) and not(NZ(tree.statuscd,0)=2 and NZ(tree.agentcd,0)=80) and', 41, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (89, 'Other removals (due to land-use reclassification) of all live on timberland (cuft per year)', ' SUM(TREE.REMVCFAL*TREE.TPAREMV_UNADJ* \r\n            IIF(ISNULL(TREE.DIA),PPP.ADJ_FACTOR_SUBP,\r\n                              IIF(TREE.DIA<5,\r\n                                     PPP.ADJ_FACTOR_MICR,\r\n                                     IIF(TREE.DIA<NZ(PLOT.MACRO_BREAKPOINT_DIA,9999),PPP.ADJ_FACTOR_SUBP,PPP.ADJ_FACTOR_MACR)))) \r\n   AS \"ESTIMATED_VALUE\" \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n TREE.TPAREMV_UNADJ IS NOT NULL AND TREE.REMVCFAL IS NOT NULL and \r\n not(NZ(tree.statuscd,0)=3) and not(NZ(tree.statuscd,0)=2 and NZ(tree.agentcd,0)=80) and', 42, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (90, 'Other removals (due to land-use reclassification) of growing-stock on timberland (cuft per year)', ' SUM(TREE.REMVCFGS*TREE.TPAREMV_UNADJ*\n            IIF(ISNULL(TREE.DIA),PPP.ADJ_FACTOR_SUBP,\r\n                              IIF(TREE.DIA<5,\r\n                                     PPP.ADJ_FACTOR_MICR,\r\n                                     IIF(TREE.DIA<NZ(PLOT.MACRO_BREAKPOINT_DIA,9999),PPP.ADJ_FACTOR_SUBP,PPP.ADJ_FACTOR_MACR)))) \r\n   AS \"ESTIMATED_VALUE\" \n FROM \n TREE INNER JOIN ( \n COND INNER JOIN (( \n POP_PLOT_STRATUM_ASSGN \n INNER JOIN \n POP_STRATUM PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \n INNER JOIN \n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \n WHERE TREE.CONDID=COND.CONDID AND \n TREE.TPAREMV_UNADJ IS NOT NULL AND TREE.REMVCFGS IS NOT NULL and \n not(NZ(tree.statuscd,0)=3) and not(NZ(tree.statuscd,0)=2 and NZ(tree.agentcd,0)=80) and', 43, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (91, 'Other removals (due to land-use reclassification) of sawtimber on timberland (bdft per year)', ' SUM(TREE.REMVBFSL*TREE.TPAREMV_UNADJ*\n            IIF(ISNULL(TREE.DIA),PPP.ADJ_FACTOR_SUBP,\r\n                              IIF(TREE.DIA<5,\r\n                                     PPP.ADJ_FACTOR_MICR,\r\n                                     IIF(TREE.DIA<NZ(PLOT.MACRO_BREAKPOINT_DIA,9999),PPP.ADJ_FACTOR_SUBP,PPP.ADJ_FACTOR_MACR)))) \r\n   AS \"ESTIMATED_VALUE\" \n FROM \n TREE INNER JOIN ( \n COND INNER JOIN (( \n POP_PLOT_STRATUM_ASSGN \n INNER JOIN \n POP_STRATUM PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \n INNER JOIN \n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \n WHERE TREE.CONDID=COND.CONDID AND \n TREE.TPAREMV_UNADJ IS NOT NULL AND TREE.REMVBFSL IS NOT NULL and \n not(NZ(tree.statuscd,0)=3) and not(NZ(tree.statuscd,0)=2 and NZ(tree.agentcd,0)=80) and', 44, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (92, 'Volume of standing dead trees on forestland (cuft)', ' SUM(TREE.TPA_UNADJ*TREE.VOLCFNET* \n            IIF(ISNULL(TREE.DIA),PPP.ADJ_FACTOR_SUBP,\r\n                              IIF(TREE.DIA<5,\r\n                                     PPP.ADJ_FACTOR_MICR,\r\n                                     IIF(TREE.DIA<NZ(PLOT.MACRO_BREAKPOINT_DIA,9999),PPP.ADJ_FACTOR_SUBP,PPP.ADJ_FACTOR_MACR)))) \r\n   AS \"ESTIMATED_VALUE\" \n FROM \n TREE INNER JOIN ( \n COND INNER JOIN (( \n POP_PLOT_STRATUM_ASSGN \n INNER JOIN \n POP_STRATUM PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \n INNER JOIN \n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \n WHERE ((TREE.STATUSCD)=2) AND (TREE.STANDING_DEAD_CD=1) AND TREE.CONDID=COND.CONDID AND ((COND.COND_STATUS_CD)=1) AND \n TREE.TPA_UNADJ IS NOT NULL AND TREE.VOLCFNET IS NOT NULL AND', 6, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (93, 'Aboveground bark biomass on forestland (oven-dry short tons)', ' SUM(TREE.TPA_UNADJ *\n(BARK_VOL_PCT / (100 + BARK_VOL_PCT) * BARK_SPGR_GREENVOL_DRYWT) /\n((1 - (BARK_VOL_PCT / (100 + BARK_VOL_PCT))) * WOOD_SPGR_GREENVOL_DRYWT)*\n           (NZ(TREE.DRYBIO_BOLE, 0) + NZ(TREE.DRYBIO_TOP, 0) +\n           NZ(TREE.DRYBIO_STUMP, 0) + NZ(TREE.DRYBIO_SAPLING, 0) +\n           NZ(TREE.DRYBIO_WDLD_SPP, 0)) *\n           IIF(ISNULL(TREE.DIA),PPP.ADJ_FACTOR_SUBP,\r\n                              IIF(TREE.DIA<5,\r\n                                     PPP.ADJ_FACTOR_MICR,\r\n                                     IIF(TREE.DIA<NZ(PLOT.MACRO_BREAKPOINT_DIA,9999),PPP.ADJ_FACTOR_SUBP,PPP.ADJ_FACTOR_MACR))))\r\n                                      / 2000 AS \"ESTIMATED_VALUE\"\n  FROM (TREE INNER JOIN(COND INNER JOIN((POP_PLOT_STRATUM_ASSGN INNER JOIN\n                              POP_STRATUM PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN =\n                              PPP.CN) INNER JOIN PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN =\n                             PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON\n        TREE.PLT_CN = PLOT.CN)\n INNER JOIN REF_SPECIES ON TREE.SPCD = REF_SPECIES.SPCD\n WHERE ((TREE.STATUSCD) = 1)\n   AND ((COND.COND_STATUS_CD) = 1)\n   AND TREE.CONDID = COND.CONDID\n   AND TREE.TPA_UNADJ IS NOT NULL\n   AND (TREE.DRYBIO_BOLE IS NOT NULL OR TREE.DRYBIO_TOP IS NOT NULL OR\n       TREE.DRYBIO_STUMP IS NOT NULL OR TREE.DRYBIO_SAPLING IS NOT NULL OR\n       TREE.DRYBIO_WDLD_SPP IS NOT NULL) \nAND', 10, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (94, 'All live tree and sapling aboveground biomass on forestland (green short tons)', ' SUM(TREE.TPA_UNADJ*((1.0+MC_PCT_GREEN_WOOD*.01)*(BARK_VOL_PCT/(100+BARK_VOL_PCT)*WOOD_SPGR_GREENVOL_DRYWT)  \n+ (1.0+MC_PCT_GREEN_BARK*.01)*(1-(BARK_VOL_PCT/(100+BARK_VOL_PCT))*BARK_SPGR_GREENVOL_DRYWT))*(NZ(TREE.DRYBIO_BOLE,0)+NZ(TREE.DRYBIO_TOP,0)+NZ(TREE.DRYBIO_STUMP,0)+NZ(TREE.DRYBIO_SAPLING,0)+NZ(TREE.DRYBIO_WDLD_SPP,0))*\nIIF(ISNULL(TREE.DIA),PPP.ADJ_FACTOR_SUBP,\r\n                              IIF(TREE.DIA<5,\r\n                                     PPP.ADJ_FACTOR_MICR,\r\n                                     IIF(TREE.DIA<NZ(PLOT.MACRO_BREAKPOINT_DIA,9999),PPP.ADJ_FACTOR_SUBP,PPP.ADJ_FACTOR_MACR))))\n                                            /2000  \n   AS \"ESTIMATED_VALUE\" \n FROM \n REF_SPECIES INNER JOIN(\n TREE INNER JOIN ( \n COND INNER JOIN (( \n POP_PLOT_STRATUM_ASSGN \n INNER JOIN \n POP_STRATUM PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \n INNER JOIN \n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \n ) ON TREE.SPCD=REF_SPECIES.SPCD\n WHERE ((TREE.STATUSCD)=1) AND ((COND.COND_STATUS_CD)=1) AND TREE.CONDID=COND.CONDID AND \n TREE.TPA_UNADJ IS NOT NULL AND \n (TREE.DRYBIO_BOLE IS NOT NULL OR\n  TREE.DRYBIO_TOP IS NOT NULL OR\n  TREE.DRYBIO_STUMP IS NOT NULL OR\n  TREE.DRYBIO_SAPLING IS NOT NULL OR\n  TREE.DRYBIO_WDLD_SPP IS NOT NULL) \n AND', 10, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (95, 'Standing dead tree aboveground biomass on forestland (oven-dry short tons)', ' SUM(TREE.TPA_UNADJ*(NZ(TREE.DRYBIO_BOLE,0)+NZ(TREE.DRYBIO_TOP,0)+NZ(TREE.DRYBIO_STUMP,0)+NZ(TREE.DRYBIO_SAPLING,0)+NZ(TREE.DRYBIO_WDLD_SPP,0))*\nIIF(ISNULL(TREE.DIA),PPP.ADJ_FACTOR_SUBP,\r\n                              IIF(TREE.DIA<5,\r\n                                     PPP.ADJ_FACTOR_MICR,\r\n                                     IIF(TREE.DIA<NZ(PLOT.MACRO_BREAKPOINT_DIA,9999),PPP.ADJ_FACTOR_SUBP,PPP.ADJ_FACTOR_MACR))))\n                                            /2000  \n   AS ESTIMATED_VALUE \n FROM \n TREE INNER JOIN ( \n COND INNER JOIN (( \n POP_PLOT_STRATUM_ASSGN \n INNER JOIN \n POP_STRATUM PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \n INNER JOIN \n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \n WHERE ((TREE.STATUSCD)=2) AND (TREE.STANDING_DEAD_CD=1) AND ((COND.COND_STATUS_CD)=1) AND TREE.CONDID=COND.CONDID AND \n TREE.TPA_UNADJ IS NOT NULL AND \n (TREE.DRYBIO_BOLE IS NOT NULL OR\n  TREE.DRYBIO_TOP IS NOT NULL OR\n  TREE.DRYBIO_STUMP IS NOT NULL OR\n  TREE.DRYBIO_SAPLING IS NOT NULL OR\n  TREE.DRYBIO_WDLD_SPP IS NOT NULL) \n AND', 6, 'COND');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (96, 'Total forest land carbon (oven-dry short tons)', ' SUM(COND.CONDPROP_UNADJ *\r\n           (NZ(COND.CARBON_DOWN_DEAD, 0) + \r\n           NZ(COND.CARBON_LITTER, 0) +\r\n           NZ(COND.CARBON_SOIL_ORG, 0) +\r\n           NZ(COND.CARBON_STANDING_DEAD, 0) +\r\n           NZ(COND.CARBON_UNDERSTORY_AG, 0) +\r\n           NZ(COND.CARBON_UNDERSTORY_BG, 0)) *           \r\n           IIF(COND.PROP_BASIS=\"MACR\",PPP.ADJ_FACTOR_MACR,PPP.ADJ_FACTOR_SUBP) +\r\n           nz(tree_ag_bg_english(cond.plt_cn,cond.condid,ppp.adj_factor_micr, \r\n           ppp.adj_factor_subp, ppp.adj_factor_macr,plot.MACRO_BREAKPOINT_DIA),0)) AS \"ESTIMATED_VALUE\"\r\n  FROM COND\r\n INNER JOIN((POP_PLOT_STRATUM_ASSGN\r\n INNER JOIN POP_STRATUM PPP\r\n    ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN)\r\n INNER JOIN PLOT\r\n    ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN\r\n WHERE ((COND.COND_STATUS_CD) = 1)\r\n   AND (COND.CONDPROP_UNADJ IS NOT NULL) AND', 6, 'COND');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (2, 'Area of forestland(acres)', ' SUM(cond.condprop_unadj*IIf(COND.prop_basis= \"MACR\", ppp.adj_factor_macr, ppp.adj_factor_subp)) AS ESTIMATED_VALUE\r\n   FROM COND\r\n  INNER JOIN((POP_PLOT_STRATUM_ASSGN\r\n  INNER JOIN POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN =\r\n       PPP.CN)\r\n  INNER JOIN PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN\r\n  WHERE  ((COND.COND_STATUS_CD) = 1) and  (COND.CONDPROP_UNADJ IS NOT NULL) AND', NULL, 'COND');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (3, 'Area of timberland(acres)', ' SUM(cond.condprop_unadj*IIf(COND.prop_basis= \"MACR\", ppp.adj_factor_macr, ppp.adj_factor_subp)) AS ESTIMATED_VALUE\r\n   FROM COND\r\n  INNER JOIN((POP_PLOT_STRATUM_ASSGN\r\n  INNER JOIN POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN =\r\n       PPP.CN)\r\n  INNER JOIN PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN\r\n  WHERE  ((COND.RESERVCD) = 0)\r\n    AND ((COND.SITECLCD) = 1 Or (COND.SITECLCD) = 2 Or (COND.SITECLCD) = 3 Or\r\n (COND.SITECLCD) = 4 Or (COND.SITECLCD) = 5 Or (COND.SITECLCD) = 6)\r\n    AND ((COND.COND_STATUS_CD) = 1) and (COND.CONDPROP_UNADJ IS NOT NULL) AND', NULL, 'COND');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (4, 'Number of all live trees on forestland(trees)', ' SUM(tree.TPA_UNADJ* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(plot.MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(tree.dia<plot.MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) AND ((COND.COND_STATUS_CD)=1) and TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (6, 'Number of standing dead trees 5\"\"+ dbh on forestland(trees)', ' SUM(tree.TPA_UNADJ* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(plot.MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(tree.dia<plot.MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.STATUSCD=2 AND TREE.DIA>=5 AND TREE.STANDING_DEAD_CD=1 and ((COND.COND_STATUS_CD)=1) and TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (7, 'Number of all live trees on timberland(trees)', ' SUM(tree.TPA_UNADJ* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(plot.MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(tree.dia<plot.MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) AND ((COND.RESERVCD)=0) \r\n      AND ((COND.SITECLCD)=1 Or (COND.SITECLCD)=2 Or (COND.SITECLCD)=3 Or (COND.SITECLCD)=4 Or (COND.SITECLCD)=5 Or (COND.SITECLCD)=6) \r\n      AND ((COND.COND_STATUS_CD)=1) and TREE.CONDID=COND.CONDID AND TREE.DIA>=1.0 AND\r\n tree.TPA_UNADJ is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (9, 'Number of standing dead trees 5\"\"+ dbh on timberland(trees)', ' SUM(tree.TPA_UNADJ* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(plot.MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(tree.dia<plot.MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.STATUSCD=2 AND TREE.DIA>=5 AND TREE.STANDING_DEAD_CD=1 and TREE.CONDID=COND.CONDID \r\n and COND.COND_STATUS_CD=1 and COND.RESERVCD = 0 \r\n    AND ((COND.SITECLCD) = 1 Or (COND.SITECLCD) = 2 Or (COND.SITECLCD) = 3 Or \r\n (COND.SITECLCD) = 4 Or (COND.SITECLCD) = 5 Or (COND.SITECLCD) = 6) and \r\n tree.TPA_UNADJ is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (11, 'All live merchantable biomass on forestland oven-dry(tons)', ' SUM(tree.TPA_UNADJ*tree.drybio_bole* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(plot.MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(tree.dia<plot.MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))/2000  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) AND ((COND.COND_STATUS_CD)=1) and TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and tree.drybio_bole is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (13, 'All live tree and sapling aboveground biomass on timberland oven-dry (tons)', ' SUM(tree.TPA_UNADJ*(nz(tree.drybio_bole,0)+nz(tree.drybio_top,0)+nz(tree.drybio_stump,0)+nz(tree.drybio_sapling,0)+nz(tree.drybio_wdld_spp,0))*   \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(plot.MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(tree.dia<plot.MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))/2000  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) AND ((COND.COND_STATUS_CD)=1) and TREE.CONDID=COND.CONDID AND \r\n ((COND.RESERVCD)=0) \r\n AND ((COND.SITECLCD)=1 Or (COND.SITECLCD)=2 Or (COND.SITECLCD)=3 Or (COND.SITECLCD)=4 Or (COND.SITECLCD)=5 Or (COND.SITECLCD)=6) and \r\n tree.TPA_UNADJ is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (15, 'Volume of growing-stock on forestland(cuft)', ' SUM(tree.TPA_UNADJ*tree.volcfnet* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(plot.MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(tree.dia<plot.MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) and tree.treeclcd=2 and TREE.CONDID=COND.CONDID AND ((COND.COND_STATUS_CD)=1) AND \r\n tree.TPA_UNADJ is not null and tree.volcfnet is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (18, 'Volume of growing-stock on timberland(cuft)', ' SUM(tree.TPA_UNADJ*tree.volcfnet* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(plot.MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(tree.dia<plot.MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1)  \r\n      AND ((TREE.TREECLCD)=2) \r\n      AND ((COND.RESERVCD)=0) \r\n      AND ((COND.SITECLCD)=1 Or (COND.SITECLCD)=2 Or (COND.SITECLCD)=3 Or (COND.SITECLCD)=4 Or (COND.SITECLCD)=5 Or (COND.SITECLCD)=6) \r\n      AND ((COND.COND_STATUS_CD)=1) and TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and tree.volcfnet is not null and TREE.VOLCFNET>0 AND', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (19, 'Volume of sawlog portion on timberland(cuft)', ' SUM(tree.TPA_UNADJ*tree.volcsnet* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(plot.MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(tree.dia<plot.MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) and tree.treeclcd=2 and TREE.CONDID=COND.CONDID and \r\n      ((COND.RESERVCD)=0) \r\n      AND ((COND.SITECLCD)=1 Or (COND.SITECLCD)=2 Or (COND.SITECLCD)=3 Or (COND.SITECLCD)=4 Or (COND.SITECLCD)=5 Or (COND.SITECLCD)=6) \r\n      AND ((COND.COND_STATUS_CD)=1) and TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and tree.volcsnet is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (21, 'Volume of sawtimber on timberland(bdft)', ' SUM(tree.TPA_UNADJ*tree.volbfnet* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(plot.MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(tree.dia<plot.MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1)  \r\n      AND ((TREE.TREECLCD)=2) \r\n      AND ((COND.RESERVCD)=0) \r\n      AND ((COND.SITECLCD)=1 Or (COND.SITECLCD)=2 Or (COND.SITECLCD)=3 Or (COND.SITECLCD)=4 Or (COND.SITECLCD)=5 Or (COND.SITECLCD)=6) \r\n      AND ((COND.COND_STATUS_CD)=1) and TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and tree.volbfnet is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (23, 'All live gross volume on forestland(cuft)', ' SUM(tree.TPA_UNADJ*tree.volcfgrs* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(plot.MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(tree.dia<plot.MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) and TREE.CONDID=COND.CONDID AND ((COND.COND_STATUS_CD)=1) AND \r\n tree.TPA_UNADJ is not null and tree.volcfgrs is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (26, 'Net growth of growing stock on forestland(cuft per year)', ' Sum(TREE.FGROWCFGS*TREE.TPAGROW_UNADJ*\r\n IIf(IsNull(TREE.dia),PPP.adj_factor_subp,IIf(TREE.dia<5,PPP.adj_factor_micr,IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp,\r\n IIf(TREE.dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))   \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n tree.TPAGROW_UNADJ is not null and tree.FGROWCFGS is not null and', NULL, 'PTREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (29, 'Net growth of growing-stock on timberland(cuft per year)', ' Sum(TREE.GROWCFGS*TREE.TPAGROW_UNADJ*\r\n IIf(IsNull(TREE.dia),PPP.adj_factor_subp,IIf(TREE.dia<5,PPP.adj_factor_micr,IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp,\r\n IIf(TREE.dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))   \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n tree.TPAGROW_UNADJ is not null and tree.GROWCFGS is not null and', NULL, 'PTREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (31, 'Mortality of all live on forestland(cuft per year)', ' Sum(TREE.FMORTCFAL*TREE.TPAMORT_UNADJ*\r\n IIf(IsNull(TREE.dia),PPP.adj_factor_subp,IIf(TREE.dia<5,PPP.adj_factor_micr,IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp,\r\n IIf(TREE.dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))   \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n tree.TPAMORT_UNADJ is not null and tree.FMORTCFAL is not null and', NULL, 'PTREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (33, 'Mortality of growing-stock on forestland(cuft per year)', ' Sum(TREE.FMORTCFGS*TREE.TPAMORT_UNADJ*\r\n IIf(IsNull(TREE.dia),PPP.adj_factor_subp,IIf(TREE.dia<5,PPP.adj_factor_micr,IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp,\r\n IIf(TREE.dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))   \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n tree.TPAMORT_UNADJ is not null and tree.FMORTCFGS is not null and', NULL, 'PTREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (35, 'Mortality of all live on timberland(cuft per year)', ' Sum(TREE.MORTCFAL*TREE.TPAMORT_UNADJ*\r\n IIf(IsNull(TREE.dia),PPP.adj_factor_subp,IIf(TREE.dia<5,PPP.adj_factor_micr,IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp,\r\n IIf(TREE.dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))   \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n tree.TPAMORT_UNADJ is not null and tree.MORTCFAL is not null and', NULL, 'PTREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (37, 'Mortality of growing-stock on timberland(cuft per year)', ' Sum(TREE.MORTCFGS*TREE.TPAMORT_UNADJ*\r\n IIf(IsNull(TREE.dia),PPP.adj_factor_subp,IIf(TREE.dia<5,PPP.adj_factor_micr,IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp,\r\n IIf(TREE.dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))   \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n tree.TPAMORT_UNADJ is not null and tree.MORTCFGS is not null and', NULL, 'PTREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (38, 'Mortality of sawtimber on timberland(bdft per year)', ' Sum(TREE.MORTBFSL*TREE.TPAMORT_UNADJ*\r\n IIf(IsNull(TREE.dia),PPP.adj_factor_subp,IIf(TREE.dia<5,PPP.adj_factor_micr,IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp,\r\n IIf(TREE.dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))   \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n tree.TPAMORT_UNADJ is not null and tree.MORTBFSL is not null and', NULL, 'PTREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (39, 'Removals of all live on forestland(cuft per year)', ' Sum(TREE.FREMVCFAL*TREE.TPAREMV_UNADJ*\r\n IIf(IsNull(TREE.dia),PPP.adj_factor_subp,IIf(TREE.dia<5,PPP.adj_factor_micr,IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp,\r\n IIf(TREE.dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))   \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n tree.TPAREMV_UNADJ is not null and tree.FREMVCFAL is not null and', NULL, 'PTREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (40, 'Removals of growing stock on forestland(cuft per year)', ' Sum(TREE.FREMVCFGS*TREE.TPAREMV_UNADJ*\r\n IIf(IsNull(TREE.dia),PPP.adj_factor_subp,IIf(TREE.dia<5,PPP.adj_factor_micr,IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp,\r\n IIf(TREE.dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))   \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n tree.TPAREMV_UNADJ is not null and tree.FREMVCFGS is not null and', NULL, 'PTREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (43, 'Removals of growing-stock on timberland(cuft per year)', ' Sum(TREE.REMVCFGS*TREE.TPAREMV_UNADJ*\r\n IIf(IsNull(TREE.dia),PPP.adj_factor_subp,IIf(TREE.dia<5,PPP.adj_factor_micr,IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp,\r\n IIf(TREE.dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))   \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n tree.TPAREMV_UNADJ is not null and tree.REMVCFGS is not null and', NULL, 'PTREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (14, 'Volume of all live on forestland(cuft)', ' SUM(tree.TPA_UNADJ*tree.volcfnet* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(plot.MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(tree.dia<plot.MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) and TREE.CONDID=COND.CONDID AND ((COND.COND_STATUS_CD)=1) AND \r\n tree.TPA_UNADJ is not null and tree.volcfnet is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (22, 'All live gross sawtimber volume on forestland(bdft)', ' SUM(tree.TPA_UNADJ*tree.volbfgrs* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(plot.MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(tree.dia<plot.MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) and tree.treeclcd=2 and TREE.CONDID=COND.CONDID AND ((COND.COND_STATUS_CD)=1) AND \r\n tree.TPA_UNADJ is not null and tree.volbfgrs is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (41, 'Removals of sawtimber on forestland(bdft per year)', ' Sum(TREE.FREMVBFSL*TREE.TPAREMV_UNADJ*\r\n IIf(IsNull(TREE.dia),PPP.adj_factor_subp,IIf(TREE.dia<5,PPP.adj_factor_micr,IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp,\r\n IIf(TREE.dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))   \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n tree.TPAREMV_UNADJ is not null and tree.FREMVBFSL is not null and', NULL, 'PTREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (5, 'Number of growing-stock trees on forestland(trees)', ' SUM(tree.TPA_UNADJ* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(plot.MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(tree.dia<plot.MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) AND (TREE.TREECLCD=2) and ((COND.COND_STATUS_CD)=1) and TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (8, 'Number of growing-stock trees on timberland(trees)', ' SUM(tree.TPA_UNADJ* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(plot.MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(tree.dia<plot.MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1)  \r\n      AND ((TREE.TREECLCD)=2) \r\n      AND ((COND.RESERVCD)=0) \r\n      AND ((COND.SITECLCD)=1 Or (COND.SITECLCD)=2 Or (COND.SITECLCD)=3 Or (COND.SITECLCD)=4 Or (COND.SITECLCD)=5 Or (COND.SITECLCD)=6) \r\n      AND ((COND.COND_STATUS_CD)=1) and TREE.CONDID=COND.CONDID AND TREE.DIA>=1.0 AND\r\n tree.TPA_UNADJ is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (10, 'All live tree and sapling aboveground biomass on forestland oven-dry(tons)', 'SUM(tree.TPA_UNADJ*(nz(tree.drybio_bole,0)+nz(tree.drybio_top,0)+nz(tree.drybio_stump,0)+nz(tree.drybio_sapling,0)+nz(tree.drybio_wdld_spp,0))*      \r\n IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr,       \r\n IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp,       \r\n IIf(dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,adj_factor_macr)))))/2000  \n   AS ESTIMATED_VALUE \n FROM \n TREE INNER JOIN ( \n COND INNER JOIN (( \n POP_PLOT_STRATUM_ASSGN \n INNER JOIN \n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \n INNER JOIN \n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \n WHERE ((TREE.STATUSCD)=1) AND ((COND.COND_STATUS_CD)=1) and TREE.CONDID=COND.CONDID AND \n tree.TPA_UNADJ is not null and \r\n (tree.drybio_bole is not null or\r\n  tree.drybio_top is not null or\r\n  tree.drybio_stump is not null or\r\n  tree.drybio_sapling is not null or\r\n  tree.drybio_wdld_spp is not null) \r\n and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (12, 'All live merchantable biomass on timberland oven-dry(tons)', ' SUM(tree.TPA_UNADJ*tree.drybio_bole* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(plot.MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(tree.dia<plot.MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))/2000  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) AND ((COND.COND_STATUS_CD)=1) and TREE.CONDID=COND.CONDID AND \r\n ((COND.RESERVCD)=0) \r\n AND ((COND.SITECLCD)=1 Or (COND.SITECLCD)=2 Or (COND.SITECLCD)=3 Or (COND.SITECLCD)=4 Or (COND.SITECLCD)=5 Or (COND.SITECLCD)=6) and \r\n tree.TPA_UNADJ is not null and tree.drybio_bole is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (16, 'Volume of sawlog portion on forestland(cuft)', ' SUM(tree.TPA_UNADJ*tree.volcsnet* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(plot.MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(tree.dia<plot.MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) and tree.treeclcd=2 and TREE.CONDID=COND.CONDID and ((COND.COND_STATUS_CD)=1) AND \r\n tree.TPA_UNADJ is not null and tree.volcsnet is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (20, 'Volume of sawtimber on forestland(bdft)', ' SUM(tree.TPA_UNADJ*tree.volbfnet* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(plot.MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(tree.dia<plot.MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) and tree.treeclcd=2 and TREE.CONDID=COND.CONDID AND ((COND.COND_STATUS_CD)=1) AND \r\n tree.TPA_UNADJ is not null and tree.volbfnet is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (24, 'All live sound volume on forestland(cuft)', ' SUM(tree.TPA_UNADJ*tree.volcfsnd* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(plot.MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(tree.dia<plot.MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) and TREE.CONDID=COND.CONDID AND ((COND.COND_STATUS_CD)=1) AND \r\n tree.TPA_UNADJ is not null and tree.volcfsnd is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (27, 'Net growth of sawtimber on forestland(bdft per year)', ' Sum(TREE.FGROWBFSL*TREE.TPAGROW_UNADJ*\r\n IIf(IsNull(TREE.dia),PPP.adj_factor_subp,IIf(TREE.dia<5,PPP.adj_factor_micr,IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp,\r\n IIf(TREE.dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))   \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n tree.TPAGROW_UNADJ is not null and tree.FGROWBFSL is not null and', NULL, 'PTREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (28, 'Net growth of all live on timberland(cuft per year)', ' Sum(TREE.GROWCFAL*TREE.TPAGROW_UNADJ*\r\n IIf(IsNull(TREE.dia),PPP.adj_factor_subp,IIf(TREE.dia<5,PPP.adj_factor_micr,IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp,\r\n IIf(TREE.dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))   \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n tree.TPAGROW_UNADJ is not null and tree.GROWCFAL is not null and', NULL, 'PTREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (30, 'Net growth of sawtimber on timberland(bdft per year)', ' Sum(TREE.GROWBFSL*TREE.TPAGROW_UNADJ*\r\n IIf(IsNull(TREE.dia),PPP.adj_factor_subp,IIf(TREE.dia<5,PPP.adj_factor_micr,IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp,\r\n IIf(TREE.dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))   \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n tree.TPAGROW_UNADJ is not null and tree.GROWBFSL is not null and', NULL, 'PTREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (32, 'Mortality of all live trees on forestland(trees per year)', ' Sum(TREE.TPAMORT_UNADJ*\r\n IIf(IsNull(TREE.dia),PPP.adj_factor_subp,IIf(TREE.dia<5,PPP.adj_factor_micr,IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp,\r\n IIf(TREE.dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))   \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n tree.TPAMORT_UNADJ is not null and', NULL, 'PTREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (34, 'Mortality of sawtimber on forestland(bdft per year)', ' Sum(TREE.FMORTBFSL*TREE.TPAMORT_UNADJ*\r\n IIf(IsNull(TREE.dia),PPP.adj_factor_subp,IIf(TREE.dia<5,PPP.adj_factor_micr,IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp,\r\n IIf(TREE.dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))   \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n tree.TPAMORT_UNADJ is not null and tree.FMORTBFSL is not null and', NULL, 'PTREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (36, 'Mortality of all live trees on timberland(trees per year)', ' Sum(TREE.TPAMORT_UNADJ*\r\n IIf(IsNull(TREE.dia),PPP.adj_factor_subp,IIf(TREE.dia<5,PPP.adj_factor_micr,IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp,\r\n IIf(TREE.dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))   \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n tree.TPAMORT_UNADJ is not null and', NULL, 'PTREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (42, 'Removals of all live on timberland(cuft per year)', ' Sum(TREE.REMVCFAL*TREE.TPAREMV_UNADJ* IIf(IsNull(TREE.dia),PPP.adj_factor_subp,IIf(TREE.dia<5,PPP.adj_factor_micr,IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp,\r\n IIf(TREE.dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))   \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n tree.TPAREMV_UNADJ is not null and tree.REMVCFAL is not null and', NULL, 'PTREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (44, 'Removals of sawtimber on timberland(bdft per year)', ' Sum(TREE.REMVBFSL*TREE.TPAREMV_UNADJ*\r\n IIf(IsNull(TREE.dia),PPP.adj_factor_subp,IIf(TREE.dia<5,PPP.adj_factor_micr,IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp,\r\n IIf(TREE.dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))   \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n tree.TPAREMV_UNADJ is not null and tree.REMVBFSL is not null and', NULL, 'PTREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (17, 'Volume of all live on timberland(cuft)', ' SUM(tree.TPA_UNADJ*tree.volcfnet* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(plot.MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(tree.dia<plot.MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) AND ((COND.RESERVCD)=0) \r\n      AND ((COND.SITECLCD)=1 Or (COND.SITECLCD)=2 Or (COND.SITECLCD)=3 Or (COND.SITECLCD)=4 Or (COND.SITECLCD)=5 Or (COND.SITECLCD)=6) \r\n      AND ((COND.COND_STATUS_CD)=1) and TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and tree.volcfnet is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (25, 'Net growth of all live on forestland(cuft per year)', ' Sum(TREE.FGROWCFAL*TREE.TPAGROW_UNADJ*\r\n IIf(IsNull(TREE.dia),PPP.adj_factor_subp,IIf(TREE.dia<5,PPP.adj_factor_micr,IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp,\r\n IIf(TREE.dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,PPP.adj_factor_macr)))))   \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE TREE.CONDID=COND.CONDID AND \r\n tree.TPAGROW_UNADJ is not null and tree.FGROWCFAL is not null and', NULL, 'PTREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (49, 'Carbon in understory belowground on forestland (short tons)', ' SUM(cond.condprop_unadj * COND.CARBON_UNDERSTORY_BG  *IIf(COND.prop_basis= \"MACR\", ppp.adj_factor_macr, ppp.adj_factor_subp)) AS ESTIMATED_VALUE\n   FROM COND\n  INNER JOIN((POP_PLOT_STRATUM_ASSGN\n  INNER JOIN POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN =\n       PPP.CN)\n  INNER JOIN PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN\n  WHERE  ((COND.COND_STATUS_CD) = 1) and  (COND.CONDPROP_UNADJ IS NOT NULL) AND\r\n  COND.CARBON_UNDERSTORY_BG is not null and', NULL, 'COND');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (50, 'Carbon in down dead on forestland (short tons)', ' SUM(cond.condprop_unadj * COND.CARBON_DOWN_DEAD*IIf(COND.prop_basis= \"MACR\", ppp.adj_factor_macr, ppp.adj_factor_subp)) AS ESTIMATED_VALUE\n   FROM COND\n  INNER JOIN((POP_PLOT_STRATUM_ASSGN\n  INNER JOIN POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN =\n       PPP.CN)\n  INNER JOIN PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN\n  WHERE  ((COND.COND_STATUS_CD) = 1) and  (COND.CONDPROP_UNADJ IS NOT NULL) AND\r\n  COND.CARBON_DOWN_DEAD is not null and', NULL, 'COND');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (52, 'Soil organic carbon on forestland (short tons)', ' SUM(cond.condprop_unadj *COND.CARBON_SOIL_ORG*IIf(COND.prop_basis= \"MACR\", ppp.adj_factor_macr, ppp.adj_factor_subp)) AS ESTIMATED_VALUE\n   FROM COND\n  INNER JOIN((POP_PLOT_STRATUM_ASSGN\n  INNER JOIN POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN =\n       PPP.CN)\n  INNER JOIN PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN\n  WHERE  ((COND.COND_STATUS_CD) = 1) and  (COND.CONDPROP_UNADJ IS NOT NULL) AND\r\n  COND.CARBON_SOIL_ORG is not null and', NULL, 'COND');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (53, 'Carbon in live trees and saplings aboveground on forestland (short tons)', ' SUM(tree.TPA_UNADJ*(nz(tree.carbon_ag,0))* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,adj_factor_macr)))))/2000  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) AND ((COND.COND_STATUS_CD)=1) and TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (55, 'Carbon in live trees and saplings above and belowground on forestland (short tons)', 'SUM(tree.TPA_UNADJ*(nz(tree.carbon_ag,0)+nz(tree.carbon_bg,0))* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,adj_factor_macr)))))/2000  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) AND ((COND.COND_STATUS_CD)=1) and TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (56, 'All live top and limb biomass on forestland oven-dry(short tons)', ' SUM(tree.TPA_UNADJ*(nz(tree.drybio_top,0))* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,adj_factor_macr)))))/2000  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) AND ((COND.COND_STATUS_CD)=1) and TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (58, 'All live stump (ground to 12 inches) biomass on forestland oven-dry(short tons)', 'SUM(tree.TPA_UNADJ*(nz(tree.drybio_stump,0))* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,adj_factor_macr)))))/2000  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) AND ((COND.COND_STATUS_CD)=1) and TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (59, 'All live belowground tree and sapling biomass on forestland oven-dry(short tons)', ' SUM(tree.TPA_UNADJ*(nz(tree.drybio_bg,0))* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,adj_factor_macr)))))/2000  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) AND ((COND.COND_STATUS_CD)=1) and TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (63, 'Carbon in understory belowground on timberland (short tons)', ' SUM(cond.condprop_unadj * COND.CARBON_UNDERSTORY_BG  *\r\nIIf(COND.prop_basis= \"MACR\", ppp.adj_factor_macr, ppp.adj_factor_subp)) AS ESTIMATED_VALUE\n   FROM COND\n  INNER JOIN((POP_PLOT_STRATUM_ASSGN\n  INNER JOIN POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN =\n       PPP.CN)\n  INNER JOIN PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN\n  WHERE  ((COND.COND_STATUS_CD) = 1)  AND COND.RESERVCD=0 \r\n  AND ((COND.SITECLCD)=1 Or (COND.SITECLCD)=2 Or (COND.SITECLCD)=3 \r\n  Or (COND.SITECLCD)=4 Or (COND.SITECLCD)=5 Or (COND.SITECLCD)=6) and \n  (COND.CONDPROP_UNADJ IS NOT NULL) AND COND.CARBON_UNDERSTORY_BG IS NOT NULL AND', NULL, 'COND');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (64, 'Carbon in down dead on timberland (short tons)', ' SUM(cond.condprop_unadj * COND.CARBON_DOWN_DEAD*\r\nIIf(COND.prop_basis= \"MACR\", ppp.adj_factor_macr, ppp.adj_factor_subp)) AS ESTIMATED_VALUE\n   FROM COND\n  INNER JOIN((POP_PLOT_STRATUM_ASSGN\n  INNER JOIN POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN =\n       PPP.CN)\n  INNER JOIN PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN\n  WHERE  ((COND.COND_STATUS_CD) = 1)  \r\n  AND COND.RESERVCD=0\r\n  AND ((COND.SITECLCD)=1 Or (COND.SITECLCD)=2 Or (COND.SITECLCD)=3 \r\n  Or (COND.SITECLCD)=4 Or (COND.SITECLCD)=5 Or (COND.SITECLCD)=6) and \n  (COND.CONDPROP_UNADJ IS NOT NULL) AND COND.CARBON_DOWN_DEAD IS NOT NULL AND', NULL, 'COND');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (66, 'Soil organic carbon on timberland (short tons)', ' SUM(cond.condprop_unadj *COND.CARBON_SOIL_ORG*\r\nIIf(COND.prop_basis= \"MACR\", ppp.adj_factor_macr, ppp.adj_factor_subp)) AS ESTIMATED_VALUE\n   FROM COND\n  INNER JOIN((POP_PLOT_STRATUM_ASSGN\n  INNER JOIN POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN)\n  INNER JOIN PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN\n  WHERE  ((COND.COND_STATUS_CD) = 1)  \r\n  AND COND.RESERVCD=0\r\n  AND ((COND.SITECLCD)=1 Or (COND.SITECLCD)=2 Or (COND.SITECLCD)=3 \r\n  Or (COND.SITECLCD)=4 Or (COND.SITECLCD)=5 Or (COND.SITECLCD)=6) and \n  (COND.CONDPROP_UNADJ IS NOT NULL) AND COND.CARBON_SOIL_ORG IS NOT NULL AND', NULL, 'COND');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (68, 'Carbon in live trees belowground on timberland (short tons)', ' SUM(tree.TPA_UNADJ*(nz(tree.carbon_bg,0))* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,adj_factor_macr)))))/2000  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) AND ((COND.COND_STATUS_CD)=1)  \r\n AND COND.RESERVCD=0 \r\n AND ((COND.SITECLCD)=1 Or (COND.SITECLCD)=2 Or (COND.SITECLCD)=3 \r\n Or (COND.SITECLCD)=4 Or (COND.SITECLCD)=5 Or (COND.SITECLCD)=6) and \r\n TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (47, 'Carbon in standing dead trees on forestland (short tons)', ' SUM(cond.condprop_unadj * COND.CARBON_STANDING_DEAD *IIf(COND.prop_basis= \"MACR\", ppp.adj_factor_macr, ppp.adj_factor_subp)) AS ESTIMATED_VALUE\n   FROM COND\n  INNER JOIN((POP_PLOT_STRATUM_ASSGN\n  INNER JOIN POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN =\n       PPP.CN)\n  INNER JOIN PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN\n  WHERE  ((COND.COND_STATUS_CD) = 1) and  (COND.CONDPROP_UNADJ IS NOT NULL)\r\n  and COND.CARBON_STANDING_DEAD is not null and', NULL, 'COND');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (48, 'Carbon in understory aboveground on forestland (short tons)', ' SUM(cond.condprop_unadj * COND.CARBON_UNDERSTORY_AG  *IIf(COND.prop_basis= \"MACR\", ppp.adj_factor_macr, ppp.adj_factor_subp)) AS ESTIMATED_VALUE\n   FROM COND\n  INNER JOIN((POP_PLOT_STRATUM_ASSGN\n  INNER JOIN POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN =\n       PPP.CN)\n  INNER JOIN PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN\n  WHERE  ((COND.COND_STATUS_CD) = 1) and  (COND.CONDPROP_UNADJ IS NOT NULL) AND\r\n  COND.CARBON_UNDERSTORY_AG is not null and', NULL, 'COND');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (51, 'Carbon in litter on forestland (short tons)', ' SUM(cond.condprop_unadj * COND.CARBON_LITTER*IIf(COND.prop_basis= \"MACR\", ppp.adj_factor_macr, ppp.adj_factor_subp)) AS ESTIMATED_VALUE\n   FROM COND\n  INNER JOIN((POP_PLOT_STRATUM_ASSGN\n  INNER JOIN POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN =\n       PPP.CN)\n  INNER JOIN PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN\n  WHERE  ((COND.COND_STATUS_CD) = 1) and  (COND.CONDPROP_UNADJ IS NOT NULL) AND\r\n  COND.CARBON_LITTER is not null and', NULL, 'COND');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (54, 'Carbon in live trees and saplings belowground on forestland (short tons)', ' SUM(tree.TPA_UNADJ*(nz(tree.carbon_bg,0))* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,adj_factor_macr)))))/2000  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) AND ((COND.COND_STATUS_CD)=1) and TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (57, 'All live sapling biomass on forestland oven-dry(short tons)', ' SUM(tree.TPA_UNADJ*(nz(tree.drybio_sapling,0))* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,adj_factor_macr)))))/2000  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) AND ((COND.COND_STATUS_CD)=1) and TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (61, 'Carbon in standing dead trees on timberland (short tons)', ' SUM(cond.condprop_unadj * COND.CARBON_STANDING_DEAD *IIf(COND.prop_basis= \"MACR\", ppp.adj_factor_macr, ppp.adj_factor_subp)) AS ESTIMATED_VALUE\r\n   FROM COND\r\n  INNER JOIN((POP_PLOT_STRATUM_ASSGN\r\n  INNER JOIN POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN =\r\n       PPP.CN)\r\n  INNER JOIN PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN\r\n  WHERE  ((COND.COND_STATUS_CD) = 1) AND COND.RESERVCD=0\r\n  AND ((COND.SITECLCD)=1 Or (COND.SITECLCD)=2 Or (COND.SITECLCD)=3 Or (COND.SITECLCD)=4 Or (COND.SITECLCD)=5 Or (COND.SITECLCD)=6) and \r\n  (COND.CONDPROP_UNADJ IS NOT NULL) AND COND.CARBON_STANDING_DEAD IS NOT NULL AND', NULL, 'COND');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (62, 'Carbon in understory aboveground on timberland (short tons)', ' SUM(cond.condprop_unadj * COND.CARBON_UNDERSTORY_AG  *\r\nIIf(COND.prop_basis= \"MACR\", ppp.adj_factor_macr, ppp.adj_factor_subp)) AS ESTIMATED_VALUE\r\n   FROM COND\r\n  INNER JOIN((POP_PLOT_STRATUM_ASSGN\r\n  INNER JOIN POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN =\r\n       PPP.CN)\r\n  INNER JOIN PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN\r\n  WHERE  ((COND.COND_STATUS_CD) = 1)  AND \r\n  COND.RESERVCD=0 AND\r\n  ((COND.SITECLCD)=1 Or (COND.SITECLCD)=2 Or (COND.SITECLCD)=3 \r\n  Or (COND.SITECLCD)=4 Or (COND.SITECLCD)=5 Or (COND.SITECLCD)=6) and \r\n  (COND.CONDPROP_UNADJ IS NOT NULL) AND COND.CARBON_UNDERSTORY_AG IS NOT NULL AND', NULL, 'COND');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (70, 'All live top and limb biomass on timberland oven-dry(short tons)', ' SUM(tree.TPA_UNADJ*(nz(tree.drybio_top,0))* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,adj_factor_macr)))))/2000  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) AND ((COND.COND_STATUS_CD)=1)  \r\n AND COND.RESERVCD=0\r\n AND ((COND.SITECLCD)=1 Or (COND.SITECLCD)=2 Or (COND.SITECLCD)=3 \r\n Or (COND.SITECLCD)=4 Or (COND.SITECLCD)=5 Or (COND.SITECLCD)=6) and \r\n TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (72, 'All live stump (ground to 12 inches) biomass on timberland oven-dry(short tons)', ' SUM(tree.TPA_UNADJ*(nz(tree.drybio_stump,0))* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,adj_factor_macr)))))/2000  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) AND ((COND.COND_STATUS_CD)=1)\r\n AND COND.RESERVCD=0 \r\n AND ((COND.SITECLCD)=1 Or (COND.SITECLCD)=2 Or (COND.SITECLCD)=3 \r\n Or (COND.SITECLCD)=4 Or (COND.SITECLCD)=5 Or (COND.SITECLCD)=6) and \r\n TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (73, 'All live belowground tree and sapling biomass on timberland oven-dry(short tons)', ' SUM(tree.TPA_UNADJ*(nz(tree.drybio_bg,0))* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,adj_factor_macr)))))/2000  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) \r\n AND COND.RESERVCD=0 \r\n AND ((COND.COND_STATUS_CD)=1)  AND ((COND.SITECLCD)=1 Or (COND.SITECLCD)=2 Or (COND.SITECLCD)=3 \r\n Or (COND.SITECLCD)=4 Or (COND.SITECLCD)=5 Or (COND.SITECLCD)=6) and \r\n TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (67, 'Carbon in live trees and saplings aboveground on timberland (short tons)', ' SUM(tree.TPA_UNADJ*(nz(tree.carbon_ag,0))* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,adj_factor_macr)))))/2000  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) AND ((COND.COND_STATUS_CD)=1)  \r\n AND COND.RESERVCD=0 \r\n AND ((COND.SITECLCD)=1 Or (COND.SITECLCD)=2 Or (COND.SITECLCD)=3 \r\n Or (COND.SITECLCD)=4 Or (COND.SITECLCD)=5 Or (COND.SITECLCD)=6) and \r\n TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (69, 'Carbon in live trees above and belowground on timberland (short tons)', ' SUM(tree.TPA_UNADJ*(nz(tree.carbon_ag,0)+nz(tree.carbon_bg,0))* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,adj_factor_macr)))))/2000  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) AND ((COND.COND_STATUS_CD)=1)  \r\n AND COND.RESERVCD=0 \r\n AND ((COND.SITECLCD)=1 Or (COND.SITECLCD)=2 Or (COND.SITECLCD)=3 \r\n Or (COND.SITECLCD)=4 Or (COND.SITECLCD)=5 Or (COND.SITECLCD)=6) and \r\n TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (71, 'All live sapling biomass on timberland oven-dry(short tons)', ' SUM(tree.TPA_UNADJ*(nz(tree.drybio_sapling,0))* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,adj_factor_macr)))))/2000  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1)\r\n AND COND.RESERVCD=0\r\n AND ((COND.COND_STATUS_CD)=1)  AND ((COND.SITECLCD)=1 Or (COND.SITECLCD)=2 Or (COND.SITECLCD)=3 \r\n Or (COND.SITECLCD)=4 Or (COND.SITECLCD)=5 Or (COND.SITECLCD)=6) and \r\n TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (79, 'Area sampled (acres)', ' SUM(cond.condprop_unadj*IIf(COND.prop_basis= \"MACR\", ppp.adj_factor_macr, ppp.adj_factor_subp)) AS ESTIMATED_VALUE\r\n   FROM COND\r\n  INNER JOIN((POP_PLOT_STRATUM_ASSGN\r\n  INNER JOIN POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN)\r\n  INNER JOIN PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN\r\n  WHERE (COND.CONDPROP_UNADJ IS NOT NULL) AND COND.COND_STATUS_CD<5 AND', NULL, 'COND');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (65, 'Carbon in litter on timberland (short tons)', ' SUM(cond.condprop_unadj * COND.CARBON_LITTER*\r\nIIf(COND.prop_basis= \"MACR\", ppp.adj_factor_macr, ppp.adj_factor_subp)) AS ESTIMATED_VALUE\n   FROM COND\n  INNER JOIN((POP_PLOT_STRATUM_ASSGN\n  INNER JOIN POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN =\n       PPP.CN)\n  INNER JOIN PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN\n  WHERE  ((COND.COND_STATUS_CD) = 1)  \r\n  AND COND.RESERVCD=0\r\n  AND ((COND.SITECLCD)=1 Or (COND.SITECLCD)=2 Or (COND.SITECLCD)=3 \r\n  Or (COND.SITECLCD)=4 Or (COND.SITECLCD)=5 Or (COND.SITECLCD)=6) and \n  (COND.CONDPROP_UNADJ IS NOT NULL) AND COND.CARBON_LITTER IS NOT NULL AND', NULL, 'COND');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (60, 'All live woodland species biomass on forestland oven-dry (short tons)', ' SUM(tree.TPA_UNADJ*(nz(tree.drybio_wdld_spp,0))* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,adj_factor_macr)))))/2000  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) AND ((COND.COND_STATUS_CD)=1) and TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (74, 'All live woodland species biomass on timberland oven-dry (short tons)', ' SUM(tree.TPA_UNADJ*(nz(tree.drybio_wdld_spp,0))* \r\n      IIf(IsNull(tree.dia),PPP.adj_factor_subp,IIf(tree.dia<5,PPP.adj_factor_micr, \r\n      IIf(IsNull(MACRO_BREAKPOINT_DIA),PPP.adj_factor_subp, \r\n      IIf(dia<MACRO_BREAKPOINT_DIA,PPP.adj_factor_subp,adj_factor_macr)))))/2000  \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n TREE INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON TREE.PLT_CN = PLOT.CN \r\n WHERE ((TREE.STATUSCD)=1) AND ((COND.COND_STATUS_CD)=1) and (COND.RESERVCD=0) \r\n AND ((COND.SITECLCD)=1 Or (COND.SITECLCD)=2 Or (COND.SITECLCD)=3 \r\n Or (COND.SITECLCD)=4 Or (COND.SITECLCD)=5 Or (COND.SITECLCD)=6) \r\n and TREE.CONDID=COND.CONDID AND \r\n tree.TPA_UNADJ is not null and', NULL, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (102, 'IPCC forest carbon total: all 5 pools (oven-dry metric tonnes)', '  SUM(0.90718474*COND.CONDPROP_UNADJ *\r\n           (NZ(COND.CARBON_DOWN_DEAD, 0) + \r\n           NZ(COND.CARBON_LITTER, 0) +\r\n           NZ(COND.CARBON_SOIL_ORG, 0) +\r\n           NZ(COND.CARBON_STANDING_DEAD, 0) +\r\n           NZ(COND.CARBON_UNDERSTORY_AG, 0) +\r\n           NZ(COND.CARBON_UNDERSTORY_BG, 0)) *           \r\n           IIF(COND.PROP_BASIS=\"MACR\",PPP.ADJ_FACTOR_MACR,PPP.ADJ_FACTOR_SUBP) +\r\n           nz(tree_ag_bg(cond.plt_cn,cond.condid,ppp.adj_factor_micr, \r\n           ppp.adj_factor_subp, ppp.adj_factor_macr,plot.MACRO_BREAKPOINT_DIA),0)) AS \"ESTIMATED_VALUE\"\r\n  FROM COND\r\n INNER JOIN((POP_PLOT_STRATUM_ASSGN\r\n INNER JOIN POP_STRATUM PPP\r\n    ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN)\r\n INNER JOIN PLOT\r\n    ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN\r\n WHERE ((COND.COND_STATUS_CD) = 1)\r\n   AND (COND.CONDPROP_UNADJ IS NOT NULL) AND', 6, 'COND');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (97, 'IPCC forest carbon pool 1: live aboveground (oven-dry metric tonnes)', ' SUM(0.90718474*COND.CONDPROP_UNADJ *\r\n           ( NZ(COND.CARBON_UNDERSTORY_AG, 0) ) *\r\n           IIF(COND.PROP_BASIS=\"MACR\",PPP.ADJ_FACTOR_MACR,PPP.ADJ_FACTOR_SUBP) +\r\n           nz(tree_ag(cond.plt_cn,cond.condid,ppp.adj_factor_micr, \r\n           ppp.adj_factor_subp, ppp.adj_factor_macr,plot.MACRO_BREAKPOINT_DIA),0)) AS \"ESTIMATED_VALUE\"\r\n  FROM COND\r\n INNER JOIN((POP_PLOT_STRATUM_ASSGN\r\n INNER JOIN POP_STRATUM PPP\r\n    ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN)\r\n INNER JOIN PLOT\r\n    ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN\r\n WHERE ((COND.COND_STATUS_CD) = 1)\r\n   AND (COND.CONDPROP_UNADJ IS NOT NULL) AND', 6, 'COND');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (45, 'Number of live seedlings on forestland(seedlings)', ' SUM(SEEDLING.TPA_UNADJ* PPP.adj_factor_micr) \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n SEEDLING INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON SEEDLING.PLT_CN = PLOT.CN \r\n WHERE ((COND.COND_STATUS_CD)=1) and SEEDLING.CONDID=COND.CONDID AND \r\n SEEDLING.TPA_UNADJ is not null and', 0, 'TREE');
INSERT INTO `ref_attribute_access` (`ATTRIBUTE_NBR`, `ATTRIBUTE_DESCR`, `VBA_SUMFROMWHERE`, `PEA_SURROGATE`, `CONDTREESEED`) VALUES (46, 'Number of live seedlings on timberland(seedlings)', ' SUM(SEEDLING.TPA_UNADJ* PPP.adj_factor_micr) \r\n   AS ESTIMATED_VALUE \r\n FROM \r\n SEEDLING INNER JOIN ( \r\n COND INNER JOIN (( \r\n POP_PLOT_STRATUM_ASSGN \r\n INNER JOIN \r\n POP_STRATUM as PPP ON POP_PLOT_STRATUM_ASSGN.STRATUM_CN = PPP.CN) \r\n INNER JOIN \r\n PLOT ON POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN) ON COND.PLT_CN = PLOT.CN) ON SEEDLING.PLT_CN = PLOT.CN \r\n WHERE ((COND.COND_STATUS_CD)=1) and SEEDLING.CONDID=COND.CONDID AND \r\n (COND.COND_STATUS_CD=1 AND COND.RESERVCD=0 AND (COND.SITECLCD=1 Or COND.SITECLCD=2 Or COND.SITECLCD=3 Or COND.SITECLCD=4 Or COND.SITECLCD=5 Or COND.SITECLCD=6)) AND \r\n SEEDLING.TPA_UNADJ is not null and', 0, 'TREE');
# 97 records

#
# Table structure for table 'REF_CITATION'
#

DROP TABLE IF EXISTS `REF_CITATION`;

CREATE TABLE `REF_CITATION` (
  `CITATION_NBR` INTEGER DEFAULT 0, 
  `CITATION` LONGTEXT, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'REF_CITATION'
#

# 0 records

#
# Table structure for table 'REF_FIADB_VERSION'
#

DROP TABLE IF EXISTS `REF_FIADB_VERSION`;

CREATE TABLE `REF_FIADB_VERSION` (
  `VERSION` VARCHAR(40), 
  `DESCR` LONGTEXT, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6), 
  `INSTALL_TYPE` VARCHAR(10)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'REF_FIADB_VERSION'
#

# 0 records

#
# Table structure for table 'REF_FOREST_TYPE'
#

DROP TABLE IF EXISTS `REF_FOREST_TYPE`;

CREATE TABLE `REF_FOREST_TYPE` (
  `VALUE` INTEGER DEFAULT 0, 
  `MEANING` VARCHAR(80), 
  `TYPGRPCD` INTEGER DEFAULT 0, 
  `MANUAL_START` FLOAT NULL DEFAULT 0, 
  `MANUAL_END` FLOAT NULL DEFAULT 0, 
  `ALLOWED_IN_FIELD` VARCHAR(1), 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'REF_FOREST_TYPE'
#

# 0 records

#
# Table structure for table 'REF_HABTYP_DESCRIPTION'
#

DROP TABLE IF EXISTS `REF_HABTYP_DESCRIPTION`;

CREATE TABLE `REF_HABTYP_DESCRIPTION` (
  `CN` VARCHAR(34), 
  `HABTYPCD` VARCHAR(10), 
  `PUB_CD` VARCHAR(10), 
  `SCIENTIFIC_NAME` VARCHAR(115), 
  `COMMON_NAME` VARCHAR(255), 
  `VALID` VARCHAR(1), 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'REF_HABTYP_DESCRIPTION'
#

# 0 records

#
# Table structure for table 'REF_HABTYP_PUBLICATION'
#

DROP TABLE IF EXISTS `REF_HABTYP_PUBLICATION`;

CREATE TABLE `REF_HABTYP_PUBLICATION` (
  `CN` VARCHAR(34), 
  `PUB_CD` VARCHAR(10), 
  `TITLE` VARCHAR(200), 
  `AUTHOR` VARCHAR(200), 
  `TYPE` VARCHAR(10), 
  `VALID` VARCHAR(1), 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'REF_HABTYP_PUBLICATION'
#

# 0 records

#
# Table structure for table 'REF_LICHEN_SPECIES'
#

DROP TABLE IF EXISTS `REF_LICHEN_SPECIES`;

CREATE TABLE `REF_LICHEN_SPECIES` (
  `LICH_SPPCD` INTEGER DEFAULT 0, 
  `YEARSTART` INTEGER DEFAULT 0, 
  `YEAREND` INTEGER DEFAULT 0, 
  `SPP_ACRONYM` VARCHAR(6), 
  `GENUS` VARCHAR(40), 
  `SPECIES` VARCHAR(50), 
  `CN` VARCHAR(34), 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'REF_LICHEN_SPECIES'
#

# 0 records

#
# Table structure for table 'REF_LICHEN_SPP_COMMENTS'
#

DROP TABLE IF EXISTS `REF_LICHEN_SPP_COMMENTS`;

CREATE TABLE `REF_LICHEN_SPP_COMMENTS` (
  `LICH_SPPCD` INTEGER DEFAULT 0, 
  `SPP_NAME` VARCHAR(80), 
  `YEAREND` INTEGER DEFAULT 0, 
  `YEARSTART` INTEGER DEFAULT 0, 
  `SPP_COMMENTS` LONGTEXT, 
  `CN` VARCHAR(34), 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'REF_LICHEN_SPP_COMMENTS'
#

# 0 records

#
# Table structure for table 'REF_PLANT_DICTIONARY'
#

DROP TABLE IF EXISTS `REF_PLANT_DICTIONARY`;

CREATE TABLE `REF_PLANT_DICTIONARY` (
  `CN` VARCHAR(34), 
  `SYMBOL_TYPE` VARCHAR(20), 
  `SYMBOL` VARCHAR(16), 
  `SCIENTIFIC_NAME` VARCHAR(100), 
  `NEW_SYMBOL` VARCHAR(16), 
  `NEW_SCIENTIFIC_NAME` VARCHAR(100), 
  `COMMON_NAME` VARCHAR(100), 
  `CATEGORY` VARCHAR(15), 
  `FAMILY` VARCHAR(25), 
  `GROWTH_HABIT` VARCHAR(50), 
  `DURATION` VARCHAR(50), 
  `US_NATIVITY` VARCHAR(50), 
  `STATE_DISTRIBUTION` LONGTEXT, 
  `XGENUS` VARCHAR(1), 
  `GENUS` VARCHAR(20), 
  `XSPECIES` VARCHAR(1), 
  `SPECIES` VARCHAR(50), 
  `SSP` VARCHAR(4), 
  `SUBSPECIES` VARCHAR(30), 
  `VAR` VARCHAR(4), 
  `VARIETY` VARCHAR(30), 
  `MANUAL_START` FLOAT NULL DEFAULT 0, 
  `MANUAL_END` FLOAT NULL DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'REF_PLANT_DICTIONARY'
#

# 0 records

#
# Table structure for table 'REF_POP_ATTRIBUTE'
#

DROP TABLE IF EXISTS `REF_POP_ATTRIBUTE`;

CREATE TABLE `REF_POP_ATTRIBUTE` (
  `CN` VARCHAR(34), 
  `ATTRIBUTE_NBR` INTEGER DEFAULT 0, 
  `ATTRIBUTE_DESCR` VARCHAR(255), 
  `EXPRESSION` LONGTEXT, 
  `WHERE_CLAUSE` VARCHAR(255), 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6), 
  `FOOTNOTE` LONGTEXT
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'REF_POP_ATTRIBUTE'
#

# 0 records

#
# Table structure for table 'REF_POP_EVAL_TYP_DESCR'
#

DROP TABLE IF EXISTS `REF_POP_EVAL_TYP_DESCR`;

CREATE TABLE `REF_POP_EVAL_TYP_DESCR` (
  `CN` VARCHAR(34), 
  `EVAL_TYP` VARCHAR(15), 
  `EVAL_TYP_DESCR` VARCHAR(255), 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'REF_POP_EVAL_TYP_DESCR'
#

# 0 records

#
# Table structure for table 'REF_PRC'
#

DROP TABLE IF EXISTS `REF_PRC`;

CREATE TABLE `REF_PRC` (
  `CLASSNBR` INTEGER DEFAULT 0, 
  `CONDTREESEED` VARCHAR(50), 
  `CLASSNM` VARCHAR(50), 
  `FUNCTIONNM` VARCHAR(255), 
  `PAGECLASS` VARCHAR(50), 
  `ROWCLASS` VARCHAR(50), 
  `COLCLASS` VARCHAR(50), 
  UNIQUE (`CLASSNBR`)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'REF_PRC'
#

INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (1, 'COND', 'County', '(select stctyLabel from ref_stcty where stcty=plot.statecd*1000+plot.countycd)', 'N', 'Y', 'N');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (2, 'COND', 'State', 'statecdLabel(plot.statecd)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (3, 'COND', 'Stand-size', 'stdszcdLabel(cond.stdszcd)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (4, 'COND', 'Ownership', 'owncdLabel(cond.owncd)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (5, 'TREE', 'Diameter class', 'diaLabel(tree.dia)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (6, 'TREE', 'Subplot', 'subpLabel(tree.subp)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (7, 'TREE', 'Species', 'spcdLabel(tree.spcd)', 'N', 'Y', 'N');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (8, 'COND', 'All live stocking', 'alstkcdLabel(cond.alstkcd)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (9, 'COND', 'Forest type', 'fortypcdLabel(cond.fortypcd)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (10, 'COND', 'Artificial regen species', 'spcdLabel(cond.stdorgsp)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (11, 'COND', 'Basal area live tree', 'baliveLabel(cond.balive)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (12, 'COND', 'Condition cond', 'condidLabel(cond.condid)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (13, 'TREE', 'Condition tree', 'condidLabel(tree.condid)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (14, 'COND', 'Condprop_unadj', 'condprop_unadjLabel(cond.condprop_unadj)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (15, 'COND', 'Ecosubsection', 'ecosubcdLabel(plot.ecosubcd)', 'N', 'Y', 'N');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (16, 'TREE', 'Species group', 'spgrpcdLabel(tree.spgrpcd)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (17, 'TREE', 'Subplot tree', 'subpLabel(tree.subp)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (18, 'COND', 'Congressional district', 'congcdLabel(plot.congcd)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (19, 'TREE', 'Crown ratio', 'crLabel(tree.cr)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (20, 'TREE', 'Crown class', 'cclcdLabel(tree.cclcd)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (21, 'TREE', 'Tree grade', 'treegrcdLabel(tree.treegrcd)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (22, 'TREE', 'Damaging agent', 'agentcdLabel(tree.agentcd)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (23, 'TREE', 'Cull proportion', 'cullLabel(tree.cull)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (24, 'TREE', 'Damage location1', 'damloc1Label(tree.damloc1)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (25, 'TREE', 'Damage type1', 'damtyp1Label(tree.damtyp1)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (26, 'TREE', 'Damage severity1', 'damsev1Label(tree.damsev1)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (27, 'TREE', 'Damage location2', 'damloc2Label(tree.damloc2)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (28, 'TREE', 'Damage type2', 'damtyp2Label(tree.damtyp2)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (29, 'TREE', 'Damage severity2', 'damsev2Label(tree.damsev2)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (30, 'TREE', 'Decay code', 'decaycdLabel(tree.decaycd)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (31, 'COND', 'Distance to road', 'rddistcdLabel(plot.rddistcd)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (32, 'COND', 'Disturbance code1', 'dstrbcd1Label(cond.dstrbcd1)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (33, 'COND', 'Disturbance code2', 'dstrbcd2Label(cond.dstrbcd2)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (34, 'COND', 'Disturbance code3', 'dstrbcd3Label(cond.dstrbcd3)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (35, 'COND', 'Elevation', 'elevLabel(plot.elev)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (36, 'COND', 'Forest Service Region', 'adforcdLabel(cond.adforcd)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (37, 'COND', 'Growing-stock stocking', 'gsstkcdLabel(cond.gsstkcd)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (38, 'TREE', 'Tree height', 'htLabel(tree.ht)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (39, 'COND', 'Land use - major', 'cond_status_cdMajorLabel(cond.cond_status_cd,cond.cond_nonsample_reasn_cd)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (40, 'COND', 'Land use - forest', 'cond_status_cdForestLabel(cond.cond_status_cd,cond.reservcd,cond.siteclcd)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (41, 'COND', 'National forest', 'adforcdNFLabel(cond.adforcd)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (42, 'TREE', 'Tree growing-stock volume', 'volcfnetLabel(tree.volcfnet)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (43, 'COND', 'Site index', 'sicondLabel(cond.sicond)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (44, 'COND', 'Site productivity', 'siteclcdLabel(cond.siteclcd)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (45, 'COND', 'Slope', 'slopeLabel(cond.slope)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (46, 'TREE', 'Species group major', 'spcdMajorLabel(tree.spcd)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (47, 'COND', 'Stand origin', 'stdorgcdLabel(cond.stdorgcd)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (48, 'COND', 'Stand treatment code1', 'trtcd1Label(cond.trtcd1)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (49, 'COND', 'Stand treatment code2', 'trtcd2Label(cond.trtcd2)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (50, 'COND', 'Stand treatment code3', 'trtcd3Label(cond.trtcd3)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (51, 'TREE', 'Tree class', 'treeclcdLabel(tree.treeclcd)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (52, 'COND', 'Survey unit', 'unitcdLabel(cond.unitcd)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (53, 'COND', 'EVALID', '(select rscdEvalidLabel from ref_rscdEvalid where rscdEvalid=POP_PLOT_STRATUM_ASSGN.rscd*1000000+POP_PLOT_STRATUM_ASSGN.evalid)', 'N', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (54, 'COND', 'Physiographic class', 'physclcdLabel(cond.physclcd)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (55, 'COND', 'Stand-age', 'stdageLabel(cond.stdage)', 'Y', 'Y', 'Y');
INSERT INTO `REF_PRC` (`CLASSNBR`, `CONDTREESEED`, `CLASSNM`, `FUNCTIONNM`, `PAGECLASS`, `ROWCLASS`, `COLCLASS`) VALUES (56, 'COND', 'EstimationUnit (runs slow)', 'estUnitLabel(POP_PLOT_STRATUM_ASSGN.cn,POP_PLOT_STRATUM_ASSGN.rscd,POP_PLOT_STRATUM_ASSGN.evalid,POP_PLOT_STRATUM_ASSGN.estn_unit)', 'N', 'Y', 'N');
# 56 records

#
# Table structure for table 'REF_RSCDEVALID'
#

DROP TABLE IF EXISTS `REF_RSCDEVALID`;

CREATE TABLE `REF_RSCDEVALID` (
  `rscdEvalid` INTEGER, 
  `rscdEvalidLabel` VARCHAR(255)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'REF_RSCDEVALID'
#

INSERT INTO `REF_RSCDEVALID` (`rscdEvalid`, `rscdEvalidLabel`) VALUES (24090600, '0012 24090600 Connecticut 2003.2004.2005.2006                                                                                                                                                                                                                  ');
INSERT INTO `REF_RSCDEVALID` (`rscdEvalid`, `rscdEvalidLabel`) VALUES (24090601, '0013 24090601 Connecticut 2003.2004.2005.2006                                                                                                                                                                                                                  ');
INSERT INTO `REF_RSCDEVALID` (`rscdEvalid`, `rscdEvalidLabel`) VALUES (24090602, '0015 24090602 Connecticut 2003.2004.2005.2006                                                                                                                                                                                                                  ');
INSERT INTO `REF_RSCDEVALID` (`rscdEvalid`, `rscdEvalidLabel`) VALUES (24090700, '0020 24090700 Connecticut 2003.2004.2005.2006.2007                                                                                                                                                                                                             ');
INSERT INTO `REF_RSCDEVALID` (`rscdEvalid`, `rscdEvalidLabel`) VALUES (24090701, '0021 24090701 Connecticut 2003.2004.2005.2006.2007                                                                                                                                                                                                             ');
INSERT INTO `REF_RSCDEVALID` (`rscdEvalid`, `rscdEvalidLabel`) VALUES (24090703, '0022 24090703 Connecticut 2003.2004.2005.2006.2007                                                                                                                                                                                                             ');
INSERT INTO `REF_RSCDEVALID` (`rscdEvalid`, `rscdEvalidLabel`) VALUES (24090800, '0017 24090800 Connecticut 2004.2005.2006.2007.2008                                                                                                                                                                                                             ');
INSERT INTO `REF_RSCDEVALID` (`rscdEvalid`, `rscdEvalidLabel`) VALUES (24090801, '0018 24090801 Connecticut 2004.2005.2006.2007.2008                                                                                                                                                                                                             ');
INSERT INTO `REF_RSCDEVALID` (`rscdEvalid`, `rscdEvalidLabel`) VALUES (24090803, '0019 24090803 Connecticut 2008                                                                                                                                                                                                                                 ');
INSERT INTO `REF_RSCDEVALID` (`rscdEvalid`, `rscdEvalidLabel`) VALUES (24095331, '0014 24095331 Connecticut 2003.2004.2005                                                                                                                                                                                                                       ');
INSERT INTO `REF_RSCDEVALID` (`rscdEvalid`, `rscdEvalidLabel`) VALUES (24095332, '0016 24095332 Connecticut 2003.2004.2005                                                                                                                                                                                                                       ');
INSERT INTO `REF_RSCDEVALID` (`rscdEvalid`, `rscdEvalidLabel`) VALUES (24098501, '0001 24098501 Connecticut 1985                                                                                                                                                                                                                                 ');
INSERT INTO `REF_RSCDEVALID` (`rscdEvalid`, `rscdEvalidLabel`) VALUES (24098502, '0002 24098502 Connecticut 1985                                                                                                                                                                                                                                 ');
INSERT INTO `REF_RSCDEVALID` (`rscdEvalid`, `rscdEvalidLabel`) VALUES (24098503, '0003 24098503 Connecticut 1985                                                                                                                                                                                                                                 ');
INSERT INTO `REF_RSCDEVALID` (`rscdEvalid`, `rscdEvalidLabel`) VALUES (24098504, '0004 24098504 Connecticut 1985                                                                                                                                                                                                                                 ');
INSERT INTO `REF_RSCDEVALID` (`rscdEvalid`, `rscdEvalidLabel`) VALUES (24098505, '0005 24098505 Connecticut 1985                                                                                                                                                                                                                                 ');
INSERT INTO `REF_RSCDEVALID` (`rscdEvalid`, `rscdEvalidLabel`) VALUES (24099801, '0006 24099801 Connecticut 1998                                                                                                                                                                                                                                 ');
INSERT INTO `REF_RSCDEVALID` (`rscdEvalid`, `rscdEvalidLabel`) VALUES (24099802, '0007 24099802 Connecticut 1998                                                                                                                                                                                                                                 ');
INSERT INTO `REF_RSCDEVALID` (`rscdEvalid`, `rscdEvalidLabel`) VALUES (24099803, '0008 24099803 Connecticut 1998                                                                                                                                                                                                                                 ');
INSERT INTO `REF_RSCDEVALID` (`rscdEvalid`, `rscdEvalidLabel`) VALUES (24099804, '0009 24099804 Connecticut 1998                                                                                                                                                                                                                                 ');
INSERT INTO `REF_RSCDEVALID` (`rscdEvalid`, `rscdEvalidLabel`) VALUES (24099805, '0010 24099805 Connecticut 1998                                                                                                                                                                                                                                 ');
INSERT INTO `REF_RSCDEVALID` (`rscdEvalid`, `rscdEvalidLabel`) VALUES (24099806, '0011 24099806 Connecticut 1998                                                                                                                                                                                                                                 ');
# 22 records

#
# Table structure for table 'REF_SPECIES'
#

DROP TABLE IF EXISTS `REF_SPECIES`;

CREATE TABLE `REF_SPECIES` (
  `SPCD` INTEGER, 
  `COMMON_NAME` VARCHAR(100), 
  `GENUS` VARCHAR(40), 
  `SPECIES` VARCHAR(50), 
  `VARIETY` VARCHAR(50), 
  `SUBSPECIES` VARCHAR(50), 
  `SPECIES_SYMBOL` VARCHAR(8), 
  `E_SPGRPCD` INTEGER DEFAULT 0, 
  `W_SPGRPCD` INTEGER DEFAULT 0, 
  `MAJOR_SPGRPCD` INTEGER DEFAULT 0, 
  `STOCKING_SPGRPCD` INTEGER DEFAULT 0, 
  `FOREST_TYPE_SPGRPCD` INTEGER DEFAULT 0, 
  `EXISTS_IN_NCRS` VARCHAR(1), 
  `EXISTS_IN_NERS` VARCHAR(1), 
  `EXISTS_IN_PNWRS` VARCHAR(1), 
  `EXISTS_IN_RMRS` VARCHAR(1), 
  `EXISTS_IN_SRS` VARCHAR(1), 
  `SITETREE` VARCHAR(1), 
  `SFTWD_HRDWD` VARCHAR(1), 
  `ST_EXISTS_IN_NCRS` VARCHAR(1), 
  `ST_EXISTS_IN_NERS` VARCHAR(1), 
  `ST_EXISTS_IN_PNWRS` VARCHAR(1), 
  `ST_EXISTS_IN_RMRS` VARCHAR(1), 
  `ST_EXISTS_IN_SRS` VARCHAR(1), 
  `EAST` VARCHAR(1), 
  `WEST` VARCHAR(1), 
  `WOODLAND` VARCHAR(1), 
  `MANUAL_START` FLOAT NULL DEFAULT 0, 
  `MANUAL_END` FLOAT NULL DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6), 
  `CORE` VARCHAR(1), 
  `JENKINS_SPGRPCD` INTEGER DEFAULT 0, 
  `JENKINS_TOTAL_B1` DOUBLE NULL DEFAULT 0, 
  `JENKINS_TOTAL_B2` DOUBLE NULL DEFAULT 0, 
  `JENKINS_STEM_WOOD_RATIO_B1` DOUBLE NULL DEFAULT 0, 
  `JENKINS_STEM_WOOD_RATIO_B2` DOUBLE NULL DEFAULT 0, 
  `JENKINS_STEM_BARK_RATIO_B1` DOUBLE NULL DEFAULT 0, 
  `JENKINS_STEM_BARK_RATIO_B2` DOUBLE NULL DEFAULT 0, 
  `JENKINS_FOLIAGE_RATIO_B1` DOUBLE NULL DEFAULT 0, 
  `JENKINS_FOLIAGE_RATIO_B2` DOUBLE NULL DEFAULT 0, 
  `JENKINS_ROOT_RATIO_B1` DOUBLE NULL DEFAULT 0, 
  `JENKINS_ROOT_RATIO_B2` DOUBLE NULL DEFAULT 0, 
  `JENKINS_SAPLING_ADJUSTMENT` DOUBLE NULL DEFAULT 0, 
  `WOOD_SPGR_GREENVOL_DRYWT` DOUBLE NULL DEFAULT 0, 
  `WOOD_SPGR_GREENVOL_DRYWT_CIT` INTEGER DEFAULT 0, 
  `BARK_SPGR_GREENVOL_DRYWT` DOUBLE NULL DEFAULT 0, 
  `BARK_SPGR_GREENVOL_DRYWT_CIT` INTEGER DEFAULT 0, 
  `MC_PCT_GREEN_WOOD` DOUBLE NULL DEFAULT 0, 
  `MC_PCT_GREEN_WOOD_CIT` INTEGER DEFAULT 0, 
  `MC_PCT_GREEN_BARK` DOUBLE NULL DEFAULT 0, 
  `MC_PCT_GREEN_BARK_CIT` INTEGER DEFAULT 0, 
  `WOOD_SPGR_MC12VOL_DRYWT` DOUBLE NULL DEFAULT 0, 
  `WOOD_SPGR_MC12VOL_DRYWT_CIT` INTEGER DEFAULT 0, 
  `BARK_VOL_PCT` DOUBLE NULL DEFAULT 0, 
  `BARK_VOL_PCT_CIT` INTEGER DEFAULT 0, 
  `RAILE_STUMP_DOB_B1` DOUBLE NULL, 
  `RAILE_STUMP_DIB_B1` DOUBLE NULL, 
  `RAILE_STUMP_DIB_B2` DOUBLE NULL
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'REF_SPECIES'
#

# 0 records

#
# Table structure for table 'REF_SPECIES_GROUP'
#

DROP TABLE IF EXISTS `REF_SPECIES_GROUP`;

CREATE TABLE `REF_SPECIES_GROUP` (
  `SPGRPCD` INTEGER DEFAULT 0, 
  `NAME` VARCHAR(35), 
  `REGION` VARCHAR(8), 
  `CLASS` VARCHAR(8), 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'REF_SPECIES_GROUP'
#

# 0 records

#
# Table structure for table 'REF_STATE_ELEV'
#

DROP TABLE IF EXISTS `REF_STATE_ELEV`;

CREATE TABLE `REF_STATE_ELEV` (
  `STATECD` INTEGER DEFAULT 0, 
  `MIN_ELEV` INTEGER DEFAULT 0, 
  `MAX_ELEV` INTEGER DEFAULT 0, 
  `LOWEST_POINT` VARCHAR(30), 
  `HIGHEST_POINT` VARCHAR(30), 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'REF_STATE_ELEV'
#

# 0 records

#
# Table structure for table 'ref_stcty'
#

DROP TABLE IF EXISTS `ref_stcty`;

CREATE TABLE `ref_stcty` (
  `STCTY` DOUBLE NULL NOT NULL, 
  `STCTYLABEL` VARCHAR(255), 
  PRIMARY KEY (`STCTY`)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'ref_stcty'
#

INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1001, '0001 Autauga');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1003, '0002 Baldwin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1005, '0003 Barbour');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1007, '0004 Bibb');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1009, '0005 Blount');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1011, '0006 Bullock');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1013, '0007 Butler');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1015, '0008 Calhoun');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1017, '0009 Chambers');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1019, '0010 Cherokee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1021, '0011 Chilton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1023, '0012 Choctaw');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1025, '0013 Clarke');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1027, '0014 Clay');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1029, '0015 Cleburne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1031, '0016 Coffee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1033, '0017 Colbert');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1035, '0018 Conecuh');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1037, '0019 Coosa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1039, '0020 Covington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1041, '0021 Crenshaw');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1043, '0022 Cullman');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1045, '0023 Dale');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1047, '0024 Dallas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1049, '0025 DeKalb');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1051, '0026 Elmore');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1053, '0027 Escambia');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1055, '0028 Etowah');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1057, '0029 Fayette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1059, '0030 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1061, '0031 Geneva');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1063, '0032 Greene');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1065, '0033 Hale');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1067, '0034 Henry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1069, '0035 Houston');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1071, '0036 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1073, '0037 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1075, '0038 Lamar');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1077, '0039 Lauderdale');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1079, '0040 Lawrence');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1081, '0041 Lee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1083, '0042 Limestone');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1085, '0043 Lowndes');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1087, '0044 Macon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1089, '0045 Madison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1091, '0046 Marengo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1093, '0047 Marion');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1095, '0048 Marshall');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1097, '0049 Mobile');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1099, '0050 Monroe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1101, '0051 Montgomery');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1103, '0052 Morgan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1105, '0053 Perry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1107, '0054 Pickens');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1109, '0055 Pike');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1111, '0056 Randolph');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1113, '0057 Russell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1115, '0058 St. Clair');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1117, '0059 Shelby');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1119, '0060 Sumter');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1121, '0061 Talladega');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1123, '0062 Tallapoosa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1125, '0063 Tuscaloosa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1127, '0064 Walker');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1129, '0065 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1131, '0066 Wilcox');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (1133, '0067 Winston');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2013, '0068 Aleutians East Borough');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2016, '0069 Aleutians West Census Area');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2020, '0070 Anchorage Borough');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2050, '0071 Bethel Census Area');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2060, '0072 Bristol Bay Borough');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2068, '0073 Denali Borough');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2070, '0074 Dillingham Census Area');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2090, '0075 Fairbanks North Star Borough');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2100, '0076 Haines Borough');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2110, '0077 Juneau Borough');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2122, '0078 Kenai Peninsula Borough');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2130, '0079 Ketchikan Gateway Borough');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2150, '0080 Kodiak Island Borough');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2164, '0081 Lake and Peninsula Borough');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2170, '0082 Matanuska-Susitna Borough');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2180, '0083 Nome Census Area');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2185, '0084 North Slope Borough');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2188, '0085 Northwest Arctic Borough');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2201, '0086 Prince of Wales-Outer Ketchikan Census Area');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2220, '0087 Sitka Borough');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2232, '0088 Skagway-Hoonah-Angoon Census Area');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2240, '0089 Southeast Fairbanks Census Area');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2261, '0090 Valdez-Cordova Census Area');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2270, '0091 Wade Hampton Census Area');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2280, '0092 Wrangell-Petersburg Census Area');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2282, '0093 Yakutat Borough');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (2290, '0094 Yukon-Koyukuk Census Area');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (4001, '0095 Apache');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (4003, '0096 Cochise');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (4005, '0097 Coconino');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (4007, '0098 Gila');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (4009, '0099 Graham');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (4011, '0100 Greenlee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (4012, '0101 La Paz');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (4013, '0102 Maricopa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (4015, '0103 Mohave');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (4017, '0104 Navajo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (4019, '0105 Pima');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (4021, '0106 Pinal');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (4023, '0107 Santa Cruz');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (4025, '0108 Yavapai');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (4027, '0109 Yuma');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5001, '0110 Arkansas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5003, '0111 Ashley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5005, '0112 Baxter');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5007, '0113 Benton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5009, '0114 Boone');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5011, '0115 Bradley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5013, '0116 Calhoun');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5015, '0117 Carroll');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5017, '0118 Chicot');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5019, '0119 Clark');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5021, '0120 Clay');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5023, '0121 Cleburne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5025, '0122 Cleveland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5027, '0123 Columbia');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5029, '0124 Conway');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5031, '0125 Craighead');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5033, '0126 Crawford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5035, '0127 Crittenden');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5037, '0128 Cross');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5039, '0129 Dallas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5041, '0130 Desha');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5043, '0131 Drew');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5045, '0132 Faulkner');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5047, '0133 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5049, '0134 Fulton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5051, '0135 Garland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5053, '0136 Grant');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5055, '0137 Greene');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5057, '0138 Hempstead');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5059, '0139 Hot Spring');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5061, '0140 Howard');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5063, '0141 Independence');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5065, '0142 Izard');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5067, '0143 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5069, '0144 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5071, '0145 Johnson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5073, '0146 Lafayette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5075, '0147 Lawrence');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5077, '0148 Lee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5079, '0149 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5081, '0150 Little River');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5083, '0151 Logan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5085, '0152 Lonoke');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5087, '0153 Madison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5089, '0154 Marion');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5091, '0155 Miller');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5093, '0156 Mississippi');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5095, '0157 Monroe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5097, '0158 Montgomery');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5099, '0159 Nevada');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5101, '0160 Newton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5103, '0161 Ouachita');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5105, '0162 Perry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5107, '0163 Phillips');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5109, '0164 Pike');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5111, '0165 Poinsett');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5113, '0166 Polk');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5115, '0167 Pope');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5117, '0168 Prairie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5119, '0169 Pulaski');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5121, '0170 Randolph');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5123, '0171 St. Francis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5125, '0172 Saline');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5127, '0173 Scott');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5129, '0174 Searcy');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5131, '0175 Sebastian');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5133, '0176 Sevier');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5135, '0177 Sharp');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5137, '0178 Stone');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5139, '0179 Union');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5141, '0180 Van Buren');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5143, '0181 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5145, '0182 White');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5147, '0183 Woodruff');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (5149, '0184 Yell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6001, '0185 Alameda');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6003, '0186 Alpine');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6005, '0187 Amador');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6007, '0188 Butte');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6009, '0189 Calaveras');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6011, '0190 Colusa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6013, '0191 Contra Costa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6015, '0192 Del Norte');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6017, '0193 El Dorado');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6019, '0194 Fresno');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6021, '0195 Glenn');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6023, '0196 Humboldt');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6025, '0197 Imperial');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6027, '0198 Inyo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6029, '0199 Kern');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6031, '0200 Kings');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6033, '0201 Lake');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6035, '0202 Lassen');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6037, '0203 Los Angeles');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6039, '0204 Madera');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6041, '0205 Marin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6043, '0206 Mariposa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6045, '0207 Mendocino');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6047, '0208 Merced');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6049, '0209 Modoc');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6051, '0210 Mono');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6053, '0211 Monterey');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6055, '0212 Napa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6057, '0213 Nevada');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6059, '0214 Orange');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6061, '0215 Placer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6063, '0216 Plumas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6065, '0217 Riverside');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6067, '0218 Sacramento');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6069, '0219 San Benito');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6071, '0220 San Bernardino');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6073, '0221 San Diego');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6075, '0222 San Francisco');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6077, '0223 San Joaquin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6079, '0224 San Luis Obispo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6081, '0225 San Mateo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6083, '0226 Santa Barbara');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6085, '0227 Santa Clara');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6087, '0228 Santa Cruz');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6089, '0229 Shasta');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6091, '0230 Sierra');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6093, '0231 Siskiyou');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6095, '0232 Solano');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6097, '0233 Sonoma');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6099, '0234 Stanislaus');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6101, '0235 Sutter');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6103, '0236 Tehama');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6105, '0237 Trinity');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6107, '0238 Tulare');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6109, '0239 Tuolumne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6111, '0240 Ventura');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6113, '0241 Yolo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (6115, '0242 Yuba');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8001, '0243 Adams');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8003, '0244 Alamosa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8005, '0245 Arapahoe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8007, '0246 Archuleta');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8009, '0247 Baca');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8011, '0248 Bent');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8013, '0249 Boulder');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8015, '0250 Chaffee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8017, '0251 Cheyenne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8019, '0252 Clear Creek');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8021, '0253 Conejos');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8023, '0254 Costilla');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8025, '0255 Crowley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8027, '0256 Custer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8029, '0257 Delta');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8031, '0258 Denver');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8033, '0259 Dolores');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8035, '0260 Douglas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8037, '0261 Eagle');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8039, '0262 Elbert');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8041, '0263 El Paso');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8043, '0264 Fremont');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8045, '0265 Garfield');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8047, '0266 Gilpin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8049, '0267 Grand');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8051, '0268 Gunnison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8053, '0269 Hinsdale');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8055, '0270 Huerfano');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8057, '0271 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8059, '0272 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8061, '0273 Kiowa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8063, '0274 Kit Carson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8065, '0275 Lake');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8067, '0276 La Plata');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8069, '0277 Larimer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8071, '0278 Las Animas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8073, '0279 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8075, '0280 Logan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8077, '0281 Mesa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8079, '0282 Mineral');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8081, '0283 Moffat');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8083, '0284 Montezuma');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8085, '0285 Montrose');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8087, '0286 Morgan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8089, '0287 Otero');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8091, '0288 Ouray');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8093, '0289 Park');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8095, '0290 Phillips');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8097, '0291 Pitkin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8099, '0292 Prowers');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8101, '0293 Pueblo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8103, '0294 Rio Blanco');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8105, '0295 Rio Grande');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8107, '0296 Routt');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8109, '0297 Saguache');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8111, '0298 San Juan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8113, '0299 San Miguel');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8115, '0300 Sedgwick');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8117, '0301 Summit');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8119, '0302 Teller');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8121, '0303 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8123, '0304 Weld');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (8125, '0305 Yuma');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (9001, '0306 Fairfield');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (9003, '0307 Hartford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (9005, '0308 Litchfield');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (9007, '0309 Middlesex');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (9009, '0310 New Haven');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (9011, '0311 New London');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (9013, '0312 Tolland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (9015, '0313 Windham');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (10001, '0314 Kent');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (10003, '0315 New Castle');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (10005, '0316 Sussex');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12001, '0317 Alachua');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12003, '0318 Baker');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12005, '0319 Bay');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12007, '0320 Bradford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12009, '0321 Brevard');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12011, '0322 Broward');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12013, '0323 Calhoun');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12015, '0324 Charlotte');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12017, '0325 Citrus');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12019, '0326 Clay');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12021, '0327 Collier');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12023, '0328 Columbia');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12025, '0329 Dade');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12027, '0330 DeSoto');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12029, '0331 Dixie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12031, '0332 Duval');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12033, '0333 Escambia');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12035, '0334 Flagler');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12037, '0335 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12039, '0336 Gadsden');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12041, '0337 Gilchrist');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12043, '0338 Glades');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12045, '0339 Gulf');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12047, '0340 Hamilton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12049, '0341 Hardee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12051, '0342 Hendry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12053, '0343 Hernando');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12055, '0344 Highlands');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12057, '0345 Hillsborough');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12059, '0346 Holmes');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12061, '0347 Indian River');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12063, '0348 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12065, '0349 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12067, '0350 Lafayette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12069, '0351 Lake');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12071, '0352 Lee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12073, '0353 Leon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12075, '0354 Levy');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12077, '0355 Liberty');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12079, '0356 Madison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12081, '0357 Manatee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12083, '0358 Marion');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12085, '0359 Martin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12087, '0360 Monroe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12089, '0361 Nassau');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12091, '0362 Okaloosa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12093, '0363 Okeechobee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12095, '0364 Orange');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12097, '0365 Osceola');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12099, '0366 Palm Beach');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12101, '0367 Pasco');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12103, '0368 Pinellas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12105, '0369 Polk');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12107, '0370 Putnam');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12109, '0371 St. Johns');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12111, '0372 St. Lucie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12113, '0373 Santa Rosa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12115, '0374 Sarasota');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12117, '0375 Seminole');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12119, '0376 Sumter');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12121, '0377 Suwannee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12123, '0378 Taylor');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12125, '0379 Union');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12127, '0380 Volusia');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12129, '0381 Wakulla');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12131, '0382 Walton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (12133, '0383 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13001, '0384 Appling');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13003, '0385 Atkinson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13005, '0386 Bacon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13007, '0387 Baker');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13009, '0388 Baldwin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13011, '0389 Banks');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13013, '0390 Barrow');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13015, '0391 Bartow');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13017, '0392 Ben Hill');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13019, '0393 Berrien');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13021, '0394 Bibb');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13023, '0395 Bleckley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13025, '0396 Brantley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13027, '0397 Brooks');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13029, '0398 Bryan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13031, '0399 Bulloch');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13033, '0400 Burke');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13035, '0401 Butts');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13037, '0402 Calhoun');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13039, '0403 Camden');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13043, '0404 Candler');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13045, '0405 Carroll');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13047, '0406 Catoosa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13049, '0407 Charlton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13051, '0408 Chatham');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13053, '0409 Chattahoochee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13055, '0410 Chattooga');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13057, '0411 Cherokee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13059, '0412 Clarke');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13061, '0413 Clay');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13063, '0414 Clayton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13065, '0415 Clinch');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13067, '0416 Cobb');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13069, '0417 Coffee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13071, '0418 Colquitt');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13073, '0419 Columbia');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13075, '0420 Cook');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13077, '0421 Coweta');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13079, '0422 Crawford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13081, '0423 Crisp');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13083, '0424 Dade');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13085, '0425 Dawson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13087, '0426 Decatur');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13089, '0427 DeKalb');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13091, '0428 Dodge');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13093, '0429 Dooly');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13095, '0430 Dougherty');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13097, '0431 Douglas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13099, '0432 Early');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13101, '0433 Echols');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13103, '0434 Effingham');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13105, '0435 Elbert');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13107, '0436 Emanuel');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13109, '0437 Evans');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13111, '0438 Fannin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13113, '0439 Fayette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13115, '0440 Floyd');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13117, '0441 Forsyth');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13119, '0442 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13121, '0443 Fulton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13123, '0444 Gilmer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13125, '0445 Glascock');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13127, '0446 Glynn');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13129, '0447 Gordon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13131, '0448 Grady');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13133, '0449 Greene');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13135, '0450 Gwinnett');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13137, '0451 Habersham');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13139, '0452 Hall');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13141, '0453 Hancock');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13143, '0454 Haralson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13145, '0455 Harris');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13147, '0456 Hart');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13149, '0457 Heard');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13151, '0458 Henry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13153, '0459 Houston');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13155, '0460 Irwin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13157, '0461 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13159, '0462 Jasper');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13161, '0463 Jeff Davis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13163, '0464 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13165, '0465 Jenkins');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13167, '0466 Johnson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13169, '0467 Jones');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13171, '0468 Lamar');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13173, '0469 Lanier');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13175, '0470 Laurens');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13177, '0471 Lee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13179, '0472 Liberty');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13181, '0473 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13183, '0474 Long');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13185, '0475 Lowndes');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13187, '0476 Lumpkin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13189, '0477 McDuffie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13191, '0478 McIntosh');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13193, '0479 Macon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13195, '0480 Madison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13197, '0481 Marion');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13199, '0482 Meriwether');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13201, '0483 Miller');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13205, '0484 Mitchell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13207, '0485 Monroe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13209, '0486 Montgomery');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13211, '0487 Morgan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13213, '0488 Murray');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13215, '0489 Muscogee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13217, '0490 Newton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13219, '0491 Oconee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13221, '0492 Oglethorpe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13223, '0493 Paulding');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13225, '0494 Peach');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13227, '0495 Pickens');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13229, '0496 Pierce');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13231, '0497 Pike');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13233, '0498 Polk');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13235, '0499 Pulaski');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13237, '0500 Putnam');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13239, '0501 Quitman');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13241, '0502 Rabun');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13243, '0503 Randolph');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13245, '0504 Richmond');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13247, '0505 Rockdale');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13249, '0506 Schley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13251, '0507 Screven');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13253, '0508 Seminole');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13255, '0509 Spalding');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13257, '0510 Stephens');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13259, '0511 Stewart');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13261, '0512 Sumter');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13263, '0513 Talbot');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13265, '0514 Taliaferro');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13267, '0515 Tattnall');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13269, '0516 Taylor');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13271, '0517 Telfair');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13273, '0518 Terrell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13275, '0519 Thomas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13277, '0520 Tift');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13279, '0521 Toombs');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13281, '0522 Towns');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13283, '0523 Treutlen');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13285, '0524 Troup');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13287, '0525 Turner');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13289, '0526 Twiggs');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13291, '0527 Union');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13293, '0528 Upson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13295, '0529 Walker');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13297, '0530 Walton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13299, '0531 Ware');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13301, '0532 Warren');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13303, '0533 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13305, '0534 Wayne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13307, '0535 Webster');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13309, '0536 Wheeler');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13311, '0537 White');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13313, '0538 Whitfield');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13315, '0539 Wilcox');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13317, '0540 Wilkes');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13319, '0541 Wilkinson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (13321, '0542 Worth');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16001, '0543 Ada');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16003, '0544 Adams');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16005, '0545 Bannock');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16007, '0546 Bear Lake');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16009, '0547 Benewah');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16011, '0548 Bingham');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16013, '0549 Blaine');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16015, '0550 Boise');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16017, '0551 Bonner');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16019, '0552 Bonneville');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16021, '0553 Boundary');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16023, '0554 Butte');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16025, '0555 Camas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16027, '0556 Canyon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16029, '0557 Caribou');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16031, '0558 Cassia');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16033, '0559 Clark');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16035, '0560 Clearwater');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16037, '0561 Custer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16039, '0562 Elmore');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16041, '0563 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16043, '0564 Fremont');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16045, '0565 Gem');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16047, '0566 Gooding');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16049, '0567 Idaho');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16051, '0568 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16053, '0569 Jerome');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16055, '0570 Kootenai');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16057, '0571 Latah');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16059, '0572 Lemhi');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16061, '0573 Lewis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16063, '0574 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16065, '0575 Madison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16067, '0576 Minidoka');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16069, '0577 Nez Perce');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16071, '0578 Oneida');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16073, '0579 Owyhee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16075, '0580 Payette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16077, '0581 Power');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16079, '0582 Shoshone');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16081, '0583 Teton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16083, '0584 Twin Falls');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16085, '0585 Valley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (16087, '0586 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17001, '0587 Adams');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17003, '0588 Alexander');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17005, '0589 Bond');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17007, '0590 Boone');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17009, '0591 Brown');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17011, '0592 Bureau');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17013, '0593 Calhoun');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17015, '0594 Carroll');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17017, '0595 Cass');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17019, '0596 Champaign');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17021, '0597 Christian');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17023, '0598 Clark');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17025, '0599 Clay');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17027, '0600 Clinton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17029, '0601 Coles');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17031, '0602 Cook');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17033, '0603 Crawford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17035, '0604 Cumberland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17037, '0605 DeKalb');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17039, '0606 De Witt');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17041, '0607 Douglas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17043, '0608 DuPage');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17045, '0609 Edgar');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17047, '0610 Edwards');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17049, '0611 Effingham');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17051, '0612 Fayette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17053, '0613 Ford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17055, '0614 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17057, '0615 Fulton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17059, '0616 Gallatin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17061, '0617 Greene');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17063, '0618 Grundy');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17065, '0619 Hamilton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17067, '0620 Hancock');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17069, '0621 Hardin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17071, '0622 Henderson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17073, '0623 Henry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17075, '0624 Iroquois');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17077, '0625 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17079, '0626 Jasper');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17081, '0627 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17083, '0628 Jersey');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17085, '0629 Jo Daviess');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17087, '0630 Johnson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17089, '0631 Kane');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17091, '0632 Kankakee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17093, '0633 Kendall');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17095, '0634 Knox');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17097, '0635 Lake');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17099, '0636 La Salle');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17101, '0637 Lawrence');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17103, '0638 Lee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17105, '0639 Livingston');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17107, '0640 Logan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17109, '0641 McDonough');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17111, '0642 McHenry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17113, '0643 McLean');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17115, '0644 Macon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17117, '0645 Macoupin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17119, '0646 Madison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17121, '0647 Marion');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17123, '0648 Marshall');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17125, '0649 Mason');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17127, '0650 Massac');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17129, '0651 Menard');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17131, '0652 Mercer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17133, '0653 Monroe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17135, '0654 Montgomery');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17137, '0655 Morgan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17139, '0656 Moultrie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17141, '0657 Ogle');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17143, '0658 Peoria');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17145, '0659 Perry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17147, '0660 Piatt');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17149, '0661 Pike');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17151, '0662 Pope');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17153, '0663 Pulaski');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17155, '0664 Putnam');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17157, '0665 Randolph');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17159, '0666 Richland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17161, '0667 Rock Island');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17163, '0668 St. Clair');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17165, '0669 Saline');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17167, '0670 Sangamon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17169, '0671 Schuyler');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17171, '0672 Scott');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17173, '0673 Shelby');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17175, '0674 Stark');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17177, '0675 Stephenson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17179, '0676 Tazewell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17181, '0677 Union');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17183, '0678 Vermilion');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17185, '0679 Wabash');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17187, '0680 Warren');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17189, '0681 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17191, '0682 Wayne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17193, '0683 White');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17195, '0684 Whiteside');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17197, '0685 Will');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17199, '0686 Williamson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17201, '0687 Winnebago');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (17203, '0688 Woodford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18001, '0689 Adams');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18003, '0690 Allen');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18005, '0691 Bartholomew');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18007, '0692 Benton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18009, '0693 Blackford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18011, '0694 Boone');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18013, '0695 Brown');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18015, '0696 Carroll');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18017, '0697 Cass');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18019, '0698 Clark');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18021, '0699 Clay');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18023, '0700 Clinton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18025, '0701 Crawford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18027, '0702 Daviess');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18029, '0703 Dearborn');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18031, '0704 Decatur');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18033, '0705 De Kalb');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18035, '0706 Delaware');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18037, '0707 Dubois');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18039, '0708 Elkhart');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18041, '0709 Fayette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18043, '0710 Floyd');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18045, '0711 Fountain');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18047, '0712 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18049, '0713 Fulton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18051, '0714 Gibson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18053, '0715 Grant');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18055, '0716 Greene');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18057, '0717 Hamilton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18059, '0718 Hancock');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18061, '0719 Harrison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18063, '0720 Hendricks');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18065, '0721 Henry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18067, '0722 Howard');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18069, '0723 Huntington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18071, '0724 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18073, '0725 Jasper');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18075, '0726 Jay');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18077, '0727 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18079, '0728 Jennings');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18081, '0729 Johnson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18083, '0730 Knox');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18085, '0731 Kosciusko');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18087, '0732 Lagrange');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18089, '0733 Lake');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18091, '0734 La Porte');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18093, '0735 Lawrence');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18095, '0736 Madison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18097, '0737 Marion');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18099, '0738 Marshall');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18101, '0739 Martin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18103, '0740 Miami');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18105, '0741 Monroe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18107, '0742 Montgomery');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18109, '0743 Morgan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18111, '0744 Newton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18113, '0745 Noble');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18115, '0746 Ohio');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18117, '0747 Orange');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18119, '0748 Owen');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18121, '0749 Parke');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18123, '0750 Perry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18125, '0751 Pike');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18127, '0752 Porter');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18129, '0753 Posey');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18131, '0754 Pulaski');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18133, '0755 Putnam');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18135, '0756 Randolph');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18137, '0757 Ripley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18139, '0758 Rush');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18141, '0759 St. Joseph');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18143, '0760 Scott');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18145, '0761 Shelby');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18147, '0762 Spencer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18149, '0763 Starke');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18151, '0764 Steuben');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18153, '0765 Sullivan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18155, '0766 Switzerland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18157, '0767 Tippecanoe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18159, '0768 Tipton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18161, '0769 Union');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18163, '0770 Vanderburgh');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18165, '0771 Vermillion');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18167, '0772 Vigo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18169, '0773 Wabash');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18171, '0774 Warren');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18173, '0775 Warrick');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18175, '0776 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18177, '0777 Wayne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18179, '0778 Wells');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18181, '0779 White');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (18183, '0780 Whitley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19001, '0781 Adair');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19003, '0782 Adams');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19005, '0783 Allamakee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19007, '0784 Appanoose');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19009, '0785 Audubon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19011, '0786 Benton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19013, '0787 Black Hawk');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19015, '0788 Boone');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19017, '0789 Bremer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19019, '0790 Buchanan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19021, '0791 Buena Vista');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19023, '0792 Butler');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19025, '0793 Calhoun');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19027, '0794 Carroll');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19029, '0795 Cass');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19031, '0796 Cedar');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19033, '0797 Cerro Gordo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19035, '0798 Cherokee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19037, '0799 Chickasaw');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19039, '0800 Clarke');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19041, '0801 Clay');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19043, '0802 Clayton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19045, '0803 Clinton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19047, '0804 Crawford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19049, '0805 Dallas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19051, '0806 Davis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19053, '0807 Decatur');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19055, '0808 Delaware');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19057, '0809 Des Moines');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19059, '0810 Dickinson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19061, '0811 Dubuque');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19063, '0812 Emmet');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19065, '0813 Fayette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19067, '0814 Floyd');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19069, '0815 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19071, '0816 Fremont');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19073, '0817 Greene');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19075, '0818 Grundy');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19077, '0819 Guthrie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19079, '0820 Hamilton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19081, '0821 Hancock');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19083, '0822 Hardin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19085, '0823 Harrison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19087, '0824 Henry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19089, '0825 Howard');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19091, '0826 Humboldt');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19093, '0827 Ida');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19095, '0828 Iowa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19097, '0829 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19099, '0830 Jasper');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19101, '0831 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19103, '0832 Johnson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19105, '0833 Jones');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19107, '0834 Keokuk');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19109, '0835 Kossuth');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19111, '0836 Lee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19113, '0837 Linn');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19115, '0838 Louisa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19117, '0839 Lucas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19119, '0840 Lyon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19121, '0841 Madison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19123, '0842 Mahaska');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19125, '0843 Marion');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19127, '0844 Marshall');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19129, '0845 Mills');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19131, '0846 Mitchell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19133, '0847 Monona');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19135, '0848 Monroe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19137, '0849 Montgomery');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19139, '0850 Muscatine');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19141, '0851 O\'Brien');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19143, '0852 Osceola');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19145, '0853 Page');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19147, '0854 Palo Alto');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19149, '0855 Plymouth');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19151, '0856 Pocahontas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19153, '0857 Polk');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19155, '0858 Pottawattamie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19157, '0859 Poweshiek');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19159, '0860 Ringgold');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19161, '0861 Sac');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19163, '0862 Scott');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19165, '0863 Shelby');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19167, '0864 Sioux');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19169, '0865 Story');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19171, '0866 Tama');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19173, '0867 Taylor');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19175, '0868 Union');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19177, '0869 Van Buren');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19179, '0870 Wapello');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19181, '0871 Warren');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19183, '0872 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19185, '0873 Wayne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19187, '0874 Webster');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19189, '0875 Winnebago');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19191, '0876 Winneshiek');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19193, '0877 Woodbury');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19195, '0878 Worth');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (19197, '0879 Wright');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20001, '0880 Allen');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20003, '0881 Anderson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20005, '0882 Atchison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20007, '0883 Barber');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20009, '0884 Barton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20011, '0885 Bourbon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20013, '0886 Brown');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20015, '0887 Butler');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20017, '0888 Chase');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20019, '0889 Chautauqua');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20021, '0890 Cherokee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20023, '0891 Cheyenne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20025, '0892 Clark');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20027, '0893 Clay');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20029, '0894 Cloud');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20031, '0895 Coffey');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20033, '0896 Comanche');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20035, '0897 Cowley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20037, '0898 Crawford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20039, '0899 Decatur');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20041, '0900 Dickinson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20043, '0901 Doniphan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20045, '0902 Douglas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20047, '0903 Edwards');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20049, '0904 Elk');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20051, '0905 Ellis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20053, '0906 Ellsworth');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20055, '0907 Finney');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20057, '0908 Ford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20059, '0909 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20061, '0910 Geary');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20063, '0911 Gove');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20065, '0912 Graham');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20067, '0913 Grant');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20069, '0914 Gray');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20071, '0915 Greeley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20073, '0916 Greenwood');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20075, '0917 Hamilton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20077, '0918 Harper');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20079, '0919 Harvey');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20081, '0920 Haskell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20083, '0921 Hodgeman');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20085, '0922 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20087, '0923 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20089, '0924 Jewell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20091, '0925 Johnson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20093, '0926 Kearny');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20095, '0927 Kingman');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20097, '0928 Kiowa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20099, '0929 Labette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20101, '0930 Lane');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20103, '0931 Leavenworth');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20105, '0932 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20107, '0933 Linn');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20109, '0934 Logan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20111, '0935 Lyon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20113, '0936 McPherson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20115, '0937 Marion');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20117, '0938 Marshall');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20119, '0939 Meade');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20121, '0940 Miami');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20123, '0941 Mitchell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20125, '0942 Montgomery');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20127, '0943 Morris');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20129, '0944 Morton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20131, '0945 Nemaha');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20133, '0946 Neosho');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20135, '0947 Ness');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20137, '0948 Norton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20139, '0949 Osage');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20141, '0950 Osborne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20143, '0951 Ottawa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20145, '0952 Pawnee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20147, '0953 Phillips');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20149, '0954 Pottawatomie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20151, '0955 Pratt');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20153, '0956 Rawlins');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20155, '0957 Reno');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20157, '0958 Republic');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20159, '0959 Rice');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20161, '0960 Riley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20163, '0961 Rooks');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20165, '0962 Rush');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20167, '0963 Russell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20169, '0964 Saline');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20171, '0965 Scott');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20173, '0966 Sedgwick');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20175, '0967 Seward');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20177, '0968 Shawnee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20179, '0969 Sheridan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20181, '0970 Sherman');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20183, '0971 Smith');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20185, '0972 Stafford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20187, '0973 Stanton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20189, '0974 Stevens');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20191, '0975 Sumner');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20193, '0976 Thomas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20195, '0977 Trego');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20197, '0978 Wabaunsee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20199, '0979 Wallace');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20201, '0980 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20203, '0981 Wichita');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20205, '0982 Wilson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20207, '0983 Woodson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (20209, '0984 Wyandotte');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21001, '0985 Adair');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21003, '0986 Allen');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21005, '0987 Anderson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21007, '0988 Ballard');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21009, '0989 Barren');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21011, '0990 Bath');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21013, '0991 Bell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21015, '0992 Boone');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21017, '0993 Bourbon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21019, '0994 Boyd');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21021, '0995 Boyle');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21023, '0996 Bracken');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21025, '0997 Breathitt');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21027, '0998 Breckinridge');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21029, '0999 Bullitt');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21031, '1000 Butler');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21033, '1001 Caldwell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21035, '1002 Calloway');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21037, '1003 Campbell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21039, '1004 Carlisle');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21041, '1005 Carroll');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21043, '1006 Carter');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21045, '1007 Casey');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21047, '1008 Christian');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21049, '1009 Clark');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21051, '1010 Clay');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21053, '1011 Clinton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21055, '1012 Crittenden');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21057, '1013 Cumberland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21059, '1014 Daviess');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21061, '1015 Edmonson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21063, '1016 Elliott');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21065, '1017 Estill');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21067, '1018 Fayette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21069, '1019 Fleming');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21071, '1020 Floyd');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21073, '1021 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21075, '1022 Fulton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21077, '1023 Gallatin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21079, '1024 Garrard');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21081, '1025 Grant');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21083, '1026 Graves');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21085, '1027 Grayson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21087, '1028 Green');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21089, '1029 Greenup');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21091, '1030 Hancock');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21093, '1031 Hardin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21095, '1032 Harlan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21097, '1033 Harrison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21099, '1034 Hart');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21101, '1035 Henderson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21103, '1036 Henry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21105, '1037 Hickman');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21107, '1038 Hopkins');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21109, '1039 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21111, '1040 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21113, '1041 Jessamine');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21115, '1042 Johnson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21117, '1043 Kenton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21119, '1044 Knott');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21121, '1045 Knox');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21123, '1046 Larue');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21125, '1047 Laurel');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21127, '1048 Lawrence');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21129, '1049 Lee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21131, '1050 Leslie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21133, '1051 Letcher');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21135, '1052 Lewis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21137, '1053 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21139, '1054 Livingston');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21141, '1055 Logan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21143, '1056 Lyon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21145, '1057 McCracken');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21147, '1058 McCreary');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21149, '1059 McLean');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21151, '1060 Madison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21153, '1061 Magoffin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21155, '1062 Marion');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21157, '1063 Marshall');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21159, '1064 Martin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21161, '1065 Mason');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21163, '1066 Meade');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21165, '1067 Menifee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21167, '1068 Mercer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21169, '1069 Metcalfe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21171, '1070 Monroe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21173, '1071 Montgomery');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21175, '1072 Morgan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21177, '1073 Muhlenberg');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21179, '1074 Nelson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21181, '1075 Nicholas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21183, '1076 Ohio');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21185, '1077 Oldham');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21187, '1078 Owen');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21189, '1079 Owsley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21191, '1080 Pendleton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21193, '1081 Perry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21195, '1082 Pike');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21197, '1083 Powell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21199, '1084 Pulaski');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21201, '1085 Robertson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21203, '1086 Rockcastle');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21205, '1087 Rowan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21207, '1088 Russell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21209, '1089 Scott');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21211, '1090 Shelby');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21213, '1091 Simpson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21215, '1092 Spencer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21217, '1093 Taylor');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21219, '1094 Todd');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21221, '1095 Trigg');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21223, '1096 Trimble');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21225, '1097 Union');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21227, '1098 Warren');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21229, '1099 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21231, '1100 Wayne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21233, '1101 Webster');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21235, '1102 Whitley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21237, '1103 Wolfe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (21239, '1104 Woodford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22001, '1105 Acadia');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22003, '1106 Allen');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22005, '1107 Ascension');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22007, '1108 Assumption');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22009, '1109 Avoyelles');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22011, '1110 Beauregard');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22013, '1111 Bienville');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22015, '1112 Bossier');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22017, '1113 Caddo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22019, '1114 Calcasieu');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22021, '1115 Caldwell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22023, '1116 Cameron');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22025, '1117 Catahoula');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22027, '1118 Claiborne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22029, '1119 Concordia');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22031, '1120 De Soto');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22033, '1121 Ebaton Rouge');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22035, '1122 East Carroll');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22037, '1123 East Feliciana');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22039, '1124 Evangeline');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22041, '1125 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22043, '1126 Grant');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22045, '1127 Iberia');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22047, '1128 Iberville');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22049, '1129 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22051, '1130 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22053, '1131 Jefferson Davis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22055, '1132 Lafayette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22057, '1133 Lafourche');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22059, '1134 La Salle');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22061, '1135 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22063, '1136 Livingston');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22065, '1137 Madison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22067, '1138 Morehouse');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22069, '1139 Natchitoches');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22071, '1140 Orleans');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22073, '1141 Ouachita');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22075, '1142 Plaquemines');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22077, '1143 Pointe Coupee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22079, '1144 Rapides');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22081, '1145 Red River');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22083, '1146 Richland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22085, '1147 Sabine');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22087, '1148 St. Bernard');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22089, '1149 St. Charles');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22091, '1150 St. Helena');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22093, '1151 St. James');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22095, '1152 St. John the Baptist');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22097, '1153 St. Landry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22099, '1154 St. Martin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22101, '1155 St. Mary');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22103, '1156 St. Tammany');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22105, '1157 Tangipahoa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22107, '1158 Tensas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22109, '1159 Terrebonne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22111, '1160 Union');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22113, '1161 Vermilion');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22115, '1162 Vernon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22117, '1163 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22119, '1164 Webster');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22121, '1165 Wbaton Rouge');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22123, '1166 West Carroll');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22125, '1167 West Feliciana');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (22127, '1168 Winn');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (23001, '1169 Androscoggin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (23003, '1170 Aroostook');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (23005, '1171 Cumberland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (23007, '1172 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (23009, '1173 Hancock');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (23011, '1174 Kennebec');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (23013, '1175 Knox');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (23015, '1176 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (23017, '1177 Oxford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (23019, '1178 Penobscot');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (23021, '1179 Piscataquis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (23023, '1180 Sagadahoc');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (23025, '1181 Somerset');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (23027, '1182 Waldo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (23029, '1183 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (23031, '1184 York');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24001, '1185 Allegany');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24003, '1186 Anne Arundel');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24005, '1187 Baltimore');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24009, '1188 Calvert');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24011, '1189 Caroline');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24013, '1190 Carroll');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24015, '1191 Cecil');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24017, '1192 Charles');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24019, '1193 Dorchester');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24021, '1194 Frederick');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24023, '1195 Garrett');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24025, '1196 Harford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24027, '1197 Howard');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24029, '1198 Kent');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24031, '1199 Montgomery');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24033, '1200 Prince George\'s');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24035, '1201 Queen Anne\'s');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24037, '1202 St. Marys');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24039, '1203 Somerset');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24041, '1204 Talbot');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24043, '1205 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24045, '1206 Wicomico');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24047, '1207 Worcester');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (24510, '1208 Baltimore city');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (25001, '1209 Barnstable');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (25003, '1210 Berkshire');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (25005, '1211 Bristol');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (25007, '1212 Dukes');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (25009, '1213 Essex');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (25011, '1214 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (25013, '1215 Hampden');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (25015, '1216 Hampshire');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (25017, '1217 Middlesex');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (25019, '1218 Nantucket');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (25021, '1219 Norfolk');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (25023, '1220 Plymouth');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (25025, '1221 Suffolk');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (25027, '1222 Worcester');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26001, '1223 Alcona');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26003, '1224 Alger');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26005, '1225 Allegan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26007, '1226 Alpena');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26009, '1227 Antrim');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26011, '1228 Arenac');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26013, '1229 Baraga');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26015, '1230 Barry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26017, '1231 Bay');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26019, '1232 Benzie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26021, '1233 Berrien');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26023, '1234 Branch');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26025, '1235 Calhoun');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26027, '1236 Cass');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26029, '1237 Charlevoix');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26031, '1238 Cheboygan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26033, '1239 Chippewa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26035, '1240 Clare');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26037, '1241 Clinton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26039, '1242 Crawford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26041, '1243 Delta');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26043, '1244 Dickinson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26045, '1245 Eaton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26047, '1246 Emmet');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26049, '1247 Genesee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26051, '1248 Gladwin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26053, '1249 Gogebic');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26055, '1250 Grand Traverse');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26057, '1251 Gratiot');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26059, '1252 Hillsdale');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26061, '1253 Houghton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26063, '1254 Huron');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26065, '1255 Ingham');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26067, '1256 Ionia');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26069, '1257 Iosco');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26071, '1258 Iron');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26073, '1259 Isabella');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26075, '1260 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26077, '1261 Kalamazoo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26079, '1262 Kalkaska');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26081, '1263 Kent');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26083, '1264 Keweenaw');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26085, '1265 Lake');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26087, '1266 Lapeer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26089, '1267 Leelanau');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26091, '1268 Lenawee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26093, '1269 Livingston');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26095, '1270 Luce');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26097, '1271 Mackinac');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26099, '1272 Macomb');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26101, '1273 Manistee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26103, '1274 Marquette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26105, '1275 Mason');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26107, '1276 Mecosta');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26109, '1277 Menominee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26111, '1278 Midland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26113, '1279 Missaukee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26115, '1280 Monroe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26117, '1281 Montcalm');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26119, '1282 Montmorency');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26121, '1283 Muskegon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26123, '1284 Newaygo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26125, '1285 Oakland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26127, '1286 Oceana');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26129, '1287 Ogemaw');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26131, '1288 Ontonagon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26133, '1289 Osceola');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26135, '1290 Oscoda');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26137, '1291 Otsego');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26139, '1292 Ottawa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26141, '1293 Presque Isle');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26143, '1294 Roscommon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26145, '1295 Saginaw');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26147, '1296 St. Clair');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26149, '1297 St. Joseph');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26151, '1298 Sanilac');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26153, '1299 Schoolcraft');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26155, '1300 Shiawassee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26157, '1301 Tuscola');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26159, '1302 Van Buren');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26161, '1303 Washtenaw');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26163, '1304 Wayne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (26165, '1305 Wexford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27001, '1306 Aitkin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27003, '1307 Anoka');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27005, '1308 Becker');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27007, '1309 Beltrami');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27009, '1310 Benton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27011, '1311 Big Stone');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27013, '1312 Blue Earth');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27015, '1313 Brown');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27017, '1314 Carlton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27019, '1315 Carver');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27021, '1316 Cass');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27023, '1317 Chippewa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27025, '1318 Chisago');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27027, '1319 Clay');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27029, '1320 Clearwater');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27031, '1321 Cook');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27033, '1322 Cottonwood');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27035, '1323 Crow Wing');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27037, '1324 Dakota');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27039, '1325 Dodge');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27041, '1326 Douglas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27043, '1327 Faribault');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27045, '1328 Fillmore');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27047, '1329 Freeborn');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27049, '1330 Goodhue');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27051, '1331 Grant');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27053, '1332 Hennepin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27055, '1333 Houston');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27057, '1334 Hubbard');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27059, '1335 Isanti');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27061, '1336 Itasca');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27063, '1337 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27065, '1338 Kanabec');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27067, '1339 Kandiyohi');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27069, '1340 Kittson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27071, '1341 Koochiching');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27073, '1342 Lac qui Parle');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27075, '1343 Lake');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27077, '1344 Lake of the Woods');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27079, '1345 Le Sueur');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27081, '1346 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27083, '1347 Lyon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27085, '1348 McLeod');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27087, '1349 Mahnomen');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27089, '1350 Marshall');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27091, '1351 Martin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27093, '1352 Meeker');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27095, '1353 Mille Lacs');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27097, '1354 Morrison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27099, '1355 Mower');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27101, '1356 Murray');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27103, '1357 Nicollet');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27105, '1358 Nobles');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27107, '1359 Norman');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27109, '1360 Olmsted');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27111, '1361 Otter Tail');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27113, '1362 Pennington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27115, '1363 Pine');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27117, '1364 Pipestone');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27119, '1365 Polk');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27121, '1366 Pope');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27123, '1367 Ramsey');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27125, '1368 Red Lake');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27127, '1369 Redwood');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27129, '1370 Renville');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27131, '1371 Rice');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27133, '1372 Rock');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27135, '1373 Roseau');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27137, '1374 St. Louis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27139, '1375 Scott');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27141, '1376 Sherburne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27143, '1377 Sibley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27145, '1378 Stearns');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27147, '1379 Steele');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27149, '1380 Stevens');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27151, '1381 Swift');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27153, '1382 Todd');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27155, '1383 Traverse');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27157, '1384 Wabasha');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27159, '1385 Wadena');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27161, '1386 Waseca');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27163, '1387 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27165, '1388 Watonwan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27167, '1389 Wilkin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27169, '1390 Winona');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27171, '1391 Wright');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (27173, '1392 Yellow Medicine');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28001, '1393 Adams');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28003, '1394 Alcorn');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28005, '1395 Amite');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28007, '1396 Attala');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28009, '1397 Benton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28011, '1398 Bolivar');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28013, '1399 Calhoun');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28015, '1400 Carroll');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28017, '1401 Chickasaw');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28019, '1402 Choctaw');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28021, '1403 Claiborne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28023, '1404 Clarke');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28025, '1405 Clay');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28027, '1406 Coahoma');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28029, '1407 Copiah');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28031, '1408 Covington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28033, '1409 DeSoto');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28035, '1410 Forrest');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28037, '1411 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28039, '1412 George');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28041, '1413 Greene');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28043, '1414 Grenada');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28045, '1415 Hancock');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28047, '1416 Harrison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28049, '1417 Hinds');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28051, '1418 Holmes');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28053, '1419 Humphreys');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28055, '1420 Issaquena');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28057, '1421 Itawamba');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28059, '1422 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28061, '1423 Jasper');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28063, '1424 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28065, '1425 Jefferson Davis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28067, '1426 Jones');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28069, '1427 Kemper');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28071, '1428 Lafayette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28073, '1429 Lamar');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28075, '1430 Lauderdale');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28077, '1431 Lawrence');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28079, '1432 Leake');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28081, '1433 Lee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28083, '1434 Leflore');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28085, '1435 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28087, '1436 Lowndes');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28089, '1437 Madison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28091, '1438 Marion');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28093, '1439 Marshall');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28095, '1440 Monroe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28097, '1441 Montgomery');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28099, '1442 Neshoba');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28101, '1443 Newton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28103, '1444 Noxubee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28105, '1445 Oktibbeha');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28107, '1446 Panola');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28109, '1447 Pearl River');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28111, '1448 Perry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28113, '1449 Pike');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28115, '1450 Pontotoc');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28117, '1451 Prentiss');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28119, '1452 Quitman');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28121, '1453 Rankin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28123, '1454 Scott');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28125, '1455 Sharkey');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28127, '1456 Simpson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28129, '1457 Smith');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28131, '1458 Stone');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28133, '1459 Sunflower');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28135, '1460 Tallahatchie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28137, '1461 Tate');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28139, '1462 Tippah');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28141, '1463 Tishomingo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28143, '1464 Tunica');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28145, '1465 Union');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28147, '1466 Walthall');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28149, '1467 Warren');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28151, '1468 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28153, '1469 Wayne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28155, '1470 Webster');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28157, '1471 Wilkinson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28159, '1472 Winston');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28161, '1473 Yalobusha');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (28163, '1474 Yazoo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29001, '1475 Adair');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29003, '1476 Andrew');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29005, '1477 Atchison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29007, '1478 Audrain');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29009, '1479 Barry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29011, '1480 Barton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29013, '1481 Bates');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29015, '1482 Benton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29017, '1483 Bollinger');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29019, '1484 Boone');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29021, '1485 Buchanan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29023, '1486 Butler');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29025, '1487 Caldwell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29027, '1488 Callaway');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29029, '1489 Camden');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29031, '1490 Cape Girardeau');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29033, '1491 Carroll');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29035, '1492 Carter');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29037, '1493 Cass');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29039, '1494 Cedar');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29041, '1495 Chariton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29043, '1496 Christian');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29045, '1497 Clark');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29047, '1498 Clay');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29049, '1499 Clinton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29051, '1500 Cole');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29053, '1501 Cooper');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29055, '1502 Crawford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29057, '1503 Dade');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29059, '1504 Dallas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29061, '1505 Daviess');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29063, '1506 DeKalb');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29065, '1507 Dent');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29067, '1508 Douglas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29069, '1509 Dunklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29071, '1510 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29073, '1511 Gasconade');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29075, '1512 Gentry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29077, '1513 Greene');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29079, '1514 Grundy');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29081, '1515 Harrison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29083, '1516 Henry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29085, '1517 Hickory');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29087, '1518 Holt');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29089, '1519 Howard');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29091, '1520 Howell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29093, '1521 Iron');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29095, '1522 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29097, '1523 Jasper');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29099, '1524 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29101, '1525 Johnson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29103, '1526 Knox');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29105, '1527 Laclede');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29107, '1528 Lafayette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29109, '1529 Lawrence');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29111, '1530 Lewis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29113, '1531 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29115, '1532 Linn');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29117, '1533 Livingston');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29119, '1534 McDonald');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29121, '1535 Macon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29123, '1536 Madison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29125, '1537 Maries');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29127, '1538 Marion');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29129, '1539 Mercer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29131, '1540 Miller');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29133, '1541 Mississippi');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29135, '1542 Moniteau');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29137, '1543 Monroe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29139, '1544 Montgomery');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29141, '1545 Morgan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29143, '1546 New Madrid');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29145, '1547 Newton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29147, '1548 Nodaway');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29149, '1549 Oregon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29151, '1550 Osage');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29153, '1551 Ozark');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29155, '1552 Pemiscot');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29157, '1553 Perry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29159, '1554 Pettis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29161, '1555 Phelps');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29163, '1556 Pike');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29165, '1557 Platte');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29167, '1558 Polk');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29169, '1559 Pulaski');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29171, '1560 Putnam');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29173, '1561 Ralls');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29175, '1562 Randolph');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29177, '1563 Ray');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29179, '1564 Reynolds');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29181, '1565 Ripley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29183, '1566 St. Charles');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29185, '1567 St. Clair');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29186, '1568 Ste. Genevieve');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29187, '1569 St. Francois');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29189, '1570 St. Louis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29195, '1571 Saline');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29197, '1572 Schuyler');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29199, '1573 Scotland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29201, '1574 Scott');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29203, '1575 Shannon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29205, '1576 Shelby');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29207, '1577 Stoddard');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29209, '1578 Stone');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29211, '1579 Sullivan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29213, '1580 Taney');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29215, '1581 Texas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29217, '1582 Vernon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29219, '1583 Warren');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29221, '1584 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29223, '1585 Wayne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29225, '1586 Webster');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29227, '1587 Worth');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29229, '1588 Wright');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (29510, '1589 St. Louis city');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30001, '1590 Beaverhead');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30003, '1591 Big Horn');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30005, '1592 Blaine');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30007, '1593 Broadwater');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30009, '1594 Carbon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30011, '1595 Carter');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30013, '1596 Cascade');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30015, '1597 Chouteau');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30017, '1598 Custer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30019, '1599 Daniels');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30021, '1600 Dawson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30023, '1601 Deer Lodge');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30025, '1602 Fallon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30027, '1603 Fergus');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30029, '1604 Flathead');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30031, '1605 Gallatin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30033, '1606 Garfield');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30035, '1607 Glacier');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30037, '1608 Golden Valley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30039, '1609 Granite');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30041, '1610 Hill');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30043, '1611 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30045, '1612 Judith Basin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30047, '1613 Lake');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30049, '1614 Lewis and Clark');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30051, '1615 Liberty');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30053, '1616 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30055, '1617 McCone');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30057, '1618 Madison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30059, '1619 Meagher');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30061, '1620 Mineral');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30063, '1621 Missoula');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30065, '1622 Musselshell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30067, '1623 Park');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30069, '1624 Petroleum');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30071, '1625 Phillips');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30073, '1626 Pondera');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30075, '1627 Powder River');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30077, '1628 Powell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30079, '1629 Prairie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30081, '1630 Ravalli');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30083, '1631 Richland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30085, '1632 Roosevelt');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30087, '1633 Rosebud');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30089, '1634 Sanders');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30091, '1635 Sheridan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30093, '1636 Silver Bow');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30095, '1637 Stillwater');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30097, '1638 Sweet Grass');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30099, '1639 Teton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30101, '1640 Toole');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30103, '1641 Treasure');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30105, '1642 Valley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30107, '1643 Wheatland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30109, '1644 Wibaux');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30111, '1645 Yellowstone');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (30113, '1646 Yellowstone National Park');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31001, '1647 Adams');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31003, '1648 Antelope');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31005, '1649 Arthur');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31007, '1650 Banner');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31009, '1651 Blaine');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31011, '1652 Boone');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31013, '1653 Box Butte');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31015, '1654 Boyd');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31017, '1655 Brown');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31019, '1656 Buffalo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31021, '1657 Burt');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31023, '1658 Butler');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31025, '1659 Cass');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31027, '1660 Cedar');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31029, '1661 Chase');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31031, '1662 Cherry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31033, '1663 Cheyenne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31035, '1664 Clay');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31037, '1665 Colfax');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31039, '1666 Cuming');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31041, '1667 Custer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31043, '1668 Dakota');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31045, '1669 Dawes');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31047, '1670 Dawson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31049, '1671 Deuel');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31051, '1672 Dixon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31053, '1673 Dodge');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31055, '1674 Douglas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31057, '1675 Dundy');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31059, '1676 Fillmore');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31061, '1677 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31063, '1678 Frontier');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31065, '1679 Furnas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31067, '1680 Gage');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31069, '1681 Garden');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31071, '1682 Garfield');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31073, '1683 Gosper');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31075, '1684 Grant');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31077, '1685 Greeley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31079, '1686 Hall');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31081, '1687 Hamilton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31083, '1688 Harlan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31085, '1689 Hayes');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31087, '1690 Hitchcock');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31089, '1691 Holt');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31091, '1692 Hooker');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31093, '1693 Howard');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31095, '1694 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31097, '1695 Johnson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31099, '1696 Kearney');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31101, '1697 Keith');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31103, '1698 Keya Paha');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31105, '1699 Kimball');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31107, '1700 Knox');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31109, '1701 Lancaster');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31111, '1702 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31113, '1703 Logan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31115, '1704 Loup');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31117, '1705 McPherson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31119, '1706 Madison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31121, '1707 Merrick');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31123, '1708 Morrill');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31125, '1709 Nance');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31127, '1710 Nemaha');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31129, '1711 Nuckolls');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31131, '1712 Otoe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31133, '1713 Pawnee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31135, '1714 Perkins');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31137, '1715 Phelps');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31139, '1716 Pierce');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31141, '1717 Platte');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31143, '1718 Polk');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31145, '1719 Red Willow');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31147, '1720 Richardson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31149, '1721 Rock');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31151, '1722 Saline');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31153, '1723 Sarpy');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31155, '1724 Saunders');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31157, '1725 Scotts Bluff');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31159, '1726 Seward');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31161, '1727 Sheridan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31163, '1728 Sherman');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31165, '1729 Sioux');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31167, '1730 Stanton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31169, '1731 Thayer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31171, '1732 Thomas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31173, '1733 Thurston');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31175, '1734 Valley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31177, '1735 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31179, '1736 Wayne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31181, '1737 Webster');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31183, '1738 Wheeler');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (31185, '1739 York');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (32001, '1740 Churchill');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (32003, '1741 Clark');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (32005, '1742 Douglas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (32007, '1743 Elko');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (32009, '1744 Esmeralda');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (32011, '1745 Eureka');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (32013, '1746 Humboldt');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (32015, '1747 Lander');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (32017, '1748 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (32019, '1749 Lyon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (32021, '1750 Mineral');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (32023, '1751 Nye');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (32027, '1752 Pershing');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (32029, '1753 Storey');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (32031, '1754 Washoe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (32033, '1755 White Pine');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (32510, '1756 Carson City');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (33001, '1757 Belknap');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (33003, '1758 Carroll');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (33005, '1759 Cheshire');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (33007, '1760 Coos');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (33009, '1761 Grafton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (33011, '1762 Hillsborough');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (33013, '1763 Merrimack');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (33015, '1764 Rockingham');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (33017, '1765 Strafford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (33019, '1766 Sullivan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (34001, '1767 Atlantic');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (34003, '1768 Bergen');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (34005, '1769 Burlington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (34007, '1770 Camden');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (34009, '1771 Cape May');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (34011, '1772 Cumberland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (34013, '1773 Essex');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (34015, '1774 Gloucester');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (34017, '1775 Hudson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (34019, '1776 Hunterdon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (34021, '1777 Mercer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (34023, '1778 Middlesex');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (34025, '1779 Monmouth');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (34027, '1780 Morris');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (34029, '1781 Ocean');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (34031, '1782 Passaic');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (34033, '1783 Salem');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (34035, '1784 Somerset');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (34037, '1785 Sussex');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (34039, '1786 Union');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (34041, '1787 Warren');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35001, '1788 Bernalillo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35003, '1789 Catron');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35005, '1790 Chaves');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35006, '1791 Cibola');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35007, '1792 Colfax');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35009, '1793 Curry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35011, '1794 DeBaca');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35013, '1795 Dona Ana');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35015, '1796 Eddy');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35017, '1797 Grant');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35019, '1798 Guadalupe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35021, '1799 Harding');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35023, '1800 Hidalgo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35025, '1801 Lea');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35027, '1802 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35028, '1803 Los Alamos');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35029, '1804 Luna');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35031, '1805 McKinley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35033, '1806 Mora');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35035, '1807 Otero');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35037, '1808 Quay');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35039, '1809 Rio Arriba');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35041, '1810 Roosevelt');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35043, '1811 Sandoval');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35045, '1812 San Juan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35047, '1813 San Miguel');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35049, '1814 Santa Fe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35051, '1815 Sierra');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35053, '1816 Socorro');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35055, '1817 Taos');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35057, '1818 Torrance');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35059, '1819 Union');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (35061, '1820 Valencia');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36001, '1821 Albany');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36003, '1822 Allegany');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36005, '1823 Bronx');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36007, '1824 Broome');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36009, '1825 Cattaraugus');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36011, '1826 Cayuga');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36013, '1827 Chautauqua');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36015, '1828 Chemung');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36017, '1829 Chenango');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36019, '1830 Clinton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36021, '1831 Columbia');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36023, '1832 Cortland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36025, '1833 Delaware');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36027, '1834 Dutchess');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36029, '1835 Erie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36031, '1836 Essex');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36033, '1837 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36035, '1838 Fulton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36037, '1839 Genesee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36039, '1840 Greene');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36041, '1841 Hamilton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36043, '1842 Herkimer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36045, '1843 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36047, '1844 Kings');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36049, '1845 Lewis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36051, '1846 Livingston');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36053, '1847 Madison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36055, '1848 Monroe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36057, '1849 Montgomery');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36059, '1850 Nassau');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36061, '1851 New York');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36063, '1852 Niagara');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36065, '1853 Oneida');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36067, '1854 Onondaga');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36069, '1855 Ontario');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36071, '1856 Orange');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36073, '1857 Orleans');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36075, '1858 Oswego');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36077, '1859 Otsego');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36079, '1860 Putnam');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36081, '1861 Queens');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36083, '1862 Rensselaer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36085, '1863 Richmond');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36087, '1864 Rockland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36089, '1865 St. Lawrence');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36091, '1866 Saratoga');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36093, '1867 Schenectady');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36095, '1868 Schoharie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36097, '1869 Schuyler');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36099, '1870 Seneca');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36101, '1871 Steuben');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36103, '1872 Suffolk');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36105, '1873 Sullivan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36107, '1874 Tioga');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36109, '1875 Tompkins');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36111, '1876 Ulster');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36113, '1877 Warren');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36115, '1878 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36117, '1879 Wayne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36119, '1880 Westchester');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36121, '1881 Wyoming');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (36123, '1882 Yates');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37001, '1883 Alamance');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37003, '1884 Alexander');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37005, '1885 Alleghany');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37007, '1886 Anson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37009, '1887 Ashe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37011, '1888 Avery');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37013, '1889 Beaufort');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37015, '1890 Bertie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37017, '1891 Bladen');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37019, '1892 Brunswick');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37021, '1893 Buncombe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37023, '1894 Burke');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37025, '1895 Cabarrus');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37027, '1896 Caldwell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37029, '1897 Camden');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37031, '1898 Carteret');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37033, '1899 Caswell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37035, '1900 Catawba');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37037, '1901 Chatham');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37039, '1902 Cherokee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37041, '1903 Chowan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37043, '1904 Clay');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37045, '1905 Cleveland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37047, '1906 Columbus');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37049, '1907 Craven');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37051, '1908 Cumberland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37053, '1909 Currituck');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37055, '1910 Dare');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37057, '1911 Davidson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37059, '1912 Davie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37061, '1913 Duplin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37063, '1914 Durham');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37065, '1915 Edgecombe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37067, '1916 Forsyth');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37069, '1917 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37071, '1918 Gaston');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37073, '1919 Gates');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37075, '1920 Graham');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37077, '1921 Granville');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37079, '1922 Greene');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37081, '1923 Guilford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37083, '1924 Halifax');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37085, '1925 Harnett');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37087, '1926 Haywood');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37089, '1927 Henderson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37091, '1928 Hertford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37093, '1929 Hoke');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37095, '1930 Hyde');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37097, '1931 Iredell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37099, '1932 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37101, '1933 Johnston');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37103, '1934 Jones');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37105, '1935 Lee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37107, '1936 Lenoir');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37109, '1937 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37111, '1938 McDowell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37113, '1939 Macon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37115, '1940 Madison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37117, '1941 Martin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37119, '1942 Mecklenburg');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37121, '1943 Mitchell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37123, '1944 Montgomery');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37125, '1945 Moore');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37127, '1946 Nash');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37129, '1947 New Hanover');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37131, '1948 Northampton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37133, '1949 Onslow');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37135, '1950 Orange');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37137, '1951 Pamlico');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37139, '1952 Pasquotank');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37141, '1953 Pender');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37143, '1954 Perquimans');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37145, '1955 Person');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37147, '1956 Pitt');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37149, '1957 Polk');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37151, '1958 Randolph');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37153, '1959 Richmond');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37155, '1960 Robeson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37157, '1961 Rockingham');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37159, '1962 Rowan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37161, '1963 Rutherford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37163, '1964 Sampson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37165, '1965 Scotland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37167, '1966 Stanly');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37169, '1967 Stokes');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37171, '1968 Surry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37173, '1969 Swain');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37175, '1970 Transylvania');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37177, '1971 Tyrrell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37179, '1972 Union');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37181, '1973 Vance');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37183, '1974 Wake');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37185, '1975 Warren');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37187, '1976 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37189, '1977 Watauga');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37191, '1978 Wayne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37193, '1979 Wilkes');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37195, '1980 Wilson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37197, '1981 Yadkin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (37199, '1982 Yancey');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38001, '1983 Adams');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38003, '1984 Barnes');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38005, '1985 Benson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38007, '1986 Billings');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38009, '1987 Bottineau');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38011, '1988 Bowman');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38013, '1989 Burke');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38015, '1990 Burleigh');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38017, '1991 Cass');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38019, '1992 Cavalier');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38021, '1993 Dickey');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38023, '1994 Divide');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38025, '1995 Dunn');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38027, '1996 Eddy');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38029, '1997 Emmons');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38031, '1998 Foster');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38033, '1999 Golden Valley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38035, '2000 Grand Forks');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38037, '2001 Grant');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38039, '2002 Griggs');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38041, '2003 Hettinger');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38043, '2004 Kidder');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38045, '2005 LaMoure');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38047, '2006 Logan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38049, '2007 McHenry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38051, '2008 McIntosh');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38053, '2009 McKenzie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38055, '2010 McLean');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38057, '2011 Mercer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38059, '2012 Morton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38061, '2013 Mountrail');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38063, '2014 Nelson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38065, '2015 Oliver');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38067, '2016 Pembina');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38069, '2017 Pierce');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38071, '2018 Ramsey');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38073, '2019 Ransom');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38075, '2020 Renville');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38077, '2021 Richland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38079, '2022 Rolette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38081, '2023 Sargent');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38083, '2024 Sheridan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38085, '2025 Sioux');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38087, '2026 Slope');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38089, '2027 Stark');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38091, '2028 Steele');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38093, '2029 Stutsman');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38095, '2030 Towner');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38097, '2031 Traill');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38099, '2032 Walsh');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38101, '2033 Ward');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38103, '2034 Wells');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (38105, '2035 Williams');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39001, '2036 Adams');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39003, '2037 Allen');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39005, '2038 Ashland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39007, '2039 Ashtabula');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39009, '2040 Athens');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39011, '2041 Auglaize');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39013, '2042 Belmont');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39015, '2043 Brown');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39017, '2044 Butler');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39019, '2045 Carroll');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39021, '2046 Champaign');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39023, '2047 Clark');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39025, '2048 Clermont');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39027, '2049 Clinton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39029, '2050 Columbiana');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39031, '2051 Coshocton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39033, '2052 Crawford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39035, '2053 Cuyahoga');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39037, '2054 Darke');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39039, '2055 Defiance');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39041, '2056 Delaware');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39043, '2057 Erie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39045, '2058 Fairfield');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39047, '2059 Fayette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39049, '2060 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39051, '2061 Fulton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39053, '2062 Gallia');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39055, '2063 Geauga');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39057, '2064 Greene');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39059, '2065 Guernsey');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39061, '2066 Hamilton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39063, '2067 Hancock');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39065, '2068 Hardin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39067, '2069 Harrison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39069, '2070 Henry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39071, '2071 Highland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39073, '2072 Hocking');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39075, '2073 Holmes');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39077, '2074 Huron');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39079, '2075 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39081, '2076 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39083, '2077 Knox');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39085, '2078 Lake');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39087, '2079 Lawrence');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39089, '2080 Licking');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39091, '2081 Logan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39093, '2082 Lorain');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39095, '2083 Lucas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39097, '2084 Madison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39099, '2085 Mahoning');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39101, '2086 Marion');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39103, '2087 Medina');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39105, '2088 Meigs');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39107, '2089 Mercer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39109, '2090 Miami');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39111, '2091 Monroe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39113, '2092 Montgomery');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39115, '2093 Morgan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39117, '2094 Morrow');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39119, '2095 Muskingum');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39121, '2096 Noble');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39123, '2097 Ottawa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39125, '2098 Paulding');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39127, '2099 Perry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39129, '2100 Pickaway');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39131, '2101 Pike');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39133, '2102 Portage');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39135, '2103 Preble');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39137, '2104 Putnam');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39139, '2105 Richland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39141, '2106 Ross');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39143, '2107 Sandusky');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39145, '2108 Scioto');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39147, '2109 Seneca');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39149, '2110 Shelby');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39151, '2111 Stark');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39153, '2112 Summit');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39155, '2113 Trumbull');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39157, '2114 Tuscarawas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39159, '2115 Union');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39161, '2116 Van Wert');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39163, '2117 Vinton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39165, '2118 Warren');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39167, '2119 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39169, '2120 Wayne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39171, '2121 Williams');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39173, '2122 Wood');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (39175, '2123 Wyandot');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40001, '2124 Adair');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40003, '2125 Alfalfa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40005, '2126 Atoka');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40007, '2127 Beaver');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40009, '2128 Beckham');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40011, '2129 Blaine');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40013, '2130 Bryan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40015, '2131 Caddo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40017, '2132 Canadian');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40019, '2133 Carter');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40021, '2134 Cherokee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40023, '2135 Choctaw');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40025, '2136 Cimarron');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40027, '2137 Cleveland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40029, '2138 Coal');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40031, '2139 Comanche');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40033, '2140 Cotton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40035, '2141 Craig');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40037, '2142 Creek');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40039, '2143 Custer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40041, '2144 Delaware');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40043, '2145 Dewey');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40045, '2146 Ellis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40047, '2147 Garfield');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40049, '2148 Garvin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40051, '2149 Grady');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40053, '2150 Grant');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40055, '2151 Greer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40057, '2152 Harmon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40059, '2153 Harper');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40061, '2154 Haskell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40063, '2155 Hughes');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40065, '2156 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40067, '2157 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40069, '2158 Johnston');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40071, '2159 Kay');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40073, '2160 Kingfisher');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40075, '2161 Kiowa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40077, '2162 Latimer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40079, '2163 Le Flore');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40081, '2164 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40083, '2165 Logan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40085, '2166 Love');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40087, '2167 McClain');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40089, '2168 McCurtain');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40091, '2169 McIntosh');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40093, '2170 Major');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40095, '2171 Marshall');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40097, '2172 Mayes');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40099, '2173 Murray');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40101, '2174 Muskogee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40103, '2175 Noble');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40105, '2176 Nowata');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40107, '2177 Okfuskee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40109, '2178 Oklahoma');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40111, '2179 Okmulgee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40113, '2180 Osage');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40115, '2181 Ottawa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40117, '2182 Pawnee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40119, '2183 Payne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40121, '2184 Pittsburg');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40123, '2185 Pontotoc');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40125, '2186 Pottawatomie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40127, '2187 Pushmataha');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40129, '2188 Roger Mills');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40131, '2189 Rogers');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40133, '2190 Seminole');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40135, '2191 Sequoyah');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40137, '2192 Stephens');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40139, '2193 Texas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40141, '2194 Tillman');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40143, '2195 Tulsa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40145, '2196 Wagoner');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40147, '2197 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40149, '2198 Washita');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40151, '2199 Woods');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (40153, '2200 Woodward');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41001, '2201 Baker');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41003, '2202 Benton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41005, '2203 Clackamas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41007, '2204 Clatsop');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41009, '2205 Columbia');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41011, '2206 Coos');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41013, '2207 Crook');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41015, '2208 Curry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41017, '2209 Deschutes');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41019, '2210 Douglas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41021, '2211 Gilliam');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41023, '2212 Grant');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41025, '2213 Harney');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41027, '2214 Hood River');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41029, '2215 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41031, '2216 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41033, '2217 Josephine');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41035, '2218 Klamath');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41037, '2219 Lake');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41039, '2220 Lane');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41041, '2221 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41043, '2222 Linn');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41045, '2223 Malheur');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41047, '2224 Marion');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41049, '2225 Morrow');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41051, '2226 Multnomah');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41053, '2227 Polk');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41055, '2228 Sherman');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41057, '2229 Tillamook');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41059, '2230 Umatilla');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41061, '2231 Union');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41063, '2232 Wallowa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41065, '2233 Wasco');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41067, '2234 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41069, '2235 Wheeler');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (41071, '2236 Yamhill');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42001, '2237 Adams');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42003, '2238 Allegheny');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42005, '2239 Armstrong');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42007, '2240 Beaver');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42009, '2241 Bedford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42011, '2242 Berks');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42013, '2243 Blair');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42015, '2244 Bradford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42017, '2245 Bucks');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42019, '2246 Butler');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42021, '2247 Cambria');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42023, '2248 Cameron');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42025, '2249 Carbon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42027, '2250 Centre');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42029, '2251 Chester');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42031, '2252 Clarion');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42033, '2253 Clearfield');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42035, '2254 Clinton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42037, '2255 Columbia');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42039, '2256 Crawford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42041, '2257 Cumberland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42043, '2258 Dauphin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42045, '2259 Delaware');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42047, '2260 Elk');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42049, '2261 Erie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42051, '2262 Fayette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42053, '2263 Forest');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42055, '2264 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42057, '2265 Fulton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42059, '2266 Greene');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42061, '2267 Huntingdon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42063, '2268 Indiana');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42065, '2269 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42067, '2270 Juniata');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42069, '2271 Lackawanna');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42071, '2272 Lancaster');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42073, '2273 Lawrence');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42075, '2274 Lebanon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42077, '2275 Lehigh');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42079, '2276 Luzerne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42081, '2277 Lycoming');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42083, '2278 McKean');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42085, '2279 Mercer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42087, '2280 Mifflin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42089, '2281 Monroe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42091, '2282 Montgomery');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42093, '2283 Montour');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42095, '2284 Northampton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42097, '2285 Northumberland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42099, '2286 Perry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42101, '2287 Philadelphia');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42103, '2288 Pike');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42105, '2289 Potter');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42107, '2290 Schuylkill');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42109, '2291 Snyder');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42111, '2292 Somerset');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42113, '2293 Sullivan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42115, '2294 Susquehanna');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42117, '2295 Tioga');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42119, '2296 Union');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42121, '2297 Venango');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42123, '2298 Warren');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42125, '2299 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42127, '2300 Wayne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42129, '2301 Westmoreland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42131, '2302 Wyoming');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (42133, '2303 York');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (44001, '2304 Bristol');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (44003, '2305 Kent');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (44005, '2306 Newport');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (44007, '2307 Providence');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (44009, '2308 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45001, '2309 Abbeville');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45003, '2310 Aiken');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45005, '2311 Allendale');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45007, '2312 Anderson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45009, '2313 Bamberg');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45011, '2314 Barnwell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45013, '2315 Beaufort');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45015, '2316 Berkeley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45017, '2317 Calhoun');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45019, '2318 Charleston');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45021, '2319 Cherokee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45023, '2320 Chester');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45025, '2321 Chesterfield');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45027, '2322 Clarendon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45029, '2323 Colleton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45031, '2324 Darlington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45033, '2325 Dillon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45035, '2326 Dorchester');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45037, '2327 Edgefield');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45039, '2328 Fairfield');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45041, '2329 Florence');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45043, '2330 Georgetown');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45045, '2331 Greenville');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45047, '2332 Greenwood');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45049, '2333 Hampton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45051, '2334 Horry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45053, '2335 Jasper');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45055, '2336 Kershaw');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45057, '2337 Lancaster');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45059, '2338 Laurens');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45061, '2339 Lee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45063, '2340 Lexington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45065, '2341 McCormick');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45067, '2342 Marion');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45069, '2343 Marlboro');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45071, '2344 Newberry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45073, '2345 Oconee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45075, '2346 Orangeburg');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45077, '2347 Pickens');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45079, '2348 Richland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45081, '2349 Saluda');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45083, '2350 Spartanburg');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45085, '2351 Sumter');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45087, '2352 Union');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45089, '2353 Williamsburg');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (45091, '2354 York');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46003, '2355 Aurora');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46005, '2356 Beadle');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46007, '2357 Bennett');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46009, '2358 Bon Homme');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46011, '2359 Brookings');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46013, '2360 Brown');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46015, '2361 Brule');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46017, '2362 Buffalo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46019, '2363 Butte');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46021, '2364 Campbell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46023, '2365 Charles Mix');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46025, '2366 Clark');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46027, '2367 Clay');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46029, '2368 Codington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46031, '2369 Corson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46033, '2370 Custer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46035, '2371 Davison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46037, '2372 Day');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46039, '2373 Deuel');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46041, '2374 Dewey');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46043, '2375 Douglas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46045, '2376 Edmunds');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46047, '2377 Fall River');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46049, '2378 Faulk');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46051, '2379 Grant');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46053, '2380 Gregory');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46055, '2381 Haakon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46057, '2382 Hamlin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46059, '2383 Hand');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46061, '2384 Hanson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46063, '2385 Harding');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46065, '2386 Hughes');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46067, '2387 Hutchinson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46069, '2388 Hyde');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46071, '2389 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46073, '2390 Jerauld');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46075, '2391 Jones');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46077, '2392 Kingsbury');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46079, '2393 Lake');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46081, '2394 Lawrence');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46083, '2395 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46085, '2396 Lyman');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46087, '2397 McCook');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46089, '2398 McPherson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46091, '2399 Marshall');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46093, '2400 Meade');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46095, '2401 Mellette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46097, '2402 Miner');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46099, '2403 Minnehaha');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46101, '2404 Moody');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46103, '2405 Pennington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46105, '2406 Perkins');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46107, '2407 Potter');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46109, '2408 Roberts');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46111, '2409 Sanborn');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46113, '2410 Shannon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46115, '2411 Spink');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46117, '2412 Stanley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46119, '2413 Sully');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46121, '2414 Todd');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46123, '2415 Tripp');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46125, '2416 Turner');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46127, '2417 Union');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46129, '2418 Walworth');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46135, '2419 Yankton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (46137, '2420 Ziebach');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47001, '2421 Anderson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47003, '2422 Bedford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47005, '2423 Benton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47007, '2424 Bledsoe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47009, '2425 Blount');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47011, '2426 Bradley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47013, '2427 Campbell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47015, '2428 Cannon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47017, '2429 Carroll');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47019, '2430 Carter');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47021, '2431 Cheatham');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47023, '2432 Chester');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47025, '2433 Claiborne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47027, '2434 Clay');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47029, '2435 Cocke');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47031, '2436 Coffee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47033, '2437 Crockett');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47035, '2438 Cumberland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47037, '2439 Davidson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47039, '2440 Decatur');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47041, '2441 DeKalb');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47043, '2442 Dickson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47045, '2443 Dyer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47047, '2444 Fayette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47049, '2445 Fentress');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47051, '2446 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47053, '2447 Gibson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47055, '2448 Giles');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47057, '2449 Grainger');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47059, '2450 Greene');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47061, '2451 Grundy');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47063, '2452 Hamblen');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47065, '2453 Hamilton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47067, '2454 Hancock');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47069, '2455 Hardeman');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47071, '2456 Hardin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47073, '2457 Hawkins');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47075, '2458 Haywood');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47077, '2459 Henderson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47079, '2460 Henry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47081, '2461 Hickman');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47083, '2462 Houston');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47085, '2463 Humphreys');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47087, '2464 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47089, '2465 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47091, '2466 Johnson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47093, '2467 Knox');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47095, '2468 Lake');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47097, '2469 Lauderdale');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47099, '2470 Lawrence');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47101, '2471 Lewis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47103, '2472 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47105, '2473 Loudon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47107, '2474 McMinn');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47109, '2475 McNairy');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47111, '2476 Macon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47113, '2477 Madison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47115, '2478 Marion');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47117, '2479 Marshall');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47119, '2480 Maury');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47121, '2481 Meigs');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47123, '2482 Monroe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47125, '2483 Montgomery');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47127, '2484 Moore');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47129, '2485 Morgan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47131, '2486 Obion');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47133, '2487 Overton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47135, '2488 Perry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47137, '2489 Pickett');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47139, '2490 Polk');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47141, '2491 Putnam');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47143, '2492 Rhea');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47145, '2493 Roane');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47147, '2494 Robertson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47149, '2495 Rutherford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47151, '2496 Scott');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47153, '2497 Sequatchie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47155, '2498 Sevier');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47157, '2499 Shelby');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47159, '2500 Smith');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47161, '2501 Stewart');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47163, '2502 Sullivan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47165, '2503 Sumner');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47167, '2504 Tipton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47169, '2505 Trousdale');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47171, '2506 Unicoi');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47173, '2507 Union');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47175, '2508 Van Buren');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47177, '2509 Warren');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47179, '2510 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47181, '2511 Wayne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47183, '2512 Weakley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47185, '2513 White');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47187, '2514 Williamson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (47189, '2515 Wilson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48001, '2516 Anderson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48003, '2517 Andrews');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48005, '2518 Angelina');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48007, '2519 Aransas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48009, '2520 Archer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48011, '2521 Armstrong');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48013, '2522 Atascosa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48015, '2523 Austin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48017, '2524 Bailey');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48019, '2525 Bandera');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48021, '2526 Bastrop');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48023, '2527 Baylor');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48025, '2528 Bee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48027, '2529 Bell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48029, '2530 Bexar');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48031, '2531 Blanco');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48033, '2532 Borden');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48035, '2533 Bosque');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48037, '2534 Bowie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48039, '2535 Brazoria');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48041, '2536 Brazos');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48043, '2537 Brewster');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48045, '2538 Briscoe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48047, '2539 Brooks');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48049, '2540 Brown');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48051, '2541 Burleson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48053, '2542 Burnet');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48055, '2543 Caldwell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48057, '2544 Calhoun');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48059, '2545 Callahan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48061, '2546 Cameron');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48063, '2547 Camp');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48065, '2548 Carson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48067, '2549 Cass');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48069, '2550 Castro');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48071, '2551 Chambers');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48073, '2552 Cherokee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48075, '2553 Childress');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48077, '2554 Clay');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48079, '2555 Cochran');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48081, '2556 Coke');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48083, '2557 Coleman');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48085, '2558 Collin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48087, '2559 Collingsworth');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48089, '2560 Colorado');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48091, '2561 Comal');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48093, '2562 Comanche');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48095, '2563 Concho');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48097, '2564 Cooke');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48099, '2565 Coryell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48101, '2566 Cottle');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48103, '2567 Crane');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48105, '2568 Crockett');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48107, '2569 Crosby');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48109, '2570 Culberson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48111, '2571 Dallam');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48113, '2572 Dallas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48115, '2573 Dawson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48117, '2574 Deaf Smith');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48119, '2575 Delta');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48121, '2576 Denton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48123, '2577 De Witt');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48125, '2578 Dickens');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48127, '2579 Dimmit');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48129, '2580 Donley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48131, '2581 Duval');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48133, '2582 Eastland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48135, '2583 Ector');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48137, '2584 Edwards');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48139, '2585 Ellis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48141, '2586 El Paso');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48143, '2587 Erath');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48145, '2588 Falls');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48147, '2589 Fannin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48149, '2590 Fayette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48151, '2591 Fisher');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48153, '2592 Floyd');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48155, '2593 Foard');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48157, '2594 Fort Bend');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48159, '2595 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48161, '2596 Freestone');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48163, '2597 Frio');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48165, '2598 Gaines');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48167, '2599 Galveston');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48169, '2600 Garza');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48171, '2601 Gillespie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48173, '2602 Glasscock');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48175, '2603 Goliad');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48177, '2604 Gonzales');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48179, '2605 Gray');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48181, '2606 Grayson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48183, '2607 Gregg');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48185, '2608 Grimes');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48187, '2609 Guadalupe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48189, '2610 Hale');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48191, '2611 Hall');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48193, '2612 Hamilton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48195, '2613 Hansford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48197, '2614 Hardeman');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48199, '2615 Hardin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48201, '2616 Harris');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48203, '2617 Harrison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48205, '2618 Hartley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48207, '2619 Haskell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48209, '2620 Hays');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48211, '2621 Hemphill');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48213, '2622 Henderson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48215, '2623 Hidalgo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48217, '2624 Hill');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48219, '2625 Hockley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48221, '2626 Hood');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48223, '2627 Hopkins');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48225, '2628 Houston');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48227, '2629 Howard');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48229, '2630 Hudspeth');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48231, '2631 Hunt');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48233, '2632 Hutchinson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48235, '2633 Irion');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48237, '2634 Jack');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48239, '2635 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48241, '2636 Jasper');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48243, '2637 Jeff Davis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48245, '2638 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48247, '2639 Jim Hogg');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48249, '2640 Jim Wells');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48251, '2641 Johnson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48253, '2642 Jones');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48255, '2643 Karnes');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48257, '2644 Kaufman');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48259, '2645 Kendall');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48261, '2646 Kenedy');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48263, '2647 Kent');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48265, '2648 Kerr');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48267, '2649 Kimble');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48269, '2650 King');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48271, '2651 Kinney');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48273, '2652 Kleberg');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48275, '2653 Knox');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48277, '2654 Lamar');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48279, '2655 Lamb');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48281, '2656 Lampasas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48283, '2657 La Salle');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48285, '2658 Lavaca');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48287, '2659 Lee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48289, '2660 Leon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48291, '2661 Liberty');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48293, '2662 Limestone');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48295, '2663 Lipscomb');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48297, '2664 Live Oak');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48299, '2665 Llano');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48301, '2666 Loving');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48303, '2667 Lubbock');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48305, '2668 Lynn');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48307, '2669 McCulloch');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48309, '2670 McLennan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48311, '2671 McMullen');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48313, '2672 Madison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48315, '2673 Marion');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48317, '2674 Martin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48319, '2675 Mason');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48321, '2676 Matagorda');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48323, '2677 Maverick');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48325, '2678 Medina');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48327, '2679 Menard');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48329, '2680 Midland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48331, '2681 Milam');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48333, '2682 Mills');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48335, '2683 Mitchell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48337, '2684 Montague');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48339, '2685 Montgomery');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48341, '2686 Moore');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48343, '2687 Morris');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48345, '2688 Motley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48347, '2689 Nacogdoches');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48349, '2690 Navarro');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48351, '2691 Newton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48353, '2692 Nolan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48355, '2693 Nueces');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48357, '2694 Ochiltree');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48359, '2695 Oldham');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48361, '2696 Orange');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48363, '2697 Palo Pinto');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48365, '2698 Panola');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48367, '2699 Parker');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48369, '2700 Parmer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48371, '2701 Pecos');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48373, '2702 Polk');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48375, '2703 Potter');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48377, '2704 Presidio');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48379, '2705 Rains');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48381, '2706 Randall');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48383, '2707 Reagan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48385, '2708 Real');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48387, '2709 Red River');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48389, '2710 Reeves');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48391, '2711 Refugio');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48393, '2712 Roberts');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48395, '2713 Robertson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48397, '2714 Rockwall');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48399, '2715 Runnels');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48401, '2716 Rusk');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48403, '2717 Sabine');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48405, '2718 San Augustine');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48407, '2719 San Jacinto');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48409, '2720 San Patricio');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48411, '2721 San Saba');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48413, '2722 Schleicher');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48415, '2723 Scurry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48417, '2724 Shackelford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48419, '2725 Shelby');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48421, '2726 Sherman');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48423, '2727 Smith');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48425, '2728 Somervell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48427, '2729 Starr');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48429, '2730 Stephens');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48431, '2731 Sterling');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48433, '2732 Stonewall');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48435, '2733 Sutton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48437, '2734 Swisher');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48439, '2735 Tarrant');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48441, '2736 Taylor');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48443, '2737 Terrell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48445, '2738 Terry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48447, '2739 Throckmorton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48449, '2740 Titus');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48451, '2741 Tom Green');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48453, '2742 Travis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48455, '2743 Trinity');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48457, '2744 Tyler');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48459, '2745 Upshur');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48461, '2746 Upton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48463, '2747 Uvalde');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48465, '2748 Val Verde');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48467, '2749 Van Zandt');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48469, '2750 Victoria');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48471, '2751 Walker');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48473, '2752 Waller');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48475, '2753 Ward');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48477, '2754 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48479, '2755 Webb');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48481, '2756 Wharton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48483, '2757 Wheeler');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48485, '2758 Wichita');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48487, '2759 Wilbarger');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48489, '2760 Willacy');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48491, '2761 Williamson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48493, '2762 Wilson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48495, '2763 Winkler');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48497, '2764 Wise');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48499, '2765 Wood');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48501, '2766 Yoakum');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48503, '2767 Young');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48505, '2768 Zapata');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (48507, '2769 Zavala');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49001, '2770 Beaver');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49003, '2771 Box Elder');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49005, '2772 Cache');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49007, '2773 Carbon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49009, '2774 Daggett');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49011, '2775 Davis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49013, '2776 Duchesne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49015, '2777 Emery');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49017, '2778 Garfield');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49019, '2779 Grand');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49021, '2780 Iron');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49023, '2781 Juab');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49025, '2782 Kane');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49027, '2783 Millard');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49029, '2784 Morgan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49031, '2785 Piute');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49033, '2786 Rich');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49035, '2787 Salt Lake');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49037, '2788 San Juan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49039, '2789 Sanpete');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49041, '2790 Sevier');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49043, '2791 Summit');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49045, '2792 Tooele');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49047, '2793 Uintah');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49049, '2794 Utah');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49051, '2795 Wasatch');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49053, '2796 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49055, '2797 Wayne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (49057, '2798 Weber');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (50001, '2799 Addison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (50003, '2800 Bennington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (50005, '2801 Caledonia');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (50007, '2802 Chittenden');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (50009, '2803 Essex');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (50011, '2804 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (50013, '2805 Grand Isle');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (50015, '2806 Lamoille');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (50017, '2807 Orange');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (50019, '2808 Orleans');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (50021, '2809 Rutland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (50023, '2810 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (50025, '2811 Windham');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (50027, '2812 Windsor');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51001, '2813 Accomack');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51003, '2814 Albemarle');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51005, '2815 Alleghany');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51007, '2816 Amelia');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51009, '2817 Amherst');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51011, '2818 Appomattox');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51013, '2819 Arlington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51015, '2820 Augusta');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51017, '2821 Bath');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51019, '2822 Bedford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51021, '2823 Bland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51023, '2824 Botetourt');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51025, '2825 Brunswick');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51027, '2826 Buchanan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51029, '2827 Buckingham');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51031, '2828 Campbell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51033, '2829 Caroline');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51035, '2830 Carroll');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51036, '2831 Charles City');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51037, '2832 Charlotte');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51041, '2833 Chesterfield');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51043, '2834 Clarke');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51045, '2835 Craig');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51047, '2836 Culpeper');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51049, '2837 Cumberland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51051, '2838 Dickenson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51053, '2839 Dinwiddie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51057, '2840 Essex');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51059, '2841 Fairfax');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51061, '2842 Fauquier');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51063, '2843 Floyd');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51065, '2844 Fluvanna');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51067, '2845 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51069, '2846 Frederick');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51071, '2847 Giles');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51073, '2848 Gloucester');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51075, '2849 Goochland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51077, '2850 Grayson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51079, '2851 Greene');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51081, '2852 Greensville');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51083, '2853 Halifax');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51085, '2854 Hanover');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51087, '2855 Henrico');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51089, '2856 Henry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51091, '2857 Highland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51093, '2858 Isle Of Wight');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51095, '2859 James City');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51097, '2860 King And Queen');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51099, '2861 King George');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51101, '2862 King William');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51103, '2863 Lancaster');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51105, '2864 Lee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51107, '2865 Loudoun');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51109, '2866 Louisa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51111, '2867 Lunenburg');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51113, '2868 Madison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51115, '2869 Mathews');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51117, '2870 Mecklenburg');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51119, '2871 Middlesex');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51121, '2872 Montgomery');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51125, '2873 Nelson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51127, '2874 New Kent');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51131, '2875 Northampton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51133, '2876 Northumberland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51135, '2877 Nottoway');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51137, '2878 Orange');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51139, '2879 Page');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51141, '2880 Patrick');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51143, '2881 Pittsylvania');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51145, '2882 Powhatan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51147, '2883 Prince Edward');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51149, '2884 Prince George');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51153, '2885 Prince William');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51155, '2886 Pulaski');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51157, '2887 Rappahannock');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51159, '2888 Richmond');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51161, '2889 Roanoke');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51163, '2890 Rockbridge');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51165, '2891 Rockingham');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51167, '2892 Russell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51169, '2893 Scott');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51171, '2894 Shenandoah');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51173, '2895 Smyth');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51175, '2896 Southampton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51177, '2897 Spotsylvania');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51179, '2898 Stafford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51181, '2899 Surry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51183, '2900 Sussex');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51185, '2901 Tazewell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51187, '2902 Warren');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51191, '2903 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51193, '2904 Westmoreland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51195, '2905 Wise');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51197, '2906 Wythe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51199, '2907 York');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51550, '2908 Chesapeake city');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51650, '2909 Hampton city');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51700, '2910 Newport News city');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51800, '2911 Suffolk city');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (51810, '2912 Virginia Beach city');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53001, '2913 Adams');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53003, '2914 Asotin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53005, '2915 Benton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53007, '2916 Chelan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53009, '2917 Clallam');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53011, '2918 Clark');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53013, '2919 Columbia');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53015, '2920 Cowlitz');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53017, '2921 Douglas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53019, '2922 Ferry');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53021, '2923 Franklin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53023, '2924 Garfield');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53025, '2925 Grant');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53027, '2926 Grays Harbor');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53029, '2927 Island');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53031, '2928 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53033, '2929 King');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53035, '2930 Kitsap');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53037, '2931 Kittitas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53039, '2932 Klickitat');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53041, '2933 Lewis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53043, '2934 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53045, '2935 Mason');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53047, '2936 Okanogan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53049, '2937 Pacific');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53051, '2938 Pend Oreille');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53053, '2939 Pierce');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53055, '2940 San Juan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53057, '2941 Skagit');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53059, '2942 Skamania');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53061, '2943 Snohomish');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53063, '2944 Spokane');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53065, '2945 Stevens');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53067, '2946 Thurston');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53069, '2947 Wahkiakum');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53071, '2948 Walla Walla');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53073, '2949 Whatcom');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53075, '2950 Whitman');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (53077, '2951 Yakima');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54001, '2952 Barbour');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54003, '2953 Berkeley');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54005, '2954 Boone');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54007, '2955 Braxton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54009, '2956 Brooke');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54011, '2957 Cabell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54013, '2958 Calhoun');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54015, '2959 Clay');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54017, '2960 Doddridge');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54019, '2961 Fayette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54021, '2962 Gilmer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54023, '2963 Grant');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54025, '2964 Greenbrier');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54027, '2965 Hampshire');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54029, '2966 Hancock');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54031, '2967 Hardy');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54033, '2968 Harrison');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54035, '2969 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54037, '2970 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54039, '2971 Kanawha');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54041, '2972 Lewis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54043, '2973 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54045, '2974 Logan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54047, '2975 Mc Dowell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54049, '2976 Marion');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54051, '2977 Marshall');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54053, '2978 Mason');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54055, '2979 Mercer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54057, '2980 Mineral');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54059, '2981 Mingo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54061, '2982 Monongalia');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54063, '2983 Monroe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54065, '2984 Morgan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54067, '2985 Nicholas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54069, '2986 Ohio');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54071, '2987 Pendleton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54073, '2988 Pleasant');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54075, '2989 Pocahontas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54077, '2990 Preston');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54079, '2991 Putnam');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54081, '2992 Raleigh');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54083, '2993 Randolph');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54085, '2994 Ritchie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54087, '2995 Roane');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54089, '2996 Summers');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54091, '2997 Taylor');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54093, '2998 Tucker');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54095, '2999 Tyler');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54097, '3000 Upshur');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54099, '3001 Wayne');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54101, '3002 Webster');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54103, '3003 Wetzel');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54105, '3004 Wirt');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54107, '3005 Wood');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (54109, '3006 Wyoming');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55001, '3007 Adams');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55003, '3008 Ashland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55005, '3009 Barron');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55007, '3010 Bayfield');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55009, '3011 Brown');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55011, '3012 Buffalo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55013, '3013 Burnett');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55015, '3014 Calumet');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55017, '3015 Chippewa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55019, '3016 Clark');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55021, '3017 Columbia');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55023, '3018 Crawford');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55025, '3019 Dane');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55027, '3020 Dodge');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55029, '3021 Door');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55031, '3022 Douglas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55033, '3023 Dunn');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55035, '3024 Eau Claire');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55037, '3025 Florence');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55039, '3026 Fond du Lac');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55041, '3027 Forest');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55043, '3028 Grant');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55045, '3029 Green');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55047, '3030 Green Lake');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55049, '3031 Iowa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55051, '3032 Iron');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55053, '3033 Jackson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55055, '3034 Jefferson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55057, '3035 Juneau');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55059, '3036 Kenosha');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55061, '3037 Kewaunee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55063, '3038 La Crosse');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55065, '3039 Lafayette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55067, '3040 Langlade');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55069, '3041 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55071, '3042 Manitowoc');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55073, '3043 Marathon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55075, '3044 Marinette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55077, '3045 Marquette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55078, '3046 Menominee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55079, '3047 Milwaukee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55081, '3048 Monroe');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55083, '3049 Oconto');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55085, '3050 Oneida');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55087, '3051 Outagamie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55089, '3052 Ozaukee');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55091, '3053 Pepin');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55093, '3054 Pierce');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55095, '3055 Polk');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55097, '3056 Portage');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55099, '3057 Price');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55101, '3058 Racine');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55103, '3059 Richland');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55105, '3060 Rock');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55107, '3061 Rusk');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55109, '3062 St. Croix');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55111, '3063 Sauk');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55113, '3064 Sawyer');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55115, '3065 Shawano');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55117, '3066 Sheboygan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55119, '3067 Taylor');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55121, '3068 Trempealeau');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55123, '3069 Vernon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55125, '3070 Vilas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55127, '3071 Walworth');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55129, '3072 Washburn');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55131, '3073 Washington');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55133, '3074 Waukesha');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55135, '3075 Waupaca');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55137, '3076 Waushara');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55139, '3077 Winnebago');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (55141, '3078 Wood');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (56001, '3079 Albany');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (56003, '3080 Big Horn');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (56005, '3081 Campbell');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (56007, '3082 Carbon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (56009, '3083 Converse');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (56011, '3084 Crook');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (56013, '3085 Fremont');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (56015, '3086 Goshen');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (56017, '3087 Hot Springs');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (56019, '3088 Johnson');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (56021, '3089 Laramie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (56023, '3090 Lincoln');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (56025, '3091 Natrona');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (56027, '3092 Niobrara');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (56029, '3093 Park');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (56031, '3094 Platte');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (56033, '3095 Sheridan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (56035, '3096 Sublette');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (56037, '3097 Sweetwater');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (56039, '3098 Teton');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (56041, '3099 Uinta');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (56043, '3100 Washakie');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (56045, '3101 Weston');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (60001, '3102 American Samoa County');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (66010, '3103 Guam County');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (70001, '3104 Palaua County');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72001, '3105 Adjuntas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72003, '3106 Aguada');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72005, '3107 Aguadilla');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72007, '3108 Aguas Buenas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72009, '3109 Aibonito');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72011, '3110 Anasco');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72013, '3111 Arecibo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72015, '3112 Arroyo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72017, '3113 Barceloneta');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72019, '3114 Barranquitas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72021, '3115 Bayamon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72023, '3116 Cabo Rojo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72025, '3117 Caguas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72027, '3118 Camuy');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72029, '3119 Canovanas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72031, '3120 Carolina');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72033, '3121 Catano');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72035, '3122 Cayey');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72037, '3123 Ceiba');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72039, '3124 Ciales');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72041, '3125 Cidra');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72043, '3126 Coamo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72045, '3127 Comerio');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72047, '3128 Corozal');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72049, '3129 Culebra');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72051, '3130 Dorado');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72053, '3131 Florida');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72054, '3132 Fajardo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72055, '3133 Guanica');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72057, '3134 Guayama');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72059, '3135 Guayanilla');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72061, '3136 Guaynabo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72063, '3137 Gurabo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72065, '3138 Hatillo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72067, '3139 Hormigueros');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72069, '3140 Humacao');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72071, '3141 Isabela Municipio');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72073, '3142 Jayuya');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72075, '3143 Juana Diaz');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72077, '3144 Juncos');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72079, '3145 Lajas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72081, '3146 Lares');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72083, '3147 Las Marias');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72085, '3148 Las Piedras');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72087, '3149 Loiza');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72089, '3150 Luquillo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72091, '3151 Manati');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72093, '3152 Maricao');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72095, '3153 Maunabo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72097, '3154 Mayaguez');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72099, '3155 Moca');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72101, '3156 Morovis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72103, '3157 Naguabo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72105, '3158 Naranjito');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72107, '3159 Orocovis');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72109, '3160 Patillas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72111, '3161 Penuelas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72113, '3162 Ponce');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72115, '3163 Quebradillas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72117, '3164 Rincon');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72119, '3165 Rio Grande');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72121, '3166 Sabana Grande');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72123, '3167 Salinas');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72125, '3168 San German');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72127, '3169 San Juan');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72129, '3170 San Lorenzo');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72131, '3171 San Sebastian');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72133, '3172 Santa Isabel');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72135, '3173 Toa Alta');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72137, '3174 Toa Baja');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72139, '3175 Trujillo Alto');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72141, '3176 Utuado');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72143, '3177 Vega Alta');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72145, '3178 Vega Baja');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72147, '3179 Vieques');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72149, '3180 Villalba');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72151, '3181 Yabucoa');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (72153, '3182 Yuaco');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (78010, '3183 St. Croix');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (78020, '3184 St. John');
INSERT INTO `ref_stcty` (`STCTY`, `STCTYLABEL`) VALUES (78030, '3185 St. Thomas');
# 3185 records

#
# Table structure for table 'REF_UNIT'
#

DROP TABLE IF EXISTS `REF_UNIT`;

CREATE TABLE `REF_UNIT` (
  `STATECD` INTEGER DEFAULT 0, 
  `VALUE` INTEGER DEFAULT 0, 
  `MEANING` VARCHAR(80), 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'REF_UNIT'
#

# 0 records

#
# Table structure for table 'SEEDLING'
#

DROP TABLE IF EXISTS `SEEDLING`;

CREATE TABLE `SEEDLING` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `UNITCD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `SUBP` INTEGER DEFAULT 0, 
  `CONDID` INTEGER DEFAULT 0, 
  `SPCD` INTEGER, 
  `SPGRPCD` INTEGER DEFAULT 0, 
  `STOCKING` FLOAT NULL DEFAULT 0, 
  `TREECOUNT` INTEGER DEFAULT 0, 
  `TOTAGE` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6), 
  `TREECOUNT_CALC` INTEGER, 
  `TPA_UNADJ` DOUBLE NULL DEFAULT 0, 
  `CYCLE` INTEGER DEFAULT 0, 
  `SUBCYCLE` INTEGER DEFAULT 0, 
  UNIQUE (`CN`)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'SEEDLING'
#

# 0 records

#
# Table structure for table 'SITETREE'
#

DROP TABLE IF EXISTS `SITETREE`;

CREATE TABLE `SITETREE` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `PREV_SIT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `UNITCD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `CONDID` INTEGER DEFAULT 0, 
  `TREE` INTEGER DEFAULT 0, 
  `SPCD` INTEGER, 
  `DIA` FLOAT NULL DEFAULT 0, 
  `HT` INTEGER DEFAULT 0, 
  `AGEDIA` INTEGER DEFAULT 0, 
  `SPGRPCD` INTEGER DEFAULT 0, 
  `SITREE` INTEGER DEFAULT 0, 
  `SIBASE` INTEGER DEFAULT 0, 
  `SUBP` INTEGER DEFAULT 0, 
  `AZIMUTH` INTEGER DEFAULT 0, 
  `DIST` FLOAT NULL DEFAULT 0, 
  `METHOD` INTEGER DEFAULT 0, 
  `SITREE_EST` INTEGER DEFAULT 0, 
  `VALIDCD` INTEGER DEFAULT 0, 
  `CONDLIST` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6), 
  `CYCLE` INTEGER DEFAULT 0, 
  `SUBCYCLE` INTEGER DEFAULT 0
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'SITETREE'
#

# 0 records

#
# Table structure for table 'SOILS_EROSION'
#

DROP TABLE IF EXISTS `SOILS_EROSION`;

CREATE TABLE `SOILS_EROSION` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `SUBP` INTEGER, 
  `MEASYEAR` INTEGER DEFAULT 0, 
  `SOILSPCT` DOUBLE NULL, 
  `COMPCPCT` DOUBLE NULL, 
  `TYPRTDCD` DOUBLE NULL, 
  `TYPCMPCD` DOUBLE NULL, 
  `TYPAREACD` DOUBLE NULL, 
  `TYPOTHRCD` DOUBLE NULL, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'SOILS_EROSION'
#

# 0 records

#
# Table structure for table 'SOILS_LAB'
#

DROP TABLE IF EXISTS `SOILS_LAB`;

CREATE TABLE `SOILS_LAB` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `SMPLNNBR` DOUBLE NULL DEFAULT 0, 
  `VSTNBR` INTEGER DEFAULT 0, 
  `LAYER_TYPE` VARCHAR(10), 
  `SAMPLER_TYPE` VARCHAR(2), 
  `QASTATCD` INTEGER DEFAULT 0, 
  `SAMPLE_DATE` DATETIME, 
  `LAB_ID` VARCHAR(10), 
  `SAMPLE_ID` VARCHAR(12), 
  `FIELD_MOIST_SOIL_WT` DOUBLE NULL DEFAULT 0, 
  `AIR_DRY_SOIL_WT` DOUBLE NULL DEFAULT 0, 
  `OVEN_DRY_SOIL_WT` DOUBLE NULL DEFAULT 0, 
  `FIELD_MOIST_WATER_CONTENT_PCT` DOUBLE NULL DEFAULT 0, 
  `RESIDUAL_WATER_CONTENT_PCT` DOUBLE NULL DEFAULT 0, 
  `TOTAL_WATER_CONTENT_PCT` DOUBLE NULL DEFAULT 0, 
  `BULK_DENSITY` DOUBLE NULL DEFAULT 0, 
  `COARSE_FRACTION_PCT` DOUBLE NULL DEFAULT 0, 
  `C_ORG_PCT` DOUBLE NULL DEFAULT 0, 
  `C_INORG_PCT` DOUBLE NULL DEFAULT 0, 
  `C_TOTAL_PCT` DOUBLE NULL DEFAULT 0, 
  `N_TOTAL_PCT` DOUBLE NULL DEFAULT 0, 
  `PH_H2O` DOUBLE NULL DEFAULT 0, 
  `PH_CACL2` DOUBLE NULL DEFAULT 0, 
  `EXCHNG_NA` DOUBLE NULL DEFAULT 0, 
  `EXCHNG_K` DOUBLE NULL DEFAULT 0, 
  `EXCHNG_MG` DOUBLE NULL DEFAULT 0, 
  `EXCHNG_CA` DOUBLE NULL DEFAULT 0, 
  `EXCHNG_AL` DOUBLE NULL DEFAULT 0, 
  `ECEC` DOUBLE NULL DEFAULT 0, 
  `EXCHNG_MN` DOUBLE NULL DEFAULT 0, 
  `EXCHNG_FE` DOUBLE NULL DEFAULT 0, 
  `EXCHNG_NI` DOUBLE NULL DEFAULT 0, 
  `EXCHNG_CU` DOUBLE NULL DEFAULT 0, 
  `EXCHNG_ZN` DOUBLE NULL DEFAULT 0, 
  `EXCHNG_CD` DOUBLE NULL DEFAULT 0, 
  `EXCHNG_PB` DOUBLE NULL DEFAULT 0, 
  `EXCHNG_S` DOUBLE NULL DEFAULT 0, 
  `BRAY1_P` DOUBLE NULL DEFAULT 0, 
  `OLSEN_P` DOUBLE NULL DEFAULT 0, 
  `MEASYEAR` INTEGER DEFAULT 0, 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6), 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'SOILS_LAB'
#

# 0 records

#
# Table structure for table 'SOILS_SAMPLE_LOC'
#

DROP TABLE IF EXISTS `SOILS_SAMPLE_LOC`;

CREATE TABLE `SOILS_SAMPLE_LOC` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `SMPLNNBR` INTEGER DEFAULT 0, 
  `MEASYEAR` INTEGER DEFAULT 0, 
  `FORFLTHK` DOUBLE NULL, 
  `LTRLRTHK` DOUBLE NULL, 
  `FORFLTHKN` DOUBLE NULL, 
  `LTRLRTHKN` DOUBLE NULL, 
  `FORFLTHKS` DOUBLE NULL, 
  `LTRLRTHKS` DOUBLE NULL, 
  `FORFLTHKE` DOUBLE NULL, 
  `LTRLRTHKE` DOUBLE NULL, 
  `FORFLTHKW` DOUBLE NULL, 
  `LTRLRTHKW` DOUBLE NULL, 
  `CONDID` INTEGER DEFAULT 0, 
  `VSTNBR` INTEGER DEFAULT 0, 
  `TXTRLYR1` DOUBLE NULL, 
  `TXTRLYR2` DOUBLE NULL, 
  `DPTHSBSL` DOUBLE NULL, 
  `SOILS_STATCD` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'SOILS_SAMPLE_LOC'
#

# 0 records

#
# Table structure for table 'SOILS_VISIT'
#

DROP TABLE IF EXISTS `SOILS_VISIT`;

CREATE TABLE `SOILS_VISIT` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `MEASDAY` INTEGER DEFAULT 0, 
  `MEASMON` INTEGER DEFAULT 0, 
  `MEASYEAR` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'SOILS_VISIT'
#

# 0 records

#
# Table structure for table 'SUBP_COND'
#

DROP TABLE IF EXISTS `SUBP_COND`;

CREATE TABLE `SUBP_COND` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `UNITCD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `SUBP` INTEGER DEFAULT 0, 
  `CONDID` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6), 
  `MICRCOND_PROP` FLOAT NULL DEFAULT 0, 
  `SUBPCOND_PROP` FLOAT NULL DEFAULT 0, 
  `MACRCOND_PROP` FLOAT NULL DEFAULT 0, 
  `NONFR_INCL_PCT_SUBP` INTEGER DEFAULT 0, 
  `NONFR_INCL_PCT_MACRO` INTEGER DEFAULT 0, 
  `CYCLE` INTEGER DEFAULT 0, 
  `SUBCYCLE` INTEGER DEFAULT 0
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'SUBP_COND'
#

# 0 records

#
# Table structure for table 'SUBP_COND_CHNG_MTRX'
#

DROP TABLE IF EXISTS `SUBP_COND_CHNG_MTRX`;

CREATE TABLE `SUBP_COND_CHNG_MTRX` (
  `CN` VARCHAR(34), 
  `STATECD` DECIMAL(4,0), 
  `SUBP` DECIMAL(1,0), 
  `SUBPTYP` DECIMAL(1,0), 
  `PLT_CN` VARCHAR(34), 
  `CONDID` DECIMAL(1,0), 
  `PREV_PLT_CN` VARCHAR(34), 
  `PREVCOND` DECIMAL(1,0), 
  `SUBPTYP_PROP_CHNG` DECIMAL(5,4), 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'SUBP_COND_CHNG_MTRX'
#

# 0 records

#
# Table structure for table 'SUBPLOT'
#

DROP TABLE IF EXISTS `SUBPLOT`;

CREATE TABLE `SUBPLOT` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `PREV_SBP_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `UNITCD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `SUBP` INTEGER DEFAULT 0, 
  `SUBP_STATUS_CD` INTEGER DEFAULT 0, 
  `POINT_NONSAMPLE_REASN_CD` INTEGER DEFAULT 0, 
  `MICRCOND` INTEGER DEFAULT 0, 
  `SUBPCOND` INTEGER DEFAULT 0, 
  `MACRCOND` INTEGER DEFAULT 0, 
  `CONDLIST` INTEGER DEFAULT 0, 
  `SLOPE` INTEGER DEFAULT 0, 
  `ASPECT` INTEGER DEFAULT 0, 
  `WATERDEP` INTEGER DEFAULT 0, 
  `P2A_GRM_FLG` VARCHAR(1), 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6), 
  `CYCLE` INTEGER DEFAULT 0, 
  `SUBCYCLE` INTEGER DEFAULT 0, 
  `ROOT_DIS_SEV_CD_PNWRS` INTEGER DEFAULT 0, 
  `NF_SUBP_STATUS_CD` INTEGER, 
  `NF_SUBP_NONSAMPLE_REASN_CD` INTEGER, 
  `P2VEG_SUBP_STATUS_CD` INTEGER, 
  `P2VEG_SUBP_NONSAMPLE_REASN_CD` INTEGER, 
  `INVASIVE_SUBP_STATUS_CD` INTEGER, 
  `INVASIVE_NONSAMPLE_REASN_CD` INTEGER
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'SUBPLOT'
#

# 0 records

#
# Table structure for table 'SURVEY'
#

DROP TABLE IF EXISTS `SURVEY`;

CREATE TABLE `SURVEY` (
  `CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `P3_OZONE_IND` VARCHAR(1), 
  `STATECD` INTEGER DEFAULT 0, 
  `STATEAB` VARCHAR(2), 
  `STATENM` VARCHAR(28), 
  `RSCD` INTEGER DEFAULT 0, 
  `ANN_INVENTORY` VARCHAR(1), 
  `NOTES` LONGTEXT, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6), 
  `CYCLE` INTEGER DEFAULT 0, 
  `SUBCYCLE` INTEGER DEFAULT 0
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'SURVEY'
#

# 0 records

#
# Table structure for table 'TempEstnUnitDescrLU'
#

DROP TABLE IF EXISTS `TempEstnUnitDescrLU`;

CREATE TABLE `TempEstnUnitDescrLU` (
  `rscdEvalidEsntUnit` VARCHAR(34), 
  `rscdEvalidEsntUnitLabel` VARCHAR(128), 
  UNIQUE (`rscdEvalidEsntUnit`)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'TempEstnUnitDescrLU'
#

INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090600000001                    ', '0001 24090600000001 PRIVATE CNTY/SUPER CNTY 003                                                                                 ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090600000002                    ', '0002 24090600000002 PRIVATE CNTY/SUPER CNTY 005                                                                                 ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090600000003                    ', '0003 24090600000003 PRIVATE CNTY/SUPER CNTY 1,7,9                                                                               ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090600000004                    ', '0004 24090600000004 PRIVATE CNTY/SUPER CNTY 11,13,15                                                                            ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090600000005                    ', '0005 24090600000005 PUBLIC CNTY/SUPER CNTY 003                                                                                  ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090600000006                    ', '0006 24090600000006 PUBLIC CNTY/SUPER CNTY 005                                                                                  ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090600000007                    ', '0007 24090600000007 PUBLIC CNTY/SUPER CNTY 1,7,9                                                                                ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090600000008                    ', '0008 24090600000008 PUBLIC CNTY/SUPER CNTY 11,13,15                                                                             ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090601000001                    ', '0009 24090601000001 PRIVATE CNTY/SUPER CNTY 003                                                                                 ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090601000002                    ', '0010 24090601000002 PRIVATE CNTY/SUPER CNTY 005                                                                                 ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090601000003                    ', '0011 24090601000003 PRIVATE CNTY/SUPER CNTY 1,7,9                                                                               ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090601000004                    ', '0012 24090601000004 PRIVATE CNTY/SUPER CNTY 11,13,15                                                                            ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090601000005                    ', '0013 24090601000005 PUBLIC CNTY/SUPER CNTY 003                                                                                  ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090601000006                    ', '0014 24090601000006 PUBLIC CNTY/SUPER CNTY 005                                                                                  ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090601000007                    ', '0015 24090601000007 PUBLIC CNTY/SUPER CNTY 1,7,9                                                                                ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090601000008                    ', '0016 24090601000008 PUBLIC CNTY/SUPER CNTY 11,13,15                                                                             ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090602000001                    ', '0017 24090602000001 CNTY/SUPER CNTY 001                                                                                         ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090602000002                    ', '0018 24090602000002 CNTY/SUPER CNTY 003                                                                                         ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090602000003                    ', '0019 24090602000003 CNTY/SUPER CNTY 005                                                                                         ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090602000004                    ', '0020 24090602000004 CNTY/SUPER CNTY 007                                                                                         ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090602000005                    ', '0021 24090602000005 CNTY/SUPER CNTY 009                                                                                         ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090602000006                    ', '0022 24090602000006 CNTY/SUPER CNTY 011                                                                                         ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090602000007                    ', '0023 24090602000007 CNTY/SUPER CNTY 013                                                                                         ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090602000008                    ', '0024 24090602000008 CNTY/SUPER CNTY 015                                                                                         ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090700000001                    ', '0025 24090700000001 PRVT_CNTY_GRP_1                                                                                             ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090700000002                    ', '0026 24090700000002 PRVT_CNTY_GRP_11                                                                                            ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090700000003                    ', '0027 24090700000003 PRVT_CNTY_GRP_13                                                                                            ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090700000004                    ', '0028 24090700000004 PRVT_CNTY_GRP_15                                                                                            ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090700000005                    ', '0029 24090700000005 PRVT_CNTY_GRP_3                                                                                             ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090700000006                    ', '0030 24090700000006 PRVT_CNTY_GRP_5                                                                                             ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090700000007                    ', '0031 24090700000007 PRVT_CNTY_GRP_7                                                                                             ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090700000008                    ', '0032 24090700000008 PRVT_CNTY_GRP_9                                                                                             ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090700000009                    ', '0033 24090700000009 PUB_UNIT_1                                                                                                  ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090700000010                    ', '0034 24090700000010 WATER_UNIT_1                                                                                                ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090701000001                    ', '0035 24090701000001 PRVT_CNTY_GRP_1                                                                                             ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090701000002                    ', '0036 24090701000002 PRVT_CNTY_GRP_11                                                                                            ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090701000003                    ', '0037 24090701000003 PRVT_CNTY_GRP_13                                                                                            ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090701000004                    ', '0038 24090701000004 PRVT_CNTY_GRP_15                                                                                            ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090701000005                    ', '0039 24090701000005 PRVT_CNTY_GRP_3                                                                                             ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090701000006                    ', '0040 24090701000006 PRVT_CNTY_GRP_5                                                                                             ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090701000007                    ', '0041 24090701000007 PRVT_CNTY_GRP_7                                                                                             ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090701000008                    ', '0042 24090701000008 PRVT_CNTY_GRP_9                                                                                             ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090701000009                    ', '0043 24090701000009 PUB_UNIT_1                                                                                                  ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090701000010                    ', '0044 24090701000010 WATER_UNIT_1                                                                                                ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090703000001                    ', '0045 24090703000001 Private Unit 1                                                                                              ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090703000002                    ', '0046 24090703000002 Public Unit 1                                                                                               ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090800000001                    ', '0047 24090800000001 Inland Census Water Cnty. Grp. 15, 13, 11, 7, ...                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090800000002                    ', '0048 24090800000002 Inland Census Water Cnty. Grp. 3                                                                            ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090800000003                    ', '0049 24090800000003 Inland Census Water Cnty. Grp. 5                                                                            ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090800000004                    ', '0050 24090800000004 Private Cnty. Grp. 1                                                                                        ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090800000005                    ', '0051 24090800000005 Private Cnty. Grp. 11                                                                                       ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090800000006                    ', '0052 24090800000006 Private Cnty. Grp. 13                                                                                       ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090800000007                    ', '0053 24090800000007 Private Cnty. Grp. 15                                                                                       ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090800000008                    ', '0054 24090800000008 Private Cnty. Grp. 3                                                                                        ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090800000009                    ', '0055 24090800000009 Private Cnty. Grp. 5                                                                                        ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090800000010                    ', '0056 24090800000010 Private Cnty. Grp. 7                                                                                        ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090800000011                    ', '0057 24090800000011 Private Cnty. Grp. 9                                                                                        ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090800000012                    ', '0058 24090800000012 Public Cnty. Grp. 1, 9                                                                                      ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090800000013                    ', '0059 24090800000013 Public Cnty. Grp. 15, 11, 13                                                                                ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090800000014                    ', '0060 24090800000014 Public Cnty. Grp. 3                                                                                         ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090800000015                    ', '0061 24090800000015 Public Cnty. Grp. 5                                                                                         ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090800000016                    ', '0062 24090800000016 Public Cnty. Grp. 7                                                                                         ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090801000001                    ', '0063 24090801000001 Inland Census Water Cnty. Grp. 15, 13, 11, 7, ...                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090801000002                    ', '0064 24090801000002 Inland Census Water Cnty. Grp. 3                                                                            ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090801000003                    ', '0065 24090801000003 Inland Census Water Cnty. Grp. 5                                                                            ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090801000004                    ', '0066 24090801000004 Private Cnty. Grp. 1                                                                                        ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090801000005                    ', '0067 24090801000005 Private Cnty. Grp. 11                                                                                       ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090801000006                    ', '0068 24090801000006 Private Cnty. Grp. 13                                                                                       ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090801000007                    ', '0069 24090801000007 Private Cnty. Grp. 15                                                                                       ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090801000008                    ', '0070 24090801000008 Private Cnty. Grp. 3                                                                                        ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090801000009                    ', '0071 24090801000009 Private Cnty. Grp. 5                                                                                        ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090801000010                    ', '0072 24090801000010 Private Cnty. Grp. 7                                                                                        ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090801000011                    ', '0073 24090801000011 Private Cnty. Grp. 9                                                                                        ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090801000012                    ', '0074 24090801000012 Public Cnty. Grp. 1, 9                                                                                      ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090801000013                    ', '0075 24090801000013 Public Cnty. Grp. 15, 11, 13                                                                                ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090801000014                    ', '0076 24090801000014 Public Cnty. Grp. 3                                                                                         ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090801000015                    ', '0077 24090801000015 Public Cnty. Grp. 5                                                                                         ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090801000016                    ', '0078 24090801000016 Public Cnty. Grp. 7                                                                                         ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090803000001                    ', '0079 24090803000001 Inland Census Water Public Cnty. Grp. 3, 5, 15...                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090803000002                    ', '0080 24090803000002 Private Cnty. Grp. 1                                                                                        ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090803000003                    ', '0081 24090803000003 Private Cnty. Grp. 11                                                                                       ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090803000004                    ', '0082 24090803000004 Private Cnty. Grp. 13                                                                                       ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090803000005                    ', '0083 24090803000005 Private Cnty. Grp. 15                                                                                       ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090803000006                    ', '0084 24090803000006 Private Cnty. Grp. 3                                                                                        ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090803000007                    ', '0085 24090803000007 Private Cnty. Grp. 5                                                                                        ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090803000008                    ', '0086 24090803000008 Private Cnty. Grp. 7                                                                                        ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24090803000009                    ', '0087 24090803000009 Private Cnty. Grp. 9                                                                                        ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24095331000001                    ', '0088 24095331000001 Population 1                                                                                                ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24095331000003                    ', '0089 24095331000003 Population 3                                                                                                ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24095331000005                    ', '0090 24095331000005 Population 5                                                                                                ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24095331000007                    ', '0091 24095331000007 Population 7                                                                                                ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24095331000009                    ', '0092 24095331000009 Population 9                                                                                                ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24095331000011                    ', '0093 24095331000011 Population 11                                                                                               ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24095331000013                    ', '0094 24095331000013 Population 13                                                                                               ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24095331000015                    ', '0095 24095331000015 Population 15                                                                                               ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24095332000001                    ', '0096 24095332000001 Population 1                                                                                                ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24095332000003                    ', '0097 24095332000003 Population 3                                                                                                ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24095332000005                    ', '0098 24095332000005 Population 5                                                                                                ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24095332000007                    ', '0099 24095332000007 Population 7                                                                                                ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24095332000009                    ', '0100 24095332000009 Population 9                                                                                                ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24095332000011                    ', '0101 24095332000011 Population 11                                                                                               ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24095332000013                    ', '0102 24095332000013 Population 13                                                                                               ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24095332000015                    ', '0103 24095332000015 Population 15                                                                                               ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098501000002                    ', '0104 24098501000002 2                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098502000002                    ', '0105 24098502000002 2                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098503000001                    ', '0106 24098503000001 1                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098503000003                    ', '0107 24098503000003 3                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098503000005                    ', '0108 24098503000005 5                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098503000007                    ', '0109 24098503000007 7                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098503000009                    ', '0110 24098503000009 9                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098503000011                    ', '0111 24098503000011 11                                                                                                          ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098503000013                    ', '0112 24098503000013 13                                                                                                          ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098503000015                    ', '0113 24098503000015 15                                                                                                          ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098503000998                    ', '0114 24098503000998 998                                                                                                         ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098504000001                    ', '0115 24098504000001 1                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098504000003                    ', '0116 24098504000003 3                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098504000005                    ', '0117 24098504000005 5                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098504000007                    ', '0118 24098504000007 7                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098504000009                    ', '0119 24098504000009 9                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098504000011                    ', '0120 24098504000011 11                                                                                                          ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098504000013                    ', '0121 24098504000013 13                                                                                                          ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098504000015                    ', '0122 24098504000015 15                                                                                                          ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098504000998                    ', '0123 24098504000998 998                                                                                                         ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098505000001                    ', '0124 24098505000001 1                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098505000003                    ', '0125 24098505000003 3                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098505000005                    ', '0126 24098505000005 5                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098505000007                    ', '0127 24098505000007 7                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098505000009                    ', '0128 24098505000009 9                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098505000011                    ', '0129 24098505000011 11                                                                                                          ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098505000013                    ', '0130 24098505000013 13                                                                                                          ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098505000015                    ', '0131 24098505000015 15                                                                                                          ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24098505000998                    ', '0132 24098505000998 998                                                                                                         ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099801000002                    ', '0133 24099801000002 2                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099802000002                    ', '0134 24099802000002 2                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099803000001                    ', '0135 24099803000001 1                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099803000003                    ', '0136 24099803000003 3                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099803000005                    ', '0137 24099803000005 5                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099803000007                    ', '0138 24099803000007 7                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099803000009                    ', '0139 24099803000009 9                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099803000011                    ', '0140 24099803000011 11                                                                                                          ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099803000013                    ', '0141 24099803000013 13                                                                                                          ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099803000015                    ', '0142 24099803000015 15                                                                                                          ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099803000998                    ', '0143 24099803000998 998                                                                                                         ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099804000001                    ', '0144 24099804000001 1                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099804000003                    ', '0145 24099804000003 3                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099804000005                    ', '0146 24099804000005 5                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099804000007                    ', '0147 24099804000007 7                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099804000009                    ', '0148 24099804000009 9                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099804000011                    ', '0149 24099804000011 11                                                                                                          ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099804000013                    ', '0150 24099804000013 13                                                                                                          ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099804000015                    ', '0151 24099804000015 15                                                                                                          ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099804000998                    ', '0152 24099804000998 998                                                                                                         ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099805000001                    ', '0153 24099805000001 1                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099805000003                    ', '0154 24099805000003 3                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099805000005                    ', '0155 24099805000005 5                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099805000007                    ', '0156 24099805000007 7                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099805000009                    ', '0157 24099805000009 9                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099805000011                    ', '0158 24099805000011 11                                                                                                          ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099805000013                    ', '0159 24099805000013 13                                                                                                          ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099805000015                    ', '0160 24099805000015 15                                                                                                          ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099805000998                    ', '0161 24099805000998 998                                                                                                         ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099806000001                    ', '0162 24099806000001 1                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099806000003                    ', '0163 24099806000003 3                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099806000005                    ', '0164 24099806000005 5                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099806000007                    ', '0165 24099806000007 7                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099806000009                    ', '0166 24099806000009 9                                                                                                           ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099806000011                    ', '0167 24099806000011 11                                                                                                          ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099806000013                    ', '0168 24099806000013 13                                                                                                          ');
INSERT INTO `TempEstnUnitDescrLU` (`rscdEvalidEsntUnit`, `rscdEvalidEsntUnitLabel`) VALUES ('24099806000015                    ', '0169 24099806000015 15                                                                                                          ');
# 169 records

#
# Table structure for table 'TREE'
#

DROP TABLE IF EXISTS `TREE`;

CREATE TABLE `TREE` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `PREV_TRE_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `UNITCD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `SUBP` INTEGER DEFAULT 0, 
  `TREE` INTEGER DEFAULT 0, 
  `CONDID` INTEGER DEFAULT 0, 
  `AZIMUTH` INTEGER DEFAULT 0, 
  `DIST` FLOAT NULL, 
  `PREVCOND` INTEGER DEFAULT 0, 
  `STATUSCD` INTEGER DEFAULT 0, 
  `SPCD` INTEGER, 
  `SPGRPCD` INTEGER DEFAULT 0, 
  `DIA` FLOAT NULL DEFAULT 0, 
  `DIAHTCD` INTEGER DEFAULT 0, 
  `HT` INTEGER DEFAULT 0, 
  `HTCD` INTEGER DEFAULT 0, 
  `ACTUALHT` INTEGER DEFAULT 0, 
  `TREECLCD` INTEGER DEFAULT 0, 
  `CR` INTEGER DEFAULT 0, 
  `CCLCD` INTEGER DEFAULT 0, 
  `TREEGRCD` INTEGER DEFAULT 0, 
  `AGENTCD` INTEGER DEFAULT 0, 
  `CULL` INTEGER DEFAULT 0, 
  `DAMLOC1` INTEGER DEFAULT 0, 
  `DAMTYP1` INTEGER DEFAULT 0, 
  `DAMSEV1` INTEGER DEFAULT 0, 
  `DAMLOC2` INTEGER DEFAULT 0, 
  `DAMTYP2` INTEGER DEFAULT 0, 
  `DAMSEV2` INTEGER DEFAULT 0, 
  `DECAYCD` INTEGER DEFAULT 0, 
  `STOCKING` FLOAT NULL DEFAULT 0, 
  `WDLDSTEM` INTEGER DEFAULT 0, 
  `VOLCFNET` DOUBLE NULL DEFAULT 0, 
  `VOLCFGRS` DOUBLE NULL DEFAULT 0, 
  `VOLCSNET` DOUBLE NULL DEFAULT 0, 
  `VOLCSGRS` DOUBLE NULL DEFAULT 0, 
  `VOLBFNET` DOUBLE NULL DEFAULT 0, 
  `VOLBFGRS` DOUBLE NULL DEFAULT 0, 
  `VOLCFSND` DOUBLE NULL DEFAULT 0, 
  `GROWCFGS` DOUBLE NULL DEFAULT 0, 
  `GROWBFSL` DOUBLE NULL DEFAULT 0, 
  `GROWCFAL` DOUBLE NULL DEFAULT 0, 
  `MORTCFGS` DOUBLE NULL DEFAULT 0, 
  `MORTBFSL` DOUBLE NULL DEFAULT 0, 
  `MORTCFAL` DOUBLE NULL DEFAULT 0, 
  `REMVCFGS` DOUBLE NULL DEFAULT 0, 
  `REMVBFSL` DOUBLE NULL DEFAULT 0, 
  `REMVCFAL` DOUBLE NULL DEFAULT 0, 
  `DIACHECK` INTEGER DEFAULT 0, 
  `MORTYR` INTEGER DEFAULT 0, 
  `SALVCD` INTEGER DEFAULT 0, 
  `UNCRCD` INTEGER DEFAULT 0, 
  `CPOSCD` INTEGER DEFAULT 0, 
  `CLIGHTCD` INTEGER DEFAULT 0, 
  `CVIGORCD` INTEGER DEFAULT 0, 
  `CDENCD` INTEGER DEFAULT 0, 
  `CDIEBKCD` INTEGER DEFAULT 0, 
  `TRANSCD` INTEGER DEFAULT 0, 
  `TREEHISTCD` INTEGER DEFAULT 0, 
  `DIACALC` FLOAT NULL DEFAULT 0, 
  `BHAGE` INTEGER DEFAULT 0, 
  `TOTAGE` INTEGER DEFAULT 0, 
  `CULLDEAD` INTEGER DEFAULT 0, 
  `CULLFORM` INTEGER DEFAULT 0, 
  `CULLMSTOP` INTEGER DEFAULT 0, 
  `CULLBF` INTEGER DEFAULT 0, 
  `CULLCF` INTEGER DEFAULT 0, 
  `BFSND` INTEGER DEFAULT 0, 
  `CFSND` INTEGER DEFAULT 0, 
  `SAWHT` INTEGER DEFAULT 0, 
  `BOLEHT` INTEGER DEFAULT 0, 
  `FORMCL` INTEGER DEFAULT 0, 
  `HTCALC` INTEGER DEFAULT 0, 
  `HRDWD_CLUMP_CD` INTEGER DEFAULT 0, 
  `SITREE` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6), 
  `MORTCD` INTEGER DEFAULT 0, 
  `HTDMP` FLOAT NULL DEFAULT 0, 
  `ROUGHCULL` INTEGER DEFAULT 0, 
  `MIST_CL_CD` INTEGER DEFAULT 0, 
  `CULL_FLD` INTEGER DEFAULT 0, 
  `RECONCILECD` INTEGER DEFAULT 0, 
  `PREVDIA` FLOAT NULL DEFAULT 0, 
  `FGROWCFGS` DOUBLE NULL DEFAULT 0, 
  `FGROWBFSL` DOUBLE NULL DEFAULT 0, 
  `FGROWCFAL` DOUBLE NULL DEFAULT 0, 
  `FMORTCFGS` DOUBLE NULL DEFAULT 0, 
  `FMORTBFSL` DOUBLE NULL DEFAULT 0, 
  `FMORTCFAL` DOUBLE NULL DEFAULT 0, 
  `FREMVCFGS` DOUBLE NULL DEFAULT 0, 
  `FREMVBFSL` DOUBLE NULL DEFAULT 0, 
  `FREMVCFAL` DOUBLE NULL DEFAULT 0, 
  `P2A_GRM_FLG` VARCHAR(1), 
  `TREECLCD_NERS` INTEGER DEFAULT 0, 
  `TREECLCD_SRS` INTEGER DEFAULT 0, 
  `TREECLCD_NCRS` INTEGER DEFAULT 0, 
  `TREECLCD_RMRS` INTEGER DEFAULT 0, 
  `STANDING_DEAD_CD` INTEGER DEFAULT 0, 
  `PREV_STATUS_CD` INTEGER DEFAULT 0, 
  `PREV_WDLDSTEM` INTEGER DEFAULT 0, 
  `TPA_UNADJ` DOUBLE NULL DEFAULT 0, 
  `TPAMORT_UNADJ` DOUBLE NULL DEFAULT 0, 
  `TPAREMV_UNADJ` DOUBLE NULL DEFAULT 0, 
  `TPAGROW_UNADJ` DOUBLE NULL DEFAULT 0, 
  `DRYBIO_BOLE` DOUBLE NULL DEFAULT 0, 
  `DRYBIO_TOP` DOUBLE NULL DEFAULT 0, 
  `DRYBIO_STUMP` DOUBLE NULL DEFAULT 0, 
  `DRYBIO_SAPLING` DOUBLE NULL DEFAULT 0, 
  `DRYBIO_WDLD_SPP` DOUBLE NULL DEFAULT 0, 
  `DRYBIO_BG` DOUBLE NULL DEFAULT 0, 
  `CARBON_AG` DOUBLE NULL DEFAULT 0, 
  `CARBON_BG` DOUBLE NULL DEFAULT 0, 
  `CYCLE` INTEGER DEFAULT 0, 
  `SUBCYCLE` INTEGER DEFAULT 0, 
  `BORED_CD_PNWRS` INTEGER DEFAULT 0, 
  `DAMLOC1_PNWRS` INTEGER DEFAULT 0, 
  `DAMLOC2_PNWRS` INTEGER DEFAULT 0, 
  `DIACHECK_PNWRS` INTEGER DEFAULT 0, 
  `DMG_AGENT1_CD_PNWRS` INTEGER DEFAULT 0, 
  `DMG_AGENT2_CD_PNWRS` INTEGER DEFAULT 0, 
  `DMG_AGENT3_CD_PNWRS` INTEGER DEFAULT 0, 
  `MIST_CL_CD_PNWRS` INTEGER DEFAULT 0, 
  `SEVERITY1_CD_PNWRS` INTEGER DEFAULT 0, 
  `SEVERITY1A_CD_PNWRS` INTEGER DEFAULT 0, 
  `SEVERITY1B_CD_PNWRS` INTEGER DEFAULT 0, 
  `SEVERITY2_CD_PNWRS` INTEGER DEFAULT 0, 
  `SEVERITY2A_CD_PNWRS` INTEGER DEFAULT 0, 
  `SEVERITY2B_CD_PNWRS` INTEGER DEFAULT 0, 
  `SEVERITY3_CD_PNWRS` INTEGER DEFAULT 0, 
  `UNKNOWN_DAMTYP1_PNWRS` INTEGER DEFAULT 0, 
  `UNKNOWN_DAMTYP2_PNWRS` INTEGER DEFAULT 0, 
  `PREV_PNTN_SRS` INTEGER DEFAULT 0, 
  INDEX (`PLT_CN`, `CONDID`), 
  UNIQUE (`CN`), 
  INDEX (`PLT_CN`)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'TREE'
#

# 0 records

#
# Table structure for table 'TREE_REGIONAL_BIOMASS'
#

DROP TABLE IF EXISTS `TREE_REGIONAL_BIOMASS`;

CREATE TABLE `TREE_REGIONAL_BIOMASS` (
  `TRE_CN` VARCHAR(34), 
  `STATECD` INTEGER DEFAULT 0, 
  `REGIONAL_DRYBIOT` DOUBLE NULL DEFAULT 0, 
  `REGIONAL_DRYBIOM` DOUBLE NULL DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'TREE_REGIONAL_BIOMASS'
#

# 0 records

#
# Table structure for table 'VEG_PLOT_SPECIES'
#

DROP TABLE IF EXISTS `VEG_PLOT_SPECIES`;

CREATE TABLE `VEG_PLOT_SPECIES` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `VVT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `VEG_FLDSPCD` VARCHAR(16), 
  `UNIQUE_SP_NBR` INTEGER DEFAULT 0, 
  `VEG_SPCD` VARCHAR(16), 
  `SPECIMEN_COLLECTED` VARCHAR(1), 
  `SPECIMEN_LABEL_NBR` DOUBLE NULL, 
  `SPECIMEN_NOT_COLLECTED_REASON` INTEGER DEFAULT 0, 
  `SPECIMEN_RESOLVED` VARCHAR(1), 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'VEG_PLOT_SPECIES'
#

# 0 records

#
# Table structure for table 'VEG_QUADRAT'
#

DROP TABLE IF EXISTS `VEG_QUADRAT`;

CREATE TABLE `VEG_QUADRAT` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `VVT_CN` VARCHAR(34), 
  `VSB_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `SUBP` INTEGER DEFAULT 0, 
  `QUADRAT` INTEGER DEFAULT 0, 
  `CONDID` INTEGER DEFAULT 0, 
  `QUADRAT_STATUS` INTEGER DEFAULT 0, 
  `QUADRAT_STATUS_PRE2004` INTEGER DEFAULT 0, 
  `TRAMPLING` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'VEG_QUADRAT'
#

# 0 records

#
# Table structure for table 'VEG_QUADRAT_SPP_VW'
#

DROP TABLE IF EXISTS `VEG_QUADRAT_SPP_VW`;

CREATE TABLE `VEG_QUADRAT_SPP_VW` (
  `PLT_CN` VARCHAR(34), 
  `VVT_CN` VARCHAR(34), 
  `VSB_CN` VARCHAR(34), 
  `VQT_CN` VARCHAR(34), 
  `VSS_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `SUBP` INTEGER DEFAULT 0, 
  `QUADRAT` INTEGER DEFAULT 0, 
  `VEG_FLDSPCD` VARCHAR(16), 
  `UNIQUE_SP_NBR` INTEGER, 
  `VEG_SPCD` VARCHAR(16), 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'VEG_QUADRAT_SPP_VW'
#

# 0 records

#
# Table structure for table 'VEG_SUBPLOT'
#

DROP TABLE IF EXISTS `VEG_SUBPLOT`;

CREATE TABLE `VEG_SUBPLOT` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `VVT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `SUBP` INTEGER DEFAULT 0, 
  `VEG_SUBP_STATUS_CD` INTEGER DEFAULT 0, 
  `VEG_SUBP_NONSAMPLE_REASN_CD` INTEGER DEFAULT 0, 
  `SUBP_ACCESSIBLE_FOREST_PCT` INTEGER DEFAULT 0, 
  `DETAILED_NONFOREST_LAND_USE` INTEGER DEFAULT 0, 
  `COMMUNITY_DESC_SPECIMEN_LABEL` VARCHAR(200), 
  `TOTAL_CANOPY_COVER_LAYER_1` INTEGER DEFAULT 0, 
  `TOTAL_CANOPY_COVER_LAYER_2` INTEGER DEFAULT 0, 
  `TOTAL_CANOPY_COVER_LAYER_3` INTEGER DEFAULT 0, 
  `TOTAL_CANOPY_COVER_LAYER_4` INTEGER DEFAULT 0, 
  `CRYPTO_CRUST_COVER_PCT` INTEGER DEFAULT 0, 
  `LICHEN_COVER_PCT` INTEGER DEFAULT 0, 
  `LITTER_DUFF_COVER_PCT` INTEGER DEFAULT 0, 
  `MINERAL_SOIL_COVER_PCT` INTEGER DEFAULT 0, 
  `MOSS_COVER_PCT` INTEGER DEFAULT 0, 
  `ROAD_TRAIL_COVER_PCT` INTEGER DEFAULT 0, 
  `ROCK_COVER_PCT` INTEGER DEFAULT 0, 
  `STANDING_WATER_COVER_PCT` INTEGER DEFAULT 0, 
  `STREAM_LAKE_COVER_PCT` INTEGER DEFAULT 0, 
  `TRASH_JUNK_COVER_PCT` INTEGER DEFAULT 0, 
  `WOOD_COVER_PCT` INTEGER DEFAULT 0, 
  `VEG_SUBP_STATUS_CD_PRE2004` INTEGER DEFAULT 0, 
  `VEG_SUBP_NONSMP_RSN_CD_PRE2004` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'VEG_SUBPLOT'
#

# 0 records

#
# Table structure for table 'VEG_SUBPLOT_SPP'
#

DROP TABLE IF EXISTS `VEG_SUBPLOT_SPP`;

CREATE TABLE `VEG_SUBPLOT_SPP` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `VVT_CN` VARCHAR(34), 
  `VSB_CN` VARCHAR(34), 
  `VPS_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `SUBP` INTEGER DEFAULT 0, 
  `VEG_FLDSPCD` VARCHAR(16), 
  `UNIQUE_SP_NBR` INTEGER DEFAULT 0, 
  `VEG_SPCD` VARCHAR(16), 
  `SP_CANOPY_COVER_TOTAL` FLOAT NULL DEFAULT 0, 
  `SP_CANOPY_COVER_LAYER_1_2` FLOAT NULL DEFAULT 0, 
  `SP_CANOPY_COVER_LAYER_3` FLOAT NULL DEFAULT 0, 
  `SP_CANOPY_COVER_LAYER_4` FLOAT NULL DEFAULT 0, 
  `QUAD_1_PRESENCE` INTEGER DEFAULT 0, 
  `QUAD_2_PRESENCE` INTEGER DEFAULT 0, 
  `QUAD_3_PRESENCE` INTEGER DEFAULT 0, 
  `DUMMY_SUBP_COVER_PRE2004` INTEGER DEFAULT 0, 
  `MAX_COVER_LAYER_NBR_PRE2004` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'VEG_SUBPLOT_SPP'
#

# 0 records

#
# Table structure for table 'VEG_VISIT'
#

DROP TABLE IF EXISTS `VEG_VISIT`;

CREATE TABLE `VEG_VISIT` (
  `CN` VARCHAR(34), 
  `PLT_CN` VARCHAR(34), 
  `INVYR` INTEGER DEFAULT 0, 
  `STATECD` INTEGER DEFAULT 0, 
  `COUNTYCD` INTEGER DEFAULT 0, 
  `PLOT` INTEGER DEFAULT 0, 
  `VEG_QA_STATUS` INTEGER DEFAULT 0, 
  `VEG_KINDCD` INTEGER DEFAULT 0, 
  `VEG_MANUAL` VARCHAR(8), 
  `TRACE_COVER_ALLOWED` INTEGER DEFAULT 0, 
  `VEG_MEASYEAR` INTEGER DEFAULT 0, 
  `VEG_MEASMON` INTEGER DEFAULT 0, 
  `VEG_MEASDAY` INTEGER DEFAULT 0, 
  `VEG_SAMPLE_BASIS` INTEGER DEFAULT 0, 
  `CREATED_BY` VARCHAR(30), 
  `CREATED_DATE` DATETIME, 
  `CREATED_IN_INSTANCE` VARCHAR(6), 
  `MODIFIED_BY` VARCHAR(30), 
  `MODIFIED_DATE` DATETIME, 
  `MODIFIED_IN_INSTANCE` VARCHAR(6)
) ENGINE=myisam DEFAULT CHARSET=utf8;

SET autocommit=1;

#
# Dumping data for table 'VEG_VISIT'
#

# 0 records

