% Generated by roxygen2 (4.0.1): do not edit by hand
\name{query.traits}
\alias{query.traits}
\title{Query trait data}
\usage{
query.traits(spstr, priors, con = NULL)
}
\arguments{
\item{spstr}{string of species id's from trait database}

\item{priors}{vector of parameters for which priors have been specified}

\item{con}{}
}
\value{
dataframe with trait data
}
\description{
Query available trait data associated with a given pft and a list of traits
}
\examples{
\dontrun{
species <- query.pft_species('ebifarm.c4crop')
spstr <- vecpaste(species$id)
trvec <- c('leafN', 'SLA')
trait.data <- query.traits(spstr, trvec)
}
}
\author{
David LeBauer, Carl Davidson, Shawn Serbin
}
\seealso{
\code{\link{query.trait.data}}
}

