% Generated by roxygen2 (4.0.1): do not edit by hand
\name{derive.trait}
\alias{derive.trait}
\title{Performs an arithmetic function, FUN, over a series of traits and returns the result as a derived trait.}
\usage{
derive.trait(FUN, ..., input = list(...), var.name = NA,
  sample.size = 100000)
}
\arguments{
\item{FUN}{arithmetic function}

\item{...}{traits that will be supplied to FUN as input}

\item{sample.size}{number of random samples generated by rnorm for normally distributed trait input}
}
\value{
a copy of the first input trait with mean, stat, and n reflecting the derived trait
}
\description{
Performs an arithmetic function, FUN, over a series of traits and returns
the result as a derived trait.
Traits must be specified as either lists or single row data frames,
and must be either single data points or normally distributed.
In the event one or more input traits are normally distributed,
the resulting distribution is approximated by numerical simulation.
The output trait is effectively a copy of the first input trait with
modified mean, stat, and n.
}
\examples{
input <- list(x = data.frame(mean = 1, stat = 1, n = 1))
derive.trait(FUN = identity, input = input, var.name = 'x')
}

