% Generated by roxygen2 (4.0.1): do not edit by hand
\name{dbfile.file}
\alias{dbfile.file}
\alias{dbfile.id}
\title{Return file from the dbfiles tables}
\usage{
dbfile.file(type, id, con, hostname = fqdn())

dbfile.id(type, file, con, hostname = fqdn())
}
\arguments{
\item{type}{the type of dbfile (Input, Posterior)}

\item{id}{the id of container type}

\item{con}{database connection object}

\item{hostname}{the name of the host where the file is stored, this will default to the name of the current machine}

\item{type}{the type of dbfile (Input, Posterior)}

\item{file}{the full pathname to the file}

\item{con}{database connection object}

\item{hostname}{the name of the host where the file is stored, this will default to the name of the current machine}
}
\value{
filename on host, or NA if none found

filename on host, or NA if none found
}
\description{
Function to return full path to a file using dbfiles table

Function to return id to containter type given a filename.
}
\details{
This will check the dbfiles and machines to see if the file exists,
and return the full filename with path to the first one found. If
none is found it will return NA.

This will check the dbfiles and machines to see if the file exists,
and return the id of the container type of the first one found. If
none is found it will return NA.
}
\examples{
\dontrun{
  dbfile.file('Input', 7, dbcon)
}
\dontrun{
  dbfile.id('Model', '/usr/local/bin/sipnet', dbcon)
}
}
\author{
Rob Kooper

Rob Kooper
}

