% Generated by roxygen2 (4.0.1): do not edit by hand
\name{dbfile.check}
\alias{dbfile.check}
\alias{dbfile.input.check}
\alias{dbfile.posterior.check}
\title{Check for a file in the input/dbfiles tables}
\usage{
dbfile.input.check(siteid, startdate, enddate, mimetype, formatname,
  parentid = NA, con, hostname = fqdn())

dbfile.posterior.check(pft, mimetype, formatname, con, hostname = fqdn())

dbfile.check(type, id, con, hostname = fqdn())
}
\arguments{
\item{siteid}{the id of the site that this data is applicable to}

\item{startdate}{the start date of the data stored in the file}

\item{enddate}{the end date of the data stored in the file}

\item{mimetype}{the mime-type of the file}

\item{formatname}{the name of the format to distinguish between simmilair mime-types}

\item{parent}{the id of the parent of the input}

\item{con}{database connection object}

\item{hostname}{the name of the host where the file is stored, this will default to the name of the current machine}

\item{params}{database connection information}

\item{pft}{the name of the pft that this data is applicable to}

\item{mimetype}{the mime-type of the file}

\item{formatname}{the name of the format to distinguish between simmilair mime-types}

\item{con}{database connection object}

\item{hostname}{the name of the host where the file is stored, this will default to the name of the current machine}

\item{params}{database connection information}

\item{type}{the type of dbfile (Input, Posterior)}

\item{id}{the id of container type}

\item{con}{database connection object}

\item{hostname}{the name of the host where the file is stored, this will default to the name of the current machine}
}
\value{
data.frame with the id, filename and pathname of the input that is requested

data.frame with the id, filename and pathname of the posterior that is requested

data.frame with the id, filename and pathname of all the files that are associated
}
\description{
Function to check to see if a file exists in the dbfiles table as an input

Function to check to see if a file exists in the dbfiles table as an input

Function to check to see if a file exists in the dbfiles table
}
\details{
This will check the dbfiles, inputs, machines and formats tables to see if the
file exists

This will check the dbfiles, inputs, machines and formats tables to see if the
file exists

This will check the dbfiles and machines to see if the file exists
}
\examples{
\dontrun{
  dbfile.input.check(siteid, startdate, enddate, 'application/x-RData', 'traits', dbcon)
}
\dontrun{
  dbfile.posterior.check(pft, 'application/x-RData', 'traits', dbcon)
}
\dontrun{
  dbfile.check('Input', 7, dbcon)
}
}
\author{
Rob Kooper

Rob Kooper

Rob Kooper
}

