%% Figure 2

load PreferenceResults_All.mat

% First of all, flip all of the responses so they're in the same order
% Always have the lowest one first
for n = 1:length(results)    
    if results(n,6) > results(n,7)
        % Switch
        results(n,6:7) = fliplr(results(n,6:7));
        results(n,8) = 0 - results(n,8);
        results(n,9) = 0 - results(n,9);
    end  
end

figure;

% Setup exp/inexp
pos{2} = 1:7;
pos{1} = 8:15;

for subtype = [2 1]

    useresults = results;
    
    hbp = boxplot(useresults(:,8),[useresults(:,2) useresults(:,1)],'color','k','factorseparator',[1],'notch','on');
    grid on

    clear useresults
    
end

% Setup
xlabel('Participant');
ylabel('Preference score');


set(gca,'xtick',1:15,'XTickLabel',{'I1','I2','I3','I4','I5','I6','I7','I8','E1','E2','E3','E4','E5','E6','E7'})
set(hbp,'linewidth',2)


cm = colormap(lines(2));

% Colours
C = [1 1 1 1 1 1 1 1 2 2 2 2 2 2 2];
for n = 1:15
    set(hbp(:,n),'color',cm(C(n),:)) 
end

%% Figure 3
% Mean absolute difference: individual subjects (all programme items)
% Standardised

load Replicate_Design
load PreferenceResults_All

% First of all, flip all of the responses so they're in the same order
% Always have the lowest one first
for n = 1:length(results)    
    if results(n,6) > results(n,7)
        % Switch
        results(n,6:7) = fliplr(results(n,6:7));
        results(n,8) = 0 - results(n,8);
        results(n,9) = 0 - results(n,9);
    end  
end

% Then, scale the scores
%allzresults = [];
allscaleresults = [];
%allnormresults = [];
for n = 1:15    % For each subject
        
    % Get the reuslts
    subresults = results(results(:,1)==n,8);
    
    % Standardise
    %zresults = zscore(subresults);
    
    % Scale rather than standardise
    scaleresults = subresults / std(subresults);
    
    % Normalise to +-50 instead
    %normresults = (50/max(abs(subresults))) * subresults;
    
    % Concatenate
    %allzresults = [allzresults; zresults];
    allscaleresults = [allscaleresults; scaleresults];
    %allnormresults = [allnormresults; normresults];
    
    % Clearup
    clear subresults zresults scaleresults %normresults
    
end

% Add standardised results to results
results = [results allscaleresults];

% Set results variable
resvar = 10;            % Scaled = 10, Raw = 8
resvar_NS = 8;

thereps = [29 30 31];

for sub = 1:15      % For each subject
    
    % Initialise variables
    count = 1;                  % Counter
    subdata{sub} = [];          % Results 
    isswitch{sub} = [];
    
    % Isolate the data
    usedata = results(results(:,1)==sub,:);
    
    for prog = 1:7   % For each programme
        
        usedata_prog = usedata(usedata(:,3)==prog,:);
        
        for rep = 1:3   % For replicate 1, 2, and 3
            
            % Determine the stimulus number
            repno = replicates(rep,prog);
            
            % Get the results for the two versions
            trial1 = usedata_prog(usedata_prog(:,5)==repno,:);
            trial2 = usedata_prog(usedata_prog(:,5)==thereps(rep),:);
            
            % Store the two scores and the difference
            subdata{sub}(count,:) = [trial1(resvar) trial2(resvar) (trial1(resvar)-trial2(resvar))];
            
            % Do the same thing for the  non-standardised version
            subdata_NS{sub}(count,:) = [trial1(resvar_NS) trial2(resvar_NS) (trial1(resvar_NS)-trial2(resvar_NS))];

            
            % % Store whether it's a switch or not
            if trial1(9) ~= trial2(9)   % Then it's reversed
                isswitch{sub}(count,1) = 1;
            else
                isswitch{sub}(count,1) = 0;
            end
                        
            count = count + 1;      % Increment count
            clear trial1 trial2     % Cleanup
        end

    end
    
end


for n = 1:length(subdata)
    
    % Get the differences
    diffs = subdata{n}(:,3);
    
    % Take the absolute 
    diffs = abs(diffs);
    
    % Take the mean
    [cis(n),means(n)] = ConfInt_TDist(diffs',0.95,'tdist');
    
end

% Grand mean & stdev
all_mean = mean(means);
all_std = std(means);

% Order the data
isexperienced = [2 4 5 6 11 12 15]';
isinexperienced = [1 3 7 8 9 10 13 14]';

subnumbers{2} = isexperienced;
subnumbers{1} = isinexperienced;
startpos = [1 length(subnumbers{1})+1];
startoffset = [0 0];

% Draw the figure
figure
hax = axes;     % Handle needed to add piecharts later
hold on


%Plot
heb = errorbar([means(subnumbers{1}) means(subnumbers{2})],[cis(subnumbers{1}) cis(subnumbers{2})],'kx','linewidth',2,'color',0*[1 1 1]);


% Add mean and stdev lines
plot([0 16+startoffset(2)],[all_mean all_mean],'linewidth',2,'color',0.45*[1 1 1]);

% Setup
grid on
set(gca,'XTick',1:length([means(subnumbers{1}) means(subnumbers{2})]),'XTickLabel',{'I1','I2','I3','I4','I5','I6','I7','I8','E1','E2','E3','E4','E5','E6','E7'})
set(gca,'XLim',[0 16+startoffset(2)])

xlabel('Participant');
ylabel('Mean absolute difference (scaled)');

%%% Percentage
% Calculate the percentages
for n = 1:length(isswitch)
    % Calculate the number of reversals
    rev(n) = sum(isswitch{n});
    notrev(n) = 21 - rev(n);
end

% Reorder by subject type
rev = [rev(isinexperienced) rev(isexperienced)];
notrev = [notrev(isinexperienced) notrev(isexperienced)];

% Get reversed percentage
rev_pct = rev ./ (rev+notrev) * 100;

%%% PLOT THE PIE CHARTS
% Get pie data
pie_data = [rev; notrev]';
% Make blank labels:
for n = 1:size(pie_data,2), pielabels{n} = ''; end
% Set size
piesize = 0.1;
% Set x positions
x_pos = 1:15;
% Set y positions
theypos = 1.35;
y_pos = repmat(theypos,1,15);
% Draw the pies
OverlayPie(hax,pie_data,x_pos,y_pos,piesize,pielabels);
% Set colours
colormap(bone)

%%% ADD TEXT LABELS
for n = 1:15
    text(n,1.475,sprintf('%2.0f%%',rev_pct(n)),'parent',hax,'horizontalalignment','center','fontsize',20)
end


%%% Extra analysis suggested by reviewer
% Percentage of judgements that changed by more than a certain percentage
% of the scale

scale_pct = 10;

for n = 1:length(subdata_NS)
    change_pct(n) = (sum(abs(subdata_NS{n}(:,3))>=scale_pct) / length(subdata_NS{n})) * 100;
end

% Reorder by participant types
change_pct = change_pct([isinexperienced; isexperienced]);

% Correlation of this with pct reversed judgements
figure
scatter(change_pct,rev_pct)
lsline
grid on
xlabel(sprintf('Percentage of repeats with difference greater than %2.1f%% of the scale',scale_pct));
ylabel('Percentage reversed judgements');
offset = 0.1;
for n = 1:length(change_pct)
  text(change_pct(n)+offset,rev_pct(n)+offset,sprintf('P%i',n));
end

%% Figure 4
% Mean absolute difference (across replicate number)

load Replicate_Design
load PreferenceResults_All

% First of all, flip all of the responses so they're in the same order
% Always have the lowest one first
for n = 1:length(results)
    if results(n,6) > results(n,7)
        % Switch
        results(n,6:7) = fliplr(results(n,6:7));
        results(n,8) = 0 - results(n,8);
        results(n,9) = 0 - results(n,9);
    end
end

% Then, scale the scores
%allzresults = [];
allscaleresults = [];
%allnormresults = [];
for n = 1:15    % For each subject
        
    % Get the reuslts
    subresults = results(results(:,1)==n,8);
    
    % Standardise
    %zresults = zscore(subresults);
    
    % Scale rather than standardise
    scaleresults = subresults / std(subresults);
    
    % Normalise to +-50 instead
    %normresults = (50/max(abs(subresults))) * subresults;
    
    % Concatenate
    %allzresults = [allzresults; zresults];
    allscaleresults = [allscaleresults; scaleresults];
    %allnormresults = [allnormresults; normresults];
    
    % Clearup
    clear subresults zresults scaleresults %normresults
    
end

% Add standardised results to results
results = [results allscaleresults];

% Set results variable
resvar = 10;            % Scaled = 10, Raw = 8

% Initialise
count = 1;
thereps = [29 30 31];


for prog = 1:7   % For each programme
    
    usedata = results(results(:,3)==prog,:);
    
    for rep = 1:3   % For replicate 1, 2, and 3
        
        % Determine the stimulus number
        repno = replicates(rep,prog);
        
        % Get the results for the two versions
        trial1 = usedata(usedata(:,5)==repno,:);
        trial2 = usedata(usedata(:,5)==thereps(rep),:);
        
        % Store the difference
        res{count} = trial1(:,resvar) - trial2(:,resvar);
        
        % Get the trial number and programme item for replicate 1-21
        rep_details(count,:) = [trial1(1,[3 6 7])];
        
        % Store if it's a reversal
        for n = 1:size(trial1,1)
            
            if trial1(n,9) ~= trial2(n,9)   % Then it's changed
                isswitch{count}(n) = 1;         % Set as 1
            else                            % Otherwise, it's not changed
                isswitch{count}(n) = 0;         % Set as 0
            end
            
        end
        
        count = count + 1;      % Increment count
        clear trial1 trial2     % Cleanup
    end
        
end

% Process the results
for n = 1:length(res)
    
    % Take the absolute 
    diffs = abs(res{n});
    
    % Take the mean
    [cis(n),means(n)] = ConfInt_TDist(diffs',0.95,'tdist');
    
    % Cleanup
    clear diffs
    
end

% Grand mean & stdev
all_mean = mean(means);
all_std = std(means);

figure
hax = axes; % Handle needed for adding pies
hold on


% Plot errorbars
heb = errorbar(means,cis,'kx','linewidth',2,'color',0*[1 1 1]);

% Add mean and stdev lines
plot([0 22],[all_mean all_mean],'linewidth',2,'color',0.45*[1 1 1]);

% Setup
grid on
set(gca,'XTick',1:21) 
set(gca,'XLim',[0 22])

xlabel('Replicate number');
ylabel('Mean absolute difference (scaled)');

%%% Percentage changed
% Calculate the percentages
for n = 1:length(isswitch)
    % Calculate the number of reversals
    rev(n) = sum(isswitch{n});
    notrev(n) = length(isswitch{n}) - rev(n);
end

% Calculate the percentage
rev_pct = (rev ./ (rev+notrev)) * 100;


%%% PLOT THE PIE CHARTS
% Get pie data
pie_data = [rev; notrev]';
% Make blank labels:
for n = 1:size(pie_data,2), pielabels{n} = ''; end
% Set size
piesize = 0.075;
% Set x positions
x_pos = 1:21;
% Set y positions
theypos = 1.35;
y_pos = repmat(theypos,1,length(x_pos));
% Draw the pies
OverlayPie(hax,pie_data,x_pos,y_pos,piesize,pielabels);
% Set colours
colormap(bone(2))

%%% ADD TEXT LABELS
for n = 1:length(rev_pct)
    text(n,1.45,sprintf('%2.0f%%',rev_pct(n)),'parent',hax,'horizontalalignment','center','fontsize',20)
end

%% Overall circular error ratio

do.getdata = 1;

% Load data
load PreferenceResults_All
load Replicate_Design

if do.getdata
    
    % First of all, flip all of the responses so they're in the same order
    % Always have the lowest one first
    for n = 1:length(results)
        if results(n,6) > results(n,7)
            % Switch
            results(n,6:7) = fliplr(results(n,6:7));
            results(n,8) = 0 - results(n,8);
            results(n,9) = 0 - results(n,9);
        end
    end
    
    % Preallocate
    newresults = [];
    
    %%% REMOVE ALL REPEATS
    for sub = 1:15
        
        % Get results for each subject
        subresults = results(results(:,1)==sub,:);
        
        for prog = 1:7
            
            % Get results for each prog (and subject)
            progresults = subresults(subresults(:,3)==prog,:);
            
            % Sort by page (i.e. in the order of doing the test)
            progresults = sortrows(progresults,4);
            
            % Get (the newly ordered) trials
            trials = progresults(:,5);
            
            % Preallocate toremove
            toremove = zeros(3,1);
            
            for rep = [29 30 31]     % For each rep
                
                if find(trials==rep) > find(trials==replicates(rep-28,prog))
                    % If the replicate trial position is higher than the
                    % original (i.e. original happens first), remove the replicate
                    toremove(rep-28) = find(trials==rep);
                else % If the replicate trial position is smaller (i.e. it happens first)
                    % remove the non-replicate
                    toremove(rep-28) = find(trials==replicates(rep-28,prog));
                end
                
            end
            
            % Remove identified rows
            progresults(toremove,:) = [];
            
            % Concatenate into results
            newresults = [newresults; progresults];
            
            % Cleanup
            clear progresults toremove
            
        end
        
        % Cleanup
        clear subresults
        
    end
    
    % Then, scale scores (NOT z-scores ?no mean centering)
    allscaleresults = [];
    for n = 1:15    % For each subject
        
        % Get the reuslts
        subresults = newresults(newresults(:,1)==n,8);
 
        % Scale scores
        scaleresults = subresults / std(subresults);
        
        % Concatenate
        %allzresults = [allzresults; zresults];
        allscaleresults = [allscaleresults; scaleresults];
        
        % Clearup
        clear subresults scaleresults %zresults
        
    end
    
    % Add standardised results to results
    newresults = [newresults allscaleresults];
    
    results = newresults; clear newresults
    
    % %% Get count matrices
    for sub = 1:15 % for each subject
        
        usedata = results(results(:,1)==sub,:);  % Get the subject's data
        
        for prog = 1:7 % for each programme
            
            % Get data
            usedata_prog = usedata(usedata(:,3)==prog,:);
            
            % Preallocate
            count{sub}{prog} = zeros(8,8);
            bincount{sub}{prog} = zeros(8,8);
            
            for n = 1:length(usedata_prog) % For each item
                stimA = usedata_prog(n,6);  % Trial A
                stimB = usedata_prog(n,7);  % Trial B
                score = usedata_prog(n,10); % Std score
                choice = usedata_prog(n,9); % Decision
                
               
                % Add to matrix (yes/no)
                if choice == -1     % stimA is preferred
                    bincount{sub}{prog}(stimA,stimB) = 1;
                    count{sub}{prog}(stimA,stimB) = abs(score);
                elseif choice == 1  % stimB is preferred
                    bincount{sub}{prog}(stimB,stimA) = 1;
                    count{sub}{prog}(stimB,stimA) = abs(score);
                elseif choice == 0  % There's no preference
                    bincount{sub}{prog}(stimA,stimB) = 0.5;
                    bincount{sub}{prog}(stimB,stimA) = 0.5;
                end
                
                % Cleanup
                clear stimA stimB choice score
                
                
            end % each test item
            
            
            % Cleanup
            clear usedata_prog
            
        end
        
        
        % Cleanup
        clear usedata
        
    end
    
    % %% Get circular error rates
    
    % Calculate every possible triad
    perms = nchoosek(1:8,3);
    
    % Preallocate
    CER = zeros(7,15); % Progs in rows, subs in cols
    
    for sub = 1:15          % Subject
        
        for prog = 1:7          % Programme
            
            for n = 1:length(perms)         % Each triad
                A = perms(n,1);
                B = perms(n,2);
                C = perms(n,3);
                
                % score1: A vs B
                % score2: B vs C
                % score3: C vs A
                score1 = bincount{sub}{prog}(A,B);
                score2 = bincount{sub}{prog}(B,C);
                score3 = bincount{sub}{prog}(C,A);
                
                % Check transitivity
                if score1 == 1 && score2 == 1 && score3 ~= 0
                    % Intransitive
                    CER(prog,sub) = CER(prog,sub) + 1;
                elseif score1 == 0 && score2 == 0 && score3 ~= 1
                    % Also intransitive
                    CER(prog,sub) = CER(prog,sub) + 1;
                end
            end % triads
        end % progs
    end % subs
    
else % Load data
    load circular_error_ratio.mat
end %getdata





% Colours
usecolours = bone(2);

% %% Circular error ratio for each subject

perms = nchoosek(1:8,3); % Calculate every possible triad
num_triads = 7 * length(perms); % Total number of triads

CER_pct = (sum(CER,1) / num_triads) * 100;

isexperienced = [2 4 5 6 11 12 15]';
isinexperienced = [1 3 7 8 9 10 13 14]';

subnumbers{1} = isinexperienced;
subnumbers{2} = isexperienced;
startpos = [1 length(subnumbers{1})+1];
startoffset = [0 0.5];

usestats{1} = CER_pct(:,isinexperienced);
usestats{2} = CER_pct(:,isexperienced);

% Plot bar chart
figure;
for type = 1:2;     % Inexperienced, experienced
    
    bar(startoffset(type)+startpos(type):startoffset(type)+startpos(type)+length(subnumbers{type})-1,... % This sets the X positions
        usestats{type},...              % Here are the stats
        'linewidth',2,...               % Linewidth
        'facecolor',usecolours(type,:)) % Colours

    hold all

end

% Plot means across subject type
for type = 1:2      % Inexperienced, experienced
    [cis(type),means(type)] = ConfInt_TDist(usestats{type},0.95,'tdist');
end

hold all

% Mean lines
plot([0.25 8.75],[means(1) means(1)],'linewidth',2,'color','k')
plot([8.75 16.25],[means(2) means(2)],'linewidth',2,'color','k')

% Upper CI lines
plot([0.25 8.75],means(1)+[cis(1) cis(1)],'--','linewidth',2,'color','k')
plot([8.75 16.25],means(2)+[cis(2) cis(2)],'--','linewidth',2,'color','k')

% Lower CI lines
plot([0.25 8.75],means(1)-[cis(1) cis(1)],'--','linewidth',2,'color','k')
plot([8.75 16.25],means(2)-[cis(2) cis(2)],'--','linewidth',2,'color','k')


set(gca,'XTick',[1:8 9.5:15.5],'XTickLabel',{'I1','I2','I3','I4','I5','I6','I7','I8','E1','E2','E3','E4','E5','E6','E7'})
set(gca,'XLim',[0 16.5])

grid on
xlabel('Participant')
ylabel('Circular error percentage (%)');

colormap(flipud(bone))


%%% Extra analysis after reviewer comments

% Calculate percentage of no preference judgements
for p = 1:length(bincount)
    d = cell2mat(bincount{p});
    d = d(:);
    
    no_pref_num(p) = sum(d==0.5);    % No preference = 0.5
    
    num_comparisons = length(nchoosek(1:8,2)) * 7;
    
    no_pref_pct = (no_pref_num ./ num_comparisons ) * 100;
    
end

% Make a scatter plot of CER pct against No pref pct
figure
scatter(no_pref_pct,CER_pct)

grid on
lsline, r = corrcoef(no_pref_pct,CER_pct);          % Calculate correlation
title(sprintf('Correlation r = %2.2f',r(2,1)));
xlabel('Pct no preference');
ylabel('Pct CER');

offset = 0.1;
for n = 1:length(bincount)
   text(no_pref_pct(n)+offset,CER_pct(n)+offset,sprintf('P%i',n)); 
end

%% Circular error rate by programme item

load circular_error_ratio.mat
load Preference_Results_Processed

% Subject types
isexperienced = [2 4 5 6 11 12 15]';
isinexperienced = [1 3 7 8 9 10 13 14]';

subnumbers{1} = isinexperienced;
subnumbers{2} = isexperienced;

% Conver CER to percentage
perms = nchoosek(1:8,3); % Calculate every possible triad
num_triads = length(perms); % Number of triads per programme

CER_pct = (CER / num_triads) * 100;

for type = 1:2 % Inexperienced, experienced
   
    % Get data from the subject type
    usedata = CER_pct(:,subnumbers{type});
   
    for prog = 1:7
        % Get means
        [cis(type,prog),means(type,prog)] = ConfInt_TDist(usedata(prog,:),0.95,'tdist');
    end
        
    % Cleanup
    clear usedata
    
end

% Plot bar chart
hbar = barwitherr(cis',means');

% Setup
set(hbar,'linewidth',2)
grid on
set(gca,'xticklabel',programmeitems)
colormap(bone);

xticklabel_rotate([],15)

ylabel('Circular error percentage (%)');

legend('Inexperienced','Experienced','location','north')

%% Preprocess and save results 

do.save = 0;
if do.save == 0
    display('NOTE: SAVING IS OFF')
end

load PreferenceResults_All
load Replicate_Design.mat

% First of all, flip all of the responses so they're in the same order
% Always have the lowest one first
for n = 1:length(results)
    if results(n,6) > results(n,7)
        % Switch
        results(n,6:7) = fliplr(results(n,6:7));
        results(n,8) = 0 - results(n,8);
        results(n,9) = 0 - results(n,9);
    end
end

% Preallocate
newresults = [];

%%% REMOVE ALL REPEATS
for sub = 1:15
    
    % Get results for each subject
    subresults = results(results(:,1)==sub,:);
    
    for prog = 1:7
        
        % Get results for each prog (and subject)
        progresults = subresults(subresults(:,3)==prog,:);
        
        % Sort by page (i.e. in the order of doing the test)
        progresults = sortrows(progresults,4);
        
        % Get (the newly ordered) trials
        trials = progresults(:,5);
        
        % Preallocate toremove
        toremove = zeros(3,1);
        
        for rep = [29 30 31]     % For each rep
           
            if find(trials==rep) > find(trials==replicates(rep-28,prog))
                % If the replicate trial position is higher than the
                % original (i.e. original happens first), remove the replicate
                    toremove(rep-28) = find(trials==rep);
            else % If the replicate trial position is smaller (i.e. it happens first)
                 % remove the non-replicate
                    toremove(rep-28) = find(trials==replicates(rep-28,prog));
            end
            
        end
        
        % Remove identified rows
        progresults(toremove,:) = [];
       
        % Concatenate into results
        newresults = [newresults; progresults];
        
        % Cleanup
        clear progresults toremove
        
    end
    
    % Cleanup
    clear subresults
    
end

% Then, scale scores (NOT z-scores -no mean centering)
allscaleresults = [];
for n = 1:15    % For each subject
    
    % Get the reuslts
    subresults = newresults(newresults(:,1)==n,8);
    
    % Standardise
    %zresults = zscore(subresults);
    
    % Scale scores
    scaleresults = subresults / std(subresults);
    
    % Concatenate
    %allzresults = [allzresults; zresults];
    allscaleresults = [allscaleresults; scaleresults];
    
    % Clearup
    clear subresults scaleresults %zresults
    
end

% Add standardised results to results
newresults = [newresults allscaleresults];



%%% Remove subject I2 (=subject 3)
newresults(newresults(:,1)==3,:) = [];

% Rename results
results = newresults;

% New info variable
info = '[Subject Experience ProgrammeItem Page Trial StimA StimB Score YesNoScore Standardised_Score]';

% Reproduction methods and programme items
programmeitems = {'Brass','Pop','BigBand','Jazz','Sport','Experimental','Film'};
repromethods = {'Headphones','LowQual','Mono','Stereo','5-chan','9-chan','22-chan','Cuboid'};

% Save
if do.save
    save('Preference_Results_Processed.mat','results','info','programmeitems','repromethods');
end

%% Figure 5
%%% Preference scale using scores, all stimuli, with bootstrapping

clear

% Set bootstrap options
numreps = 50; % Number of bootstraps
include = 25; % Number of items (selected at random) to include

randstate = rng('shuffle');     % Reset the random number generator

% Load the results
load Preference_Results_Processed


% Preallocate the matrix (for each type of subject)
counts{1} = cell(8,8);
counts{2} = cell(8,8);

types = {'Inexperienced','Experienced'};


for subtype = 1:2
    
    % Get the results
    useresults = results(results(:,2)==subtype-1,:);
    
    % Step through the results and alter the counts
    for n = 1:length(useresults)
        
        % Get data
        stimA = useresults(n,6);   % Stim A number
        stimB = useresults(n,7);   % Stim B number
        score = useresults(n,8);   % Preference score (-50=A, +50=B)
        pref = useresults(n,9);    % Preference decision (-1=A, +1=B, 0=None)
        score_std = useresults(n,10);   % Preference score (standardised)
        
        % Update matrix (regardless of the result)
        counts{subtype}{stimA,stimB} = [counts{subtype}{stimA,stimB}; score_std];
        
        % Cleanup
        clear stimA stimB score pref
        
    end
    
    % Cleanup
    clear useresults
    
end

% %% For each repeat

for subtype = 1:2
    
    for n = 1:numreps
        
        for stimA = 1:8
            for stimB = 1:8
                
                % Get the data
                usedata = counts{subtype}{stimA,stimB};
                if isempty(usedata), continue, end
                
                % Randomly select items
                [~,randuse] = sort(rand(49,1));     % Randomly sort 1-49
                randuse = randuse(1:include);       % Select the first 'include' (25) points
                usedata = usedata(randuse);         % Get only those points from the data
                
                % Go through the data and generate a new count matrix for
                % each repeat. The count is the sum of the absolute
                % preference ratings for that particular stimulus
                % combination
                newcount{subtype}{n}(stimA,stimB) = abs(sum(usedata(usedata<0))); 
                newcount{subtype}{n}(stimB,stimA) = abs(sum(usedata(usedata>0))); 
                                
                % Cleanup
                clear usedata randuse
                
            end
        end
        
    end
     
end

% %% Do the scaling for each counts matrix

% Edit the counts so that there's a minimum of 0.5
mini = norminv(0.5+(0.5/include)); % This is the equivalent standardised score (normal distribution) to 0.5/include
for sub = 1:2                 % For subject type
    for n = 1:numreps         % For num reps
        for a = 1:8             
            for b = 1:8
                if a==b, continue, end
                if newcount{sub}{n}(a,b) == 0;
                    newcount{sub}{n}(a,b) = mini;
                    newcount{sub}{n}(b,a) = newcount{sub}{n}(b,a) - mini;
                end
            end
        end
        
        %%% Do the Thurstone scaling
        % Empirical probabilities
        % Manually set N so be the number of items * the maximum scale
        % value
        maxscaleval = max(abs(results(:,10))); 
        N = (maxscaleval*include) * ones(8,8);
        P = newcount{sub}{n} ./ (N + (N==0));     % Avoid divide by zero
        P(eye(size(newcount{sub}{n},1))>0) = 0.5; % Set diagonals to have p=0.5
        
        % Calculate the scale
        Z = norminv(P);
        S{sub}{n} = -mean(Z,1)';        
        
        % Cleanup
        clear N P Z
        
    end
end

% Normalise the scale results
allscale = [cell2mat(S{1}); cell2mat(S{2})];
Sall = (allscale - min(allscale(:))) / range(allscale(:));

% Put into the scale vecs
scale{1} = Sall(1:8,:);
scale{2} = Sall(9:end,:);

% Take mean and CIs
for sub = 1:2
    for n = 1:8
        usedata = scale{sub}(n,:);
        [cis{sub}(n),means{sub}(n)] = ConfInt_TDist(usedata,0.95,'normal');
        clear usedata
    end
end


Means = [means{1}; means{2}]';
CIs = [cis{1}; cis{2}]';

% Sort the values
[Means,I] = sortrows(Means,2);
CIs = CIs(I,:);

% Plot the bar
figure
[hbar,heb] = barwitherr(CIs,Means);
set(hbar,'linewidth',2); % Linewidth for bars
set(heb,'linewidth',1)   % Linewidth for errorbars

% Setup
set(gca,'xtick',1:8,'xticklabel',repromethods(I))
grid on
xlabel('Reproduction method');
ylabel('Mean normalized scale value');
for n = 1:length(types), leglabels{n} = [types{n} ' listeners']; end        % Append 'listeners' to legend labels
legend(leglabels,'location','northwest')

set(gca,'XLim',[0 9])
xticklabel_rotate([],15)

%% Figure 6
% Preference scale using scores, broken down by repro method, visualised by intersecting lines
% Lines are colour-coded by repro method, with prog item on the x-axis

% Cleanup first
clear

% Set bootstrap options
numreps = 1; % Number of bootstraps
include = 7; % Number of items (selected at random) to include

randstate = rng('shuffle');     % Reset the random number generator

% Load the results
load Preference_Results_Processed

% Preallocate the matrix (for each type of subject)
counts = cell(2,1);

types = {'Inexperienced','Experienced'};


for subtype = 1:2
    
    % Get the results
    useresults_sub = results(results(:,2)==subtype-1,:);
    
    % Preallocate
    counts{subtype} = cell(7,1);
    
    for prog = 1:7
        
        % Get the results
        useresults = useresults_sub(useresults_sub(:,3)==prog,:);
        
        % Preallocate
        counts{subtype}{prog} = cell(8,8);
        
        % Step through the results and alter the counts
        for n = 1:length(useresults)
            
            % Get data
            stimA = useresults(n,6);   % Stim A number
            stimB = useresults(n,7);   % Stim B number
            score = useresults(n,8);   % Preference score (-50=A, +50=B)
            pref = useresults(n,9);    % Preference decision (-1=A, +1=B, 0=None)
            score_std = useresults(n,10);   % Preference score (standardised)
            
            % Update matrix (regardless of the result)
            counts{subtype}{prog}{stimA,stimB} = [counts{subtype}{prog}{stimA,stimB}; score_std];
            
            % Cleanup
            clear stimA stimB score pref
            
        end % each result
        
        % Cleanup
        clear useresults
        
    end % prog
    
    % Cleanup
    clear useresults_sub
    
end % subject type


% Preallocate
newcount = cell(2,1);

% %% Do the bootstrapping
for subtype = 1:2   % for each subject type
    
    % Preallocate
    newcount{subtype} = cell(numreps,1);
    
    for n = 1:numreps % for each bootstrap
        
        % Preallocate
        newcount{subtype}{n} = cell(7,1);
        
        for prog = 1:7  % For each programme item
            
            for stimA = 1:8
                for stimB = 1:8
                    
                    % Get the data
                    usedata = counts{subtype}{prog}{stimA,stimB};
                    if isempty(usedata), continue, end
                    
                    % Randomly select items
                    [~,randuse] = sort(rand(7,1));     % Randomly sort 1-7
                    randuse = randuse(1:include);       % Select the first 'include' points
                    usedata = usedata(randuse);         % Get only those points from the data
                    
                    % Go through the data and generate a new count matrix for
                    % each repeat. The count is the sum of the absolute
                    % preference ratings for that particular stimulus
                    % combination
                    newcount{subtype}{n}{prog}(stimA,stimB) = abs(sum(usedata(usedata<0))); 
                    newcount{subtype}{n}{prog}(stimB,stimA) = abs(sum(usedata(usedata>0))); 
                    
                    % Cleanup
                    clear usedata randuse
                    
                end % stimB
            end % stimA
            
        end % prog
        
    end % Bootstrap iterations
    
end %Subtype

% %% Do the scaling for each counts matrix

% Edit the counts so that there's a minimum of 0.5
mini = norminv(0.5+(0.5/include)); % This is the equivalent standardised score (normal distribution) to 0.5/include, which is what was added in the other case
for sub = 1:2                 % For subject type
    for prog = 1:7            % For programme item
        for n = 1:numreps         % For num reps
            for a = 1:8
                for b = 1:8
                    if a==b, continue, end
                    if newcount{sub}{n}{prog}(a,b) == 0 && newcount{sub}{n}{prog}(b,a) == 0;    
                        % If both are 0, i.e., there's never a preference between the two... they should be equally likely.
                        % The weights should be equal, and proportional to
                        % the general level of preference for the stimuli.
                        % So, use half of the row-wise average for the two
                        % stimuli in question
                        
                        newcount{sub}{n}{prog}(a,b) = mini;
                        newcount{sub}{n}{prog}(b,a) = mini;
                    elseif newcount{sub}{n}{prog}(a,b) == 0; % Else, if only 1 of them is zeor.
                        newcount{sub}{n}{prog}(a,b) = mini;
                        newcount{sub}{n}{prog}(b,a) = newcount{sub}{n}{prog}(b,a) - mini;
                    end 
                end %stimB
            end % stimA
        end % Bootstrap iterations 
        
        %%% Do the Thurstone scaling
        % Empirical probabilities
        % Manually set N so be the number of items * the maximum scale
        % value
        maxscaleval = max(abs(results(:,10)));
        N = (maxscaleval*include) * ones(8,8);
        P = newcount{sub}{n}{prog} ./ (N + (N==0));     % Avoid divide by zero
        P(eye(size(newcount{sub}{n}{prog},1))>0) = 0.5; % Set diagonals to have p=0.5
        
        % Calculate the scale
        Z = norminv(P);
        S{sub}{n}{prog} = -mean(Z,1)';
               
        % Cleanup
        clear N P Z
        
    end % Programme
end % Subtype

% %% Normalise the scale results
allscale = [cell2mat(S{1}{1}); cell2mat(S{2}{1})];
Sall = (allscale - min(allscale(:))) / range(allscale(:));

% Put into the scale vecs
scale{1} = Sall(1:8,:);
scale{2} = Sall(9:end,:);


% %% Make the plots

% Set the order to be the same as in previous plots
order = [2 3 8 1 4 7 5 6];

for subtype = 1:2   % For each subject type
    
    %%%% DRAW AS A LINE PLOT
    h_line(subtype) = figure;
    
    usedata{subtype} = scale{subtype}(order,:)';
    
    do.offset = 1;
    offsetorder = [4 5 3 6 2 7 1 8];
    
    if do.offset
        offsetsize = 0.2;    
        offsets = -offsetsize/2:offsetsize/7:offsetsize/2;
        offsets = offsets(offsetorder);
    else
        offsets = zeros(1,8);
    end
    
    % Loop through 
    for repro = 1:size(usedata{subtype},2)
       
        h_plot(repro) = plot((1:7)+offsets(repro),usedata{subtype}(:,repro),'x--','linewidth',2);
        hold all
        
    end
    
    
    % Line colours + marker styles
    mycm = bone(12);  % Get 12 items (use the first 8 so they're darker)
    mycm = mycm/max(mycm(:)); % Normalise to 1
       
    mycm = flipud(mycm);
    
    markerstyles = {'+','o','x','s','d','^','v','*'};    
    
    for n = 1:length(h_plot)
        set(h_plot(n),'color',mycm(offsetorder(n)+4,:),'marker',markerstyles{n},'markersize',8)
    end
    
    % Add text labels for each line
    shortlabs = {'HP','LQ','M','St','5','9','22','Cu'};
   
    textoffset{1}.x = 0.15*[1 1 1 1 1 1 0.75 1];
    textoffset{1}.y = 0.02*[1 1 1 -1 -1 1 2 0];
    textoffset{2}.x = 0.15*[1 1 1 1 1 1 1 1];
    textoffset{2}.y = 0.02*[1 1 1 -1 2 1 1 -0.5];
    for repro = 1:size(usedata{subtype},2)
        text(7+textoffset{subtype}.x(repro)+offsets(repro),usedata{subtype}(end,repro)+textoffset{subtype}.y(repro),shortlabs(order(repro)));   
    end
        
    % Setup
    grid on
    set(gca,'xtick',1:length(programmeitems),'xticklabel',programmeitems)
    legend(repromethods(order),'location','EastOutside')        % 'EastOutside'
    colormap(flipud(bone))
    offset = 0.5;
    set(gca,'XLim',[offset length(programmeitems)+offset])
    xticklabel_rotate([],15)
    xlabel('Programme item');
    ylabel('Normalized preference');

    %%% KENDALL'S COEFFICIENT OF CONCORDANCE
    % How much do the rank orders agree?
    
    % Get ranks from data
    % tiedrank returns ranks for the columns; transpose is needed to get
    %  ranks for each row (http://stackoverflow.com/questions/3506056/apply-function-to-all-rows)    
    ranks{subtype} = tiedrank(usedata{subtype}')';  
    
    % Transpose so repro methods are in rows, stimuli in columns (as
    % required by KendallCoef)
    ranks{subtype} = ranks{subtype}';
    
    % Calculate Kendall's w
    kendall(subtype) = KendallCoef(ranks{subtype});
    

end % subtype

%% Figure 7

% Cleanup first
clear

% Set bootstrap options
numreps = 1; %50; 
include = 7; %25; 

randstate = rng('shuffle');     % Reset the random number generator

% Load the results
load Preference_Results_Processed

% Set colours
mycm = bone(2);

% Preallocate the matrix (for each type of subject)
counts = cell(2,1);

types = {'Inexperienced','Experienced'};


for subtype = 1:2
    
    % Get the results
    useresults_sub = results(results(:,2)==subtype-1,:);
    
    % Preallocate
    counts{subtype} = cell(7,1);
    
    for prog = 1:7
        
        % Get the results
        useresults = useresults_sub(useresults_sub(:,3)==prog,:);
        
        % Preallocate
        counts{subtype}{prog} = cell(8,8);
        
        % Step through the results and alter the counts
        for n = 1:length(useresults)
            
            % Get data
            stimA = useresults(n,6);   % Stim A number
            stimB = useresults(n,7);   % Stim B number
            score = useresults(n,8);   % Preference score (-50=A, +50=B)
            pref = useresults(n,9);    % Preference decision (-1=A, +1=B, 0=None)
            score_std = useresults(n,10);   % Preference score (standardised)
            
            % Update matrix (regardless of the result)
            counts{subtype}{prog}{stimA,stimB} = [counts{subtype}{prog}{stimA,stimB}; score_std];
            
            % Cleanup
            clear stimA stimB score pref
            
        end % each result
        
        % Cleanup
        clear useresults
        
    end % prog
    
    % Cleanup
    clear useresults_sub
    
end % subject type


% Preallocate
newcount = cell(2,1);

% %% Do the bootstrapping
for subtype = 1:2   % for each subject type
    
    % Preallocate
    newcount{subtype} = cell(numreps,1);
    
    for n = 1:numreps % for each bootstrap
        
        % Preallocate
        newcount{subtype}{n} = cell(7,1);
        
        for prog = 1:7  % For each programme item
            
            for stimA = 1:8
                for stimB = 1:8
                    
                    % Get the data
                    usedata = counts{subtype}{prog}{stimA,stimB};
                    if isempty(usedata), continue, end
                    
                    % Randomly select items
                    [~,randuse] = sort(rand(7,1));     % Randomly sort 1-7
                    randuse = randuse(1:include);       % Select the first 'include' (25) points
                    usedata = usedata(randuse);         % Get only those points from the data
                    
                    % Go through the data and generate a new count matrix for
                    % each repeat. The count is the sum of the absolute
                    % preference ratings for that particular stimulus
                    % combination
                    newcount{subtype}{n}{prog}(stimA,stimB) = abs(sum(usedata(usedata<0))); 
                    newcount{subtype}{n}{prog}(stimB,stimA) = abs(sum(usedata(usedata>0))); 
                    
                    % Cleanup
                    clear usedata randuse
                    
                end % stimB
            end % stimA
            
        end % prog
        
    end % Bootstrap iterations
    
end %Subtype

% %% Do the scaling for each counts matrix

% Edit the counts so that there's a minimum of 0.5
mini = norminv(0.5+(0.5/include)); % This is the equivalent standardised score (normal distribution) to 0.5/include, which is what was added in the other case
for sub = 1:2                 % For subject type
    for prog = 1:7            % For programme item
        for n = 1:numreps         % For num reps
            for a = 1:8
                for b = 1:8
                    if a==b, continue, end
                    if newcount{sub}{n}{prog}(a,b) == 0 && newcount{sub}{n}{prog}(b,a) == 0;    
                        % If both are 0, i.e., there's never a preference between the two... they should be equally likely.
                        % The weights should be equal, and proportional to
                        % the general level of preference for the stimuli.
                        % So, use half of the row-wise average for the two
                        % stimuli in question
                        
                        newcount{sub}{n}{prog}(a,b) = mini;
                        newcount{sub}{n}{prog}(b,a) = mini;
                    elseif newcount{sub}{n}{prog}(a,b) == 0; % Else, if only 1 of them is zeor.
                        newcount{sub}{n}{prog}(a,b) = mini;
                        newcount{sub}{n}{prog}(b,a) = newcount{sub}{n}{prog}(b,a) - mini;
                    end 
                end %stimB
            end % stimA
        end % Bootstrap iterations 
        
        %%% Do the Thurstone scaling
        % Empirical probabilities
        % Manually set N so be the number of items * the maximum scale
        % value
        maxscaleval = max(abs(results(:,10)));
        N = (maxscaleval*include) * ones(8,8);
        P = newcount{sub}{n}{prog} ./ (N + (N==0));     % Avoid divide by zero
        P(eye(size(newcount{sub}{n}{prog},1))>0) = 0.5; % Set diagonals to have p=0.5
        
        % Calculate the scale
        Z = norminv(P);
        S{sub}{n}{prog} = -mean(Z,1)';
               
        % Cleanup
        clear N P Z
        
    end % Programme
end % Subtype

% %% Normalise the scale results
allscale = [cell2mat(S{1}{1}); cell2mat(S{2}{1})];
Sall = (allscale - min(allscale(:))) / range(allscale(:));

% Put into the scale vecs
scale{1} = Sall(1:8,:);
scale{2} = Sall(9:end,:);


% Plot order for reproduction methods (same as earlier in the paper)
methodorder = [2 3 8 1 4 7 5 6];


%%% Plot figure
figure;
offset = [0.5 0];
barwidth = 0.5;
hax = axes;
axis([0.5 8.5 0.5 8.5]);

for subtype = 1:2   % for each subtype

    %%% GET THE DATA
    
    % Get ranks table
    % scale, and therefore ranks, has programmes in columns, methods in rows
    ranks{subtype} = tiedrank(scale{subtype});
    
    % The best rank that each method has been
    highrank{subtype} = max(ranks{subtype}');
    
    % The worst rank that each method has been
    lowrank{subtype} = min(ranks{subtype}');
    
    % The difference, and hence the size of the bar
    diff{subtype} = highrank{subtype} - lowrank{subtype};
    
    
    %%% DO THE PLOTTING
    
    count = 1; % Initialise a counter for the x-positions
    for n = methodorder %1:length(highrank{subtype})     % for each repro method
        
        rectangle('position',[count-offset(subtype) lowrank{subtype}(n)-offset(1) barwidth diff{subtype}(n)+(2*offset(1))], ...
            'curvature',0.1,...
            'linewidth',2,...
            'facecolor',mycm(subtype,:));
        
        count = count + 1; % Increment counter
        
    end



end



% Setup
set(gca,'xtick',1:8,'xticklabel',repromethods(methodorder))
set(gca,'ytick',1:8,'yticklabel',8:-1:1)                        % Invert the numbers on the y-axis
set(gca,'ygrid','on')
box on

% Manually draw the xgrid lines so they're at the edges of each set of blocks
hold on
theylims = get(gca,'ylim');
for n = 1.5:1:7.5
    plot(n*[1 1],theylims,'k:')
end


xticklabel_rotate([],15)

ylabel('Preference rank');

haxtemp = axes;
set(haxtemp,'position',get(hax,'position'));    % This is necessary to set the dummy axes to the same size as the real axes
ptemp = bar(haxtemp,rand(2,2),'linewidth',2);
colormap(mycm)
for n = 1:length(types), leglabels{n} = [types{n} ' listeners']; end        % Append 'listeners' to legend labels
hleg = legend(leglabels,'location','northwest');
set(hleg,'linewidth',1)
set(haxtemp,'visible','off')
set(ptemp,'visible','off')

%% Cluster use statistics

load Attributes.mat
load Final_Clusters

% %% Experienced:

% Number of clusters
experienced.numclust = length(clusters.experienced);

% Number used in grouping
[a,b] = CheckUniqueItems(clusternums_list.experienced(:,2));
experienced.numingroups = a;

% Number removed
experienced.numremoved = experienced.numclust - experienced.numingroups;

% Percentage removed
experienced.pctremoved = experienced.numremoved/experienced.numclust * 100;

% Total number of phrases clustered
experienced.numresponsesclusters = 1967;

% Number of phrases in clusters that were used
experienced.numphrasesused = 0;
for n = 1:length(b)
    experienced.numphrasesused = experienced.numphrasesused + length(clusters.experienced{b(n,1)}); 
    
end

% Percentage of phrases used
experienced.pctphrasesused = experienced.numphrasesused / experienced.numresponsesclusters * 100;

% %% Inexperienced:
% Number of clusters
inexperienced.numclust = length(clusters.inexperienced);

% Number used in grouping
[a,b] = CheckUniqueItems(clusternums_list.inexperienced(:,2));
inexperienced.numingroups = a;

% Number removed
inexperienced.numremoved = inexperienced.numclust - inexperienced.numingroups;

% Percentage removed
inexperienced.pctremoved = inexperienced.numremoved/inexperienced.numclust * 100;

% Total number of phrases clustered
inexperienced.numresponsesclusters = 2270;

% Number of phrases in clusters that were used
inexperienced.numphrasesused = 0;
for n = 1:length(b)
    inexperienced.numphrasesused = inexperienced.numphrasesused + length(clusters.inexperienced{b(n,1)}); 
    
end

% Percentage of phrases used
inexperienced.pctphrasesused = inexperienced.numphrasesused / inexperienced.numresponsesclusters * 100;

%% Get attribute use data
% Note: takes a long time to run. The same data can be loaded from
% Attribute_Use_Data.mat

% Apply an attribute to each response
% Determine how many responses there are for each attributes

load PreferenceResults_All, clear results
load Preference_Results_Processed
load Final_Clusters
load Attributes

% Go through each item of textreuslts.
% Find the corresponding item of results
% Get the standardised score
% Find the attribute that it was changed into
% Strip out duplicates

% What makes a trial unique? Combination of:
% [Subject ProgItem Page] = [1 3 4]
uniquetrial = results(:,[1 3 4]);
uniquetrial = table(uniquetrial(:,1),uniquetrial(:,2),uniquetrial(:,3)); % Convert to a table, facilitates using ismember()

% Subject types
types = {'inexperienced','experienced'};

% Preallocate answers
subnums = [];
scores = [];
attnums = [];
attlables = {};
subtypes = [];
originaltext = {};
count = 1;


for n = 1:length(textresults) % For each textresponse
    
    % Get the details
    nums = textresults{n,1};
    texts = GenerateDictionary({textresults{n,2}});
    
    checkunique = table(nums(1),nums(3),nums(4));
    
    % See if this trial made it through to the processed results
    resnum = find(ismember(uniquetrial,checkunique));
    
    if ~isempty(resnum) % If the trial was used
        
        % For debugging
        if results(resnum,2) + 1 == 0
            error('HUH? There''s a zero here');
        end
        
        
        % Get the subject number
        subtype = results(resnum,2) + 1; %1 = inexperienced, 2 = experienced
        
        %%% Determine the attribute(s) that were attached
        
        % 1) Step through each cluster and see if it contains this item
        % ... get a list (isincluster) of all clusters that contain this text
        
        % Preallocate
        isincluster = [];
        
        for c = 1:length(clusters.(types{subtype})) % For each cluster
            
            % Get current cluster
            currentcluster = clusters.(types{subtype}){c};
            
            % See if the text is in it
            if ismember(texts,currentcluster) % the text is in the cluster
                isincluster = [isincluster; c];
            end % check cluster for the text
            
            % Cleanup
            clear currentcluster
            
        end % each cluster
        
        if isempty(isincluster) % If it's not in a cluster
            % See if it's in the unclustered items
            if ismember(texts,stats.(types{subtype}).unclustered)
                isincluster = 0;
            else
                % It's not in a cluster, and it's not unclustered.
                % The spelling was potentially changed
                isincluster = -1;
            end
            
        end
        
        % 2) Go through the list, and get the attribute label/number for
        % each of the clusters from 'isincluster'
        for c = 1:length(isincluster)
            
            % Get current clusternumber
            currentclusternumber = isincluster(c);
            
            
            % If it's zero, it's unclustered
            if currentclusternumber == 0
                subnums(count,1) = results(resnum,1);
                scores(count,1) = results(resnum,10);
                attnums(count,1) = 0;
                attlabels{count,1} = 'Unclustered';
                subtypes(count,1) = subtype;
                originaltext{count,1} = texts;
                stimA(count,1) = results(resnum,6);
                stimB(count,1) = results(resnum,7);
                prog(count,1) = results(resnum,3);
                count = count + 1;
            elseif currentclusternumber == -1 % If it's -1, then it wasn't found
                subnums(count,1) = results(resnum,1);
                scores(count,1) = results(resnum,10);
                attnums(count,1) = -1;
                attlabels{count,1} = 'Not found';
                subtypes(count,1) = subtype;
                originaltext{count,1} = texts;
                stimA(count,1) = results(resnum,6);
                stimB(count,1) = results(resnum,7);
                prog(count,1) = results(resnum,3);
                count = count + 1;
            elseif ismember(isincluster,clusternums_list.(types{subtype})(:,2)) % if it's not zero and it is in the list
                % Work out how many attributes it is
                theattributes = clusternums_list.(types{subtype})(clusternums_list.(types{subtype})(:,2)==isincluster,1);
                numattributes = length(theattributes);
                
                % For debugging
                if numattributes > 1
                    [~,B] = CheckUniqueItems(theattributes);
                    if max(B(:,2)) > 1 % If the same attribute happens twice
                        display('Check this one')
                    end
                end
                
                for a = 1:numattributes
                    
                    % Determine which attribute is it
                    subnums(count,1) = results(resnum,1);
                    scores(count,1) = results(resnum,10); % Changed so it's NOT absolute
                    attnums(count,1) = theattributes(a);
                    attlabels{count,1} = attributelabels.(types{subtype}){attnums(count,1)};
                    subtypes(count,1) = subtype;
                    originaltext{count,1} = texts;
                    stimA(count,1) = results(resnum,6);
                    stimB(count,1) = results(resnum,7);
                    prog(count,1) = results(resnum,3);
                    count = count + 1;
                end
                
                
            else % it's not in the unclustered items, and it's not in a cluster that was made into an attribute
                subnums(count,1) = results(resnum,1);
                scores(count,1) = results(resnum,10);
                attnums(count,1) = -2;
                attlabels{count,1} = 'Discarded cluster';
                subtypes(count,1) = subtype;
                originaltext{count,1} = texts;
                stimA(count,1) = results(resnum,6);
                stimB(count,1) = results(resnum,7);
                prog(count,1) = results(resnum,3);
                count = count + 1;
            end % value of currentclusternumber
            
            
            
            
            % Cleanup
            clear currentclusternumber
            
        end % each cluster that has this text in
        
    else
        %display('Not used'); % For debugging
    end % was the trial used?
    
    
    % Cleanup
    clear nums texts resnum subtype isincluster
    
end

% Compile results into a table
attribute_use_table = table(subtypes,attnums,attlabels,scores,originaltext,stimA,stimB,prog,subnums,'VariableNames',{'SubjectType','AttNum','AttLabel','Score','OriginalText','StimA','StimB','Prog','SubjectNumber'});

% %% Sort by subject type
attribute_use_table = sortrows(attribute_use_table,{'SubjectType','AttNum'});

% Also save as an array
%               [Subtype stimA stimB score attnum];
attribute_use = [subtypes stimA stimB scores attnums subnums];
info = 'attribute_use: [Subtype(1=inexp,2=exp) stimA stimB Score AttributeNumber SubjectNumber]';

%% Figure 8

% Load data
load Attributes
load Attribute_Use_Data

types = {'inexperienced','experienced'};

% Maximum possible number of participants
max_subjects = [7 7];   % NOTE: One inexperienced listener was removed 

for subtype = 1:2
    
    % Get data
    useresults = attribute_use(attribute_use(:,1)==subtype,:);
    
    % For each attribute
    for n = 1:length(attributelabels.(types{subtype}))
        
        % Get data
        usedata = useresults(useresults(:,5)==n,:);
        
        % Check how many subjects used it
        [number{subtype}(n),breakdown{subtype}{n}] = CheckUniqueItems(usedata(:,6));
        
        
        % Cleanup
        clear usedata
        
        
    end % Attribute
    
    % Cleanup
    clear useresults

    % Convert into percentages
    num_pct{subtype} = (number{subtype} ./ max_subjects(subtype)) * 100;
    
    % Sort
    [num_pct{subtype},I{subtype}] = sort(num_pct{subtype},'descend');
       
    
end % subtype
   
%%% Go through the breakdowns and plot a stacked barchart

for subtype = 1:2
    
    % Get data
   for att = 1:length(breakdown{subtype})       % For each attribute
       
       for n = 1:15     % For each potential subject
       
           if ismember(n,breakdown{subtype}{att}(:,1))  
               newbreakdown{subtype}(att,n) = breakdown{subtype}{att}(breakdown{subtype}{att}(:,1)==n,2);
           else
               newbreakdown{subtype}(att,n) = 0; 
           end
    
       end
       
   end
 
    % Remove any subjects from the other group
   doremove = sum(newbreakdown{subtype},1) == 0;
   newbreakdown{subtype}(:,doremove) = [];
   
   % Calculate percentages for each attribute (attributes in rows)
   for att = 1:size(newbreakdown{subtype},1)    % For each attribute
       
       % Calculate the overall percentage
       pcts{subtype}(att,1) = (sum(newbreakdown{subtype}(att,:)>0) / length(newbreakdown{subtype}(att,:))) * 100;
             
       plotdata{subtype}(att,:) = newbreakdown{subtype}(att,:) * (pcts{subtype}(att) / sum(newbreakdown{subtype}(att,:)));
       
    
   end
   
   % Get hold of the data before sorting
   pct_subjects_used_attributes_unsorted{subtype} = pcts{subtype};
   
   % Work out the plot order
   [~,I{subtype}] = sort(pcts{subtype},'descend');
   
   % Draw the plot
   hfig(subtype) = figure;
   hbar{subtype} = bar(plotdata{subtype}(I{subtype},:),'stacked','linewidth',2);
   
   % Legend
   leglabels = [];
   for n = 1:size(plotdata{subtype},2)
       
       if subtype==1 && n>1
           thesubnum = n + 1;
       else
           thesubnum = n;
       end
           
       leglabels = [leglabels; sprintf('Subject %i',thesubnum)];
   end
   legend(leglabels)
   
   % Setup
   grid on
   colormap(bone)
   set(hbar{subtype},'EdgeColor','k')
   
   % Label
   ylabel('Percentage of participants (%)');
   set(gca,'xtick',1:length(attributelabels.(types{subtype})),'xticklabel',attributelabels_short.(types{subtype})(I{subtype}))  % NOTE: Make sure the labels are sorted
   set(gca,'ylim',[0 100],'xlim',[0 length(attributelabels.(types{subtype}))+1])  
   xticklabel_rotate
   
end

%% Figure 9

load Attribute_Use_Data
load Attributes
load pct_subjects_used_attributes.mat

% Turn into normal variables
subtypes = table2array(attribute_use_table(:,1));
attnums = table2array(attribute_use_table(:,2));
attlabels = table2cell(attribute_use_table(:,3));

types = {'inexperienced','experienced'};

% Manually set the ylims for the cutoff lines
printylims = [400 800];


for subtype = 1:2 % 1 = Inexperienced, 2 = experienced
   
    % Get the data for that subject
    use = subtypes==subtype;
    use_attnums = attnums(use);
    use_attlabels = attlabels(use);
    
    % Remove non-attributes
    nonattributes = use_attnums<1 | isnan(use_attnums);
    use = use(~nonattributes);
    use_attnums = use_attnums(~nonattributes);
    use_attlabels = use_attlabels(~nonattributes);
    
    % Get frequeny of use
    [~,freq] = CheckUniqueItems(use_attnums);
        
    % Calculate percentage of missing data
    pct_missing = (sum(nonattributes) / length(nonattributes)) * 100;
    num_missing = sum(nonattributes);
    
    % Calculate the modified expected count
    Emod = (sum(freq(:,2)) + num_missing) / length(freq(:,2));      % Number of responses + missing responses divided by number of attributes
    
    % Calculate the standardised residuals
    SR = (freq(:,2) - Emod) / (sqrt(Emod));
    
    % Set alpha level
    alpha = 0.05;
    P = abs(norminv(alpha/2));
    
    % Calculate the frequency needed to be confident that the result stands with the missing data
    Fhigh = (P * sqrt(Emod)) + Emod;
    Flow = (-P * sqrt(Emod)) + Emod;
    
    % Three ways of splitting up the missing values proportionally to how the attributes were actually used ?this is like saying that the missing values have the same distribution as the present values, and could therefore be sampled.
    f_pct = (freq(:,2) / sum(freq(:,2))) * 100;
    errorsize = (num_missing .* f_pct) / 100;
    
    %%% Plot the figure
    
    % New figure
    h(subtype) = figure;
    
    % Bar chart
    errors(:,:,1) = zeros(size(freq(:,2)));
    errors(:,:,2) = errorsize;
    
    % Sort the data
    [F,I] = sort(freq(:,2),'descend');
    errors(:,:,:) = errors(I,:,:);
    
    
    [hbar,heb] = barwitherr(errors,F);
    set(hbar,'linewidth',2)
    set(heb,'linewidth',2)
    
    % Upper and lower lines
    hold all
    plot([0 length(freq(:,2))+1],[Fhigh Fhigh],'linewidth',2,'color','k')
    plot([0 length(freq(:,2))+1],[Flow Flow],'linewidth',2,'color','k')
    
    % Cutoff lines
    
    maxpoint = F + errors(:,:,2);
    numabove = sum(maxpoint>Fhigh) + 0.5;
  
    maxpoint = F;
    numabove = sum(maxpoint>Fhigh) + 0.5;
 
    % Plot the cutoff point for attributes used at less than chance freq

    lowcutoffpoints = 0.5+[13 12];
    
    plot([lowcutoffpoints(subtype) lowcutoffpoints(subtype)],[0 printylims(subtype)],'--','linewidth',2,'color',0.45*[1 1 1])
 
    % Generate labels that include percentage of subjects that used the
    % term    
    pct_subjects_used_attributes{subtype} = pct_subjects_used_attributes_unsorted{subtype}(I);    % Sort the percentages
    
    for n = 1:length(attributelabels_short.(types{subtype}))
        newlabel{subtype}{n} = sprintf('%s (%2.1f%%)',char(attributelabels_short.(types{subtype})(I(n))),pct_subjects_used_attributes{subtype}(n));  
    end
    
    
    % Setup
    set(gca,'xtick',1:length(freq(:,2)),'xticklabel',newlabel{subtype});
    set(gca,'XLim',[0 length(freq(:,2))+1]);
    grid on
    ylabel('Frequency of use');
    xticklabel_rotate %([],30)
      
    cmapnum = [1 3];
    colormap(bone);
    
    % Cleanup
    clear use use_attnums use_attlabels nonattributes maxpoint numabove freq F I errors errorsize
    
end

%% Figure 10
% USES ALL PREFERENCES SCORES FOR EACH STIMULUS COMBINATION 

load('Preference_Results_Processed.mat','repromethods');    % Get repro method labels
load Attributes
load Attribute_Use_Data
load pct_subjects_used_attributes.mat


types = {'inexperienced','experienced'};
subtype = 2;            % 2 = experienced


% How many plots
do.numplots = 'some'; 

switch do.numplots
    case 'some'
        % Number of attributes to use for each subject type
        use_num_atts = [13 13];     % 
        useatts{1} = [1:13 15];
        useatts{2} = [1:12 13 17 19];       
        % Dimensions for subplots for each subject type
        subplotrows = [3 3];
        subplotcols = [5 5];
    case 'all'
        % Number of attributes to use for each subject type
        use_num_atts = [24 27];     %
        useatts{1} = 1:24;
        useatts{2} = 1:27;
        % Dimensions for subplots for each subject type
        subplotrows = [5 4];
        subplotcols = [5 7];
end


ylimmax = [30 40];


% Stimulus combinations
combs = nchoosek([1:8],2);


for subtype = 1:2;
    
% Get subtype
useresults = attribute_use(attribute_use(:,1)==subtype,:);

% Preallocate
X = zeros(length(combs),length(attributelabels.(types{subtype})));  % Features matrix
y = zeros(length(combs),1);                                         % Scores vector


    % Open a figure
    hfig(subtype) = figure;
    
    for n = 1:length(combs)         % For each stimulus combination
        
        stimA = combs(n,1);
        stimB = combs(n,2);
        
        % Get the data
        tempdata = useresults(useresults(:,2)==stimA,:);
        tempdata = tempdata(tempdata(:,3)==stimB,:);
        
        % Get the y score
        [y_confint(n),y(n)] = ConfInt_TDist(abs(tempdata(:,4))',0.95,'normal');
        
        % Get raw y scores (not abs)
        [y_raw_confint(n),y_raw(n)] = ConfInt_TDist(tempdata(:,4)',0.95,'normal');
        
        % Get the frequency of use
        [a,b] = CheckUniqueItems(tempdata(:,5));
        
        for A = 1:size(b,1)        % For each reported attribute
            
            attnum = b(A,1);    % Get the attribute number
            freq = b(A,2);      % And the frequency of use
            
            % If the attnum if less than 1, skip it
            if attnum < 1, continue, end
            
            % If it's not, get the frequency of use and add to features X
            X(n,attnum) = freq;
            
            % Cleanup
            clear attnum freq
            
        end
        

        % Cleanup
        clear tempdata stimA stimB
        
    end
    
    % Get an order for the plots
    % Sort attributes by total frequency of use
    usefreq = sum(X,1);
    [usefreq,attributeorder] = sort(usefreq,'descend');
    % Sort X, and the labels, into the attribute order
    X = X(:,attributeorder); 
    sortedattributelabels.(types{subtype}) = attributelabels_short.(types{subtype})(attributeorder);
    % Also sort the percentage of subjects data in the same way
    pct_subjects_used_attributes{subtype} = pct_subjects_used_attributes_unsorted{subtype}(attributeorder);
    
    
    
    count = 1;
    
    for attribute = useatts{subtype}            %1:use_num_atts(subtype)
        
        X_att = X(:,attribute);
   
        % Calculate correlation
        [tempr,tempp] = corrcoef(y,X_att);
        r(attribute) = tempr(2);
        p(attribute) = tempp(2) < 0.05;             % 1 (significant) if p < 0.05
        
        % Draw a plot
        subplot(subplotrows(subtype),subplotcols(subtype),count)
        hscat = scatter(y,X_att);       % Normal scatter plot
        
        % Change the markers and colours to differentiate repro methods

        newcm = lines(7);                                         % NOTE: only need 7 values
        
        reproA = {'+','o','x','s','d','^','v'};                         % Markers
        reproB = mat2cell(newcm,[1 1 1 1 1 1 1]);                         % Put colourmap into cells
        
        C = flipud(get(hscat,'Children'));      % Return handles to each point. Flip them so it goes 1-28, not 28-1
        
        for n = 1:length(C)
            
            if X_att(n) == 0
                set(C(n),'Marker','.')
                set(C(n),'MarkerSize',15)
                set(C(n),'MarkerEdgeColor',0.2*[1 1 1])
            else
                set(C(n),'Marker',reproA{combs(n,1)})
                set(C(n),'MarkerEdgeColor',reproB{combs(n,2)-1})
            end
            
        end
        
        % Setup
        grid on
        set(gca,'xlim',[0 2],'ylim',[0 ylimmax(subtype)])
        set(C,'LineWidth',2)
        
        
        

        % Set the title with a used-by-num-subjects value
        usedbysubs = pct_subjects_used_attributes{subtype}(attribute);
        thetitle = sprintf('%s\n(%2.1f%%)',char(sortedattributelabels.(types{subtype})(attribute)),usedbysubs);
        
        % Generate ylabel with total frequency of use
        ylabeltext = sprintf('Frequency (total: %i)',sum(X_att));
        
        
        title(thetitle);
        xlabel('Mean abs. pref.');
        ylabel(ylabeltext);
        
        % Cleanup
        clear X_att rempr rempp thetitle ylabeltext usedbysubs
        count = count + 1;
        
    end % attribute
    
    
    if subtype == 1
        % Create legends
        % ReproA = shape, ReproB = colour
        
        hs1 = subplot(subplotrows(subtype),subplotcols(subtype),count);
        
        % Plot with 14 points
        p1 = plot(hs1,rand(14,14),'linestyle','none');
        
        % Setup markers and colours
        legendmarkers = [reproA,'*','*','*','*','*','*','*'];
        legendcolours = [repmat([0 0 0],7,1); newcm];
        
        % Set line styles of the plot
        for n = 1:length(p1)
            set(p1(n),'linewidth',2,'color',legendcolours(n,:),'marker',legendmarkers{n})
        end
        
  
        % Legend1
        hlegA = legend(p1(1:7),repromethods(1:7),'location','West');
        htitle = get(hlegA,'title');
        set(htitle,'string','Method A');
        
        % Manually move legend 1
        legApos = get(hlegA,'position');
        set(hlegA,'position',[0.749000587889481 0.0758288895125815 0.119341563786008 0.233791748526522]);
        
        
        
        % Legend 2
        a1=axes('position',get(gca,'position'),...
            'visible','off');
        hlegB = legend(a1,p1(8:14),repromethods(2:end),'location','East');
        htitle2 = get(hlegB,'title');
        set(htitle2,'string','Method B');
        
        % Manually move legend
        legBpos = get(hlegB,'position');
        set(hlegB,'position',[0.87026381540271 0.0758288895125809 0.0967078189300412 0.233791748526521]);

        
        set(p1,'visible','off')
        set(hs1,'visible','off')
        
    end
    
    % Cleanup
    clear attributeorder y
      
end % Subject type

%% Percentage of comparisons in which the higher channel count came second
% Response to reviewer question

methodnames = {'Headphones','LQ mono','Mono','Stereo','5-chan','9-chan','22-chan','Cuboid'};

methodcounts = [2 1 1 2 5 9 22 8];

perms = nchoosek(1:8,2);

count = 0;

for n = 1:length(perms)
    
    achans = methodcounts(perms(n,1));
    bchans = methodcounts(perms(n,2));
    
    % Increment count if B has more channels than A
    if bchans > achans
        count = count + 1;
        perms(n,3) = 1;
    else
        perms(n,3) = 0;
    end
    
    
end

% Calculate percentage
pct = (count / length(perms)) * 100;

