function h_pie = OverlayPie(axis_handle,pie_data,x_pos,y_pos,piesize,pielabels)
%OverlayPie draws pie charts of the data in pie_data on axis_handle
%
% INPUT:
% -axis_handle: handle to the axis on which to draw the pies
% -pie_data: data for each pie (individual pies in rows, segments in
%            columns)
% -x_pos: x positions (in terms of axis units) of the pies (a vector)
% -y_pos: y positions (in terms of axis units) of the pies (a vector)
% -varargin: visualisation options for the pies
%
% Jon Francombe, j.francombe@surrey.ac.uk
% 08/10/2015
%

% Get the position of the original axis (within the figure)
axis_position = get(axis_handle,'position');

% A: The start position of the axis
xA = axis_position(1);
yA = axis_position(2);

% E: The end position of the axis (the length + the start position)
xE = axis_position(3) + xA;
yE = axis_position(4) + yA;

% Get the axis limits (needed to calculate the step size)
xlims = get(axis_handle,'xlim');
ylims = get(axis_handle,'ylim');

% Get the step size
xS = (xE-xA) / (xlims(2) - xlims(1));                   % The plot axis units divided by the x limits gives the step size
yS = (yE-yA) / (ylims(2) - ylims(1));

% For each position, the stepsize multiplier is given by xpos - xlims(1)
xSmulti = x_pos - xlims(1);
ySmulti = y_pos - ylims(1);

% The new pos is then given by A+(Smulti*S)
new_xpos = xA + (xSmulti .* xS);
new_ypos = yA + (ySmulti .* yS);

% Plot the pies
for n = 1:size(pie_data,1)      % for each pie
    
    pax(n) = axes;
    h_pie{n} = pie(pax(n),pie_data(n,:),pielabels);
    
    pie_xpos = new_xpos(n);
    pie_ypos = new_ypos(n);
    
    set(pax(n),'position',[pie_xpos-(piesize/2) pie_ypos-(piesize/2) piesize piesize])
    
end % each pie

