#ifndef _UTILS_H_INCLUDED_
	#define _UTILS_H_INCLUDED_
	//some utility functions
	//#define USE_MUTEX_LOCKS
	//#define ADD_PADDING
	/* #define OPTERON */
	/* #define OPTERON_OPTIMIZE */

	#include <stdlib.h>
	#include <stdio.h>
	#include <errno.h>
	#include <string.h>
	#include <sched.h>
	#include <inttypes.h>
	#include <sys/time.h>
	#include <unistd.h>
	#ifdef __sparc__
		#include <sys/types.h>
		#include <sys/processor.h>
		#include <sys/procset.h>
		#elif defined(__tile__)
		#include <arch/atomic.h>
		#include <arch/cycle.h>
		#include <tmc/cpus.h>
		#include <tmc/task.h>
		#include <tmc/spin.h>
		#include <sched.h>
		#else
		#if defined(PLATFORM_MCORE)
			#include <numa.h>
		#endif
		#if defined(__SSE__)
			#include <xmmintrin.h>
			#else
			#define _mm_pause() asm volatile ("nop")
		#endif
		#if defined(__SSE2__)
			#include <emmintrin.h>
		#endif
	#endif
	#include <pthread.h>
	#include "getticks.h"
	#include "random.h"
	#include "measurements.h"
	#include "ssalloc.h"
	#include "atomic_ops_if.h"


	#ifdef __cplusplus
		extern "C"
		{
		#endif


		#define DO_ALIGN
		/* #define DO_PAD */


		#if !defined(false)
			#define false 0
		#endif

		#if !defined(true)
			#define true 1
		#endif

		#define likely(x)       __builtin_expect((x), 1)
		#define unlikely(x)     __builtin_expect((x), 0)


		#if !defined(UNUSED)
			#define UNUSED __attribute__ ((unused))
		#endif

		#if defined(DO_ALIGN)
			#define ALIGNED(N) __attribute__ ((aligned (N)))
			#else
			#define ALIGNED(N)
		#endif

		#if !defined(COMPILER_BARRIER)
			#define COMPILER_BARRIER() asm volatile ("" ::: "memory")
		#endif

		#if !defined(COMPILER_NO_REORDER)
			#define COMPILER_NO_REORDER(exec)		\
			COMPILER_BARRIER();				\
			exec;						\
			COMPILER_BARRIER()
		#endif

		static inline int
		is_power_of_two (unsigned int x)
		{
			return ((x != 0) && !(x & (x - 1)));
		}


		#ifdef T44
			#define NUMBER_OF_SOCKETS 4
			#define CORES_PER_SOCKET 64
			#define CACHE_LINE_SIZE 64
			#define NOP_DURATION 2
			//mapping from threads to cores on the niagara
			#define ALTERNATE_CORES
			#ifdef ALTERNATE_CORES
				static uint8_t UNUSED the_cores[] = {
					0,   8,  16,  24,  32,  40,  48,  56,
					1,   9,  17,  25,  33,  41,  49,  57,
					2,  10,  18,  26,  34,  42,  50,  58,
					3,  11,  19,  27,  35,  43,  51,  59,
					4,  12,  20,  28,  36,  44,  52,  60,
					5,  13,  21,  29,  37,  45,  53,  61,
					6,  14,  22,  30,  38,  46,  54,  62,
					7,  15,  23,  31,  39,  47,  55,  63,
					64,  72,  80,  88,  96, 104, 112, 120,
					65,  73,  81,  89,  97, 105, 113, 121,
					66,  74,  82,  90,  98, 106, 114, 122,
					67,  75,  83,  91,  99, 107, 115, 123,
					68,  76,  84,  92, 100, 108, 116, 124,
					69,  77,  85,  93, 101, 109, 117, 125,
					70,  78,  86,  94, 102, 110, 118, 126,
					71,  79,  87,  95, 103, 111, 119, 127,
					128, 136, 144, 152, 160, 168, 176, 184,
					129, 137, 145, 153, 161, 169, 177, 185,
					130, 138, 146, 154, 162, 170, 178, 186,
					131, 139, 147, 155, 163, 171, 179, 187,
					132, 140, 148, 156, 164, 172, 180, 188,
					133, 141, 149, 157, 165, 173, 181, 189,
					134, 142, 150, 158, 166, 174, 182, 190,
					135, 143, 151, 159, 167, 175, 183, 191,
					192, 200, 208, 216, 224, 232, 240, 248,
					193, 201, 209, 217, 225, 233, 241, 249,
					194, 202, 210, 218, 226, 234, 242, 250,
					195, 203, 211, 219, 227, 235, 243, 251,
					196, 204, 212, 220, 228, 236, 244, 252,
					197, 205, 213, 221, 229, 237, 245, 253,
					198, 206, 214, 222, 230, 238, 246, 254,
					199, 207, 215, 223, 231, 239, 247, 255,
				};

				static uint8_t UNUSED the_sockets[] = {
					0, 0, 0, 0, 0, 0, 0, 0,
					0, 0, 0, 0, 0, 0, 0, 0,
					0, 0, 0, 0, 0, 0, 0, 0,
					0, 0, 0, 0, 0, 0, 0, 0,
					1, 1, 1, 1, 1, 1, 1, 1,
					1, 1, 1, 1, 1, 1, 1, 1,
					1, 1, 1, 1, 1, 1, 1, 1,
					1, 1, 1, 1, 1, 1, 1, 1,
					2, 2, 2, 2, 2, 2, 2, 2,
					2, 2, 2, 2, 2, 2, 2, 2,
					2, 2, 2, 2, 2, 2, 2, 2,
					2, 2, 2, 2, 2, 2, 2, 2,
					3, 3, 3, 3, 3, 3, 3, 3,
					3, 3, 3, 3, 3, 3, 3, 3,
					3, 3, 3, 3, 3, 3, 3, 3,
					3, 3, 3, 3, 3, 3, 3, 3,
				};

				#else	 /* !ALTERNATE_CORES */
				static UNUSED the_cores[] = {
					0,   1,   2,   3,   4,   5,   6,   7,
					8,   9,  10,  11,  12,  13,  14,  15,
					16,  17,  18,  19,  20,  21,  22,  23,
					24,  25,  26,  27,  28,  29,  30,  31,
					32,  33,  34,  35,  36,  37,  38,  39,
					40,  41,  42,  43,  44,  45,  46,  47,
					48,  49,  50,  51,  52,  53,  54,  55,
					56,  57,  58,  59,  60,  61,  62,  63,
					64,  65,  66,  67,  68,  69,  70,  71,
					72,  73,  74,  75,  76,  77,  78,  79,
					80,  81,  82,  83,  84,  85,  86,  87,
					88,  89,  90,  91,  92,  93,  94,  95,
					96,  97,  98,  99, 100, 101, 102, 103,
					104, 105, 106, 107, 108, 109, 110, 111,
					112, 113, 114, 115, 116, 117, 118, 119,
					120, 121, 122, 123, 124, 125, 126, 127,
					128, 129, 130, 131, 132, 133, 134, 135,
					136, 137, 138, 139, 140, 141, 142, 143,
					144, 145, 146, 147, 148, 149, 150, 151,
					152, 153, 154, 155, 156, 157, 158, 159,
					160, 161, 162, 163, 164, 165, 166, 167,
					168, 169, 170, 171, 172, 173, 174, 175,
					176, 177, 178, 179, 180, 181, 182, 183,
					184, 185, 186, 187, 188, 189, 190, 191,
					192, 193, 194, 195, 196, 197, 198, 199,
					200, 201, 202, 203, 204, 205, 206, 207,
					208, 209, 210, 211, 212, 213, 214, 215,
					216, 217, 218, 219, 220, 221, 222, 223,
					224, 225, 226, 227, 228, 229, 230, 231,
					232, 233, 234, 235, 236, 237, 238, 239,
					240, 241, 242, 243, 244, 245, 246, 247,
					248, 249, 250, 251, 252, 253, 254, 255,
				};

				static uint8_t UNUSED the_sockets[] = {
					0, 0, 0, 0, 0, 0, 0, 0,
					0, 0, 0, 0, 0, 0, 0, 0,
					0, 0, 0, 0, 0, 0, 0, 0,
					0, 0, 0, 0, 0, 0, 0, 0,
					1, 1, 1, 1, 1, 1, 1, 1,
					1, 1, 1, 1, 1, 1, 1, 1,
					1, 1, 1, 1, 1, 1, 1, 1,
					1, 1, 1, 1, 1, 1, 1, 1,
					2, 2, 2, 2, 2, 2, 2, 2,
					2, 2, 2, 2, 2, 2, 2, 2,
					2, 2, 2, 2, 2, 2, 2, 2,
					2, 2, 2, 2, 2, 2, 2, 2,
					3, 3, 3, 3, 3, 3, 3, 3,
					3, 3, 3, 3, 3, 3, 3, 3,
					3, 3, 3, 3, 3, 3, 3, 3,
					3, 3, 3, 3, 3, 3, 3, 3,
				};

			#endif  /* ALTERNATE_CORES */
		#endif	/* T44*/


		#ifdef __sparc__
			#define PAUSE    asm volatile("rd    %%ccr, %%g0\n\t" ::: "memory")
			#elif defined(__tile__)
			#define PAUSE cycle_relax()
			#else
			#define PAUSE _mm_pause()
		#endif
		static inline void pause_rep(uint32_t num_reps)
		{
			volatile uint32_t i;
			for (i = 0; i < num_reps; i++)
			{
				PAUSE;
				/* PAUSE; */
				/* asm volatile ("NOP"); */
			}
		}

		static inline void nop_rep(uint32_t num_reps)
		{
			uint32_t i;
			for (i = 0; i < num_reps; i++)
			{
				asm volatile ("");
			}
		}

		/*************************************************************************************************************************************/
		//machine dependent parameters
		#if defined(DEFAULT)
			#define NUMBER_OF_SOCKETS 1
			#define CORES_PER_SOCKET  CORE_NUM
			#define CACHE_LINE_SIZE   64
			#define NOP_DURATION      2
			static uint8_t __attribute__ ((unused)) the_cores[] ={
				0, 1, 2, 3, 4, 5, 6, 7,
				8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23,
				24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39,
				40, 41, 42, 43, 44, 45, 46, 47
			};
		#endif  /*  */

		#if defined(EXCESS)
			#define NUMBER_OF_SOCKETS 2
			#define CORES_PER_SOCKET  16
			#define CACHE_LINE_SIZE   64
			#define NOP_DURATION      2
			#if MEMORY_SETUP == 2 //ad- alternate sockets
				static uint8_t __attribute__ ((unused)) the_cores[] ={
					0, 8, 1, 9, 2, 10, 3, 11, 4, 12, 5, 13, 6, 14, 7, 15,
					16, 24, 17, 25, 18, 26, 19, 27, 20, 28, 21, 29, 22, 30, 23, 31
				};
			#else
				#if HYPERTHREAD == 1
					static uint8_t __attribute__ ((unused)) the_cores[] ={
						0, 16, 1, 17, 2, 18, 3, 19, 4, 20, 5, 21, 6, 22, 7, 23,
						8, 24, 9, 25, 10, 26, 11, 27, 12, 28, 13, 29, 14, 30, 15, 31
					};
				#else
					static uint8_t __attribute__ ((unused)) the_cores[] ={
						0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
						16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31
					};
				#endif
			#endif
		#endif  /* adon- */

		#if defined(ODYSSEUS)
			#define NUMBER_OF_SOCKETS 1
			#define CORES_PER_SOCKET  CORE_NUM
			#define CACHE_LINE_SIZE   64
			#define NOP_DURATION      2
			#if MEMORY_SETUP == 2 //kvg- alternate tiles
				static uint32_t __attribute__ ((unused)) the_cores[] ={
					0,18,36,54,1,19,37,55,2,20,38,56,3,21,39,57,4,22,40,58,5,23,41,59,6,24,42,60,7,25,43,61,8,26,44,62,9,27,45,63,10,28,46,64,11,29,47,65,12,30,48,66,13,31,49,67,14,32,50,68,15,33,51,69,16,34,52,70,17,35,53,71,
					72,90,108,126,73,91,109,127,74,92,110,128,75,93,111,129,76,94,112,130,77,95,113,131,78,96,114,132,79,97,115,133,80,98,116,134,81,99,117,135,82,100,118,136,83,101,119,137,84,102,120,138,85,103,121,139,86,104,122,140,87,105,123,141,88,106,124,142,89,107,125,143,
					144,162,180,198,145,163,181,199,146,164,182,200,147,165,183,201,148,166,184,202,149,167,185,203,150,168,186,204,151,169,187,205,152,170,188,206,153,171,189,207,154,172,190,208,155,173,191,209,156,174,192,210,157,175,193,211,158,176,194,212,159,177,195,213,160,178,196,214,161,179,197,215,
					216,234,252,270,217,235,253,271,218,236,254,272,219,237,255,273,220,238,256,274,221,239,257,275,222,240,258,276,223,241,259,277,224,242,260,278,225,243,261,279,226,244,262,280,227,245,263,281,228,246,264,282,229,247,265,283,230,248,266,284,231,249,267,285,232,250,268,286,233,251,269,287,
				};
			#else
				#if HYPERTHREAD == 1
					static uint32_t __attribute__ ((unused)) the_cores[] ={
						0,72,144,216,1,73,145,217,2,74,146,218,3,75,147,219,4,76,148,220,5,77,149,221,6,78,150,222,7,79,151,223,8,80,152,224,9,81,153,225,10,82,154,226,11,83,155,227,12,84,156,228,13,85,157,229,14,86,158,230,15,87,159,231,16,88,160,232,17,89,161,233,18,90,162,234,19,91,163,235,20,92,164,236,21,93,165,237,22,94,166,238,23,95,167,239,24,96,168,240,25,97,169,241,26,98,170,242,27,99,171,243,28,100,172,244,29,101,173,245,30,102,174,246,31,103,175,247,32,104,176,248,33,105,177,249,34,106,178,250,35,107,179,251,36,108,180,252,37,109,181,253,38,110,182,254,39,111,183,255,40,112,184,256,41,113,185,257,42,114,186,258,43,115,187,259,44,116,188,260,45,117,189,261,46,118,190,262,47,119,191,263,48,120,192,264,49,121,193,265,50,122,194,266,51,123,195,267,52,124,196,268,53,125,197,269,54,126,198,270,55,127,199,271,56,128,200,272,57,129,201,273,58,130,202,274,59,131,203,275,60,132,204,276,61,133,205,277,62,134,206,278,63,135,207,279,64,136,208,280,65,137,209,281,66,138,210,282,67,139,211,283,68,140,212,284,69,141,213,285,70,142,214,286,71,143,215,287
					};
				#else
					static uint32_t __attribute__ ((unused)) the_cores[] ={
						0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,
						72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
						144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,
						216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,256,257,258,259,260,261,262,263,264,265,266,267,268,269,270,271,272,273,274,275,276,277,278,279,280,281,282,283,284,285,286,287
					};
				#endif
			#endif
		#endif  /* adon- */
		#if defined(ITHACA)
			#define NUMBER_OF_SOCKETS 2
			#define CORES_PER_SOCKET  36
			#define CACHE_LINE_SIZE   64
			#define NOP_DURATION      2
			#if MEMORY_SETUP == 2 //ad- alternate sockets
				static uint8_t __attribute__ ((unused)) the_cores[] ={
					0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,
					36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71
				};
			#else
				#if HYPERTHREAD == 1
					static uint8_t __attribute__ ((unused)) the_cores[] ={
						0,36,2,38,4,40,6,42,8,44,10,46,12,48,14,50,16,52,18,54,20,56,22,58,24,60,26,62,28,64,30,66,32,68,34,70,1,37,3,39,5,41,7,43,9,45,11,47,13,49,15,51,17,53,19,55,21,57,23,59,25,61,27,63,29,65,31,67,33,69,35,71
					};
				#else
					static uint8_t __attribute__ ((unused)) the_cores[] ={
						0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,		// Real threads
						36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,	// Hyperthreads
						1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,		// Real threads, on the other socket
						37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71	// Hyperthreads, on the other socket
					};
				#endif
			#endif
		#endif  /* adon- */
		#if defined(ATHENA)
			#define NUMBER_OF_SOCKETS 2
			#define CORES_PER_SOCKET  128
			#define CACHE_LINE_SIZE   64
			#define NOP_DURATION      2
			#if MEMORY_SETUP == 2 // Alternate between sockets
				static uint16_t __attribute__ ((unused)) the_cores[] ={
                    0  ,128,8  ,136,16 ,144,24 ,152,32 ,160,40 ,168,48 ,176,56 ,184,64 ,192,72 ,200,80 ,208,88 ,216,96 ,224,104,232,112,240,120,248, // CCX 0 on both CPU, real threads
                    1  ,129,9  ,137,17 ,145,25 ,153,33 ,161,41 ,169,49 ,177,57 ,185,65 ,193,73 ,201,81 ,209,89 ,217,97 ,225,105,233,113,241,121,249, // CCX 1 on both CPU, real threads
                    2  ,130,10 ,138,18 ,146,26 ,154,34 ,162,42 ,170,50 ,178,58 ,186,66 ,194,74 ,202,82 ,210,90 ,218,98 ,226,106,234,114,242,122,250, // CCX 2 on both CPU, real threads
                    3  ,131,11 ,139,19 ,147,27 ,155,35 ,163,43 ,171,51 ,179,59 ,187,67 ,195,75 ,203,83 ,211,91 ,219,99 ,227,107,235,115,243,123,251, // CCX 3 on both CPU, real threads
                    4  ,132,12 ,140,20 ,148,28 ,156,36 ,164,44 ,172,52 ,180,60 ,188,68 ,196,76 ,204,84 ,212,92 ,220,100,228,108,236,116,244,124,252, // CCX 4 on both CPU, real threads
                    5  ,133,13 ,141,21 ,149,29 ,157,37 ,165,45 ,173,53 ,181,61 ,189,69 ,197,77 ,205,85 ,213,93 ,221,101,229,109,237,117,245,125,253, // CCX 5 on both CPU, real threads
                    6  ,134,14 ,142,22 ,150,30 ,158,38 ,166,46 ,174,54 ,182,62 ,190,70 ,198,78 ,206,86 ,214,94 ,222,102,230,110,238,118,246,126,254, // CCX 6 on both CPU, real threads
                    7  ,135,15 ,143,23 ,151,31 ,159,39 ,167,47 ,175,55 ,183,63 ,191,71 ,199,79 ,207,87 ,215,95 ,223,103,231,111,239,119,247,127,255, // CCX 7 on both CPU, real threads
                    256,384,264,392,272,400,280,408,288,416,296,424,304,432,312,440,320,448,328,456,336,464,344,472,352,480,360,488,368,496,376,504, // CCX 0 on both CPU, hyperthreads
                    257,385,265,393,273,401,281,409,289,417,297,425,305,433,313,441,321,449,329,457,337,465,345,473,353,481,361,489,369,497,377,505, // CCX 1 on both CPU, hyperthreads
                    258,386,266,394,274,402,282,410,290,418,298,426,306,434,314,442,322,450,330,458,338,466,346,474,354,482,362,490,370,498,378,506, // CCX 2 on both CPU, hyperthreads
                    259,387,267,395,275,403,283,411,291,419,299,427,307,435,315,443,323,451,331,459,339,467,347,475,355,483,363,491,371,499,379,507, // CCX 3 on both CPU, hyperthreads
                    260,388,268,396,276,404,284,412,292,420,300,428,308,436,316,444,324,452,332,460,340,468,348,476,356,484,364,492,372,500,380,508, // CCX 4 on both CPU, hyperthreads
                    261,389,269,397,277,405,285,413,293,421,301,429,309,437,317,445,325,453,333,461,341,469,349,477,357,485,365,493,373,501,381,509, // CCX 5 on both CPU, hyperthreads
                    262,390,270,398,278,406,286,414,294,422,302,430,310,438,318,446,326,454,334,462,342,470,350,478,358,486,366,494,374,502,382,510, // CCX 6 on both CPU, hyperthreads
                    263,391,271,399,279,407,287,415,295,423,303,431,311,439,319,447,327,455,335,463,343,471,351,479,359,487,367,495,375,503,383,511  // CCX 7 on both CPU, hyperthreads
				};
			#else
				#if HYPERTHREAD == 1 // Alternate real and hyperthread on each socket
					static uint16_t __attribute__ ((unused)) the_cores[] ={
                        0  ,256,8  ,264,16 ,272,24 ,280,32 ,288,40 ,296,48 ,304,56 ,312,64 ,320,72 ,328,80 ,336,88 ,344,96 ,352,104,360,112,368,120,376, // CCX 0 on CPU 1, alternating real and hyper-threads
                        1  ,257,9  ,265,17 ,273,25 ,281,33 ,289,41 ,297,49 ,305,57 ,313,65 ,321,73 ,329,81 ,337,89 ,345,97 ,353,105,361,113,369,121,377, // CCX 1 on CPU 1, alternating real and hyper-threads
                        2  ,258,10 ,266,18 ,274,26 ,282,34 ,290,42 ,298,50 ,306,58 ,314,66 ,322,74 ,330,82 ,338,90 ,346,98 ,354,106,362,114,370,122,378, // CCX 2 on CPU 1, alternating real and hyper-threads
                        3  ,259,11 ,267,19 ,275,27 ,283,35 ,291,43 ,299,51 ,307,59 ,315,67 ,323,75 ,331,83 ,339,91 ,347,99 ,355,107,363,115,371,123,379, // CCX 3 on CPU 1, alternating real and hyper-threads
                        4  ,260,12 ,268,20 ,276,28 ,284,36 ,292,44 ,300,52 ,308,60 ,316,68 ,324,76 ,332,84 ,340,92 ,348,100,356,108,364,116,372,124,380, // CCX 4 on CPU 1, alternating real and hyper-threads
                        5  ,261,13 ,269,21 ,277,29 ,285,37 ,293,45 ,301,53 ,309,61 ,317,69 ,325,77 ,333,85 ,341,93 ,349,101,357,109,365,117,373,125,381, // CCX 5 on CPU 1, alternating real and hyper-threads
                        6  ,262,14 ,270,22 ,278,30 ,286,38 ,294,46 ,302,54 ,310,62 ,318,70 ,326,78 ,334,86 ,342,94 ,350,102,358,110,366,118,374,126,382, // CCX 6 on CPU 1, alternating real and hyper-threads
                        7  ,263,15 ,271,23 ,279,31 ,287,39 ,295,47 ,303,55 ,311,63 ,319,71 ,327,79 ,335,87 ,343,95 ,351,103,359,111,367,119,375,127,383, // CCX 7 on CPU 1, alternating real and hyper-threads
                        128,384,136,392,144,400,152,408,160,416,168,424,176,432,184,440,192,448,200,456,208,464,216,472,224,480,232,488,240,496,248,504, // CCX 0 on CPU 2, alternating real and hyper-threads
                        129,385,137,393,145,401,153,409,161,417,169,425,177,433,185,441,193,449,201,457,209,465,217,473,225,481,233,489,241,497,249,505, // CCX 1 on CPU 2, alternating real and hyper-threads
                        130,386,138,394,146,402,154,410,162,418,170,426,178,434,186,442,194,450,202,458,210,466,218,474,226,482,234,490,242,498,250,506, // CCX 2 on CPU 2, alternating real and hyper-threads
                        131,387,139,395,147,403,155,411,163,419,171,427,179,435,187,443,195,451,203,459,211,467,219,475,227,483,235,491,243,499,251,507, // CCX 3 on CPU 2, alternating real and hyper-threads
                        132,388,140,396,148,404,156,412,164,420,172,428,180,436,188,444,196,452,204,460,212,468,220,476,228,484,236,492,244,500,252,508, // CCX 4 on CPU 2, alternating real and hyper-threads
                        133,389,141,397,149,405,157,413,165,421,173,429,181,437,189,445,197,453,205,461,213,469,221,477,229,485,237,493,245,501,253,509, // CCX 5 on CPU 2, alternating real and hyper-threads
                        134,390,142,398,150,406,158,414,166,422,174,430,182,438,190,446,198,454,206,462,214,470,222,478,230,486,238,494,246,502,254,510, // CCX 6 on CPU 2, alternating real and hyper-threads
                        135,391,143,399,151,407,159,415,167,423,175,431,183,439,191,447,199,455,207,463,215,471,223,479,231,487,239,495,247,503,255,511  // CCX 7 on CPU 2, alternating real and hyper-threads
					};
				#else // prefer one socket and then real threads. Now round robin pinning between CCX, to get a more uniformly distributed memory pattern.
					static uint16_t __attribute__ ((unused)) the_cores[] ={ 
                        0  ,8  ,16 ,24 ,32 ,40 ,48 ,56 ,64 ,72 ,80 ,88 ,96 ,104,112,120, // CCx 0 on CPU 1, real threads
                        1  ,9  ,17 ,25 ,33 ,41 ,49 ,57 ,65 ,73 ,81 ,89 ,97 ,105,113,121, // CCx 1 on CPU 1, real threads
                        2  ,10 ,18 ,26 ,34 ,42 ,50 ,58 ,66 ,74 ,82 ,90 ,98 ,106,114,122, // CCx 2 on CPU 1, real threads
                        3  ,11 ,19 ,27 ,35 ,43 ,51 ,59 ,67 ,75 ,83 ,91 ,99 ,107,115,123, // CCx 3 on CPU 1, real threads
                        4  ,12 ,20 ,28 ,36 ,44 ,52 ,60 ,68 ,76 ,84 ,92 ,100,108,116,124, // CCx 4 on CPU 1, real threads
                        5  ,13 ,21 ,29 ,37 ,45 ,53 ,61 ,69 ,77 ,85 ,93 ,101,109,117,125, // CCx 5 on CPU 1, real threads
                        6  ,14 ,22 ,30 ,38 ,46 ,54 ,62 ,70 ,78 ,86 ,94 ,102,110,118,126, // CCx 6 on CPU 1, real threads
                        7  ,15 ,23 ,31 ,39 ,47 ,55 ,63 ,71 ,79 ,87 ,95 ,103,111,119,127, // CCx 7 on CPU 1, real threads
                        256,264,272,280,288,296,304,312,320,328,336,344,352,360,368,376, // CCx 0 on CPU 1, hyperthreads
                        257,265,273,281,289,297,305,313,321,329,337,345,353,361,369,377, // CCx 1 on CPU 1, hyperthreads
                        258,266,274,282,290,298,306,314,322,330,338,346,354,362,370,378, // CCx 2 on CPU 1, hyperthreads
                        259,267,275,283,291,299,307,315,323,331,339,347,355,363,371,379, // CCx 3 on CPU 1, hyperthreads
                        260,268,276,284,292,300,308,316,324,332,340,348,356,364,372,380, // CCx 4 on CPU 1, hyperthreads
                        261,269,277,285,293,301,309,317,325,333,341,349,357,365,373,381, // CCx 5 on CPU 1, hyperthreads
                        262,270,278,286,294,302,310,318,326,334,342,350,358,366,374,382, // CCx 6 on CPU 1, hyperthreads
                        263,271,279,287,295,303,311,319,327,335,343,351,359,367,375,383, // CCx 7 on CPU 1, hyperthreads
                        128,136,144,152,160,168,176,184,192,200,208,216,224,232,240,248, // CCx 0 on CPU 2, real threads
                        129,137,145,153,161,169,177,185,193,201,209,217,225,233,241,249, // CCx 1 on CPU 2, real threads
                        130,138,146,154,162,170,178,186,194,202,210,218,226,234,242,250, // CCx 2 on CPU 2, real threads
                        131,139,147,155,163,171,179,187,195,203,211,219,227,235,243,251, // CCx 3 on CPU 2, real threads
                        132,140,148,156,164,172,180,188,196,204,212,220,228,236,244,252, // CCx 4 on CPU 2, real threads
                        133,141,149,157,165,173,181,189,197,205,213,221,229,237,245,253, // CCx 5 on CPU 2, real threads
                        134,142,150,158,166,174,182,190,198,206,214,222,230,238,246,254, // CCx 6 on CPU 2, real threads
                        135,143,151,159,167,175,183,191,199,207,215,223,231,239,247,255, // CCx 7 on CPU 2, real threads
                        384,392,400,408,416,424,432,440,448,456,464,472,480,488,496,504, // CCx 0 on CPU 2, hyperthreads
                        385,393,401,409,417,425,433,441,449,457,465,473,481,489,497,505, // CCx 1 on CPU 2, hyperthreads
                        386,394,402,410,418,426,434,442,450,458,466,474,482,490,498,506, // CCx 2 on CPU 2, hyperthreads
                        387,395,403,411,419,427,435,443,451,459,467,475,483,491,499,507, // CCx 3 on CPU 2, hyperthreads
                        388,396,404,412,420,428,436,444,452,460,468,476,484,492,500,508, // CCx 4 on CPU 2, hyperthreads
                        389,397,405,413,421,429,437,445,453,461,469,477,485,493,501,509, // CCx 5 on CPU 2, hyperthreads
                        390,398,406,414,422,430,438,446,454,462,470,478,486,494,502,510, // CCx 6 on CPU 2, hyperthreads
                        391,399,407,415,423,431,439,447,455,463,471,479,487,495,503,511  // CCx 7 on CPU 2, hyperthreads
                    };
				#endif
			#endif
		#endif
		#if defined(EXAMPLE)
			#define NUMBER_OF_SOCKETS 1
			#define CORES_PER_SOCKET  128
			#define CACHE_LINE_SIZE   64
			#define NOP_DURATION      2
			#if MEMORY_SETUP == 2 // Alternate between sockets
				static uint16_t __attribute__ ((unused)) the_cores[] ={
					#error Not defined! This thread pinning strategy is not used by default in the tests, so need not be implemented to re-create the experiments.
				};
			#else
				#if HYPERTHREAD == 1 // Alternate real and hyperthread on each socket
					static uint16_t __attribute__ ((unused)) the_cores[] ={
						#error Not defined! This thread pinning strategy is not used by default in the tests, so need not be implemented to re-create the experiments.
					};
				#else // Now just set to increment from 0 to the max thread number (256 here). This is usually a fine strategy for many CPU, at least until starting to use SMT
					static uint16_t __attribute__ ((unused)) the_cores[] ={ 
						0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255
                    };
				#endif
			#endif
		#endif  /* kåre - */
		/******************************************************************************************************************************************/
		#ifdef MAGLITE
			#define NUMBER_OF_SOCKETS 8
			#define CORES_PER_SOCKET 8
			#define CACHE_LINE_SIZE 64
			#define NOP_DURATION 9
			//mapping from threads to cores on the niagara
			#define ALTERNATE_SOCKETS
			#ifdef ALTERNATE_SOCKETS
				static uint8_t __attribute__ ((unused)) the_cores[] = {
					0, 8, 16, 24, 32, 40, 48, 56,
					1, 9, 17, 25, 33, 41, 49, 57,
					2, 10, 18, 26, 34, 42, 50, 58,
					3, 11, 19, 27, 35, 43, 51, 59,
					4, 12, 20, 28, 36, 44, 52, 60,
					5, 13, 21, 29, 37, 45, 53, 61,
					6, 14, 22, 30, 38, 46, 54, 62,
					7, 15, 23, 31, 39, 47, 55, 63
				};

				static uint8_t __attribute__ ((unused)) the_sockets[] = {
					0, 0, 0, 0, 0, 0, 0, 0,
					1, 1, 1, 1, 1, 1, 1, 1,
					2, 2, 2, 2, 2, 2, 2, 2,
					3, 3, 3, 3, 3, 3, 3, 3,
					4, 4, 4, 4, 4, 4, 4, 4,
					5, 5, 5, 5, 5, 5, 5, 5,
					6, 6, 6, 6, 6, 6, 6, 6,
					7, 7, 7, 7, 7, 7, 7, 7
				};
				#else
				static uint8_t __attribute__ ((unused)) the_cores[] = {
					0, 1, 2, 3, 4, 5, 6, 7,
					8, 9, 10, 11, 12, 13, 14, 15,
					16, 17, 18, 19, 20, 21, 22, 23,
					24, 25, 26, 27, 28, 29, 30, 31,
					32, 33, 34, 35, 36, 37, 38, 39,
					40, 41, 42, 43, 44, 45, 46, 47,
					48, 49, 50, 51, 52, 53, 54, 55,
					56, 57, 58, 59, 60, 61, 62, 63
				};
				static uint8_t __attribute__ ((unused)) the_sockets[] = {
					0, 0, 0, 0, 0, 0, 0, 0,
					1, 1, 1, 1, 1, 1, 1, 1,
					2, 2, 2, 2, 2, 2, 2, 2,
					3, 3, 3, 3, 3, 3, 3, 3,
					4, 4, 4, 4, 4, 4, 4, 4,
					5, 5, 5, 5, 5, 5, 5, 5,
					6, 6, 6, 6, 6, 6, 6, 6,
					7, 7, 7, 7, 7, 7, 7, 7
				};
			#endif
		#endif	/* MAGLITE */

		#if defined __tile__
			#define NUMBER_OF_SOCKETS 1
			#define CORES_PER_SOCKET 36
			#define CACHE_LINE_SIZE 64
			#define NOP_DURATION 4
			static uint8_t __attribute__ ((unused)) the_cores[] = {
				0, 1, 2, 3, 4, 5, 6, 7,
				8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23,
				24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35
			};
		#endif	/*  */


		#if defined(OPTERON)
			#define NUMBER_OF_SOCKETS 8
			#define CORES_PER_SOCKET 6
			#define CACHE_LINE_SIZE 64
			#define NOP_DURATION 2
			static uint8_t  UNUSED the_cores[] = {
				0, 1, 2, 3, 4, 5, 6, 7,
				8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23,
				24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39,
				40, 41, 42, 43, 44, 45, 46, 47
			};
		#endif	/*  */

		#if defined(HASWELL) || defined(IGORLAPTOPLINUX) || defined(LPDPC4)
			#define NUMBER_OF_SOCKETS 1
			#define CORES_PER_SOCKET 8
			#define CACHE_LINE_SIZE 64
			#define NOP_DURATION 2
			static UNUSED uint8_t  the_cores[] = {
				0, 1, 2, 3, 4, 5, 6, 7,
				0, 1, 2, 3, 4, 5, 6, 7,
				0, 1, 2, 3, 4, 5, 6, 7,
				0, 1, 2, 3, 4, 5, 6, 7,
				0, 1, 2, 3, 4, 5, 6, 7,
				0, 1, 2, 3, 4, 5, 6, 7,
				0, 1, 2, 3, 4, 5, 6, 7,
			};

			static __attribute__ ((unused)) double static_power[3] = { 0, 0, 0 };
			static __attribute__ ((unused)) double eng_per_test_iter_nj[8][5] =
			{
				{ 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0 },
				{ 0, 0, 0, 0, 0 },
			};
		#endif	/*  */

		#if defined(OANALAPTOPLINUX)
			#define NUMBER_OF_SOCKETS 1
			#define CORES_PER_SOCKET 2
			#define CACHE_LINE_SIZE 64
			#define NOP_DURATION 2
			static uint8_t  the_cores[] = {
				0, 1, 2, 3, 4, 5, 6, 7,
				8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23,
				24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39,
				40, 41, 42, 43, 44, 45, 46, 47
			};
		#endif  /*  */

		#if defined(XEON)
			#define NUMBER_OF_SOCKETS 8
			#define CORES_PER_SOCKET 10
			#define CACHE_LINE_SIZE 64
			#define NOP_DURATION 1
			static uint8_t __attribute__ ((unused)) the_cores[] = {
				1,2,3,4,5,6,7,8,9,10,	/* 0 */
				11,12,13,14,15,16,17,18,19,20, /* 1 */
				21,22,23,24,25,26,27,28,29,30, /* 2 */
				31,32,33,34,35,36,37,38,39,40, /* 3 */

				41,42,43,44,45,46,47,48,49,50, /* 0 */
				51,52,53,54,55,56,57,58,59,60, /* 1 */
				61,62,63,64,65,66,67,68,69,70,  /* 2 */
				71,72,73,74,75,76,77,78,79,80, /* 3 */

				0,81,82,83,84,85,86,87,88,89,  /* 4 */
				90,91,92,93,94,95,96,97,98,99, /* 5 */
				100,101,102,103,104,105,106,107,108,109, /* 6 */
				110,111,112,113,114,115,116,117,118,119, /* 7 */

				120,121,122,123,124,125,126,127,128,129, /* 4 */
				130,131,132,133,134,135,136,137,138,139, /* 5 */
				140,141,142,143,144,145,146,147,148,149, /* 6 */
				150,151,152,153,154,155,156,157,158,159,  /* 7 */


			};
			static uint8_t __attribute__ ((unused)) the_sockets[] =
			{
				0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
				1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
				2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
				3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
				4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
				5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
				6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
				7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
				0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
				1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
				2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
				3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
				4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
				5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
				6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
				7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
			};

		#endif



		#if defined(LPDQUAD)
			#define NUMBER_OF_SOCKETS 4
			#define CORES_PER_SOCKET 24
			#define CACHE_LINE_SIZE 64
			#define NOP_DURATION 2	/* have not actually measured it! */

			#define USE_HYPERTRHEADS 0	/* use first all the hyperthreads of one socket if set */


			#if USE_HYPERTRHEADS == 1
				static uint8_t UNUSED the_cores[] =
				{
					0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60, 64, 68, 72, 76, 80, 84, 88, 92,
					1, 5, 9, 13, 17, 21, 25, 29, 33, 37, 41, 45, 49, 53, 57, 61, 65, 69, 73, 77, 81, 85, 89, 93,
					2, 6, 10, 14, 18, 22, 26, 30, 34, 38, 42, 46, 50, 54, 58, 62, 66, 70, 74, 78, 82, 86, 90, 94,
					3, 7, 11, 15, 19, 23, 27, 31, 35, 39, 43, 47, 51, 55, 59, 63, 67, 71, 75, 79, 83, 87, 91, 95,
				};


				#elif USE_HYPERTRHEADS == 2
				static uint8_t UNUSED the_cores[] =
				{
					0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44,
					1, 5, 9, 13, 17, 21, 25, 29, 33, 37, 41, 45,
					2, 6, 10, 14, 18, 22, 26, 30, 34, 38, 42, 46,
					3, 7, 11, 15, 19, 23, 27, 31, 35, 39, 43, 47,
					48, 52, 56, 60, 64, 68, 72, 76, 80, 84, 88, 92,
					49, 53, 57, 61, 65, 69, 73, 77, 81, 85, 89, 93,
					50, 54, 58, 62, 66, 70, 74, 78, 82, 86, 90, 94,
					51, 55, 59, 63, 67, 71, 75, 79, 83, 87, 91, 95,
				};
				#else

				static uint8_t UNUSED the_cores[] =
				{
					0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60, 64, 68, 72, 76, 80, 84, 88, 92,
					1, 5, 9, 13, 17, 21, 25, 29, 33, 37, 41, 45, 49, 53, 57, 61, 65, 69, 73, 77, 81, 85, 89, 93,
					2, 6, 10, 14, 18, 22, 26, 30, 34, 38, 42, 46, 50, 54, 58, 62, 66, 70, 74, 78, 82, 86, 90, 94,
					3, 7, 11, 15, 19, 23, 27, 31, 35, 39, 43, 47, 51, 55, 59, 63, 67, 71, 75, 79, 83, 87, 91, 95,
				};
			#endif
		#endif

		#if defined(LPDXEON)
			#define NUMBER_OF_SOCKETS 2
			#define CORES_PER_SOCKET 20
			#define CACHE_LINE_SIZE 64
			#define NOP_DURATION 2	/* have not actually measured it! */

			#define USE_HYPERTRHEADS 0	/* use first all the hyperthreads of one socket if set */

			static __attribute__ ((unused)) double static_power[3] = { 55.352036, 27.152955, 28.199081 };

			#if USE_HYPERTRHEADS == 1
				static uint8_t UNUSED the_cores[] =
				{
					0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
					20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
					10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
					30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
					40, 41, 42, 43, 44, 45, 46, 47, 48, 49 /* extra 10 cores used on other machines */
				};

				static __attribute__ ((unused)) double eng_per_test_iter_nj[40][5] =
				{
					{ 229.69729598644526791474, 155.66214662469074066401, 81.83660070338615833062, 74.03514936175452725073, 73.82554592130458233338 },
					{ 129.92729806775347849450, 92.87097637973462891891, 56.00234334076527234995, 37.05632168801884957558, 36.86863303896935656896 },
					{ 90.41777757464943248965, 65.52330993301908554940, 40.91458270191838825779, 24.89446764163034694025, 24.60872723110069729160 },
					{ 71.70503359096182987812, 53.24135231318132056255, 34.80945251967976791088, 18.46368127778050931557, 18.43189979350155265166 },
					{ 61.46753870671294508202, 46.78646439258800146428, 32.03633878459513542680, 14.68107315213430217184, 14.75012676998350748336 },
					{ 54.97594655229231348292, 42.71548104800787877290, 30.41308814787980294890, 12.26046550428443471002, 12.30239193218561013831 },
					{ 51.02304494347293687860, 40.37056455594769643394, 29.76741673354698132698, 10.65248038752524044465, 10.60314782240071510696 },
					{ 46.66188950826064796324, 37.48114377688081847622, 28.25001855878092773848, 9.18074573137982948701, 9.23112521809989073774 },
					{ 43.82981659933958230283, 35.69367323680874111720, 27.49950147952476895043, 8.13614336253084118562, 8.19417175728397216677 },
					{ 41.69095949967046461199, 34.30773768541027309793, 26.91831862599122132592, 7.38322181426019151406, 7.38941905941905177200 },
					{ 40.59293050480954019531, 33.45212847545872453059, 26.30114873118361091350, 7.14080202935081566471, 7.15097974427511361709 },
					{ 40.44686414650826126024, 33.31671652956449391896, 26.27224100478459902189, 7.13014761694376734127, 7.04447552477989489707 },
					{ 38.63400068948118319131, 31.91860005978480917390, 25.19750824179147185110, 6.71540062969637401740, 6.72109181799333732280 },
					{ 37.67909047223780921291, 31.18991524978350760173, 24.66098999594509043423, 6.48917522245430161117, 6.52892525383841716750 },
					{ 37.48723976518549914509, 31.06633912116336134131, 24.60876432712765744925, 6.42090064402213780378, 6.45757479403570389206 },
					{ 35.93501879430925271111, 29.75867009353556265858, 23.58547726220328510678, 6.17634870077369005252, 6.17319283133227755179 },
					{ 35.05017234730261831232, 29.09994805102562282020, 23.10239243045587092387, 5.95022429627699549212, 5.99755609020108517101 },
					{ 34.33623863130784173523, 28.53358911826720240123, 22.69320957257437978096, 5.80264951304063933400, 5.84037954569282262026 },
					{ 33.62212279422026234553, 27.97741535442858221174, 22.29040838672357529177, 5.64470743979168013378, 5.68700696770500691997 },
					{ 32.96013040831562785054, 27.45807499800290621390, 21.91855412561404127317, 5.50205541031272163663, 5.53952087238886494072 },
					{ 47.28979119370549142660, 37.57742259581472526086, 27.12930484663258689462, 9.71236859789076616574, 10.44811774918213836623 },
					{ 45.04223960057763314934, 36.12670245507833406360, 26.35758635758431850058, 8.91553714549929908573, 9.76911609749401556301 },
					{ 43.67058189530530121470, 35.30521274013663281700, 26.11846887938988574819, 8.36536915516866839769, 9.18674386074674706881 },
					{ 42.60576732090060253270, 34.66262408187614412303, 25.99871539418099355935, 7.94314323902445840966, 8.66390902206491067188 },
					{ 41.43785484784768595987, 33.96582093092079759619, 25.76444895626643043996, 7.47203391692688836368, 8.20137197465436715622 },
					{ 40.52741384104634466711, 33.41888347027097869475, 25.64406424437515648596, 7.10853037077536597235, 7.77481922589582220879 },
					{ 39.73059107478248313233, 32.98011789158887275831, 25.57809009720159869296, 6.75047289800730009821, 7.40202779438727406534 },
					{ 38.94634111648463567134, 32.51279081568074916725, 25.46060084018057458151, 6.43355030080388650408, 7.05219024731822665330 },
					{ 38.16383202841839362803, 32.03052300604605296144, 25.28963494582244393904, 6.13330902237234066659, 6.74088831997533912918 },
					{ 37.63081417152950568538, 31.70806299031871792150, 25.24062036465074840362, 5.92275093244654732551, 6.46744287443220995623 },
					{ 37.40460815458195975134, 31.49719966424260718405, 25.10160606515992572487, 5.90740824439235785549, 6.39559384502967617097 },
					{ 36.70523797166752357139, 31.01720151497208405688, 24.72886652361023523840, 5.68803645669543951451, 6.28833474977085589582 },
					{ 36.36230898406250579150, 30.71837596401063154148, 24.51039400569840274168, 5.64393325838237797544, 6.20798171998172507437 },
					{ 35.94203972550205584335, 30.38581980198740920074, 24.26089097066515915434, 5.55621992351464664261, 6.12492883132225004640 },
					{ 35.57800034292794851435, 30.07757882236843739458, 24.03853750233998553733, 5.50042152055951111976, 6.03904132002845185724 },
					{ 35.39234634574758951660, 29.89126654242762491350, 23.91805792786781963610, 5.50107980331996460310, 5.97320861455980527740 },
					{ 34.82555044972040436622, 29.49492132651811652940, 23.61327246397056092310, 5.33062934896130439254, 5.88164886254755560630 },
					{ 34.46029740456764074470, 29.19381617075399181019, 23.38893084166544372580, 5.26648123381364893451, 5.80488555171465413568 },
					{ 34.12928397922275831757, 28.91513972025352938497, 23.18354067760409305115, 5.21414425896922893259, 5.73159904264943633382 },
					{ 34.01931977364001659009, 28.78915228904349525819, 23.09106190310396673079, 5.23016748459652133189, 5.69809038593952852740 },
				};

				#elif USE_HYPERTRHEADS == 2
				static uint8_t UNUSED the_cores[] =
				{
					0, 20, 1, 21, 2, 22, 3, 23, 4, 24, 5, 25, 6, 26, 7, 27, 8, 28, 9, 29,
					10, 30, 11, 32, 12, 32, 13, 33, 14, 34, 15, 35, 16, 36, 17, 37, 18, 38, 19, 39,
					40, 41, 42, 43, 44, 45, 46, 47, 48, 49 /* extra 10 cores used on other machines */
				};

				#else

				static uint8_t UNUSED the_cores[] =
				{
					0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
					10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
					20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
					30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
					40, 41, 42, 43, 44, 45, 46, 47, 48, 49 /* extra 10 cores used on other machines */

				};

				static __attribute__ ((unused)) double eng_per_test_iter_nj[40][5] =
				{
					{ 234.60202230853298000266, 157.78963908775246754635, 80.44831687022313379144, 76.81238322078051245630, 77.34131612172547360784 },
					{ 130.19996880311263288606, 91.56731092586975276041, 52.80283160655244668894, 38.63265787724288012565, 38.76447931931730607146 },
					{ 97.91595546524582008240, 72.39697050602267259573, 46.60342225213650460048, 25.51898495922314748667, 25.79354825388616799524 },
					{ 77.04375160600302599006, 57.57828792397870397323, 38.21962801434882946454, 19.46546215830228597312, 19.35866143335191055239 },
					{ 66.60063321661194166091, 51.15731276822387036897, 35.66530615337983236951, 15.44332044838807129193, 15.49200661484403799946 },
					{ 57.49899387962235952981, 44.58655908661531318309, 31.68513275476549920752, 12.91243479300704634671, 12.90142633184981397557 },
					{ 53.27035061266595667227, 42.10006040481277496608, 30.96939543760024990670, 11.17029108323957857484, 11.13066409182612819072 },
					{ 48.92342769050576551962, 39.24447490279040370380, 29.56886689364194497347, 9.67895202667359460237, 9.67560800914845873033 },
					{ 46.12214510779135114825, 37.45366351767337511821, 28.83407196255519128182, 8.66848226745290259961, 8.61959155511818383639 },
					{ 43.63624377096353945724, 35.89729262149872662820, 28.14989135969805710956, 7.73895114946481282903, 7.74740065317834627917 },
					{ 62.26695987361801406190, 48.98600780801804534908, 34.50521338743658272535, 13.28095206559996871281, 14.48079498170199685330 },
					{ 58.81986970966034325330, 46.64160874974837420037, 33.47459881463837642843, 12.17826045039200038526, 13.16700993510999777193 },
					{ 55.77327394848195568283, 44.59252612218050592723, 32.45971838900925961332, 11.18074782630144975560, 12.13280773317124631390 },
					{ 53.35587288745431262924, 43.02595839718354181266, 31.76556645416326274830, 10.32991492545868382811, 11.26039194302027906436 },
					{ 51.22436410494622750896, 41.60525336637767574119, 31.08686360026960446088, 9.61911114484092710457, 10.51838976610807128030 },
					{ 50.72842739157257898552, 41.36400358256455644076, 31.45162462316764386700, 9.36442380900802254475, 9.91237857683589650565 },
					{ 48.99046398301495587324, 40.32421848749861061920, 30.99405693133628881203, 8.66624585523240489317, 9.33016155616232180716 },
					{ 48.11277574019122570714, 39.71043989030147027573, 30.87415450267398697528, 8.40233584988975543140, 8.83628538762748330044 },
					{ 47.27696104262690915577, 39.07910823119677425900, 30.69454806615792056010, 8.19785313422370833973, 8.38455984224528025593 },
					{ 45.16170140463251706290, 37.66052939798363717429, 29.68952434502926891488, 7.50117231340289999367, 7.97100474620034815434 },
					{ 44.51583685738054533766, 37.15204737263273381387, 29.32370958651938854100, 7.36378948474781152379, 7.82833778611334527287 },
					{ 43.43013825275178117605, 36.45475025278843083354, 28.78995224052679450709, 6.97538799996335034250, 7.66479830697727120339 },
					{ 42.94690003756602036974, 36.04904963824908174182, 28.51084325552140461565, 6.89785039931693862791, 7.53820638272767712617 },
					{ 42.26067973923170856435, 35.53403983813456176836, 28.13027516609941735845, 6.72663990109714679598, 7.40376467203514440991 },
					{ 41.98618856775846311797, 35.24569998142351115429, 27.93292096951690480387, 6.74048858633495196368, 7.31277873099243677336 },
					{ 41.20836493276575472375, 34.68626534514603305665, 27.50999590394027310286, 6.52209986326137167710, 7.17626916556410994378 },
					{ 40.87150736222739389167, 34.36797495572245203629, 27.28895716569301410588, 6.50353267815879815155, 7.07901751837558163423 },
					{ 40.25219121707161961689, 33.91928887901263807204, 26.96299045247495756590, 6.33290233805898154485, 6.95629815954399156785 },
					{ 39.83391484521466729567, 33.59152539482701028605, 26.73460514635079961834, 6.24238945038765700961, 6.85692024847621066771 },
					{ 39.55126277140646402901, 33.33080507859673118252, 26.56300538880562612737, 6.22045769280973284649, 6.76779968979110505514 },
					{ 38.96658623593443610402, 32.90791002776678688417, 26.25382275043740832491, 6.05867620816764921985, 6.65408702222620201318 },
					{ 38.68918927266693359830, 32.65106439580023766058, 26.07516254009421377975, 6.03812512886984064766, 6.57590185570602388082 },
					{ 38.16034503480971312149, 32.31342179350376932966, 25.83713511502098060769, 5.84692324130594379183, 6.47628667848278872196 },
					{ 37.91648062860701649610, 32.02772316504159186846, 25.64230586534548387014, 5.88875746356542462763, 6.38541754433334922594 },
					{ 37.28148927946042406843, 31.59798786276086677330, 25.31658436857910177437, 5.68350141669955729513, 6.28140349418176499893 },
					{ 37.02177497269500577004, 31.36130736103363126266, 25.15403294750756878376, 5.66046761166137450738, 6.20727441352606247890 },
					{ 36.52273643324810166725, 30.98044786895787129327, 24.86612807705081168421, 5.54228833027635982942, 6.11431979190705960906 },
					{ 36.19653408528347033103, 30.72216019713365534917, 24.68578867382584546101, 5.47437411908338849177, 6.03637152330780988816 },
					{ 36.08325306161539608844, 30.59647911797491177361, 24.61054348764035785114, 5.48677371485792065615, 5.98593563033455392247 },
					{ 35.52336201872074272167, 30.19903621272641681415, 24.31628487828975205780, 5.32432580599432590751, 5.88275133443666475635 },
				};
			#endif
		#endif

		#if defined(LAPTOP)
			#define NUMBER_OF_SOCKETS 1
			#define CORES_PER_SOCKET 8
			#define CACHE_LINE_SIZE 64
			#define NOP_DURATION 1
			static uint8_t UNUSED the_cores[] = {
				0, 1, 2, 3, 4, 5, 6, 7,
				8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23,
				24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39,
				40, 41, 42, 43, 44, 45, 46, 47
			};
			static uint8_t UNUSED the_sockets[] =
			{
				0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			};

		#endif


		/* PLATFORM specific -------------------------------------------------------------------- */
		#if !defined(PREFETCHW)
			#if defined(__x86_64__)
				#  define PREFETCHW(x)		     asm volatile("prefetchw %0" :: "m" (*(unsigned long *)x))
			#elif defined(__sparc__)
				#  define PREFETCHW(x)
			#elif defined(XEON)
				#  define PREFETCHW(x)
			#else
				#  define PREFETCHW(x)
			#endif
		#endif

		#if !defined(PREFETCH)
			#if defined(__x86_64__)
				#  define PREFETCH(x)		     asm volatile("prefetch %0" :: "m" (*(unsigned long *)x))
				#elif defined(__sparc__)
				#  define PREFETCH(x)
				#elif defined(XEON)
				#  define PREFETCH(x)
				#else
				#  define PREFETCH(x)
			#endif
		#endif


		//debugging functions
		#ifdef DEBUG
			#define DPRINT(args...) fprintf(stderr,args);
			#define DDPRINT(fmt, args...) printf("%s:%s:%d: "fmt, __FILE__, __FUNCTION__, __LINE__, args)
			#else
			#define DPRINT(...)
			#define DDPRINT(fmt, ...)
		#endif



		static inline int get_cluster(int thread_id) {
			#ifdef __solaris__
				if (thread_id>64){
					perror("Thread id too high");
					return 0;
				}
				return thread_id/CORES_PER_SOCKET;
				//    return the_sockets[thread_id];
			#elif XEON
				if (thread_id>=80){
					perror("Thread id too high");
					return 0;
				}

				return the_sockets[thread_id];
			#elif defined(__tile__)
				return 0;
			#else
				return thread_id/CORES_PER_SOCKET;
			#endif
		}

		static inline double wtime(void)
		{
			struct timeval t;
			gettimeofday(&t,NULL);
			return (double)t.tv_sec + ((double)t.tv_usec)/1000000.0;
		}

		static inline
		void set_cpu(int cpu)
		{
			/****************************************************
				//ad- change affinity to NUMA mode custome for excess machine. Split threads to the available two processors
				#if MEMORY_SETUP == 2
				#if defined(EXCESS)
				extern size_t num_threads;
				int thread_idn=cpu;
				if(thread_idn%2==0)
				{
				cpu = thread_idn/2;
				}
				else
				{
				cpu = 7-(thread_idn/2)+thread_idn;
				}
				#endif
				#endif
			/****************************************************/
			#ifndef NO_SET_CPU
				#ifdef __sparc__
					processor_bind(P_LWPID,P_MYID, the_cores[cpu], NULL);
				#elif defined(__tile__)
					if (cpu>=tmc_cpus_grid_total())
					{
						perror("Thread id too high");
					}
					// cput_set_t cpus;
					if (tmc_cpus_set_my_cpu(the_cores[cpu])<0)
					{
						tmc_task_die("tmc_cpus_set_my_cpu() failed.");
					}
				#else
					int n_cpus = sysconf(_SC_NPROCESSORS_ONLN);
					//    cpu %= (NUMBER_OF_SOCKETS * CORES_PER_SOCKET);
					if (cpu < n_cpus)
					{
						int cpu_use = the_cores[cpu];
						cpu_set_t mask;
						CPU_ZERO(&mask);
						CPU_SET(cpu_use, &mask);
						#  if defined(PLATFORM_NUMA)
							numa_set_preferred(get_cluster(cpu_use));
						#  endif
						pthread_t thread = pthread_self();
						if (pthread_setaffinity_np(thread, sizeof(cpu_set_t), &mask) != 0)
						{
							fprintf(stderr, "Error setting thread affinity\n");
						}
					}
				#endif
			#endif
		}


		static inline void cdelay(ticks cycles)
		{
			if (unlikely(cycles == 0))
			{
				return;
			}
			ticks __ts_end = getticks() + (ticks) cycles;
			while (getticks() < __ts_end);
		}

		static inline void cpause(ticks cycles)
		{
			#if defined(XEON)
				cycles >>= 3;
				ticks i;
				for (i=0;i<cycles;i++)
				{
					_mm_pause();
				}
				#else
				ticks i;
				for (i=0;i<cycles;i++)
				{
					__asm__ __volatile__("nop");
				}
			#endif
		}

		static inline void udelay(unsigned int micros)
		{
			double __ts_end = wtime() + ((double) micros / 1000000);
			while (wtime() < __ts_end);
		}

		//getticks needs to have a correction because the call itself takes a
		//significant number of cycles and skewes the measurement
		extern ticks getticks_correction_calc();

		static inline ticks get_noop_duration() {
			#define NOOP_CALC_REPS 1000000
			ticks noop_dur = 0;
			uint32_t i;
			ticks corr = getticks_correction_calc();
			ticks start;
			ticks end;
			start = getticks();
			for (i=0;i<NOOP_CALC_REPS;i++) {
				__asm__ __volatile__("nop");
			}
			end = getticks();
			noop_dur = (ticks)((end-start-corr)/(double)NOOP_CALC_REPS);
			return noop_dur;
		}

		/// Round up to next higher power of 2 (return x if it's already a power
		/// of 2) for 32-bit numbers
		static inline uint32_t pow2roundup (uint32_t x)
		{
			if (x==0) return 1;
			--x;
			x |= x >> 1;
			x |= x >> 2;
			x |= x >> 4;
			x |= x >> 8;
			x |= x >> 16;
			return x+1;
		}

		static const size_t pause_fixed = 16384;

		static inline void do_pause()
		{
			cpause((mrand(seeds) % pause_fixed));
		}


		static const size_t pause_max   = 16384;
		static const size_t pause_base  = 512; //64;//ad-
		static const size_t pause_min   = 512; //64;//ad-

		static inline void do_pause_exp(size_t nf)
		{
			if (unlikely(nf > 32))
			{
				nf = 32;
			}
			const size_t p = (pause_base << nf);
			const size_t pm = (p > pause_max) ? pause_max : p;
			const size_t tp = pause_min + (mrand(seeds) % pm);

			cdelay(tp);
		}

		// 0: fixed max pause
		// 1: exponentially increasing pause
		#define DO_PAUSE_EXP(nr)            do_pause_exp(nr);//cdelay(nr); // //ruk
		#define DO_PAUSE_TYPE     1
		#if DO_PAUSE_TYPE == 0
			#define DO_PAUSE()            do_pause()
			#define NUM_RETRIES()
		#elif DO_PAUSE_TYPE == 1
			#define DO_PAUSE()            do_pause_exp(__nr++);
			#define NUM_RETRIES()         UNUSED size_t __nr;
		#else
		#endif

		#ifdef __cplusplus
		}

	#endif


#endif
