##############################################################################################################################################################
# Material Suplementario - Rabuñal et al., en revisión. Las ocupaciones tardiglaciares de la Cova de Les Borres (La Febró, Tarragona). Trabajos de Prehistoria
##############################################################################################################################################################


##### Paquetes necesarios: readxl, rcarbon, pangear, dplyr
library(openxlsx)
library(rcarbon)
library(pangaear)
library(dplyr)

##### Cargar la base de datos desde el archivo "dataciones_tardiglaciar_este_peninsular.xlsx" con el nombre "dataciones_completo"
dataciones_completo = read.xlsx("data/dataciones_tardiglaciar_este_peninsular.xlsx")



##### Calibración de las dataciones de la Cova de Les Borres para elaborar la Tabla 1

## Calibración de las dataciones tardiglaciares
dataciones_lb_carbon = subset(dataciones_completo, YACIMIENTO=="Cova de Les Borres" & MUESTRA =="Carbón")
dataciones_lb_concha = subset(dataciones_completo, YACIMIENTO=="Cova de Les Borres" & MUESTRA =="Concha")

calibracion_lb_carbon = calibrate(x=dataciones_lb_carbon$BP,
                                  errors = dataciones_lb_carbon$SD,
                                  calCurves = "intcal20",
                                  ids = c("Beta-398109", "Beta-398110","Beta-516483"))
calibracion_lb_concha = calibrate(x= dataciones_lb_concha$BP,
                                  errors = dataciones_lb_concha$SD,
                                  resOffsets = -42,
                                  resErrors = 30,
                                  calCurves = "marine20",
                                  ids = "Beta-365279")

calibraciones_lb_tardiglaciar = combine(calibracion_lb_carbon,calibracion_lb_concha)

## Calibración de la datación de la Estructura 1B
calibracion_lb_estr1B = calibrate(x=1330,
                                  errors= 30,
                                  calCurves="intcal20",
                                  ids="Beta-465325")

### Exportar las calibraciones de todas las fechas disponibles de Cova de Les Borres
calibraciones_lb_completo = combine(calibraciones_lb_tardiglaciar,calibracion_lb_estr1B)
calibraciones_tabla1 = summary(calibraciones_lb_completo)
write.xlsx(calibraciones_tabla1, file = "calibraciones_tabla1.xlsx")



##### Figura 6. Curvas de probabilidad acumulada de dataciones radiométricas para conjuntos tardiglaciares y postglaciares sin geométricos y con geométricos, y para las ocupaciones asociadas al Magdaleniense Superior Final y Sauveterroide de la Cova de Les Borres

## Calibración de las dataciones de conjuntos tardiglaciares del este peninsular
dataciones_tardiglaciar = subset(dataciones_completo, YACIMIENTO!="Cova de Les Borres")
dataciones_con_geometricos = subset(dataciones_tardiglaciar,GEOMETRICOS==TRUE)
dataciones_sin_geometricos = subset(dataciones_tardiglaciar,GEOMETRICOS==FALSE)
dataciones_sin_geometricos_marine = subset(dataciones_sin_geometricos,MUESTRA=="Concha")
dataciones_sin_geometricos_intcal = subset(dataciones_sin_geometricos,MUESTRA!="Concha")


calibracion_sin_geometricos_marine = calibrate(x= dataciones_sin_geometricos_marine$BP,
                                               errors = dataciones_sin_geometricos_marine$SD,
                                               resOffsets = -42,
                                               resErrors = 30,
                                               calCurves = "marine20",
                                               ids = dataciones_sin_geometricos_marine$REF_LAB)
calibracion_sin_geometricos_intcal = calibrate(x=dataciones_sin_geometricos_intcal$BP,
                                               errors = dataciones_sin_geometricos_intcal$SD,
                                               calCurves = "intcal20",
                                               ids = dataciones_sin_geometricos_intcal$REF_LAB)

calibraciones_sin_geometricos = combine(calibracion_sin_geometricos_marine,calibracion_sin_geometricos_intcal)
calibraciones_con_geometricos = calibrate(x= dataciones_con_geometricos$BP,
                                          errors = dataciones_con_geometricos$SD,
                                          calCurves = "intcal20",
                                          ids = dataciones_con_geometricos$REF_LAB)

## Distribución de la suma de probabilidades para los conjuntos con y sin geométricos de Cova de Les Borres

lb_nivel_1_2 = calibraciones_lb_tardiglaciar[calibraciones_lb_tardiglaciar$metadata$DateID=="Beta-516483"|
                                                     calibraciones_lb_tardiglaciar$metadata$DateID=="Beta-365279"]

spd_lb_nivel_1_2 = spd(lb_nivel_1_2, timeRange = c(16000,8000))

lb_nivel_2 = calibraciones_lb_tardiglaciar[calibraciones_lb_tardiglaciar$metadata$DateID=="Beta-398110"]

spd_lb_nivel_2 = spd(lb_nivel_2, timeRange = c(16000,8000))

## Distribución de la suma de probabilidades para conjuntos tardiglaciares con y sin geométricos del este peninsular

spd_sin_geometricos = spd(calibraciones_sin_geometricos, timeRange = c(16000,8000))
spd_con_geometricos = spd(calibraciones_con_geometricos, timeRange = c(16000,8000))

## Curva NGRIP

NGRIP<- pg_data(doi='10.1594/PANGAEA.824889')
NGRIPdata <- NGRIP[[1]]$data 
NGRIPdata <- rename(NGRIPdata, age = 2)
NGRIPdata <- rename(NGRIPdata, d18O = 3)
NGRIPdata$calBP <-NGRIPdata$age*1000 
NGRIPdata$calBP <- round(NGRIPdata$calBP, 0)
NGRIPdata <- NGRIPdata %>% filter(calBP>=8000 & calBP<=16000)

### Montaje de la Figura 6

tiff(filename = "Figura 6.tiff", width = 400, height = 179.25, units = "mm", res = 300)
par(mfrow=c(2,1))
par(yaxs="i")
par(xaxs="i")
par(oma=c(4,2,2,2))

#Gráfico dataciones
par(mar=c(0,4,0,4))

multi.plot = plot(spd_sin_geometricos, fill.p = rgb(.22,.63,.8,.5) , type = "standard", runm = 250, xaxt = "n")
multi.plot = plot(spd_con_geometricos, fill.p = rgb(.55,.68,.25,.5), add = TRUE, type = "standard", runm = 250, xaxt = "n")
multi.plot = plot(spd_lb_nivel_2, fill.p = rgb(1,1,0),add = TRUE, type = "standard", runm = 100, xaxt = "n")
multi.plot = plot(spd_lb_nivel_1_2, fill.p = rgb(0,0,0),add = TRUE, type = "standard", runm = 100, xaxt = "n")
legend(x=10500, y=.07, cex=1.5, bty = "n", legend = c("Conjuntos sin geométricos", "Conjuntos con geométricos", "Cova de Les Borres Niv. 2", "Cova de Les Borres Niv. 1.2"), fill=c(rgb(.22,.63,.8,.5),rgb(.55,.68,.25,.5),rgb(1,1,0), rgb(0,0,0)))
abline(v=c(14650,12846,11653,10800), lty=2)


#Gráfico clima
par(mar=c(0,4,0,4))
plot(x=NGRIPdata$calBP,
     y= NGRIPdata$d18O,
     xlab="cal BP",
     xaxt="n",
     yaxt="n",
     yaxs="i",
     xaxs="i",
     type="l",
     ylab = "",
     ylim=c(-46,-33),
     xlim=c(16000,8000),
     col="blue",lwd=2)
axis(1, at=seq(8000,16000, by=1000), tck=-0.02)
axis(1, at=seq(8000,16000, by=100), labels = FALSE, tck=-0.01)
axis(1, at=seq(8000,16000, by=1000),labels = FALSE, tck=0.02)
axis(1, at=seq(8000,16000, by=100), labels = FALSE, tck=0.01)
axis(4, at=seq(-46,-33, by=1), tck=-0.02)
axis(3, at=seq(8000,16000, by=1000), labels = FALSE, tck=-0.02)
axis(3, at=seq(8000,16000, by=100), labels = FALSE, tck=-0.01)
axis(3, at=seq(8000,16000, by=1000), labels = FALSE, tck=0.02)
axis(3, at=seq(8000,16000, by=100), labels = FALSE, tck=0.01)
mtext("cal BP", side=1, line = 2.7)
mtext("d18O", side = 4, line=2.7)
abline(v=c(14650,12846,11653,10800), lty=2)
text(15325,-45.5,labels="GS-2")
text(13763,-45.5,labels="GI-1")
text(12250,-45.5,labels="GS-1")
text(11227,-45.5,labels="PB")
text(9400,-45.5,labels="B")

dev.off()


