% Volume and its sensitivities: beams
function [V,dv1,dv2] = volbeam(V,dv1,dv2,nodes,edges,b,h)
ndv1 = size(dv1,1);
% Loop over beams
for i = 1:size(edges,1)
    n1 = edges(i,1);
    n2 = edges(i,2);
    x1 = nodes(n1,1); y1 = nodes(n1,2);
    x2 = nodes(n2,1); y2 = nodes(n2,2);
    L = ((x2-x1)^2+(y2-y1)^2)^0.5;
    b_beam = b(i);
    V = V + L*h*b_beam;
    coeff = 0.5*((x2-x1)^2+(y2-y1)^2)^(-0.5);
    dLdx1 = -coeff*2*(x2-x1);
    dLdx2 = coeff*2*(x2-x1);
    dLdy1 = -coeff*2*(y2-y1);
    dLdy2 = coeff*2*(y2-y1);
    
    dv1(i,1) = L*h;
    dv1(ndv1-1) = dv1(ndv1-1) + L*b_beam;
    
    dv2(2*n1-1,1) = dv2(2*n1-1,1) + dLdx1*h*b_beam;
    dv2(2*n1,1) = dv2(2*n1,1) + dLdy1*h*b_beam;
    dv2(2*n2-1,1) = dv2(2*n2-1,1) + dLdx2*h*b_beam;
    dv2(2*n2,1) = dv2(2*n2,1) + dLdy2*h*b_beam;


end

