% Sensitivity of deflection w.r.t nodes: plates
function dd = ddefplate_nodes(dd,U,ADJ,nodes,plates,E,nu,th)
nplates = size(plates,1);
% Loop over plates
for i = 1:nplates
    n1 = plates(i,1); n2 = plates(i,2); n3 = plates(i,3);
    plate_X = [nodes(n1,1) nodes(n2,1) nodes(n3,1)];
    plate_Y = [nodes(n1,2) nodes(n2,2) nodes(n3,2)];
    x1 = plate_X(1);  x2 = plate_X(2); x3 = plate_X(3);
    y1 = plate_Y(1);  y2 = plate_Y(2); y3 = plate_Y(3);
    edofCST = [6*n1-5,6*n1-4,6*n2-5,6*n2-4,6*n3-5,6*n3-4]; 
    edofDKT = [6*n1-3,6*n1-2,6*n1-1,6*n1,6*n2-3,6*n2-2,6*n2-1,6*n2,6*n3-3,6*n3-2,6*n3-1,6*n3]; 
    dkCSTdx1 = dkeCSTdx1(E,nu,th,x1,x2,x3,y1,y2,y3);
    dkCSTdy1 = dkeCSTdy1(E,nu,th,x1,x2,x3,y1,y2,y3);
    dkCSTdx2 = dkeCSTdx2(E,nu,th,x1,x2,x3,y1,y2,y3);
    dkCSTdy2 = dkeCSTdy2(E,nu,th,x1,x2,x3,y1,y2,y3);
    dkCSTdx3 = dkeCSTdx3(E,nu,th,x1,x2,x3,y1,y2,y3);
    dkCSTdy3 = dkeCSTdy3(E,nu,th,x1,x2,x3,y1,y2,y3);
    dkDKTdx1 = dkeDKTdx1(E,nu,th,x1,x2,x3,y1,y2,y3);
    dkDKTdy1 = dkeDKTdy1(E,nu,th,x1,x2,x3,y1,y2,y3);
    dkDKTdx2 = dkeDKTdx2(E,nu,th,x1,x2,x3,y1,y2,y3);
    dkDKTdy2 = dkeDKTdy2(E,nu,th,x1,x2,x3,y1,y2,y3);
    dkDKTdx3 = dkeDKTdx3(E,nu,th,x1,x2,x3,y1,y2,y3);
    dkDKTdy3 = dkeDKTdy3(E,nu,th,x1,x2,x3,y1,y2,y3);
    ueCST = U(edofCST,1); adjeCST = ADJ(edofCST,1);
    ueDKT = U(edofDKT,1); adjeDKT = ADJ(edofDKT,1);
    dddx1 = (adjeCST'*(dkCSTdx1*ueCST) + adjeDKT'*(dkDKTdx1*ueDKT));
    dddy1 = (adjeCST'*(dkCSTdy1*ueCST) + adjeDKT'*(dkDKTdy1*ueDKT));
    dddx2 = (adjeCST'*(dkCSTdx2*ueCST) + adjeDKT'*(dkDKTdx2*ueDKT));
    dddy2 = (adjeCST'*(dkCSTdy2*ueCST) + adjeDKT'*(dkDKTdy2*ueDKT));
    dddx3 = (adjeCST'*(dkCSTdx3*ueCST) + adjeDKT'*(dkDKTdx3*ueDKT));
    dddy3 = (adjeCST'*(dkCSTdy3*ueCST) + adjeDKT'*(dkDKTdy3*ueDKT));
    dd(2*n1-1) = dd(2*n1-1) + dddx1;
    dd(2*n1) = dd(2*n1) + dddy1;
    dd(2*n2-1) = dd(2*n2-1) + dddx2;
    dd(2*n2) = dd(2*n2) + dddy2; 
    dd(2*n3-1) = dd(2*n3-1) + dddx3;
    dd(2*n3) = dd(2*n3) + dddy3; 
end
end