% Sensitivity of deflection w.r.t nodes: beams
function dd = ddefbeam_nodes(dd,U,ADJ,nodes,edges,E,nu,b,h,th)
% Loop over beams
for i = 1:size(edges,1)
    n1 = edges(i,1);
    n2 = edges(i,2);
    x1 = nodes(n1,1); y1 = nodes(n1,2);
    x2 = nodes(n2,1); y2 = nodes(n2,2);
    b_beam = b(i);
    edofBEAM = [6*n1-5:6*n1,6*n2-5:6*n2];
    dkbeamdx1 = dkedx1(E,b_beam,h,nu,th,x1,x2,y1,y2);
    dkbeamdy1 = dkedy1(E,b_beam,h,nu,th,x1,x2,y1,y2);
    dkbeamdx2 = dkedx2(E,b_beam,h,nu,th,x1,x2,y1,y2);
    dkbeamdy2 = dkedy2(E,b_beam,h,nu,th,x1,x2,y1,y2);
    ue = U(edofBEAM,1); adje = ADJ(edofBEAM,1);
    dd(2*n1-1) = dd(2*n1-1) + adje'*(dkbeamdx1*ue);
    dd(2*n1) = dd(2*n1) + adje'*(dkbeamdy1*ue);
    dd(2*n2-1) = dd(2*n2-1) + adje'*(dkbeamdx2*ue);
    dd(2*n2) = dd(2*n2) + adje'*(dkbeamdy2*ue);
end