% Sensitivity of deflection: beams
function dd = ddefbeam(dd,U,ADJ,nodes,edges,E,nu,b,h,th)
ndv = size(dd,1);
% Loop over beams
for i = 1:size(edges,1)
    n1 = edges(i,1);
    n2 = edges(i,2);
    x1 = nodes(n1,1); y1 = nodes(n1,2);
    x2 = nodes(n2,1); y2 = nodes(n2,2);
    b_beam = b(i);
    edofBEAM = [6*n1-5:6*n1,6*n2-5:6*n2];
    dkbeamdb = dkedb(E,b_beam,h,nu,th,x1,x2,y1,y2);
    dkbeamdh = dkedh(E,b_beam,h,nu,th,x1,x2,y1,y2);
    dkbeamdth = dkedth(E,b_beam,h,th,x1,x2,y1,y2);
    ue = U(edofBEAM,1);
    adje = ADJ(edofBEAM,1);
    dddb = adje'*(dkbeamdb*ue);
    dddh = adje'*(dkbeamdh*ue);
    dddth = adje'*(dkbeamdth*ue);
    dd(i,1) = dddb;
    dd(ndv-1) = dd(ndv-1) + dddh;
    dd(ndv) = dd(ndv) + dddth;
end