% Computes dFswdb*U derivative of self weight load for beam elements
function dFdbU = assmdFswdbU(U,nodes,edges,h,massden)
dFdbU = zeros(size(edges,1),1);
for i = 1:size(edges,1)
    n1 = edges(i,1);
    n2 = edges(i,2);
    x1 = nodes(n1,1); y1 = nodes(n1,2);
    x2 = nodes(n2,1); y2 = nodes(n2,2);
    L = ((x2-x1)^2+(y2-y1)^2)^0.5;
    % Derivative of beam self weight
    dfswdb = [-L*h*massden/2,-L*h*massden/2];
    loaddofs = [6*n1-3,6*n2-3];
    dFdbU(i) = dfswdb*U(loaddofs,1);
end
end