% Assembles stiffness of CST and DKT elements
function [K] = assmKplate(K,nodes,plates,E,nu,th)
nplates = size(plates,1);
for i = 1:nplates
    % Element nodes
    n1 = plates(i,1); n2 = plates(i,2); n3 = plates(i,3);
    % Node coordinates
    plate_X = [nodes(n1,1) nodes(n2,1) nodes(n3,1)];
    plate_Y = [nodes(n1,2) nodes(n2,2) nodes(n3,2)];
    x1 = plate_X(1);  x2 = plate_X(2); x3 = plate_X(3);
    y1 = plate_Y(1);  y2 = plate_Y(2); y3 = plate_Y(3);
    edofCST = [6*n1-5,6*n1-4,6*n2-5,6*n2-4,6*n3-5,6*n3-4]; 
    edofDKT = [6*n1-3,6*n1-2,6*n1-1,6*n1,6*n2-3,6*n2-2,6*n2-1,6*n2,6*n3-3,6*n3-2,6*n3-1,6*n3]; 
    ke_CST = ke_CST_from_sym(E,nu,th,x1,x2,x3,y1,y2,y3);
    ke_DKT = ke_DKT_from_sym(E,nu,th,x1,x2,x3,y1,y2,y3);
    K(edofCST,edofCST) = K(edofCST,edofCST) + ke_CST;
    K(edofDKT,edofDKT) = K(edofDKT,edofDKT) + ke_DKT;
end
end