% Assembles stiffness of beam elements
function [K] = assmKbeam(K,nodes,edges,E,nu,b,h,th)
for i = 1:size(edges,1)
    n1 = edges(i,1);
    n2 = edges(i,2);
    x1 = nodes(n1,1); y1 = nodes(n1,2);
    x2 = nodes(n2,1); y2 = nodes(n2,2);
    b_beam = b(i);
    edofBEAM = [6*n1-5:6*n1,6*n2-5:6*n2];
    [ke_BEAM] = ke_beam_from_sym(E,b_beam,h,nu,th,x1,x2,y1,y2);
    K(edofBEAM,edofBEAM) = K(edofBEAM,edofBEAM) + ke_BEAM;
end