% Volume and its sensitivities: plates
function [totalArea,plates] = areaplate(nodes,plates)
nplates = size(plates,1);
totalArea = 0;
for i = 1:nplates
    % Element nodes
    n1 = plates(i,1); n2 = plates(i,2); n3 = plates(i,3);
    % Node coordinates
    plate_X = [nodes(n1,1) nodes(n2,1) nodes(n3,1)];
    plate_Y = [nodes(n1,2) nodes(n2,2) nodes(n3,2)];
    % Area
    plates(i,4) = 0.5*(plate_X(1)*(plate_Y(2)-plate_Y(3)) + ...
        plate_X(2)*(plate_Y(3)-plate_Y(1)) + ...
        plate_X(3)*(plate_Y(1)-plate_Y(2)));
    totalArea = totalArea + plates(i,4);
end
end

